/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties.utils;

import ancestris.util.swing.DialogManager;
import genj.gedcom.PropertyFile;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import modules.editors.gedcomproperties.GedcomPropertiesMediaFormatPanel;
import modules.editors.gedcomproperties.utils.ButtonColumn;
import modules.editors.gedcomproperties.utils.MediaPathTableModel;
import modules.editors.gedcomproperties.utils.PathData;
import modules.editors.gedcomproperties.utils.SearchFilePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MediaManagerPanel
extends JPanel {
    private Registry registry = null;
    private String rootPath = "";
    private Map<PropertyFile, String> property2PathMap = null;
    private Set<PathData> pathDataList = null;
    private boolean mapModified = false;
    private MediaPathTableModel mptm = null;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable table;

    public MediaManagerPanel(String rootPath, Map<PropertyFile, String> property2PathMap) {
        this.rootPath = rootPath;
        this.property2PathMap = property2PathMap;
        this.registry = Registry.get(this.getClass());
        this.mapModified = false;
        this.pathDataList = this.buildTable();
        this.mptm = new MediaPathTableModel(this, this.pathDataList, rootPath);
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("mediaManagerWindowWidth", this.getPreferredSize().width), this.registry.get("mediaManagerWindowHeight", this.getPreferredSize().height)));
        this.displayTable();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MediaManagerPanel.this.formComponentResized(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MediaManagerPanel.class, (String)"MediaManagerPanel.jLabel1.text"));
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)this.rootPath);
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(this.mptm);
        this.table.setPreferredSize(new Dimension(200, 64));
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 140, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2).addContainerGap()));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("mediaManagerWindowWidth", evt.getComponent().getWidth());
        this.registry.put("mediaManagerWindowHeight", evt.getComponent().getHeight());
        this.resizeColumns();
    }

    private Set<PathData> buildTable() {
        TreeSet<PathData> ret = new TreeSet<PathData>();
        for (PropertyFile pFile : this.property2PathMap.keySet()) {
            if (pFile.isIsRemote()) continue;
            File localFile = new File(pFile.getValue());
            String name = localFile.getName();
            String newPath = this.property2PathMap.get(pFile);
            boolean rel = !GedcomPropertiesMediaFormatPanel.ABSOLUTE.matcher(newPath).matches();
            File f = new File(rel ? this.rootPath + File.separator + newPath + name : newPath + name);
            boolean found = f.exists();
            String key = newPath + (found ? "1" : "0");
            PathData pd = this.getPathData(ret, key);
            if (pd == null) {
                pd = new PathData(found, rel, pFile, newPath);
                ret.add(pd);
                continue;
            }
            pd.addFile(pFile);
        }
        return ret;
    }

    private PathData getPathData(Set<PathData> set, String key) {
        for (PathData pd : set) {
            if (!key.equals(pd.getKey())) continue;
            return pd;
        }
        return null;
    }

    public void updateMap(int row, String newPath) {
        PathData pd = this.getPathDataFromRow(row);
        this.updateMapPathData(pd, newPath);
    }

    private void updatePathDataList(PathData pd, String path, boolean rel) {
        Path rootbase = Paths.get(this.rootPath, new String[0]);
        Path newpath = Paths.get(path, new String[0]);
        String newPath = path;
        if (rel) {
            Path relativePath = rootbase.relativize(newpath);
            newPath = relativePath.toString() + File.separator;
        }
        this.updateMapPathData(pd, newPath);
        this.pathDataList = this.buildTable();
        this.mptm.resetData(this.pathDataList);
        this.mptm.fireUpdateTable();
        this.resizeLines();
    }

    private PathData getPathDataFromRow(int row) {
        int i = 0;
        PathData pdRow = null;
        Iterator<PathData> iterator = this.pathDataList.iterator();
        while (iterator.hasNext()) {
            PathData pd;
            pdRow = pd = iterator.next();
            if (i == row) break;
            ++i;
        }
        return pdRow;
    }

    private void updateMapPathData(PathData pd, String newPath) {
        for (PropertyFile pFile : pd.getFiles()) {
            String previousPath = this.property2PathMap.get(pFile);
            if (previousPath.equals(newPath)) continue;
            this.mapModified = true;
            this.property2PathMap.put(pFile, newPath);
        }
    }

    public boolean isMapModified() {
        return this.mapModified;
    }

    private void displayTable() {
        TableCellRenderer renderer = this.table.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)renderer);
        headerLabel.setHorizontalAlignment(0);
        AbstractAction action = new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable localtable = (JTable)e.getSource();
                AbstractTableModel model = (AbstractTableModel)localtable.getModel();
                int row = Integer.valueOf(e.getActionCommand());
                String newPath = (String)model.getValueAt(row, 2);
                Boolean rel = (Boolean)model.getValueAt(row, 4);
                PathData pdRow = MediaManagerPanel.this.getPathDataFromRow(row);
                MediaManagerPanel.this.displayNewPath(pdRow, newPath, rel);
            }
        };
        ButtonColumn bc = new ButtonColumn(this.table, action, 3);
        this.resizeColumns();
        this.resizeLines();
    }

    private void resizeColumns() {
        Dimension size = this.table.getSize();
        int small = 100;
        int width = Math.max(size.width - small * 4, 100);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(width);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(small);
    }

    private void resizeLines() {
        int rowHeight = new JButton().getPreferredSize().height * 2;
        this.table.setRowHeight(rowHeight);
        Dimension preferredSize = this.table.getPreferredSize();
        preferredSize.height = rowHeight * this.mptm.getRowCount() + 1;
        this.table.setPreferredSize(preferredSize);
        this.table.revalidate();
        this.table.repaint();
    }

    private void displayNewPath(PathData pd, String path, Boolean rel) {
        SearchFilePanel panel = new SearchFilePanel(pd, rel != false ? this.rootPath + File.separator + path : path);
        Object o = DialogManager.create((String)NbBundle.getMessage(MediaManagerPanel.class, (String)"MediaManagerPanel.displayPathTitle"), (JComponent)panel).setMessageType(-1).setOptionType(2).show();
        if (o == DialogManager.OK_OPTION) {
            this.updatePathDataList(pd, panel.getNewPath(), rel);
        }
    }
}

