/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.webbook.WebBookWizardAction;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.io.FileAssociation;
import genj.util.Registry;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebBookButtonAction
extends AbstractAncestrisContextAction {
    private Registry registry;

    public WebBookButtonAction() {
        this.putValue("iconBase", "ancestris/modules/webbook/WebBook.png");
        this.setText(NbBundle.getMessage(WebBookButtonAction.class, (String)"CTL_WebBookAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        Context contextToOpen = this.getContext();
        String text = this.getLatestLink(contextToOpen);
        text = text.isEmpty() ? NbBundle.getMessage(WebBookButtonAction.class, (String)"CTL_WebBookAction") : NbBundle.getMessage(WebBookButtonAction.class, (String)"CTL_WebBookButtonAction");
        this.setText(text);
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            boolean regenerate = false;
            String link = this.getLatestLink(contextToOpen);
            if (!link.isEmpty()) {
                try {
                    FileAssociation.getDefault().execute(new URL(link));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                regenerate = true;
            }
            if (regenerate) {
                new WebBookWizardAction().actionPerformed(event);
            }
        }
    }

    private String getLatestLink(Context contextToOpen) {
        if (contextToOpen == null) {
            return "";
        }
        Gedcom gedcom = contextToOpen.getGedcom();
        if (gedcom != null) {
            this.registry = gedcom.getRegistry();
            return this.registry.get("localwebsite", "");
        }
        return "";
    }
}

