/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class BeanHelper {
    public static JLabel createTagLabel(String tag) {
        return BeanHelper.createTagLabel(tag, null, 0);
    }

    public static JLabel createTagLabel(String tag, String tip, int fontSize) {
        return BeanHelper.createLabel(Gedcom.getName((String)tag), BeanHelper.formatToolTip(tag, tip), fontSize);
    }

    public static JLabel createLabel(String label, String tip, int fontSize) {
        JLabel jLabel = new JLabel(label);
        if (tip != null && tip.length() != 0) {
            jLabel.setToolTipText(BeanHelper.formatToolTip(null, tip));
        }
        if (fontSize != 0) {
            jLabel.setFont(new Font("DejaVu Sans", 0, fontSize));
        }
        return jLabel;
    }

    public static String formatToolTip(String tag, String tip) {
        if (tag != null) {
            if (tip != null && tip.length() == 0) {
                tip = PropertyBean.RESOURCES.getString("HINT_" + tag, false);
            }
            if (tip == null) {
                tip = Gedcom.getInfo((String)tag);
            }
        }
        if (tip != null && !tip.startsWith("<html>")) {
            tip = "<html><table width=200><tr><td>" + tip + "</td></tr></table></html";
        }
        return tip;
    }

    public static JCheckBox createShowHide(String title, String tip, final JComponent component) {
        final JCheckBox jcb = new JCheckBox();
        jcb.setFont(new Font("DejaVu Sans", 0, 10));
        jcb.setText(title);
        jcb.setToolTipText(BeanHelper.formatToolTip(null, tip));
        jcb.setHorizontalTextPosition(2);
        jcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                component.setVisible(jcb.isSelected());
            }
        });
        return jcb;
    }
}

