/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.report.svgtree.Translator;
import ancestris.report.svgtree.graphics.GraphicsFileOutput;
import ancestris.report.svgtree.graphics.GraphicsOutput;
import ancestris.report.svgtree.graphics.PdfWriter;
import ancestris.report.svgtree.graphics.PngWriter;
import ancestris.report.svgtree.graphics.ScreenOutput;
import ancestris.report.svgtree.graphics.SvgWriter;
import genj.report.Report;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GraphicsOutputFactory {
    public int output_type = 0;
    public String[] output_types = null;
    private final Map<String, GraphicsOutput> outputs = new LinkedHashMap<String, GraphicsOutput>();
    public List<GraphicsOutput> outputList = new ArrayList<GraphicsOutput>();
    private final Translator translator;

    public GraphicsOutputFactory(Translator translator) {
        this.translator = translator;
        this.add(translator.translate("output_type.svg"), new SvgWriter());
        this.add(translator.translate("output_type.pdf"), new PdfWriter());
        this.add(translator.translate("output_type.png"), new PngWriter());
        this.add(translator.translate("output_type.screen"), new ScreenOutput());
    }

    public GraphicsOutput createOutput(Report report) {
        GraphicsOutput output = this.outputList.get(this.output_type);
        if (output == null) {
            return null;
        }
        if (output instanceof GraphicsFileOutput) {
            GraphicsFileOutput fileOutput = (GraphicsFileOutput)output;
            String extension = fileOutput.getFileExtension();
            File file = report.getFileFromUser(report.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, extension);
            if (file == null) {
                return null;
            }
            String suffix = "." + extension;
            if (!file.getPath().endsWith(suffix)) {
                file = new File(file.getPath() + suffix);
            }
            fileOutput.setFile(file);
        }
        return output;
    }

    public final void add(String name, GraphicsOutput output) {
        this.outputs.put(name, output);
        this.outputList.add(output);
        this.output_types = this.outputs.keySet().toArray(new String[0]);
    }
}

