/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.narrative;

import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.util.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utterance {
    private final String template;
    private final Map props = new HashMap();
    private final List linkedEntities = new ArrayList();
    private final Resources resources;
    private int gender = 0;
    private static final String SUBJECT = "SUBJECT";
    private static final String LANG = Locale.getDefault().getLanguage();
    private static final Pattern ARG_PATTERN = Pattern.compile("\\[[^\\[\\]]*\\]");

    private Utterance(Resources resources, String template) {
        this.resources = resources;
        this.template = template;
        if (template == null) {
            System.err.println("No resource found for " + template);
        }
        this.props.put("LBRACKET", "[");
        this.props.put("RBRACKET", "]");
        this.props.put("LBRACE", "{");
        this.props.put("RBRACE", "}");
    }

    public static Utterance forProperty(Resources resources, String property) {
        return Utterance.forTemplate(resources, Utterance.translateWithFallback(property, resources));
    }

    public static Utterance forProperty(Resources resources, String property, String[] params, Entity[] linkedEntities) {
        return Utterance.forTemplate(resources, Utterance.translateWithFallback(property, resources), params, linkedEntities);
    }

    public static Utterance forProperty(Resources resources, String property, String[] params) {
        return Utterance.forTemplate(resources, Utterance.translateWithFallback(property, resources), params);
    }

    public static Utterance forTemplate(Resources resources, String template) {
        return new Utterance(resources, template);
    }

    public static Utterance forTemplate(Resources resources, String template, String[] params, Entity[] linkedEntities) {
        Utterance result = Utterance.forTemplate(resources, template, params);
        for (Entity entity : linkedEntities) {
            result.linkedEntities.add(entity);
        }
        return result;
    }

    public static Utterance forTemplate(Resources resources, String template, String[] params) {
        Utterance result = new Utterance(resources, template);
        for (int i = 0; i < params.length; ++i) {
            result.set(Integer.toString(i + 1), params[i]);
        }
        return result;
    }

    private String translate(String key) {
        return Utterance.translate(key, this.resources);
    }

    public static boolean isTranslatable(String key, Resources resources) {
        return Utterance.translate(key, resources) != null;
    }

    public static String translateWithFallback(String key, Resources resources) {
        String translation = Utterance.translate(key, resources);
        if (translation == null) {
            System.err.println("No translation found for " + key);
            translation = key;
        }
        return translation;
    }

    public static String translate(String key, Resources resources) {
        if (resources == null) {
            return key;
        }
        String result = resources.getString(key);
        if (result.equals(key)) {
            return null;
        }
        if (result.startsWith("_")) {
            result = " " + result.substring(1);
        }
        if (result.endsWith("_")) {
            result = result.substring(0, result.length() - 1) + " ";
        }
        return result;
    }

    private String getGenderKeySuffix() {
        switch (this.gender) {
            case 1: {
                return ".male";
            }
            case 2: {
                return ".female";
            }
        }
        return ".genderUnknown";
    }

    public void setSubject(Indi indi) {
        this.gender = indi.getSex();
        this.props.put(SUBJECT, this.translate("pronoun.nom" + this.getGenderKeySuffix()));
        this.props.put("SUBJECT.dat", this.translate("pronoun.dat" + this.getGenderKeySuffix()));
    }

    public void addText(Document doc) {
        doc.addText(this.toString());
    }

    public String toString() {
        Matcher matcher = ARG_PATTERN.matcher(this.template);
        String result = this.template;
        int start = 0;
        while (matcher.find(start)) {
            int where = matcher.start();
            String key = matcher.group();
            String value = (String)this.props.get(key = key.substring(1, key.length() - 1));
            if (value == null) {
                if (key.startsWith("OPTIONAL_")) {
                    value = "";
                } else {
                    if (key.startsWith("ending.")) {
                        value = this.translate(key + this.getGenderKeySuffix());
                    } else if (key.startsWith("SUBJECT.")) {
                        value = this.translate("pronoun." + key.substring(8) + this.getGenderKeySuffix());
                    }
                    if (value == null) {
                        System.err.println("No value for key " + key + " in sentence template " + this.template);
                        value = key;
                    }
                }
            }
            if (where == 0) {
                if (value.length() == 0) {
                    System.err.println("Empty string for key " + key);
                } else {
                    value = Character.toUpperCase(value.charAt(0)) + value.substring(1);
                }
            }
            if (where > 0 && value.length() > 0 && !key.startsWith("ending.") && (!Character.isSpaceChar(result.charAt(where - 1)) && Character.isLetterOrDigit(value.charAt(0)) || !Character.isSpaceChar(result.charAt(where - 1)) && this.punctuationRequiresPrecedingBlank(value.charAt(0)))) {
                value = " " + value;
            }
            String before = result.substring(0, where);
            String after = result.substring(where + matcher.group().length());
            start = where + value.length();
            if (value.endsWith(".") && after.startsWith(".")) {
                after = after.substring(1);
            }
            if (start > (result = before + value + after).length()) {
                System.err.println("OutOfBoundsException about to happen");
                result = result.substring(0, result.length() - key.length() - 2);
                break;
            }
            matcher.reset(result);
        }
        return result;
    }

    private boolean punctuationRequiresPrecedingBlank(char c) {
        return c == '(' || c == '{' || c == '[';
    }

    public static void main(String[] args) {
        Utterance s = Utterance.forTemplate(null, "[SUBJECT] wurde geboren[OPTIONAL_PP_PLACE][OPTIONAL_PP_DATE].");
        s.set(SUBJECT, "er");
        System.out.println(s);
        s.set("OPTIONAL_PP_PLACE", "in Frankfurt");
        System.out.println(s);
        s = Utterance.forTemplate(null, "Geboren wurde [SUBJECT][OPTIONAL_PP_PLACE][OPTIONAL_PP_DATE].");
        s.set(SUBJECT, "sie");
        System.out.println(s);
        s.set("OPTIONAL_PP_PLACE", "in Duesseldorf");
        System.out.println(s);
        Utterance pp = Utterance.forTemplate(null, "in [CITY]");
        pp.set("CITY", "Frankfurt");
        s.set("OPTIONAL_PP_PLACE", pp.toString());
        System.out.println(s);
    }

    public void set(String key, String value) {
        this.props.put(key, value);
    }

    public String get(String key) {
        return (String)this.props.get(key);
    }

    public boolean hasKey(String key) {
        return this.props.containsKey(key);
    }
}

