/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.genealogystatus;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.report.Report;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openide.util.NbBundle;

public class ReportGenealogyStatus
extends Report {
    public int maxNbOfAncestors = 512;
    public boolean includeSiblings = true;
    public String directoryParam = System.getProperty("user.home") + "<insert media directory name here>";
    private static final String OUI = "1";
    private static final String APX = "~";
    private static final String NON = ".";
    private static final String ERR = "#";
    private static final String SEQ = "@";
    private static final String FIL = "\u00a7";
    private static final String SPA = " ";
    private static final String TAB = "\t";
    private int maxSosaLength = 5;
    private static final String MAXSTR = "                                                                           ";
    private String[] placeFormat = null;
    private int sizePlaces = 0;
    private final Map<BigInteger, Indi> sosaList = new TreeMap<BigInteger, Indi>();
    private final Map<String, String> entMap = new TreeMap<String, String>();
    private int cntAnomaly = 0;
    private int cntOutOfSeq = 0;
    private int cntKnwnSrc = 0;
    private static final int MAX_NB_OF_UNUSED_FILES = 100;
    private int nbOfUnusedFiles = 0;

    public void start(Gedcom gedcom) {
        String str;
        this.cntAnomaly = 0;
        this.cntOutOfSeq = 0;
        this.cntKnwnSrc = 0;
        this.maxSosaLength = 5;
        Collection entities = gedcom.getEntities("INDI");
        String sib = "0";
        for (Indi indi : entities) {
            Property[] props = indi.getProperties(Indi.TAG_SOSA);
            if (props.length == 0) {
                props = indi.getProperties(Indi.TAG_SOSADABOVILLE);
            }
            for (Property prop : props) {
                String sosaStr = prop.getValue();
                int index = sosaStr.indexOf(NON);
                if (index != -1 || sosaStr.matches(".*[a-z].*")) continue;
                index = sosaStr.indexOf(SPA);
                if (index != -1) {
                    sosaStr = sosaStr.substring(0, index);
                }
                if ((index = sosaStr.indexOf("-")) != -1) {
                    sib = sosaStr.substring(index + 1);
                    sosaStr = sosaStr.substring(0, index);
                }
                if (!this.includeSiblings && !sib.equals("0")) {
                    sib = "0";
                    continue;
                }
                BigInteger divider = BigInteger.ONE;
                if (!sib.equals("0")) {
                    divider = divider.add(BigInteger.ONE);
                }
                BigInteger bi = new BigInteger(sosaStr + "00").divide(divider).add(new BigInteger(sib));
                sib = "0";
                this.sosaList.put(bi, indi);
                if (bi.toString().length() <= this.maxSosaLength) continue;
                this.maxSosaLength = bi.toString().length() + 4;
            }
        }
        if (this.sosaList.isEmpty()) {
            this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_NoSosaFound"));
            this.println("========");
            return;
        }
        this.placeFormat = this.validatePlaceFormat(gedcom.getPlaceFormat());
        this.sizePlaces = this.placeFormat != null ? this.placeFormat.length : 0;
        this.headerLine();
        int sosaCnt = 1;
        int i = 1;
        boolean isSibling = false;
        for (BigInteger item : this.sosaList.keySet()) {
            BigInteger[] items = item.divideAndRemainder(new BigInteger("100"));
            Indi indi = this.sosaList.get(item);
            BigInteger sosaNb = items[0];
            boolean bl = isSibling = !items[1].equals(BigInteger.ZERO);
            if (sosaNb.doubleValue() > 1.0 && !isSibling) {
                ++sosaCnt;
            }
            while (sosaNb.doubleValue() > (double)sosaCnt && sosaCnt < this.maxNbOfAncestors) {
                this.println(this.emptyLine());
                ++sosaCnt;
            }
            Iterator space = "";
            BigInteger displaySosa = sosaNb;
            String suffix = "";
            if (isSibling) {
                BigInteger multiplyer = BigInteger.ONE.add(BigInteger.ONE);
                displaySosa = sosaNb.multiply(multiplyer);
                space = (String)((Object)space) + SPA;
                suffix = "-" + items[1].toString();
            }
            this.println(this.getLine(indi, i++, sosaNb, (String)((Object)space) + displaySosa.toString() + suffix));
            if (i % 10 != 0) continue;
            this.midLine();
        }
        this.sosaList.clear();
        this.println(SPA);
        this.println(SPA);
        this.println("========");
        this.println(SPA);
        this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_counters"));
        this.println(SPA);
        this.println("   " + this.cntAnomaly + "\t " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_anomalies") + " (" + ERR + ")");
        this.println("   " + this.cntOutOfSeq + TAB + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_sequence") + " (" + SEQ + ")");
        this.println("   " + this.cntKnwnSrc + TAB + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_source") + " (" + FIL + ")");
        this.println(SPA);
        this.println(SPA);
        this.println("========");
        this.println(SPA);
        List ents = gedcom.getEntities();
        ArrayList<String> gedcomFiles = new ArrayList<String>();
        for (Object ent : ents) {
            for (PropertyXRef xref : ent.getProperties(PropertyXRef.class)) {
                Entity entity = xref.getTargetEntity();
                if (entity == null) continue;
                String str2 = this.entMap.get(entity.getId());
                if (str2 == null) {
                    this.entMap.put(entity.getId(), ent.getId());
                    continue;
                }
                this.entMap.put(entity.getId(), str2 + ", " + ent.getId());
            }
            for (PropertyFile file : ent.getProperties(PropertyFile.class)) {
                if (file == null || file.getInput().orElse(null) == null) continue;
                gedcomFiles.add(((InputSource)file.getInput().get()).getName());
            }
        }
        this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_entity_not_used"));
        this.println(SPA);
        boolean none = true;
        for (Entity ent : ents) {
            if (ent.getTag().equals("HEAD") || ent instanceof Submitter || (str = this.entMap.get(ent.getId())) != null) continue;
            String value = ent.toString(false);
            this.println("   " + ent.getId() + SPA + value.substring(0, Math.min(value.length(), 50)));
            none = false;
        }
        if (none) {
            this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_entity_not_used_none"));
        }
        this.println(SPA);
        this.println(SPA);
        this.println("========");
        this.println(SPA);
        this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_multiple_source"));
        this.println(SPA);
        none = true;
        for (Entity ent : ents) {
            str = this.entMap.get(ent.getId());
            if (str == null || str.indexOf(",") <= 0 || !(ent instanceof Source)) continue;
            this.println("   " + ent.getId() + SPA + ent.toString(false) + " ===> " + str);
            none = false;
        }
        if (none) {
            this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_multiple_source_none"));
        }
        this.entMap.clear();
        this.println(SPA);
        this.println(SPA);
        this.println("========");
        this.println(SPA);
        File directory = new File(this.directoryParam);
        this.println(NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_unused_media", (Object)directory.toString()));
        this.println(SPA);
        if (directory.isDirectory()) {
            this.nbOfUnusedFiles = 0;
            this.checkDirectory(directory, gedcomFiles);
            if (this.nbOfUnusedFiles > 100) {
                this.println(SPA);
                this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_maxnbofunusedfilesreached"));
            } else if (this.nbOfUnusedFiles == 0) {
                this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_directoryUsed"));
            }
        } else {
            this.println("   " + NbBundle.getMessage(ReportGenealogyStatus.class, (String)"TXT_invalidDirectory"));
        }
        this.println(SPA);
        this.println(SPA);
        this.println("========");
        this.println(SPA);
    }

    private void headerLine() {
        String str = MAXSTR.substring(0, this.maxSosaLength - 4);
        this.println("Nb \tSosa" + str + TAB + "Gen" + TAB + "Id       " + TAB + "Med" + TAB + "Birt" + TAB + "Chr " + TAB + "Marr " + TAB + "Fam      " + TAB + "Occu" + TAB + "Deat" + TAB + "Name                                                   ");
        this.midLine();
    }

    private void midLine() {
        String str = MAXSTR.substring(0, this.maxSosaLength - 4);
        this.println("---\t----" + str + TAB + "---" + TAB + "---------" + TAB + "---" + TAB + "----" + TAB + "----" + TAB + "---- " + TAB + "---------" + TAB + "----" + TAB + "----" + TAB + "------------------------------------------------------");
    }

    private String emptyLine() {
        String str = MAXSTR.substring(0, this.maxSosaLength - 1);
        return ".  \t." + str + TAB + ".   " + TAB + ".        " + TAB + ".  " + TAB + ".   " + TAB + ".   " + TAB + ".    " + TAB + "         " + TAB + "    " + TAB + "    " + TAB + ".                                                     ";
    }

    private String getLine(Indi indi, int index, BigInteger sosaNb, String sosa) {
        String line = "";
        line = line + index;
        line = line + TAB;
        String[] bits = sosa.split("-");
        String str = MAXSTR.substring(0, this.maxSosaLength - bits[0].length());
        line = line + sosa + str;
        line = line + TAB;
        if (sosaNb == BigInteger.ZERO) {
            line = line + "--";
        } else {
            int g = 1 + (int)(Math.log(sosaNb.doubleValue()) / Math.log(2.0));
            line = line + "" + g;
        }
        line = line + TAB;
        line = line + indi.getId() + "         ".substring(indi.getId().length());
        line = line + TAB;
        line = line + this.getMedia(sosa, (Entity)indi, "INDI:OBJE");
        line = line + TAB;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:BIRT", true);
        line = line + TAB;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:CHR", false);
        line = line + TAB;
        line = line + this.getFamilies(sosa, indi, sosaNb.doubleValue() > 1.0);
        line = line + TAB;
        line = line + this.getMultipleEvent(sosa, (Entity)indi, "OCCU");
        line = line + TAB;
        line = line + this.getEvent(sosa, (Entity)indi, "INDI:DEAT", sosaNb.doubleValue() > 15.0);
        line = line + TAB;
        line = line + indi.getLastName() + ", " + indi.getFirstName().substring(0, Math.min(40, indi.getFirstName().length()));
        return line;
    }

    private String getEvent(String sosa, Entity ent, String tag, boolean mandatory) {
        String line = "";
        Property prop = ent.getPropertyByPath(tag);
        if (prop == null) {
            return mandatory ? this.err() + this.err() + this.err() + this.err() : "    ";
        }
        line = line + this.isValidAndComplete(ent.getPropertyByPath(tag + ":DATE"), mandatory);
        line = line + this.isValidAndComplete(ent.getPropertyByPath(tag + ":PLAC"), mandatory);
        line = line + this.getSource(sosa, ent, tag + ":SOUR", mandatory || line.contains(OUI));
        return line;
    }

    private String getMultipleEvent(String sosa, Entity ent, String tag) {
        String line = "";
        boolean isOccu = tag.equalsIgnoreCase("OCCU");
        Property[] prop = ent.getProperties(tag);
        if (prop == null || prop.length == 0) {
            return "    ";
        }
        int intNbFound = 0;
        String src = "  ";
        for (int i = 0; i < prop.length; ++i) {
            Property property = prop[i];
            if (isOccu) {
                String str = property.toString();
                intNbFound += str != null && str.length() > 0 ? 1 : 0;
            }
            String tmpSrc = this.getSource(sosa, ent, tag + ":SOUR", false);
            if (src.compareTo(ERR) != -1) continue;
            if (tmpSrc.compareTo(ERR) != -1) {
                src = tmpSrc;
                continue;
            }
            if (src.compareTo(FIL) == -1) {
                src = tmpSrc;
            }
            if (tmpSrc.compareTo(FIL) != -1) {
                src = tmpSrc;
                continue;
            }
            if (src.compareTo(NON) == -1) {
                src = tmpSrc;
            }
            if (tmpSrc.compareTo(NON) == -1) continue;
            src = tmpSrc;
        }
        line = line + (prop.length == 0 ? NON : String.valueOf(prop.length));
        line = line + (intNbFound == 0 ? NON : String.valueOf(intNbFound));
        line = line + src;
        return line;
    }

    private String getMedia(String sosa, Entity ent, String tag) {
        boolean exists;
        String src = "";
        Property[] props = ent.getProperties(new TagPath(tag));
        boolean bl = exists = props != null && props.length != 0;
        if (!exists) {
            return "   ";
        }
        src = src + props.length;
        String file = SPA;
        Property fp = null;
        boolean found = true;
        for (Property p : props) {
            fp = p instanceof PropertyMedia ? ((PropertyMedia)p).getTargetEntity().getProperty("FILE") : p.getProperty("FILE");
            if (this.isValidFile(fp)) continue;
            found = false;
            break;
        }
        file = found ? OUI : this.fil();
        src = src + file + SPA;
        return src;
    }

    private String getSource(String sosa, Entity ent, String tag, boolean mandatory) {
        String src = "";
        Property[] props = ent.getProperties(new TagPath(tag));
        if (props == null || props.length == 0) {
            return mandatory ? this.err() + this.err() : "  ";
        }
        src = src + props.length;
        String file = SPA;
        Property f1 = null;
        Property f2 = null;
        Property f3 = null;
        Property f4 = null;
        Property textProp = null;
        boolean found = true;
        for (Property p : props) {
            Entity media;
            Property p2;
            if (p instanceof PropertySource) {
                Property p4;
                Entity sourceEnt = ((PropertySource)p).getTargetEntity();
                textProp = sourceEnt.getProperty("TEXT");
                p2 = p.getProperty("OBJE");
                if (p2 != null) {
                    f1 = p2.getProperty("FILE");
                }
                if (p2 != null && p2 instanceof PropertyMedia) {
                    media = ((PropertyMedia)p2).getTargetEntity();
                    f2 = media.getProperty("FILE");
                }
                if ((p4 = sourceEnt.getProperty("OBJE")) != null) {
                    f3 = p4.getProperty("FILE");
                }
                if (p4 != null && p4 instanceof PropertyMedia) {
                    Entity media2 = ((PropertyMedia)p4).getTargetEntity();
                    f4 = media2.getProperty("FILE");
                }
                if ((this.isValidFile(f1) || this.isValidFile(f2) || this.isValidFile(f3) || this.isValidFile(f4)) && this.isValidText(textProp)) {
                    found = true;
                    continue;
                }
                found = false;
                break;
            }
            textProp = p.getProperty("TEXT");
            boolean is551 = ent.getGedcom().getGrammar().equals(Grammar.V551);
            p2 = p.getProperty("OBJE");
            if (p2 != null) {
                f1 = p2.getProperty("FILE");
            }
            if (p2 != null && p2 instanceof PropertyMedia) {
                media = ((PropertyMedia)p2).getTargetEntity();
                f2 = media.getProperty("FILE");
            }
            if (!this.isValidText(textProp)) {
                found = false;
                break;
            }
            if (!is551) continue;
            if (this.isValidFile(f1) || this.isValidFile(f2)) {
                found = true;
                continue;
            }
            found = false;
            break;
        }
        file = found ? OUI : this.fil();
        src = src + file;
        return src;
    }

    private String getFamilies(String sosa, Indi indi, boolean mandatory) {
        String line = "";
        Fam[] families = indi.getFamiliesWhereSpouse();
        if (families == null || families.length == 0) {
            return (mandatory ? this.err() + this.err() + this.err() + this.err() + SPA : "     ") + TAB + "         " + SPA;
        }
        Fam famFound = null;
        for (int i = 0; i < families.length; ++i) {
            Fam family = families[i];
            Indi spouse = family.getHusband();
            if (spouse == indi) {
                spouse = family.getWife();
            }
            if (spouse != null && spouse.getProperty(Indi.TAG_SOSA) == null && spouse.getProperty(Indi.TAG_SOSADABOVILLE) == null) continue;
            famFound = family;
            break;
        }
        if (famFound != null) {
            line = line + this.getEvent(sosa, (Entity)famFound, "FAM:MARR", mandatory);
            line = line + this.checkKidsOrder(famFound);
            line = line + TAB;
            line = line + famFound.getId() + "         ".substring(famFound.getId().length());
            line = line + SPA;
            return line;
        }
        return ".... \t          ";
    }

    private String isValidAndComplete(Property prop, boolean mandatory) {
        if (prop == null) {
            return mandatory ? this.err() : SPA;
        }
        if (!(prop instanceof PropertyDate) && !(prop instanceof PropertyPlace)) {
            return mandatory ? this.err() : NON;
        }
        if (prop.getValue().isEmpty()) {
            return mandatory ? this.err() : NON;
        }
        if (prop instanceof PropertyDate) {
            PropertyDate pDate = (PropertyDate)prop;
            if (!pDate.isValid()) {
                return this.err();
            }
            if (pDate.isRange()) {
                return APX;
            }
            PointInTime pit = pDate.getStart();
            if (!pit.isValid()) {
                return this.err();
            }
            if (!pit.isComplete()) {
                return APX;
            }
            return OUI;
        }
        if (prop instanceof PropertyPlace) {
            String[] place = prop.getValue().trim().split("\\,", -1);
            if (this.isEmpty(place)) {
                return mandatory ? this.err() : NON;
            }
            if (this.sizePlaces > 0 && place.length != this.sizePlaces) {
                return mandatory ? this.err() : NON;
            }
            PropertyPlace pPlace = (PropertyPlace)prop;
            if (pPlace.getCity().trim().isEmpty()) {
                return APX;
            }
            return OUI;
        }
        return NON;
    }

    private boolean isEmpty(String[] tags) {
        if (tags == null) {
            return true;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    private String[] validatePlaceFormat(String placeFormat) {
        String[] tags = null;
        if (placeFormat.length() != 0) {
            tags = placeFormat.split("\\,", -1);
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = tags[i].trim();
            }
        }
        return tags;
    }

    private String checkKidsOrder(Fam family) {
        Indi[] kids = family.getChildren(false);
        if (kids == null || kids.length < 2) {
            return SPA;
        }
        PropertyDate pDatePrev = null;
        for (int i = 0; i < kids.length; ++i) {
            PropertyDate pDate = kids[i].getBirthDate();
            if (pDate == null || !pDate.isValid()) continue;
            if (pDatePrev != null && pDate.compareTo((Property)pDatePrev) < 0) {
                return this.seq();
            }
            pDatePrev = pDate;
        }
        return SPA;
    }

    private String err() {
        ++this.cntAnomaly;
        return ERR;
    }

    private String seq() {
        ++this.cntOutOfSeq;
        return SEQ;
    }

    private String fil() {
        ++this.cntKnwnSrc;
        return FIL;
    }

    private void checkDirectory(File directory, List<String> gedcomFiles) {
        if (this.nbOfUnusedFiles > 100) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.checkDirectory(files[i], gedcomFiles);
                continue;
            }
            String filename = files[i].getName();
            if (gedcomFiles.contains(filename)) continue;
            this.println("   " + files[i].toString());
            ++this.nbOfUnusedFiles;
            if (this.nbOfUnusedFiles <= 100) continue;
            return;
        }
    }

    private boolean isValidFile(Property fp) {
        if (fp != null && fp instanceof PropertyFile) {
            InputSource is = ((PropertyFile)fp).getInput().orElse(null);
            if (is == null || !(is instanceof FileInput)) {
                return false;
            }
            File f = ((FileInput)is).getFile();
            return f != null && f.exists();
        }
        return false;
    }

    private boolean isValidText(Property textProp) {
        if (textProp == null) {
            return false;
        }
        String text = textProp.getValue().trim();
        return !text.isEmpty();
    }
}

