/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.tools.LegendPanel;
import ancestris.modules.gedcomcompare.tools.STMap;
import ancestris.modules.gedcomcompare.tools.STPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.DefaultWaypointRenderer;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.Waypoint;
import org.jxmapviewer.viewer.WaypointPainter;
import org.openide.windows.WindowManager;

public class CompareMapPanel
extends JPanel {
    private LegendPanel legend = null;
    private boolean isZoomFixed = false;
    private JXMapKit jXMapKit1;

    public CompareMapPanel() {
        this.initComponents();
        this.jXMapKit1.setMiniMapVisible(false);
        this.jXMapKit1.setZoomButtonsVisible(true);
        this.jXMapKit1.setZoomSliderVisible(true);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(107, 0), "zoomout");
        this.getActionMap().put("zoomout", this.jXMapKit1.getZoomOutAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(109, 0), "zoomin");
        this.getActionMap().put("zoomin", this.jXMapKit1.getZoomInAction());
        this.legend = new LegendPanel();
        this.legend.setBounds(10, 10, this.legend.getPreferredSize().width, this.legend.getPreferredSize().height);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.insets = new Insets(6, 6, 6, 6);
        this.jXMapKit1.getMainMap().add((Component)this.legend, (Object)c);
    }

    public void init(final STMap map1, final STMap map2, final STMap intersection) {
        final Set<STPoint> stPoints = map1.getPoints(0);
        stPoints.addAll(map2.getPoints(1));
        stPoints.addAll(intersection.getPoints(2));
        WaypointPainter painter = new WaypointPainter();
        painter.setWaypoints(stPoints);
        painter.setRenderer((org.jxmapviewer.viewer.WaypointRenderer)new WaypointRenderer());
        this.jXMapKit1.setAddressLocationPainter(painter);
        this.jXMapKit1.repaint();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                if (!CompareMapPanel.this.isZoomFixed) {
                    CompareMapPanel.this.jXMapKit1.getMainMap().zoomToBestFit(CompareMapPanel.this.getGeoPositions(stPoints), 0.9);
                }
                CompareMapPanel.this.legend.setNames(map1.getName() + " (" + map1.getPoints(0).size() + ")", map2.getName() + " (" + map2.getPoints(1).size() + ")", intersection.getPoints(2).size());
                CompareMapPanel.this.legend.setBounds(10, 10, ((CompareMapPanel)CompareMapPanel.this).legend.getPreferredSize().width, ((CompareMapPanel)CompareMapPanel.this).legend.getPreferredSize().height);
            }
        });
    }

    private void initComponents() {
        this.jXMapKit1 = new JXMapKit();
        this.jXMapKit1.setPreferredSize(new Dimension(600, 500));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jXMapKit1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jXMapKit1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    public void fixZoom() {
        this.isZoomFixed = true;
    }

    private Set<GeoPosition> getGeoPositions(Set<STPoint> set) {
        HashSet<GeoPosition> ret = new HashSet<GeoPosition>();
        set.forEach(p -> ret.add(p.getPosition()));
        return ret;
    }

    private class WaypointRenderer
    extends DefaultWaypointRenderer {
        Color[] colors = new Color[]{Color.BLUE, new Color(0, 144, 0), Color.RED};

        public void paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
            Point2D point = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
            int x = Long.valueOf(Math.round(point.getX())).intValue();
            int y = Long.valueOf(Math.round(point.getY())).intValue();
            STPoint stPoint = (STPoint)wp;
            int size = (int)(Math.sqrt(stPoint.getTime()) * 20.0 / (double)(map.getZoom() + 1));
            Color color = this.colors[stPoint.getType()];
            g.setColor(color);
            if (stPoint.getType() == 2) {
                g.fillOval(x - size, y - size, 2 * size, 2 * size);
            } else {
                g.setStroke(new BasicStroke(3.0f));
                g.drawOval(x - size, y - size, 2 * size, 2 * size);
            }
        }
    }
}

