/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.document.view.FopDocumentView;
import ancestris.util.TimingUtility;
import genj.edit.actions.GedcomEditorAction;
import genj.fo.Document;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import genj.view.ViewContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.WindowManager;

public class FixesWindow {
    private static final Logger LOG = Logger.getLogger("ancestris.import", null);
    private static String[] sections = new String[]{"summary", "header", "repairLine", "missingEntity", "invalidEntity", "invalidTag", "invalidTagLocation", "invalidSourceLocation", "missingTag", "invalidFileStructure", "invalidName", "invalidSex", "eventValue", "invalidDate", "invalidPlace", "invalidAge", "invalidCardinality", "eventsCardinality", "switchAssos", "duplicateAssociations", "invalidInformation", "textformatting", "createdEntity"};
    private TreeMap<String, String> summary = new TreeMap();
    private Context context;
    private List<ImportFix> fixes;
    private Map<String, ImportFix> fixesMap;
    private List<ViewContext> issues;

    public FixesWindow(HashMap<String, String> summary, Context context, List<ImportFix> fixes) {
        this.summary.putAll(summary);
        this.context = context;
        this.fixes = fixes;
    }

    private void convertFixesToIssues() {
        this.issues = new ArrayList<ViewContext>();
        this.fixesMap = new HashMap<String, ImportFix>();
        Gedcom gedcom = this.context.getGedcom();
        String nbmax = "000000000000000000000000000000";
        Pattern p = Pattern.compile("([^0-9]+\\?)([0-9]+)(.*)");
        for (ImportFix fix : this.fixes) {
            ImageIcon icon;
            this.fixesMap.put(fix.getId().toString(), fix);
            String xref = fix.getXref();
            Entity ent = gedcom.getEntity(xref);
            if (ent == null) {
                ent = gedcom.getFirstEntity(xref);
            }
            Entity property = ent;
            if (ent != null && !fix.getNewTag().isEmpty()) {
                String path = fix.getNewTag().replaceAll("\\(", "?").replaceAll("\\)", "");
                Matcher m = p.matcher(path);
                if (m.matches()) {
                    String result = "";
                    while (m.matches()) {
                        result = result + m.group(1);
                        int counter = Integer.valueOf(m.group(2)) - 1;
                        result = result + counter;
                        Matcher m2 = p.matcher(m.group(3));
                        if (!m2.matches()) {
                            result = result + m.group(3);
                        }
                        m = m2;
                    }
                    path = result;
                }
                try {
                    TagPath tagPath = new TagPath(path);
                    property = ent.getProperty(tagPath);
                }
                catch (Exception e) {
                    LOG.warning("invalid path: " + path + " from entity=" + ent + " and for fix=" + fix.getCode());
                }
            }
            if (ent == null) {
                LOG.warning("Display Issues: following xref is null, so correction attached to first entity: " + fix.getXref() + " - code=" + fix.getCode() + " - oldtag=" + fix.getOldTag() + " - oldvalue=" + fix.getOldValue() + " - newTag=" + fix.getNewTag() + " - newValue=" + fix.getNewValue());
                ent = gedcom.getFirstEntity("HEAD");
                icon = MetaProperty.IMG_ERROR;
            } else {
                icon = ent.getImage();
            }
            if (property == null) {
                property = ent;
            }
            String key = this.getSectionIndex(fix.getCode()) + ";";
            key = key + fix.getCode() + ";";
            key = key + ent.getTag() + ";";
            String id = ent.getId().replaceAll("[^0-9]", "");
            if ((id = id.substring(0, Math.min(nbmax.length(), id.length()))).isEmpty()) {
                id = "0";
            }
            key = key + nbmax.substring(id.length()) + id + ";";
            key = key + fix.getId().toString();
            this.issues.add(new ViewContext((Property)property).setCode(fix.getCode()).setText(key).setImage(icon));
        }
    }

    protected void displayFixes(final boolean extract) {
        TimingUtility.getInstance().reset();
        LOG.fine("Display Issues: started. Time= " + TimingUtility.getInstance().getTime());
        this.convertFixesToIssues();
        LOG.fine("Display Issues: list prepared. Time=" + TimingUtility.getInstance().getTime());
        final Preferences modulePreferences = NbPreferences.forModule(FixesWindow.class);
        final int size = this.issues != null ? this.issues.size() : 0;
        final ProgressMonitor progressMonitor = new ProgressMonitor(null, this.getResource("process.name", "" + size), "", 0, size);
        final String title = this.getResource("title", this.summary.get("a.software"));
        final String mode = NbBundle.getMessage(Import.class, (String)(!extract ? "mode.displayFullList" : "mode.displayExtractOnly"));
        progressMonitor.setProgress(0);
        Task fullTask = new Task(progressMonitor, size){

            @Override
            public Void doInBackground() {
                String noissues = FixesWindow.this.getResource("noissues", new String[0]);
                Document doc = new Document(title);
                String goToToc = "  \u2191";
                String tocAnchor = "toc";
                if (FixesWindow.this.fixes != null) {
                    doc.nextParagraph("text-align=center, space-before=2cm, space-after=1cm");
                    doc.addText(title + "  (" + FixesWindow.this.issues.size() + ") - " + mode, "font-size=20, font-weight=bold");
                    doc.nextParagraph();
                    String text = FixesWindow.this.getSectionName("summary");
                    doc.addText(text, "text-align=left, font-size=14, font-weight=bold, space-before=2cm, space-after=1cm, keep-with-next.within-page=always, text-decoration=underline");
                    doc.addLink(goToToc, tocAnchor);
                    doc.addTOCEntry(text);
                    doc.nextParagraph();
                    doc.startTable("genj:csv=true,width=60%");
                    doc.addTableColumn("column-width=70%");
                    doc.addTableColumn("column-width=30%");
                    for (String key : FixesWindow.this.summary.keySet()) {
                        doc.nextTableRow();
                        doc.addText(FixesWindow.this.getResource("section.summary." + key, new String[0]));
                        doc.nextTableCell();
                        doc.addText((String)FixesWindow.this.summary.get(key));
                    }
                    doc.endTable();
                    doc.nextParagraph();
                    LOG.fine("Display Issues: sort starting. Time=" + TimingUtility.getInstance().getTime());
                    try {
                        Collections.sort(FixesWindow.this.issues, (o1, o2) -> {
                            ViewContext vc1 = (ViewContext)o1;
                            ViewContext vc2 = (ViewContext)o2;
                            return vc1.getText().compareTo(vc2.getText());
                        });
                        LOG.fine("Display Issues: sort completed. Time=" + TimingUtility.getInstance().getTime());
                        String section = "";
                        String newSection = "";
                        String code = "";
                        String newCode = "";
                        ListIterator iterator = FixesWindow.this.issues.listIterator();
                        int p = 0;
                        int counterPerCorrection = 0;
                        HashSet<String> extractedTags = new HashSet<String>();
                        boolean truncated = false;
                        LOG.fine("Display Issues: start editing. Time=" + TimingUtility.getInstance().getTime());
                        while (iterator.hasNext() && !progressMonitor.isCanceled()) {
                            progressMonitor.setProgress(++p);
                            ViewContext c = (ViewContext)iterator.next();
                            newCode = c.getCode();
                            newSection = newCode.split("\\.")[0];
                            if (c != null && !code.equals(newCode)) {
                                if (!code.isEmpty()) {
                                    doc.endTable();
                                    doc.nextParagraph();
                                }
                                code = newCode;
                                LOG.fine("Display Issues: editing new code. Time=" + TimingUtility.getInstance().getTime() + " - code=" + newCode);
                                counterPerCorrection = 0;
                                extractedTags.clear();
                                truncated = false;
                                if (!section.equals(newSection)) {
                                    section = newSection;
                                    LOG.fine("Display Issues: editing new section. Time=" + TimingUtility.getInstance().getTime() + " - section=" + newSection);
                                    doc.nextParagraph("space-before=3cm, space-after=0cm, keep-with-next.within-page=always");
                                    String sectionStr = FixesWindow.this.getSectionName(section) + "  (" + FixesWindow.this.getSectionCount(section) + ")";
                                    doc.addText(sectionStr, "font-size=14, font-weight=bold, text-decoration=underline");
                                    doc.addLink(goToToc, tocAnchor);
                                    doc.addTOCEntry(sectionStr);
                                    doc.nextParagraph();
                                }
                                doc.nextParagraph("space-before=1cm, space-after=0.25cm, keep-with-next.within-page=always");
                                doc.addText(FixesWindow.this.getResource("col.correction", new String[0]) + ":   ", "font-weight=bold");
                                doc.addText(FixesWindow.this.getResource("section." + code, new String[0]) + "  (" + FixesWindow.this.getCorrectionCount(code) + ")");
                                doc.nextParagraph();
                                doc.startTable("genj:csv=true,width=100%");
                                doc.addTableColumn("column-width=5%");
                                doc.addTableColumn("column-width=15%");
                                doc.addTableColumn("column-width=10%");
                                doc.addTableColumn("column-width=15%");
                                doc.addTableColumn("column-width=10%");
                                doc.addTableColumn("column-width=15%");
                                doc.nextTableRow();
                                doc.nextTableCell();
                                doc.addText(FixesWindow.this.getResource("col.id", new String[0]), "font-weight=bold");
                                doc.nextTableCell();
                                doc.addText(FixesWindow.this.getResource("col.name", new String[0]), "font-weight=bold");
                                doc.nextTableCell();
                                doc.addText(FixesWindow.this.getResource("col.previousTag", new String[0]), "font-weight=bold");
                                doc.nextTableCell();
                                doc.addText(FixesWindow.this.getResource("col.previousValue", new String[0]), "font-weight=bold");
                                doc.nextTableCell();
                                doc.addText(FixesWindow.this.getResource("col.newTag", new String[0]), "font-weight=bold");
                                doc.nextTableCell();
                                doc.addText(FixesWindow.this.getResource("col.newValue", new String[0]), "font-weight=bold");
                            }
                            ImportFix fix = (ImportFix)FixesWindow.this.fixesMap.get(FixesWindow.this.getKey(c.getText()));
                            String tag = fix.getOldTag().replaceAll("[0123456789]", "");
                            if (extract && ++counterPerCorrection > 20 && (extractedTags.contains(tag) || extractedTags.size() > 500)) {
                                if (truncated) continue;
                                doc.nextTableRow();
                                doc.addText("...");
                                truncated = true;
                                continue;
                            }
                            extractedTags.add(tag);
                            truncated = false;
                            doc.nextTableRow();
                            doc.addLink(c.getEntity().getId().isEmpty() ? c.getEntity().getTag() : c.getEntity().getId(), c.getProperty() != null ? c.getProperty().getLinkAnchor() : c.getEntity().getLinkAnchor());
                            doc.nextTableCell();
                            String entityString = c.getEntity().toString(false);
                            if (entityString.length() > 100) {
                                entityString = entityString.substring(0, 75);
                            }
                            if (c.getEntity() instanceof Note) {
                                entityString = c.getEntity().getPropertyName();
                            }
                            doc.addText(entityString);
                            doc.nextTableCell();
                            doc.addText(fix.getOldTag());
                            doc.nextTableCell();
                            doc.addText(fix.getOldValue());
                            doc.nextTableCell();
                            doc.addText(fix.getNewTag());
                            doc.nextTableCell();
                            doc.addText(fix.getNewValue());
                        }
                        doc.endTable();
                        doc.nextParagraph();
                        doc.addText("   ");
                        doc.nextParagraph();
                        doc.addText("   ");
                        doc.nextParagraph();
                        doc.addText("   ");
                        doc.addLink(goToToc, tocAnchor);
                    }
                    catch (Exception e) {
                        LOG.severe("Display Issues during sorting and editing: exception = " + e);
                        Exceptions.printStackTrace((Throwable)e);
                    }
                } else {
                    doc.nextParagraph("text-align=center, space-before=2cm, space-after=1cm");
                    doc.addText(noissues);
                }
                SwingUtilities.invokeLater(() -> {
                    LOG.fine("Display Issues: window opening. Time=" + TimingUtility.getInstance().getTime());
                    FopDocumentView window = new FopDocumentView(FixesWindow.this.context, title, FixesWindow.this.getResource("tabtip", new String[0]));
                    window.displayDocument(doc, modulePreferences);
                    LOG.fine("Display Issues: window displayed. Time=" + TimingUtility.getInstance().getTime());
                });
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        GedcomEditorAction action = new GedcomEditorAction();
                        action.edit(FixesWindow.this.context.getProperty(), false);
                    }
                });
                progressMonitor.setProgress(size);
                LOG.fine("Display Issues: background task completed. Time=" + TimingUtility.getInstance().getTime());
                return null;
            }
        };
        fullTask.execute();
        LOG.fine("Display Issues: background task started. Time=" + TimingUtility.getInstance().getTime());
    }

    private String getSectionIndex(String code) {
        String str = code.split("\\.")[0];
        for (int i = 0; i < sections.length; ++i) {
            if (!sections[i].equals(str)) continue;
            return String.format("%03d", i);
        }
        return "000";
    }

    private String getSectionName(String section) {
        for (String item : sections) {
            if (!item.equals(section)) continue;
            return this.getResource("section." + item, new String[0]);
        }
        return "";
    }

    private String getSectionCount(String section) {
        int count = 0;
        for (ViewContext c : this.issues) {
            String str = c.getCode().split("\\.")[0];
            count += str.equals(section) ? 1 : 0;
        }
        return "" + count;
    }

    private String getCorrectionCount(String correction) {
        int count = 0;
        for (ViewContext c : this.issues) {
            String str = c.getCode();
            count += str.equals(correction) ? 1 : 0;
        }
        return "" + count;
    }

    private String getKey(String str) {
        String[] bits = str.split(";");
        return bits[4];
    }

    private Integer order(String entityTag) {
        int order = 9;
        for (String type : Gedcom.ENTITIES) {
            if (type.equals(entityTag)) {
                return order;
            }
            ++order;
        }
        return order;
    }

    private String getResource(String resource, String ... params) {
        String ret = "";
        try {
            ret = NbBundle.getMessage(FixesWindow.class, (String)resource, (Object[])params);
        }
        catch (MissingResourceException e) {
            System.err.println();
            LOG.log(Level.WARNING, "MissingResourceException: " + resource);
            ret = resource;
        }
        return ret;
    }

    private class Task
    extends SwingWorker<Void, Void> {
        private final ProgressMonitor pm;
        private int maxp = 0;

        public Task(ProgressMonitor progressMonitor, int maxProgress) {
            this.pm = progressMonitor;
            this.maxp = maxProgress;
        }

        @Override
        public Void doInBackground() {
            return null;
        }

        @Override
        public void done() {
            if (this.pm != null) {
                this.pm.setProgress(this.maxp);
            }
        }
    }
}

