/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.option.OptionsWidget;
import genj.report.Report;
import genj.report.ReportDetail;
import genj.report.ReportList;
import genj.report.ReportLoader;
import genj.report.ReportSelectionListener;
import genj.report.ReportView;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

class ReportSelector
extends JPanel {
    private ReportDetail detail = new ReportDetail();
    private ReportList list = new ReportList(ReportLoader.getInstance().getReports(), 1);
    private OptionsWidget options = new OptionsWidget("");
    private Action actionGroup = new ActionGroup();
    static final Resources RESOURCES = Resources.get(ReportView.class);

    public ReportSelector() {
        super(new BorderLayout());
        final Resources res = Resources.get((Object)this);
        final JTabbedPane right = new JTabbedPane();
        right.add(res.getString("title"), this.detail);
        right.add(res.getString("report.options"), (Component)this.options);
        this.detail.setOpaque(false);
        this.detail.setPreferredSize(new Dimension(320, 200));
        this.options.setPreferredSize(new Dimension(320, 200));
        this.add((Component)new JScrollPane(this.list), "West");
        this.add((Component)right, "Center");
        this.list.setSelectionListener(new ReportSelectionListener(){

            @Override
            public void valueChanged(Report report) {
                ReportSelector.this.detail.setReport(report);
                if (report != null) {
                    right.setTitleAt(0, report.getName());
                    ReportSelector.this.options.setOptions(report.getOptions());
                } else {
                    right.setTitleAt(0, res.getString("report.options"));
                    ReportSelector.this.options.setOptions(new ArrayList());
                }
            }
        });
    }

    public void select(Report report) {
        if (report != null) {
            this.list.setSelection(report);
        }
    }

    Report getReport() {
        this.options.stopEditing();
        return this.list.getSelection();
    }

    public Action getActionGroup() {
        return this.actionGroup;
    }

    private class ActionGroup
    extends AbstractAncestrisAction {
        protected ActionGroup() {
            this.setImage((Icon)new ImageIcon(ReportView.class, "Group"));
            this.setTip(RESOURCES.getString("report.group.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            int viewType = ReportSelector.this.list.getViewType();
            if (viewType == 0) {
                ReportSelector.this.list.setViewType(1);
            } else {
                ReportSelector.this.list.setViewType(0);
            }
        }
    }
}

