/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.community;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.stream.Collectors;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.community.Community;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.Sink;

public abstract class DecentralizedCommunityAlgorithm
implements DynamicAlgorithm,
Sink {
    protected Graph graph;
    protected String marker;
    protected String nonUniqueMarker;
    protected boolean graphChanged = true;
    protected boolean staticMode = false;
    protected Random rng;

    public DecentralizedCommunityAlgorithm() {
    }

    public DecentralizedCommunityAlgorithm(Graph graph) {
        this();
        this.init(graph);
    }

    public DecentralizedCommunityAlgorithm(Graph graph, String marker) {
        this();
        this.setMarker(marker);
        this.init(graph);
    }

    public void init(Graph graph, String marker) {
        this.setMarker(marker);
        this.init(graph);
    }

    @Override
    public void init(Graph graph) {
        if (this.marker == null) {
            this.setMarker(null);
        }
        this.graph = graph;
        if (this.rng == null) {
            this.rng = new Random();
        }
    }

    @Override
    public void terminate() {
    }

    public void staticMode() {
        this.staticMode = true;
    }

    @Parameter
    public void setMarker(String marker) {
        this.nonUniqueMarker = marker == null ? "community" : marker;
        this.marker = this.toString() + "." + this.nonUniqueMarker;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setRandom(Random rng) {
        this.rng = rng;
    }

    public Random getRandom() {
        return this.rng;
    }

    @Override
    public void compute() {
        if (this.graphChanged) {
            ArrayList nodeSet = this.graph.nodes().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(nodeSet, this.rng);
            nodeSet.forEach(node -> {
                this.computeNode((Node)node);
                this.updateDisplayClass((Node)node);
            });
            this.graphChanged = this.staticMode;
        }
    }

    public abstract void computeNode(Node var1);

    protected void originateCommunity(Node node) {
        node.setAttribute(this.marker, new Object[]{new Community()});
    }

    protected void updateDisplayClass(Node node) {
        node.setAttribute("ui.class", new Object[]{this.nonUniqueMarker + "_" + ((Community)node.getAttribute(this.marker)).getId()});
    }

    public void attributeChanged(Element element, String attribute, Object oldValue, Object newValue) {
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        this.graphChanged = true;
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        this.graphChanged = true;
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.graphChanged = true;
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        this.graphChanged = true;
    }

    public void graphCleared(String graphId, long timeId) {
        this.graphChanged = true;
    }

    public void stepBegins(String graphId, long timeId, double time) {
    }

    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
    }

    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
    }

    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        this.nodeAttributeChanged(graphId, timeId, nodeId, attribute, null, value);
    }

    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
    }

    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
    }

    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
    }

    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
    }

    @Result
    public String defaultMessage() {
        return "Result stored in \"ui.class\" attribute";
    }
}

