/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import org.geonames.WebService;

public class WikipediaArticle {
    private String language;
    private String title;
    private String summary;
    private String wikipediaUrl;
    private String feature;
    private int population;
    private Integer elevation;
    private double latitude;
    private double longitude;
    private String thumbnailImg;
    private int rank;
    public static final Comparator ELEVATION_ORDER = new Comparator<WikipediaArticle>(){

        @Override
        public int compare(WikipediaArticle wikipediaArticle, WikipediaArticle wikipediaArticle2) {
            return Double.compare(wikipediaArticle2.elevation.intValue(), wikipediaArticle.elevation.intValue());
        }
    };
    public static final Comparator RANK_ORDER = new Comparator<WikipediaArticle>(){

        @Override
        public int compare(WikipediaArticle wikipediaArticle, WikipediaArticle wikipediaArticle2) {
            return Double.compare(wikipediaArticle2.rank, wikipediaArticle.rank);
        }
    };

    public Integer getElevation() {
        return this.elevation;
    }

    public void setElevation(int n) {
        this.elevation = n;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String string) {
        this.feature = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d) {
        this.latitude = d;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d) {
        this.longitude = d;
    }

    public int getPopulation() {
        return this.population;
    }

    public void setPopulation(int n) {
        this.population = n;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String string) {
        this.summary = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getWikipediaUrl() {
        if (this.wikipediaUrl == null || WebService.isAndroid()) {
            String string = this.title.replace(' ', '_');
            try {
                string = URLEncoder.encode(string, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            String string2 = this.language;
            if (WebService.isAndroid()) {
                string2 = string2 + ".m";
            }
            return "http://" + string2 + ".wikipedia.org/wiki/" + string;
        }
        return this.wikipediaUrl;
    }

    public void setWikipediaUrl(String string) {
        this.wikipediaUrl = string;
    }

    public String getThumbnailImg() {
        return this.thumbnailImg;
    }

    public void setThumbnailImg(String string) {
        this.thumbnailImg = string;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int n) {
        this.rank = n;
    }
}

