/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import ancestris.api.core.Version;
import genj.crypto.Enigma;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.time.PointInTime;
import genj.io.AnselCharset;
import genj.io.Filter;
import genj.io.GedcomEncodingException;
import genj.io.GedcomEncodingSniffer;
import genj.io.GedcomIOException;
import genj.io.IGedcomWriter;
import genj.io.PropertyWriter;
import genj.util.Resources;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public class GedcomWriter
implements IGedcomWriter {
    private static final Resources RESOURCES = Resources.get(GedcomWriter.class);
    private static final Logger LOG = Logger.getLogger("ancestris.io");
    private Gedcom gedcom;
    private BufferedWriter out;
    private String file;
    private String date;
    private String time;
    private int total;
    private int line;
    private int entity;
    private boolean cancel = false;
    private Filter filter;
    private boolean hasVetoed = false;
    private Enigma enigma = null;
    private boolean sort = false;

    public GedcomWriter(Gedcom ged, OutputStream stream) throws IOException, GedcomEncodingException {
        Calendar now = Calendar.getInstance();
        this.gedcom = ged;
        this.file = ged.getOrigin() == null ? "Uknown" : ged.getOrigin().getFileName();
        this.line = 0;
        this.date = PointInTime.getNow().getValue();
        this.time = new SimpleDateFormat("HH:mm:ss").format(now.getTime());
        this.filter = new Filter.Union(this.gedcom, Collections.emptyList());
        CharsetEncoder encoder = this.getCharset(stream, ged.getEncoding()).newEncoder();
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.out = new BufferedWriter(new OutputStreamWriter(stream, encoder));
    }

    private Charset getCharset(OutputStream out, String encoding) throws GedcomEncodingException {
        try {
            if ("UNICODE".equals(encoding)) {
                try {
                    out.write(GedcomEncodingSniffer.BOM_UTF16BE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return Charset.forName("UTF-16BE");
            }
            if ("UTF-8".equals(encoding)) {
                try {
                    out.write(GedcomEncodingSniffer.BOM_UTF8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return Charset.forName("UTF-8");
            }
            if ("ASCII".equals(encoding)) {
                return Charset.forName("ISO-8859-1");
            }
            if ("LATIN1".equals(encoding)) {
                return Charset.forName("ISO-8859-1");
            }
            if ("ANSI".equals(encoding)) {
                return Charset.forName("Windows-1252");
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        if ("ANSEL".equals(encoding)) {
            return new AnselCharset();
        }
        throw new GedcomEncodingException("Can't write with unknown encoding " + encoding);
    }

    @Override
    public void cancelTrackable() {
        this.cancel = true;
    }

    @Override
    public int getProgress() {
        if (this.entity == 0) {
            return 0;
        }
        return this.entity * 100 / this.total;
    }

    @Override
    public String getState() {
        String lStr = NumberFormat.getIntegerInstance().format(this.line);
        String eStr = NumberFormat.getIntegerInstance().format(this.entity);
        return this.getTaskName() + " : " + RESOURCES.getString("progress.read.entities", "" + lStr, eStr);
    }

    @Override
    public String getTaskName() {
        if (this.gedcom != null) {
            return RESOURCES.getString("writer.title", this.gedcom.getName());
        }
        return "";
    }

    @Override
    public void setFilters(Collection<Filter> fs) {
        this.filter = new Filter.Union(this.gedcom, fs);
    }

    @Override
    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public int getLines() {
        return this.line;
    }

    @Override
    public void write() throws GedcomIOException {
        if (this.gedcom == null) {
            throw new IllegalStateException("can't call write() twice");
        }
        ArrayList<Entity> ents = new ArrayList<Entity>();
        ents.addAll(this.gedcom.getEntities());
        this.total = ents.size();
        try {
            this.writeHeader();
            if (this.sort) {
                ArrayList<Entity> indis = new ArrayList<Entity>();
                indis.addAll(this.gedcom.getEntities("INDI"));
                Collections.sort(indis);
                this.writeEntities(indis);
                ents.removeAll(indis);
                ArrayList<Entity> fams = new ArrayList<Entity>();
                fams.addAll(this.gedcom.getEntities("FAM"));
                Collections.sort(fams);
                this.writeEntities(fams);
                ents.removeAll(fams);
                ArrayList<Entity> objs = new ArrayList<Entity>();
                objs.addAll(this.gedcom.getEntities("OBJE"));
                Collections.sort(objs);
                this.writeEntities(objs);
                ents.removeAll(objs);
                ArrayList<Entity> notes = new ArrayList<Entity>();
                notes.addAll(this.gedcom.getEntities("NOTE"));
                Collections.sort(notes);
                this.writeEntities(notes);
                ents.removeAll(notes);
                ArrayList<Entity> sources = new ArrayList<Entity>();
                sources.addAll(this.gedcom.getEntities("SOUR"));
                Collections.sort(sources);
                this.writeEntities(sources);
                ents.removeAll(sources);
                ArrayList<Entity> repos = new ArrayList<Entity>();
                repos.addAll(this.gedcom.getEntities("REPO"));
                Collections.sort(repos);
                this.writeEntities(repos);
                ents.removeAll(repos);
                ArrayList<Entity> subms = new ArrayList<Entity>();
                subms.addAll(this.gedcom.getEntities("SUBM"));
                Collections.sort(subms);
                this.writeEntities(subms);
                ents.removeAll(subms);
                this.writeEntities(ents);
            } else {
                this.writeEntities(ents);
            }
            this.writeTail();
            this.out.close();
        }
        catch (GedcomIOException ioe) {
            throw ioe;
        }
        catch (UnmappableCharacterException unme) {
            throw new GedcomEncodingException(this.gedcom.getFirstEntity("HEAD"), this.gedcom.getEncoding());
        }
        catch (GedcomException | IOException ex) {
            throw new GedcomIOException("Error while writing / " + ex.getMessage(), this.line);
        }
        finally {
            this.gedcom = null;
        }
    }

    private void writeLine(String line) throws IOException {
        this.out.write(line);
        this.out.newLine();
        ++this.line;
    }

    private Entity writeHeader() throws IOException, GedcomException {
        Entity header = this.gedcom.getFirstEntity("HEAD");
        if (header == null) {
            header = this.gedcom.createEntity("HEAD", "");
        }
        Property prop = this.replaceProperties(header, "SOUR", "ANCESTRIS");
        prop.addProperty("VERS", ((Version)Lookup.getDefault().lookup(Version.class)).getVersionString());
        prop.addProperty("NAME", "Ancestris");
        prop.addProperty("CORP", RESOURCES.getString("header.corp", "Ancestris")).addProperty("ADDR", "http://www.ancestris.org");
        this.replaceProperties(header, "DEST", this.gedcom.getDestination());
        this.replaceProperties(header, "DATE", this.date).addProperty("TIME", this.time);
        if (this.gedcom.getSubmitter() != null) {
            this.replaceProperties(header, "SUBM", "@" + this.gedcom.getSubmitter().getId() + '@');
        }
        this.replaceProperties(header, "FILE", this.file);
        prop = this.replaceProperties(header, "GEDC", "");
        prop.addProperty("VERS", this.gedcom.getGrammar().getVersion());
        prop.addProperty("FORM", "LINEAGE-LINKED");
        this.replaceProperties(header, "CHAR", this.gedcom.getEncoding());
        if (this.gedcom.getLanguage() != null) {
            this.replaceProperties(header, "LANG", this.gedcom.getLanguage());
        }
        new EntityWriter().write(0, header);
        return header;
    }

    private Property replaceProperties(Property prop, String tag, String value) {
        prop.delProperties(tag);
        return prop.addProperty(tag, value);
    }

    private void writeEntities(List<Entity> entities) throws IOException {
        for (Entity e : entities) {
            if ("HEAD".equals(e.getTag())) continue;
            if (this.cancel) {
                throw new GedcomIOException("Operation cancelled", this.line);
            }
            if (this.filter.veto(e)) {
                this.hasVetoed = true;
                continue;
            }
            try {
                this.line += new EntityWriter().write(0, e);
            }
            catch (UnmappableCharacterException unme) {
                throw new GedcomEncodingException(e, this.gedcom.getEncoding());
            }
            ++this.entity;
        }
    }

    private void writeTail() throws IOException {
        this.writeLine("0 TRLR");
    }

    @Override
    public boolean hasFiltersVetoed() {
        return this.hasVetoed;
    }

    private class EntityWriter
    extends PropertyWriter {
        EntityWriter() {
            super(GedcomWriter.this.out, false);
        }

        @Override
        protected void writeProperty(int level, Property prop) throws IOException {
            if (!prop.getTag().equalsIgnoreCase("HEAD") && !prop.isTransient() && !prop.isGuessed() && GedcomWriter.this.filter.veto(prop)) {
                GedcomWriter.this.hasVetoed = true;
                return;
            }
            super.writeProperty(level, prop);
        }

        @Override
        protected String getValue(Property prop) throws IOException {
            return prop.isPrivate() ? this.encrypt(prop.getValue()) : super.getValue(prop);
        }

        private String encrypt(String value) throws IOException {
            if (GedcomWriter.this.gedcom.getPassword() == null || value.length() == 0) {
                return value;
            }
            if (GedcomWriter.this.enigma == null) {
                if (GedcomWriter.this.gedcom.getPassword() == "unknown") {
                    return value;
                }
                if (GedcomWriter.this.gedcom.getPassword() == null) {
                    throw new IOException("Password not set - needed for encryption");
                }
                GedcomWriter.this.enigma = Enigma.getInstance(GedcomWriter.this.gedcom.getPassword());
                if (GedcomWriter.this.enigma == null) {
                    throw new IOException("Encryption not available");
                }
            }
            return GedcomWriter.this.enigma.encrypt(value);
        }
    }
}

