/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Property;

public class Source
extends Entity {
    public Source(String tag, String id) {
        super(tag, id);
        this.assertTag("SOUR");
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty();
    }

    @Override
    public void moveEntityValue() {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.getTitle().isEmpty()) {
                this.setTitle(value);
                this.setValue("");
            } else {
                super.moveEntityValue();
            }
        }
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        return this.getTitle();
    }

    @Override
    public String getDisplayTitle() {
        int cut;
        int len;
        int maxLen = 30;
        String str = this.getTitle().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut);
        }
        if (str.isEmpty()) {
            str = "?";
        }
        return this.getId() + " - " + str;
    }

    public String getTitle() {
        Property title = this.getProperty("TITL");
        return title != null ? title.getValue() : "";
    }

    public void setTitle(String title) {
        Property property = this.getProperty("TITL");
        if (property == null) {
            property = this.addProperty("TITL", title);
        } else {
            property.setValue(title);
        }
    }

    public String getText() {
        Property text = this.getProperty("TEXT");
        if (text != null) {
            return text.getValue();
        }
        return "";
    }
}

