/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;

public class PropertyWife
extends PropertyXRef {
    private static final TagPath PATH_INDIFAMS = new TagPath("INDI:FAMS");
    public static final String TAG = "WIFE";
    public static final String LABEL_MOTHER = Gedcom.resources.getString("WIFE.mother");
    public static final String LABEL = Gedcom.resources.getString("WIFE.name");

    public PropertyWife() {
        super(TAG);
    }

    protected PropertyWife(String tag) {
        super(tag);
        this.assertTag(TAG);
    }

    @Override
    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.wife.veto");
    }

    public Indi getWife() {
        return (Indi)this.getTargetEntity();
    }

    @Override
    public void link() throws GedcomException {
        PropertyFamilySpouse pfs;
        Fam fam = null;
        try {
            fam = (Fam)this.getEntity();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (fam == null) {
            throw new GedcomException(resources.getString("error.noenclosingfam"));
        }
        if (fam.getWife() != null) {
            throw new GedcomException(resources.getString("error.already.spouse", fam.getWife().toString(), fam.toString()));
        }
        Indi wife = (Indi)this.getCandidate();
        if (fam.getHusband() == wife) {
            throw new GedcomException(resources.getString("error.already.spouse", wife.toString(), fam.toString()));
        }
        if (wife.isDescendantOf(fam)) {
            throw new GedcomException(resources.getString("error.already.descendant", wife.toString(), fam.toString()));
        }
        Property[] ps = wife.getProperties(PATH_INDIFAMS);
        for (int i = 0; i < ps.length; ++i) {
            pfs = (PropertyFamilySpouse)ps[i];
            if (!pfs.isCandidate(fam)) continue;
            this.link(pfs);
            return;
        }
        pfs = new PropertyFamilySpouse();
        wife.addProperty(pfs);
        this.link(pfs);
    }

    @Override
    public String getTargetType() {
        return "INDI";
    }

    @Override
    public ImageIcon getImage(boolean checkValid) {
        Indi wife = this.getWife();
        if (wife == null) {
            return super.getImage(checkValid);
        }
        switch (wife.getSex()) {
            case 1: {
                return this.overlay(PropertyChild.IMG_MALE);
            }
            case 2: {
                return this.overlay(PropertyChild.IMG_FEMALE);
            }
        }
        return this.overlay(PropertyChild.IMG_UNKNOWN);
    }
}

