/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.modules.commonAncestor.graphics.IGraphicsRenderer;
import ancestris.swing.ToolBar;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.SelectionDispatcher;
import genj.fo.Format;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.io.FileAssociation;
import genj.report.ReportView;
import genj.util.swing.EditorHyperlinkSupport;
import genj.util.swing.ImageIcon;
import genj.util.swing.SliderWidget;
import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.NbBundle;

public class PreviewView
extends JPanel {
    static final Logger LOG = Logger.getLogger("genj.report");
    private static final String WELCOME = "welcome";
    private static final String CONSOLE = "console";
    private static final String RESULT = "result";
    private String currentPage = "welcome";
    private Console output;
    private JScrollPane result;
    private ActionShow actionShow = new ActionShow();
    private static final ImageIcon imgStart = new ImageIcon(ReportView.class, "Start");
    private static final ImageIcon imgStop = new ImageIcon(ReportView.class, "Stop");
    private static final ImageIcon imgSave = new ImageIcon(ReportView.class, "Save");
    private static final ImageIcon imgConsole = new ImageIcon(ReportView.class, "ReportShell");
    private static final ImageIcon imgGui = new ImageIcon(ReportView.class, "ReportGui");
    private Gedcom gedcom;
    private double zoom = 1.0;
    private SliderWidget sliderZoom;
    private IGraphicsRenderer renderer;
    private Point lastPoint;
    private JComponent scrolledComponent;

    public PreviewView() {
        this.setLayout(new CardLayout());
        this.output = new Console();
        this.add((Component)new JScrollPane(this.output), CONSOLE);
        this.result = new JScrollPane(new JPanel());
        this.add((Component)this.result, RESULT);
        this.result.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PreviewView.this.lastPoint = e.getPoint();
                PreviewView.this.result.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PreviewView.this.result.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.result.addMouseMotionListener(new MouseMotionAdapter(){
            private JScrollBar hSb;
            private JScrollBar vSb;
            {
                this.hSb = PreviewView.this.result.getHorizontalScrollBar();
                this.vSb = PreviewView.this.result.getVerticalScrollBar();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int dX = ((PreviewView)PreviewView.this).lastPoint.x - e.getX();
                int dY = ((PreviewView)PreviewView.this).lastPoint.y - e.getY();
                this.hSb.setValue(this.hSb.getValue() + (int)((double)dX * PreviewView.this.zoom));
                this.vSb.setValue(this.vSb.getValue() + (int)((double)dY * PreviewView.this.zoom));
                PreviewView.this.lastPoint = e.getPoint();
            }
        });
        this.result.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int newValue = PreviewView.this.sliderZoom.getValue() - e.getWheelRotation() * 3;
                PreviewView.this.sliderZoom.setValue(newValue);
            }
        });
    }

    void show(String page) {
        if (!this.currentPage.equals(page)) {
            ((CardLayout)this.getLayout()).show(this, page);
            this.currentPage = page;
        }
    }

    void showResult(Object object) {
        if (object == null) {
            if (this.output.getDocument().getLength() == 0) {
                this.show(WELCOME);
            }
            return;
        }
        if (object instanceof InterruptedException) {
            this.output.add("*** cancelled");
            return;
        }
        if (object instanceof Throwable) {
            CharArrayWriter buf = new CharArrayWriter(256);
            ((Throwable)object).printStackTrace(new PrintWriter(buf));
            this.output.add("*** exception caught\n" + buf);
            LOG.log(Level.WARNING, "Exception caught ", (Throwable)object);
            return;
        }
        if (object instanceof File) {
            File file = (File)object;
            if (file.getName().endsWith(".htm") || file.getName().endsWith(".html")) {
                try {
                    object = file.toURI().toURL();
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    FileAssociation.getDefault().execute(file.getAbsolutePath());
                }
                catch (Throwable t) {
                    Logger.getLogger("genj.report").log(Level.INFO, "can't open " + file, t);
                    this.output.add("*** can't open file " + file);
                }
                return;
            }
        }
        if (object instanceof URL) {
            try {
                this.output.setPage((URL)object);
            }
            catch (IOException e) {
                this.output.add("*** can't open URL " + object + ": " + e.getMessage());
            }
            this.actionShow.setEnabled(false);
            this.actionShow.setSelected(false);
            this.show(CONSOLE);
            return;
        }
        if (object instanceof JComponent) {
            JComponent c = (JComponent)object;
            c.setMinimumSize(new Dimension(0, 0));
            this.scrolledComponent = c;
            this.result.setViewportView(c);
            this.actionShow.setEnabled(true);
            this.actionShow.setSelected(true);
            this.show(RESULT);
            return;
        }
        if (object instanceof genj.fo.Document) {
            genj.fo.Document doc = (genj.fo.Document)object;
            Format[] formats = Format.getFormats();
            HashMap<String, String> fmts = new HashMap<String, String>();
            for (Format format : formats) {
                fmts.put(format.getFormat(), format.getFileExtension());
            }
            FileChooserBuilder fcb = new FileChooserBuilder(genj.fo.Document.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"Fo_Document", (Object)doc.getTitle())).setApproveText(NbBundle.getMessage(this.getClass(), (String)"Fo_OK_Select")).setDefaultExtension(formats[0].getFileExtension()).setFileFilters(fmts).setAcceptAllFileFilterUsed(false).setDefaultDirAsReportDirectory().setFileHiding(true);
            File file = fcb.showSaveDialog();
            if (file == null) {
                this.showResult(null);
                return;
            }
            Format formatter = Format.getFormatFromExtension((String)FileChooserBuilder.getExtension((String)file.getName()));
            try {
                file.getParentFile().mkdirs();
                formatter.format(doc, file);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "formatting " + doc + " failed", t);
                this.output.add("*** formatting " + doc + " failed");
                return;
            }
            this.showResult(file);
            return;
        }
        this.output.add("*** report returned unknown result " + object);
    }

    public void setZoom(double d) {
        this.zoom = Math.max(0.1, Math.min(1.0, d));
        if (this.renderer != null) {
            this.renderer.setZoom(this.zoom);
            if (this.scrolledComponent != null) {
                this.scrolledComponent.setPreferredSize(new Dimension(this.renderer.getImageWidth(), this.renderer.getImageHeight()));
                this.scrolledComponent.setSize(new Dimension(this.renderer.getImageWidth(), this.renderer.getImageHeight()));
                this.repaint();
            }
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    void setRenderer(IGraphicsRenderer renderer) {
        this.renderer = renderer;
        renderer.setZoom(this.zoom);
    }

    public void populate(ToolBar toolbar) {
        this.sliderZoom = new SliderWidget(1, 100, (int)(this.zoom * 100.0));
        this.sliderZoom.addChangeListener((ChangeListener)new SliderListener());
        this.sliderZoom.setAlignmentX(0.0f);
        this.sliderZoom.setOpaque(false);
        this.sliderZoom.setFocusable(false);
        toolbar.add((JComponent)this.sliderZoom);
        JLabel dummy = new JLabel();
        dummy.setPreferredSize(new Dimension(20, 20));
        dummy.setEnabled(false);
        toolbar.add((JComponent)dummy);
    }

    private class Console
    extends JEditorPane
    implements MouseListener,
    MouseMotionListener {
        private String id = null;

        private Console() {
            this.setContentType("text/plain");
            this.setFont(new Font("Monospaced", 0, 12));
            this.setEditable(false);
            this.addHyperlinkListener((HyperlinkListener)new EditorHyperlinkSupport((JEditorPane)this));
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.id = this.markIDat(e.getPoint());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Entity entity;
            if (this.id != null && PreviewView.this.gedcom != null && (entity = PreviewView.this.gedcom.getEntity(this.id)) != null) {
                SelectionDispatcher.fireSelection((AWTEvent)e, (Context)new Context(entity));
            }
        }

        private String markIDat(Point loc) {
            try {
                int pos = this.viewToModel(loc);
                if (pos < 0) {
                    return null;
                }
                Document doc = this.getDocument();
                int i = 0;
                while (true) {
                    if (i == 10) {
                        return null;
                    }
                    if (pos == 0 || !Character.isLetterOrDigit(doc.getText(pos - 1, 1).charAt(0))) break;
                    --pos;
                    ++i;
                }
                int len = 0;
                while (true) {
                    if (len == 10) {
                        return null;
                    }
                    if (pos + len == doc.getLength() || !Character.isLetterOrDigit(doc.getText(pos + len, 1).charAt(0))) break;
                    ++len;
                }
                if (len < 2) {
                    return null;
                }
                String id = doc.getText(pos, len);
                if (PreviewView.this.gedcom == null || PreviewView.this.gedcom.getEntity(id) == null) {
                    return null;
                }
                this.setCaretPosition(pos);
                this.moveCaretPosition(pos + len);
                return id;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        void clear() {
            this.setContentType("text/plain");
            this.setText("");
        }

        void add(String txt) {
            Document doc = this.getDocument();
            try {
                doc.insertString(doc.getLength(), txt, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class ActionShow
    extends AbstractAncestrisAction {
        protected ActionShow() {
            this.setImage((Icon)imgConsole);
            this.setTip(NbBundle.getMessage(ReportView.class, (String)"report.output"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            this.setSelected(this.isSelected());
        }

        public boolean setSelected(boolean selected) {
            this.setImage((Icon)(selected ? imgGui : imgConsole));
            if (selected) {
                PreviewView.this.show(PreviewView.RESULT);
            } else {
                PreviewView.this.show(PreviewView.CONSOLE);
            }
            return super.setSelected(selected);
        }
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PreviewView.this.setZoom((double)PreviewView.this.sliderZoom.getValue() * 0.01);
        }
    }
}

