/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.explorer.EntitiesNode;
import ancestris.explorer.EntityNode;
import ancestris.explorer.GedcomEntities;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

class EntityChildren
extends Children.SortedArray
implements GedcomMetaListener {
    private final GedcomEntities entities;
    private final String tag;
    private final boolean tagIsFam;
    private TreeSet<Entity> addedEntities;
    private TreeSet<Entity> deletedEntities;
    private TreeSet<Entity> changedEntities;

    public EntityChildren(GedcomEntities entities) {
        this.entities = entities;
        this.tag = entities.getTag();
        this.tagIsFam = this.tag.equals("FAM");
        entities.getGedcom().addGedcomListener((GedcomListener)this);
        this.addedEntities = new TreeSet();
        this.deletedEntities = new TreeSet();
        this.changedEntities = new TreeSet();
    }

    public Collection<Node> initCollection() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Entity entity : this.entities.getEntities()) {
            result.add((Node)new EntityNode(entity));
        }
        return result;
    }

    protected void addNotify() {
        super.addNotify();
        AncestrisPlugin.register((Object)((Object)this));
    }

    protected void removeNotify() {
        super.removeNotify();
        if (this.entities != null) {
            this.entities.getGedcom().removeGedcomListener((GedcomListener)this);
        }
        AncestrisPlugin.unregister((Object)((Object)this));
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        if (this.tag.equals(entity.getTag())) {
            this.addedEntities.add(entity);
            return;
        }
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        if (this.tag.equals(entity.getTag())) {
            this.deletedEntities.add(entity);
            return;
        }
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        this.invalidate(property.getEntity());
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        this.invalidate(property.getEntity());
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        this.invalidate(property.getEntity());
    }

    private void invalidate(Entity entity) {
        if (this.tag.equals(entity.getTag()) || this.tagIsFam && entity instanceof Indi) {
            this.changedEntities.add(entity);
            return;
        }
    }

    public void gedcomHeaderChanged(Gedcom gedcom) {
    }

    public void gedcomWriteLockAcquired(Gedcom gedcom) {
        this.addedEntities.clear();
        this.deletedEntities.clear();
        this.changedEntities.clear();
    }

    public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomAfterUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomWriteLockReleased(Gedcom gedcom) {
        EntityNode en;
        Node node;
        if (!this.addedEntities.isEmpty()) {
            for (Entity entity : this.addedEntities) {
                this.add((Node[])new EntityNode[]{new EntityNode(entity)});
            }
            node = this.getNode();
            if (node instanceof EntitiesNode) {
                EntitiesNode esn = (EntitiesNode)node;
                esn.updateDisplay();
            }
        }
        if (!this.deletedEntities.isEmpty()) {
            for (Node n : this.getNodes()) {
                en = (EntityNode)n;
                if (!this.deletedEntities.contains(en.getEntity())) continue;
                this.remove((Node[])new EntityNode[]{en});
            }
            node = this.getNode();
            if (node instanceof EntitiesNode) {
                EntitiesNode esn = (EntitiesNode)node;
                esn.updateDisplay();
            }
        }
        if (!this.changedEntities.isEmpty()) {
            if (this.tagIsFam) {
                for (Node n : this.getNodes()) {
                    en = (EntityNode)n;
                    Fam f = (Fam)en.getEntity();
                    Indi i = f.getHusband();
                    if (i != null && this.changedEntities.contains(i)) {
                        en.fireChanges();
                        continue;
                    }
                    i = f.getWife();
                    if (i == null || !this.changedEntities.contains(i)) continue;
                    en.fireChanges();
                }
            } else {
                for (Node n : this.getNodes()) {
                    en = (EntityNode)n;
                    if (!this.changedEntities.contains(en.getEntity())) continue;
                    en.fireChanges();
                }
            }
        }
        this.refresh();
    }
}

