/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app.actions;

import ancestris.app.App;
import ancestris.app.actions.SortEntityAction;
import ancestris.app.actions.SortEntityTask;
import ancestris.util.ProgressListener;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.util.Trackable;
import java.awt.event.ActionEvent;
import java.util.List;
import org.openide.util.NbBundle;
import spin.Spin;

public class SortAllEntitiesAction
extends SortEntityAction {
    public SortAllEntitiesAction() {
        this.setText(NbBundle.getMessage(App.class, (String)"action.sortAll"));
        this.setTip(NbBundle.getMessage(App.class, (String)"action.sortAll.tip"));
    }

    @Override
    public void actionPerformedImpl(ActionEvent ae) {
        if (this.getContext() == null) {
            return;
        }
        SortEntityTask dj = (SortEntityTask)Spin.off((Object)new DoJob(this.getGedcom()));
        ProgressListener.Dispatcher.processStarted((Trackable)dj);
        try {
            this.getGedcom().doUnitOfWork(g -> dj.run());
        }
        catch (GedcomException e) {
            DialogManager.createError(null, (String)e.getMessage()).show();
        }
        ProgressListener.Dispatcher.processStopped((Trackable)dj);
    }

    private class DoJob
    implements SortEntityTask {
        private int counter = 0;
        private int maxCounter = 0;
        private boolean cancel = false;
        private Gedcom gedcom;

        DoJob(Gedcom g) {
            this.gedcom = g;
        }

        @Override
        public void run() {
            this.maxCounter = this.gedcom.getIndis().size() + this.gedcom.getFamilies().size();
            this.gedcom.getIndis().forEach(indi -> {
                List<Property> lp = SortAllEntitiesAction.this.doSortPropertyIndi((Indi)indi);
                indi.moveProperties(lp, 0);
                ++this.counter;
            });
            this.gedcom.getFamilies().forEach(fam -> {
                List<Property> lp = SortAllEntitiesAction.this.doSortPropertyFam((Fam)fam);
                fam.moveProperties(lp, 0);
                ++this.counter;
            });
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            return 100 * this.counter / this.maxCounter;
        }

        public String getState() {
            return this.gedcom.getName();
        }

        public String getTaskName() {
            return "SortEntitiesName";
        }
    }
}

