/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.api.search.SearchCommunicator;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import genj.util.swing.ImageIcon;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.MenuElement;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ReplacePanel
extends JPanel {
    static final Logger LOG = Logger.getLogger("ancestris.find-and-replace");
    Gedcom gedcom;
    private Registry registry = null;
    boolean replaceMode = false;
    private DefaultComboBoxModel cbFindModel = new DefaultComboBoxModel();
    JTextComponent comboFindText = null;
    private DefaultComboBoxModel cbReplaceModel = new DefaultComboBoxModel();
    JTextComponent comboReplaceText = null;
    private LinkedList<String> oldFindWhat;
    private LinkedList<String> oldReplaceWith;
    private LinkedList<String> oldSelectedEntities;
    private LinkedList<String> oldSelectedCategories;
    private static final String[] DEFAULT_VALUES = new String[]{""};
    private static final int MAX_OLD = 16;
    private String SELECT_ALL = "";
    private String UNSELECT_ALL = "";
    private JPopupMenu entityPopupMenu;
    private JPopupMenu propertyPopupMenu;
    private List<Category> categories = null;
    private boolean categoryUpToDate = false;
    private List<Property> results = null;
    private int resultsTotal = 0;
    private int resultsCurrent = 0;
    private boolean ready = false;
    private JButton entityFilter;
    private JLabel filtersLabel;
    private JComboBox findCombo;
    private JLabel findwhatLabel1;
    private JCheckBox matchCheckBox;
    private JLabel matchesLabel;
    private JButton nextButton;
    private JButton previousButton;
    private JButton propertyFilter;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JComboBox replaceCombo;
    private JLabel replacewithLabel;
    private JLabel resultEntity;
    private JLabel resultEntityLabel;
    private JLabel resultProperty;
    private JLabel resultPropertyLabel;
    private JScrollPane resultScrollPane;
    private JTextPane resultTextPane;
    private JLabel resultmatchesLabel;
    private JCheckBox selectionCheckBox;
    private JButton showButton;
    private JCheckBox wholeWordCheckBox;

    public ReplacePanel(Gedcom gedcom, boolean replaceMode) {
        this.registry = Registry.get(this.getClass());
        this.gedcom = gedcom;
        this.replaceMode = replaceMode;
        this.oldFindWhat = new LinkedList<String>(Arrays.asList(this.registry.get("findreplace_old_findwhat", DEFAULT_VALUES)));
        this.oldReplaceWith = new LinkedList<String>(Arrays.asList(this.registry.get("findreplace_old_replacewith", DEFAULT_VALUES)));
        this.updateModel(this.cbFindModel, this.oldFindWhat);
        this.updateModel(this.cbReplaceModel, this.oldReplaceWith);
        this.SELECT_ALL = NbBundle.getMessage(this.getClass(), (String)"ReplacePanel.entityFilter.selectall");
        this.UNSELECT_ALL = NbBundle.getMessage(this.getClass(), (String)"ReplacePanel.entityFilter.unselectall");
        this.results = new ArrayList<Property>();
        this.oldSelectedEntities = new LinkedList<String>(Arrays.asList(this.registry.get("findreplace_old_selectedEntities", Gedcom.ENTITIES)));
        this.entityPopupMenu = new JPopupMenu();
        JCheckBoxMenuItem entityMenuItem = new JCheckBoxMenuItem(this.UNSELECT_ALL, null, false);
        entityMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                boolean set = item.getText().equals(ReplacePanel.this.SELECT_ALL);
                for (MenuElement element : ReplacePanel.this.entityPopupMenu.getSubElements()) {
                    ((JCheckBoxMenuItem)element).setSelected(set);
                }
                item.setText(set ? ReplacePanel.this.UNSELECT_ALL : ReplacePanel.this.SELECT_ALL);
                item.setSelected(false);
                ReplacePanel.this.showEntityMenu();
                ReplacePanel.this.resetCategories();
            }
        });
        this.entityPopupMenu.add(entityMenuItem);
        for (String str : Gedcom.ENTITIES) {
            boolean select = this.oldSelectedEntities.isEmpty();
            for (String oldEnt : this.oldSelectedEntities) {
                if (!str.equals(oldEnt)) continue;
                select = true;
                break;
            }
            int nb = gedcom.getEntities(str).size();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(Gedcom.getName((String)str) + " (" + nb + ")", (Icon)Gedcom.getEntityImage((String)str), select);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReplacePanel.this.showEntityMenu();
                    ReplacePanel.this.categoryUpToDate = false;
                }
            });
            this.entityPopupMenu.add(item);
        }
        this.oldSelectedCategories = new LinkedList<String>(Arrays.asList(this.registry.get("findreplace_old_selectedCategories", DEFAULT_VALUES)));
        this.initCategories();
        this.initComponents();
        this.replacewithLabel.setVisible(replaceMode);
        this.replaceCombo.setVisible(replaceMode);
        FilterPopupListener fpl = new FilterPopupListener();
        this.entityPopupMenu.addPopupMenuListener(fpl);
        this.propertyPopupMenu.addPopupMenuListener(fpl);
        this.resetCategories();
        this.findCombo.setModel(this.cbFindModel);
        this.comboFindText = (JTextComponent)this.findCombo.getEditor().getEditorComponent();
        this.comboFindText.getDocument().addDocumentListener(new ComboListener());
        this.comboReplaceText = (JTextComponent)this.replaceCombo.getEditor().getEditorComponent();
        this.replaceCombo.setModel(this.cbReplaceModel);
        this.matchCheckBox.setSelected(this.registry.get("findreplace_old_matchcase", false));
        this.wholeWordCheckBox.setSelected(this.registry.get("findreplace_old_wholeword", false));
        this.selectionCheckBox.setSelected(this.registry.get("findreplace_old_selection", false));
        this.ready = true;
        this.findResults(0);
    }

    private void initComponents() {
        this.findwhatLabel1 = new JLabel();
        this.findCombo = new JComboBox();
        this.replacewithLabel = new JLabel();
        this.replaceCombo = new JComboBox();
        this.matchCheckBox = new JCheckBox();
        this.wholeWordCheckBox = new JCheckBox();
        this.filtersLabel = new JLabel();
        this.selectionCheckBox = new JCheckBox();
        this.matchesLabel = new JLabel();
        this.resultmatchesLabel = new JLabel();
        this.resultEntityLabel = new JLabel();
        this.resultEntity = new JLabel();
        this.resultPropertyLabel = new JLabel();
        this.resultProperty = new JLabel();
        this.showButton = new JButton();
        this.resultScrollPane = new JScrollPane();
        this.resultTextPane = new JTextPane();
        this.previousButton = new JButton();
        this.replaceButton = new JButton();
        this.replaceAllButton = new JButton();
        this.nextButton = new JButton();
        this.entityFilter = new JButton();
        this.propertyFilter = new JButton();
        this.setPreferredSize(new Dimension(600, 400));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ReplacePanel.this.formComponentResized(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.findwhatLabel1, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.findwhatLabel1.text"));
        this.findCombo.setEditable(true);
        this.findCombo.setMaximumRowCount(15);
        this.findCombo.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.findCombo.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.replacewithLabel, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.replacewithLabel.text"));
        this.replaceCombo.setEditable(true);
        this.replaceCombo.setMaximumRowCount(15);
        this.replaceCombo.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.replaceCombo.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.matchCheckBox, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.matchCheckBox.text"));
        this.matchCheckBox.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.matchCheckBox.toolTipText"));
        this.matchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.matchCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.wholeWordCheckBox, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.wholeWordCheckBox.text"));
        this.wholeWordCheckBox.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.wholeWordCheckBox.toolTipText"));
        this.wholeWordCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.wholeWordCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.filtersLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.selectionCheckBox, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.selectionCheckBox.text"));
        this.selectionCheckBox.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.selectionCheckBox.toolTipText"));
        this.selectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.selectionCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.matchesLabel, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.matchesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.resultmatchesLabel, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultmatchesLabel.text"));
        this.resultmatchesLabel.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultmatchesLabel.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.resultEntityLabel, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultEntityLabel.text"));
        this.resultEntity.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.resultEntity, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultEntity.text"));
        this.resultEntity.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultEntity.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.resultPropertyLabel, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultPropertyLabel.text"));
        this.resultProperty.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.resultProperty, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultProperty.text"));
        this.resultProperty.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultProperty.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.showButton, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.showButton.text"));
        this.showButton.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.showButton.toolTipText"));
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.showButtonActionPerformed(evt);
            }
        });
        this.resultTextPane.setEditable(false);
        this.resultTextPane.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.resultTextPane.toolTipText"));
        this.resultTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ReplacePanel.this.resultTextPaneKeyPressed(evt);
            }
        });
        this.resultScrollPane.setViewportView(this.resultTextPane);
        Mnemonics.setLocalizedText((AbstractButton)this.previousButton, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.previousButton.text"));
        this.previousButton.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.previousButton.toolTipText"));
        this.previousButton.setPreferredSize(new Dimension(100, 27));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.previousButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.replaceButton, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.replaceButton.text"));
        this.replaceButton.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.replaceButton.toolTipText"));
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.replaceButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAllButton, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.replaceAllButton.text"));
        this.replaceAllButton.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.replaceAllButton.toolTipText"));
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.replaceAllButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.nextButton, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.nextButton.text"));
        this.nextButton.setToolTipText(NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.nextButton.toolTipText"));
        this.nextButton.setPreferredSize(new Dimension(100, 27));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.nextButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.entityFilter, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.entityFilter.text"));
        this.entityFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.entityFilterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.propertyFilter, (String)NbBundle.getMessage(ReplacePanel.class, (String)"ReplacePanel.propertyFilter.text"));
        this.propertyFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplacePanel.this.propertyFilterActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.previousButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton, -2, -1, -2).addGap(30, 30, 30).addComponent(this.replaceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceAllButton).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchesLabel).addComponent(this.filtersLabel).addComponent(this.replacewithLabel).addComponent(this.findwhatLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.findCombo, 0, -1, Short.MAX_VALUE).addComponent(this.replaceCombo, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.entityFilter, -1, 114, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.propertyFilter, -1, 131, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.matchCheckBox).addGap(18, 18, 18).addComponent(this.wholeWordCheckBox)).addComponent(this.selectionCheckBox))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.resultmatchesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showButton)).addGroup(layout.createSequentialGroup().addComponent(this.resultEntityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultEntity)).addGroup(layout.createSequentialGroup().addComponent(this.resultPropertyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultProperty))).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.findwhatLabel1).addComponent(this.findCombo, -2, -1, -2).addComponent(this.matchCheckBox).addComponent(this.wholeWordCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replacewithLabel).addComponent(this.replaceCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectionCheckBox).addComponent(this.filtersLabel).addComponent(this.entityFilter).addComponent(this.propertyFilter)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchesLabel).addComponent(this.resultEntityLabel).addComponent(this.resultEntity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultPropertyLabel).addComponent(this.resultProperty)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showButton).addComponent(this.resultmatchesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultScrollPane, -1, 152, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previousButton, -2, -1, -2).addComponent(this.replaceButton).addComponent(this.replaceAllButton).addComponent(this.nextButton, -2, -1, -2)).addContainerGap()));
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.next();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        this.previous();
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        this.replace();
        this.findResults(this.resultsCurrent);
    }

    private void replaceAllButtonActionPerformed(ActionEvent evt) {
        this.replaceAll();
        this.findResults(0);
    }

    private void entityFilterActionPerformed(ActionEvent evt) {
        this.showEntityMenu();
    }

    private void propertyFilterActionPerformed(ActionEvent evt) {
        this.showPropertyMenu();
    }

    private void showButtonActionPerformed(ActionEvent evt) {
        SelectionDispatcher.fireSelection((AWTEvent)evt, (Context)new Context(this.results.get(this.resultsCurrent)));
    }

    private void matchCheckBoxActionPerformed(ActionEvent evt) {
        this.findResults(0);
    }

    private void wholeWordCheckBoxActionPerformed(ActionEvent evt) {
        this.findResults(0);
    }

    private void selectionCheckBoxActionPerformed(ActionEvent evt) {
        this.findResults(0);
    }

    private void resultTextPaneKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 33 || evt.getKeyCode() == 37) {
            this.previous();
        } else if (evt.getKeyCode() == 40 || evt.getKeyCode() == 34 || evt.getKeyCode() == 39) {
            this.next();
        }
    }

    public void saveParams() {
        this.ready = false;
        this.rememberAll();
        this.registry.put("findreplace_old_findwhat", this.oldFindWhat);
        this.registry.put("findreplace_old_replacewith", this.oldReplaceWith);
        this.registry.put("findreplace_old_matchcase", Boolean.valueOf(this.matchCheckBox.isSelected()));
        this.registry.put("findreplace_old_wholeword", Boolean.valueOf(this.wholeWordCheckBox.isSelected()));
        this.registry.put("findreplace_old_selectedEntities", this.oldSelectedEntities);
        this.registry.put("findreplace_old_selectedCategories", (Object[])this.oldSelectedCategories.toArray(new String[this.oldSelectedCategories.size()]));
        this.registry.put("findreplace_old_selection", Boolean.valueOf(this.selectionCheckBox.isSelected()));
    }

    private void rememberAll() {
        String text = (String)this.findCombo.getSelectedItem();
        this.remember(this.cbFindModel, this.oldFindWhat, text);
        text = (String)this.replaceCombo.getSelectedItem();
        this.remember(this.cbReplaceModel, this.oldReplaceWith, text);
        this.oldSelectedEntities.clear();
        block0: for (String str : Gedcom.ENTITIES) {
            for (MenuElement element : this.entityPopupMenu.getSubElements()) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)element;
                if (!item.getText().startsWith(Gedcom.getName((String)str)) || !item.isSelected()) continue;
                this.oldSelectedEntities.add(str);
                continue block0;
            }
        }
        this.updateCategories();
    }

    private void updateCategories() {
        this.oldSelectedCategories.clear();
        block0: for (Category category : this.categories) {
            for (MenuElement element : this.propertyPopupMenu.getSubElements()) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)element;
                if (!item.getText().startsWith(category.getName())) continue;
                category.setSelected(item.isSelected());
                if (!category.isSelected()) continue block0;
                this.oldSelectedCategories.add(category.getId());
                continue block0;
            }
        }
    }

    private void remember(DefaultComboBoxModel model, LinkedList<String> old, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        old.remove(value);
        old.addFirst(value);
        if (old.size() > 16) {
            old.removeLast();
        }
        this.updateModel(model, old);
    }

    private void updateModel(DefaultComboBoxModel model, LinkedList<String> old) {
        model.removeAllElements();
        for (String str : old) {
            model.addElement(str);
        }
    }

    private void showEntityMenu() {
        this.entityPopupMenu.show(this.entityFilter, 3, this.entityFilter.getHeight() - 5);
    }

    private void showPropertyMenu() {
        if (!this.categoryUpToDate) {
            this.resetCategories();
            this.categoryUpToDate = true;
        }
        this.propertyPopupMenu.show(this.propertyFilter, 3, this.propertyFilter.getHeight() - 5);
    }

    private void initCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        this.categories.clear();
        this.categories.add(new Category("name", new ImageIcon((Object)this.gedcom, "images/Name"), new String[]{"NAME", "GIVN", "SURN", "NICK", "NPFX", "AUTH", "SPFX", "NSFX", "CORP", "DATA", "SEX"}));
        this.categories.add(new Category("place", new ImageIcon((Object)this.gedcom, "images/Place"), new String[]{"PLAC", "MAP", "LATI", "LONG"}));
        this.categories.add(new Category("address", new ImageIcon((Object)this.gedcom, "images/Addr"), new String[]{"ADDR", "CITY", "POST", "PHON", "EMAI", "EMAIL", "STAE", "CTRY", "ADR1", "ADR2", "ADR3", "WWW", "FAX"}));
        this.categories.add(new Category("occupation", new ImageIcon((Object)this.gedcom, "images/Occupation"), new String[]{"OCCU"}));
        this.categories.add(new Category("description", new ImageIcon((Object)this.gedcom, "images/Type"), new String[]{"TYPE", "PEDI", "RESN", "STAT", "CAST", "DSCR", "EDUC", "NATI", "PROP", "RELI", "FACT", "ROLE", "FONE", "ROMN", "DESC", "ANCI", "DESI", "FAMF"}));
        this.categories.add(new Category("event", new ImageIcon((Object)this.gedcom, "images/Event"), new String[]{"AGNC", "CAUS", "BIRT", "DEAT", "CHR", "BURI", "CREM", "ADOP", "CHRA", "CONF", "FCOM", "ORDN", "RETI", "CONL", "SLGC", "BAPM", "BARM", "BASM", "BLES", "NATU", "EMIG", "IMMI", "PROB", "WILL", "GRAD", "BAPL", "ENDL", "ORDI", "SLGS", "EVEN", "ANUL", "CENS", "DIV", "DIVF", "ENGA", "MARB", "MARC", "MARR", "MARL", "MARS", "RESI"}));
        this.categories.add(new Category("relation", new ImageIcon((Object)this.gedcom, "images/Description"), new String[]{"RELA", "ALIA", "ASSO", "CHIL", "INDI", "CHIL", "FAM", "FAMC", "FAMS", "HUSB", "WIFE", "OBJE", "REPO", "SOUR", "SUBM"}));
        this.categories.add(new Category("date", new ImageIcon((Object)this.gedcom, "images/Date"), new String[]{"DATE", "CHAN", "TIME"}));
        this.categories.add(new Category("age", new ImageIcon((Object)this.gedcom, "images/Birth"), new String[]{"AGE"}));
        this.categories.add(new Category("note", new ImageIcon((Object)this.gedcom, "images/Note"), new String[]{"NOTE"}));
        this.categories.add(new Category("text", new ImageIcon((Object)this.gedcom, "images/Title"), new String[]{"TEXT", "TITL", "ABBR", "PUBL"}));
        this.categories.add(new Category("number", new ImageIcon((Object)this.gedcom, "images/IDNumber"), new String[]{"CALN", "REFN", "RIN", "AFN", "ANCE", "IDNO", "NMR", "PAGE", "RFN", "SSN", "NCHI"}));
        this.categories.add(new Category("filename", new ImageIcon((Object)this.gedcom, "images/Disk"), new String[]{"FILE"}));
        this.categories.add(new Category("media", new ImageIcon((Object)this.gedcom, "images/Media"), new String[]{"MEDI"}));
        this.categories.add(new Category("quality", new ImageIcon((Object)this.gedcom, "images/Repository"), new String[]{"QUAY"}));
        this.categories.add(new Category("format", new ImageIcon((Object)this.gedcom, "images/Format"), new String[]{"FORM", "CHAR", "COPR", "DEST", "GEDC", "LANG", "SUBN", "TEMP", "VERS"}));
        this.categories.add(new Category("user", new ImageIcon((Object)this.gedcom, "images/Question"), new String[]{"_"}));
        this.propertyPopupMenu = new JPopupMenu();
        JCheckBoxMenuItem propertyMenuItem = new JCheckBoxMenuItem(this.UNSELECT_ALL, null, false);
        propertyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                boolean set = item.getText().equals(ReplacePanel.this.SELECT_ALL);
                for (MenuElement element : ReplacePanel.this.propertyPopupMenu.getSubElements()) {
                    ((JCheckBoxMenuItem)element).setSelected(set);
                }
                item.setText(set ? ReplacePanel.this.UNSELECT_ALL : ReplacePanel.this.SELECT_ALL);
                item.setSelected(false);
                ReplacePanel.this.showPropertyMenu();
            }
        });
        this.propertyPopupMenu.add(propertyMenuItem);
        for (Category category : this.categories) {
            boolean select = this.oldSelectedCategories.isEmpty();
            for (String oldCat : this.oldSelectedCategories) {
                if (!category.getId().equals(oldCat)) continue;
                select = true;
                break;
            }
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(category.getName() + " (" + category.getVolume() + ")", (Icon)category.getIcon(), select);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReplacePanel.this.showPropertyMenu();
                }
            });
            this.propertyPopupMenu.add(item);
        }
    }

    private void resetCategories() {
        for (Category category : this.categories) {
            category.reset();
        }
        for (String str : Gedcom.ENTITIES) {
            boolean selected = false;
            for (MenuElement element : this.entityPopupMenu.getSubElements()) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)element;
                if (!(item.getText().startsWith(Gedcom.getName((String)str)) & item.isSelected())) continue;
                selected = true;
                break;
            }
            if (!selected) continue;
            for (Entity entity : this.gedcom.getEntities(str)) {
                block4: for (Property property : entity.getProperties(Property.class)) {
                    String tag = property.getTag();
                    for (Category category : this.categories) {
                        if (!category.contains(tag)) continue;
                        category.incrementVolume();
                        continue block4;
                    }
                }
            }
        }
        Collections.sort(this.categories, new CategoryComparator());
        block6: for (Category category : this.categories) {
            for (MenuElement element : this.propertyPopupMenu.getSubElements()) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)element;
                if (!item.getText().startsWith(category.getName())) continue;
                item.setText(category.getName() + " (" + category.getVolume() + ")");
                category.setSelected(item.isSelected());
                continue block6;
            }
        }
    }

    private void findResults(int indexToShow) {
        if (!this.ready) {
            return;
        }
        String toBeFound = this.comboFindText.getText();
        this.results.clear();
        HashSet<Property> selection = new HashSet<Property>();
        if (this.selectionCheckBox.isSelected()) {
            selection.addAll(this.getSelection());
        }
        this.updateCategories();
        for (String str : Gedcom.ENTITIES) {
            boolean selected = false;
            for (MenuElement element : this.entityPopupMenu.getSubElements()) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)element;
                if (!(item.getText().startsWith(Gedcom.getName((String)str)) & item.isSelected())) continue;
                selected = true;
                break;
            }
            if (!selected) continue;
            for (Entity entity : this.gedcom.getEntities(str)) {
                block3: for (Property property : entity.getProperties(Property.class)) {
                    if (property instanceof PropertyXRef || property.getTag().equals("NAME")) continue;
                    String tag = property.getTag();
                    for (Category category : this.categories) {
                        String str2;
                        String str1;
                        Matcher m;
                        if (!category.isSelected() || !category.contains(tag) || (m = this.match(str1 = Normalizer.normalize(property.getDisplayValue(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", ""), str2 = Normalizer.normalize(toBeFound, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", ""))) == null || !m.find() || this.selectionCheckBox.isSelected() && !selection.contains(property) && !selection.contains(property.getEntity())) continue;
                        this.results.add(property);
                        continue block3;
                    }
                }
            }
        }
        this.resultsTotal = this.results.size() - 1;
        this.resultsCurrent = indexToShow;
        if (this.resultsCurrent > this.resultsTotal) {
            --this.resultsCurrent;
        }
        this.displayResult();
        this.showButtons(!this.results.isEmpty());
    }

    private void displayResult() {
        this.resultTextPane.setText("");
        if (this.results == null || this.results.isEmpty() || this.resultsCurrent < 0 || this.resultsCurrent > this.resultsTotal) {
            this.displayNullResults();
            return;
        }
        this.resultmatchesLabel.setText(NbBundle.getMessage(this.getClass(), (String)"ReplacePanel.resultmatchesLabel.text", (Object)(this.resultsCurrent + 1), (Object)(this.resultsTotal + 1)));
        Property prop = this.results.get(this.resultsCurrent);
        this.resultEntity.setIcon((Icon)prop.getEntity().getImage());
        String str = prop.getEntity().toString(true);
        if (str.length() > 80) {
            str = str.substring(0, 80) + "...";
        }
        this.resultEntity.setText(str);
        this.resultProperty.setIcon((Icon)prop.getImage());
        this.resultProperty.setText(prop.getPath().getName());
        this.resultProperty.setToolTipText("<html>" + NbBundle.getMessage(this.getClass(), (String)"ReplacePanel.resultProperty.toolTipText") + "<br>" + prop.getPropertyInfo() + "</html>");
        String text = Normalizer.normalize(prop.getDisplayValue(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        String toBeFound = Normalizer.normalize(this.comboFindText.getText(), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        DefaultStyledDocument doc = new DefaultStyledDocument();
        try {
            doc.insertString(0, prop.getDisplayValue(), null);
        }
        catch (BadLocationException ex) {
            this.displayNullResults();
        }
        SimpleAttributeSet highlighted = new SimpleAttributeSet();
        StyleConstants.setForeground(highlighted, Color.RED);
        StyleConstants.setBold(highlighted, true);
        Matcher m = this.match(text, toBeFound);
        int firstIndex = -1;
        while (m != null && m.find()) {
            if (firstIndex == -1) {
                firstIndex = m.start();
            }
            doc.setCharacterAttributes(m.start(), m.end() - m.start(), highlighted, false);
        }
        this.resultTextPane.setDocument(doc);
        this.resultTextPane.setCaretPosition(Math.max(0, firstIndex));
    }

    private void displayNullResults() {
        this.resultmatchesLabel.setText(NbBundle.getMessage(this.getClass(), (String)"ReplacePanel.resultmatchesLabel.text", (Object)0, (Object)0));
        this.resultEntity.setIcon(null);
        this.resultEntity.setText("-");
        this.resultProperty.setIcon(null);
        this.resultProperty.setText("-");
        this.resultProperty.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"ReplacePanel.resultProperty.toolTipText"));
        this.resultTextPane.setText("-");
    }

    private Matcher match(String text, String toBeFound) {
        String textToAnalyse = text;
        String regex = "";
        regex = this.wholeWordCheckBox.isSelected() ? regex + "\\b" + toBeFound + "\\b" : regex + toBeFound;
        try {
            Pattern pattern = this.matchCheckBox.isSelected() ? Pattern.compile(regex) : Pattern.compile(regex, 66);
            return pattern.matcher(textToAnalyse);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void showButtons(boolean set) {
        this.nextButton.setEnabled(set);
        this.previousButton.setEnabled(set);
        this.replaceAllButton.setEnabled(set && this.replaceMode);
        this.replaceButton.setEnabled(set && this.replaceMode);
        this.showButton.setEnabled(set);
        this.replaceAllButton.setVisible(this.replaceMode);
        this.replaceButton.setVisible(this.replaceMode);
    }

    private List<Property> getSelection() {
        return SearchCommunicator.getResults((Gedcom)this.gedcom);
    }

    private void next() {
        ++this.resultsCurrent;
        if (this.resultsCurrent > this.resultsTotal) {
            this.resultsCurrent = 0;
        }
        this.displayResult();
    }

    private void previous() {
        --this.resultsCurrent;
        if (this.resultsCurrent < 0) {
            this.resultsCurrent = this.resultsTotal;
        }
        this.displayResult();
    }

    private void replace() {
        try {
            if (!this.gedcom.isWriteLocked()) {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        Property propToReplace = (Property)ReplacePanel.this.results.get(ReplacePanel.this.resultsCurrent);
                        String textFrom = ReplacePanel.this.comboFindText.getText();
                        Matcher m = ReplacePanel.this.match(propToReplace.getDisplayValue(), textFrom);
                        String textTo = ReplacePanel.this.comboReplaceText.getText();
                        Property parent = propToReplace.getParent();
                        if (parent instanceof PropertyName) {
                            ReplacePanel.this.replaceName((PropertyName)parent, propToReplace, m.replaceFirst(textTo));
                        } else {
                            propToReplace.setValue(m.replaceFirst(textTo));
                        }
                        ReplacePanel.this.log("ReplacePanel.replacingSingle", propToReplace, textFrom, textTo);
                    }
                });
            }
        }
        catch (GedcomException t) {
            LOG.log(Level.WARNING, "Error while replacing content in gedcom " + this.gedcom.getName(), t);
        }
    }

    private void replaceAll() {
        try {
            if (!this.gedcom.isWriteLocked()) {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        for (Property propToReplace : ReplacePanel.this.results) {
                            String textFrom = ReplacePanel.this.comboFindText.getText();
                            Matcher m = ReplacePanel.this.match(propToReplace.getDisplayValue(), textFrom);
                            String textTo = ReplacePanel.this.comboReplaceText.getText();
                            Property parent = propToReplace.getParent();
                            if (parent instanceof PropertyName) {
                                ReplacePanel.this.replaceName((PropertyName)parent, propToReplace, m.replaceAll(textTo));
                            } else {
                                propToReplace.setValue(m.replaceAll(textTo));
                            }
                            ReplacePanel.this.log("ReplacePanel.replacingAll", propToReplace, textFrom, textTo);
                        }
                    }
                });
            }
        }
        catch (GedcomException t) {
            LOG.log(Level.WARNING, "Error while replacing content in gedcom " + this.gedcom.getName(), t);
        }
    }

    public void replaceName(PropertyName name, Property p, String to) {
        String tag = p.getTag();
        String npfx = "NPFX".equals(tag) ? to : name.getNamePrefix();
        String givn = "GIVN".equals(tag) ? to : name.getFirstName();
        String spfx = "SPFX".equals(tag) ? to : name.getSurnamePrefix();
        String surn = "SURN".equals(tag) ? to : name.getLastName();
        String nsfx = "NSFX".equals(tag) ? to : name.getSuffix();
        String nick = "NICK".equals(tag) ? to : name.getNick();
        name.setName(npfx, givn, spfx, surn, nsfx);
        name.setNick(nick);
    }

    public void cancel(Gedcom gedcom, int undoNb) {
        int nbChanges = gedcom.getUndoNb() - undoNb;
        if (!gedcom.isWriteLocked()) {
            while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
        }
        LOG.log(Level.INFO, gedcom.getName() + " - " + NbBundle.getMessage(this.getClass(), (String)"ReplacePanel.canceled", (Object)nbChanges));
    }

    private void log(String key, Property property, String from, String to) {
        Entity entity = property.getEntity();
        if (entity != null) {
            String entityStr = property.getEntity().toString(true);
            LOG.log(Level.FINE, this.gedcom.getName() + " - " + NbBundle.getMessage(this.getClass(), (String)key, (Object)from, (Object)to, (Object)(entity.getTag() + ":" + entityStr.substring(0, Math.min(25, entityStr.length()))), (Object)(property.getPath().getName() + ":" + property.getPath().toString()), (Object[])new Object[0]));
        }
    }

    private class CategoryComparator
    implements Comparator<Category> {
        private CategoryComparator() {
        }

        @Override
        public int compare(Category c1, Category c2) {
            return c1.getName().compareTo(c2.getName());
        }
    }

    private class Category {
        private String id = "";
        private String name = "";
        private String[] tags = null;
        private ImageIcon icon = null;
        private int volume = 0;
        private boolean includeUserDefined = false;
        private boolean isSelected = false;

        public Category(String name, ImageIcon icon, String[] tags) {
            this.id = name;
            this.name = NbBundle.getMessage(this.getClass(), (String)("ReplacePanel.findreplace_categ_" + name));
            this.icon = icon;
            this.tags = tags;
            for (String t : tags) {
                if (!t.startsWith("_")) continue;
                this.includeUserDefined = true;
                break;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void reset() {
            this.volume = 0;
        }

        public void incrementVolume() {
            ++this.volume;
        }

        public int getVolume() {
            return this.volume;
        }

        public void setSelected(boolean set) {
            this.isSelected = set;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public boolean contains(String tag) {
            if (tag.startsWith("_") && this.includeUserDefined) {
                return true;
            }
            for (String t : this.tags) {
                if (!t.equals(tag)) continue;
                return true;
            }
            return false;
        }
    }

    private class ComboListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            ReplacePanel.this.findResults(0);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ReplacePanel.this.findResults(0);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ReplacePanel.this.findResults(0);
        }
    }

    private class FilterPopupListener
    implements PopupMenuListener {
        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            ReplacePanel.this.findResults(0);
        }
    }
}

