/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.MediaWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.io.InputSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;

public class SourceWrapper {
    private static int ENTITY_MOUNT = 0;
    private static int CITATION_MOUNT = 1;
    private static Map<String, Integer> mounts;
    private Property hostingProperty = null;
    private boolean recordType = true;
    private Entity targetSource = null;
    private String title = "";
    private String text = "";
    private Repository targetRepo = null;
    private String repoName = "";
    public List<MediaWrapper> sourceMediaSet = null;
    public List<MediaWrapper> sourceMediaRemovedSet = null;
    public int sourceMediaIndex = 0;

    public SourceWrapper(Property hostingProperty) {
        if (hostingProperty instanceof PropertySource) {
            this.hostingProperty = hostingProperty;
            this.setSourceFromEntity((Source)((PropertySource)hostingProperty).getTargetEntity());
        } else if (hostingProperty instanceof Source) {
            this.setSourceFromEntity((Source)hostingProperty);
        } else {
            this.hostingProperty = hostingProperty;
            this.targetSource = null;
            this.resetMediaSet();
            this.setInfoFromCitation(hostingProperty);
            this.getMediaFromProperty(hostingProperty);
        }
    }

    public final void setSourceFromEntity(Source source) {
        this.targetSource = source;
        this.resetMediaSet();
        this.setInfoFromRecord((Property)source);
        this.getMediaFromProperty((Property)source);
        if (this.hostingProperty != null) {
            this.getMediaFromProperty(this.hostingProperty);
        }
    }

    public SourceWrapper(String title) {
        this.setTitle(title);
    }

    public SourceWrapper(Repository repo) {
        this.setRepo(repo);
    }

    public SourceWrapper(MediaWrapper media) {
        this.resetMediaSet();
        this.sourceMediaSet.add(media);
    }

    public SourceWrapper(InputSource f) {
        this.setMediaFile(f, false);
    }

    public Property getHostingProperty() {
        return this.hostingProperty;
    }

    private void resetMediaSet() {
        if (this.sourceMediaSet != null) {
            this.sourceMediaSet.clear();
            this.sourceMediaSet = null;
        }
        if (this.sourceMediaRemovedSet != null) {
            this.sourceMediaRemovedSet.clear();
            this.sourceMediaRemovedSet = null;
        }
        this.sourceMediaSet = new ArrayList<MediaWrapper>();
        this.sourceMediaRemovedSet = new ArrayList<MediaWrapper>();
        this.sourceMediaIndex = 0;
    }

    public final void getMediaFromProperty(Property property) {
        Property[] mediaProps;
        if (this.sourceMediaSet == null || property == null) {
            return;
        }
        for (Property prop : mediaProps = property.getProperties("OBJE")) {
            MediaWrapper media;
            if (prop == null) continue;
            if (prop instanceof PropertyMedia) {
                media = new MediaWrapper((Media)((PropertyMedia)prop).getTargetEntity());
                media.setHostingProperty(prop);
                this.sourceMediaSet.add(media);
                continue;
            }
            media = new MediaWrapper(prop);
            this.sourceMediaSet.add(media);
        }
    }

    public boolean isRecord() {
        return this.recordType;
    }

    public Entity getTargetSource() {
        return this.targetSource;
    }

    public String getTitle() {
        return this.title;
    }

    public final void setTitle(String str) {
        this.title = str;
    }

    public String getText() {
        return this.text;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public void setMedia(MediaWrapper media, boolean addMedia) {
        if (this.sourceMediaSet == null) {
            this.resetMediaSet();
        }
        if (this.sourceMediaSet.isEmpty() || addMedia) {
            this.sourceMediaSet.add(media);
        } else {
            this.sourceMediaSet.set(this.sourceMediaIndex, media);
        }
    }

    public boolean deleteMedia() {
        if (this.sourceMediaSet == null || this.sourceMediaSet.isEmpty() || this.sourceMediaRemovedSet == null) {
            return false;
        }
        this.sourceMediaRemovedSet.add(this.sourceMediaSet.get(this.sourceMediaIndex));
        this.sourceMediaSet.remove(this.sourceMediaIndex);
        --this.sourceMediaIndex;
        if (this.sourceMediaIndex < 0) {
            this.sourceMediaIndex = 0;
        }
        return true;
    }

    public String getMediaTitle() {
        if (this.sourceMediaSet == null || this.sourceMediaSet.isEmpty()) {
            return "";
        }
        return this.sourceMediaSet.get(this.sourceMediaIndex).getTitle();
    }

    public void setMediaTitle(String title) {
        if (this.sourceMediaSet == null) {
            if (title.isEmpty()) {
                return;
            }
            this.resetMediaSet();
        }
        if (this.sourceMediaSet.isEmpty()) {
            this.sourceMediaSet.add(new MediaWrapper(title));
        } else {
            this.sourceMediaSet.get(this.sourceMediaIndex).setTitle(title);
        }
    }

    public final void setMediaFile(InputSource f, boolean addMedia) {
        if (this.sourceMediaSet == null) {
            this.resetMediaSet();
        }
        if (this.sourceMediaSet.isEmpty() || addMedia) {
            this.sourceMediaSet.add(new MediaWrapper(f));
        } else {
            this.sourceMediaSet.get(this.sourceMediaIndex).setInputSource(f);
        }
    }

    public InputSource getMediaFile() {
        if (this.sourceMediaSet == null || this.sourceMediaSet.isEmpty()) {
            return null;
        }
        return this.sourceMediaSet.get(this.sourceMediaIndex).getInputSource();
    }

    public String getRepoName() {
        return this.repoName;
    }

    public void setRepoName(String name) {
        this.repoName = name;
    }

    public final void setRepo(Repository repo) {
        this.targetRepo = repo;
        this.repoName = repo == null ? "" : this.targetRepo.getRepositoryName();
    }

    public Repository getRepo() {
        return this.targetRepo;
    }

    private void setInfoFromRecord(Property property) {
        this.recordType = true;
        if (property == null) {
            return;
        }
        Property propTitle = property.getProperty("TITL", true);
        this.title = propTitle != null ? propTitle.getDisplayValue() : "";
        Property propText = property.getProperty("TEXT", true);
        this.text = propText != null ? propText.getDisplayValue() : "";
        Property propRepository = property.getProperty("REPO", true);
        if (propRepository != null && propRepository instanceof PropertyRepository) {
            PropertyRepository pr = (PropertyRepository)propRepository;
            this.targetRepo = (Repository)pr.getTargetEntity();
            this.repoName = this.targetRepo.getRepositoryName();
        } else {
            this.targetRepo = null;
            this.repoName = "";
        }
    }

    private void setInfoFromCitation(Property property) {
        this.recordType = false;
        if (property == null) {
            return;
        }
        this.title = property.getDisplayValue().trim();
        Property propText = property.getProperty("TEXT");
        if (propText != null) {
            this.text = propText.getDisplayValue();
        }
    }

    public void update(Property mainProp) {
        if (this.hostingProperty == null) {
            try {
                if (this.targetSource == null) {
                    this.targetSource = mainProp.getGedcom().createEntity("SOUR");
                }
                mainProp.addSource((Source)this.targetSource);
                this.putSourceRecord((Property)((Source)this.targetSource));
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return;
        }
        if (!this.recordType) {
            this.putSourceCitation(this.hostingProperty);
        } else {
            try {
                if (this.targetSource == null) {
                    this.targetSource = mainProp.getGedcom().createEntity("SOUR");
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.recordType && this.hostingProperty instanceof PropertySource) {
                this.putSourceRecord((Property)this.targetSource);
                PropertySource ps = (PropertySource)this.hostingProperty;
                Entity tse = ps.getTargetEntity();
                if (!this.targetSource.equals(tse)) {
                    Utils.replaceRef((PropertyXRef)ps, tse, this.targetSource);
                }
            } else if (this.recordType && !(this.hostingProperty instanceof PropertySource)) {
                mainProp.addSource((Source)this.targetSource);
                this.putSourceRecord((Property)this.targetSource);
            }
        }
    }

    private void putSourceRecord(Property property) {
        if (property == null) {
            return;
        }
        this.putProperty(property, "TITL", this.title);
        this.putProperty(property, "TEXT", this.text);
        if (this.title.trim().isEmpty()) {
            property.delProperties("TITL");
        }
        if (this.text.trim().isEmpty()) {
            property.delProperties("TEXT");
        }
        Property host = this.getDefaultHost(property);
        this.putMediaItems(host);
        if (this.repoName.trim().isEmpty()) {
            return;
        }
        if (this.targetRepo == null) {
            try {
                this.targetRepo = (Repository)property.getGedcom().createEntity("REPO");
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.targetRepo.setRepositoryName(this.repoName);
        Property propRepository = property.getProperty("REPO", true);
        if (propRepository != null && propRepository instanceof PropertyRepository) {
            PropertyRepository pr = (PropertyRepository)propRepository;
            Repository tmpRepo = (Repository)pr.getTargetEntity();
            if (tmpRepo != this.targetRepo) {
                property.delProperty(propRepository);
                if (!this.repoName.isEmpty()) {
                    property.addRepository(this.targetRepo);
                }
            }
        } else {
            property.addRepository(this.targetRepo);
        }
    }

    private void putSourceCitation(Property property) {
        Utils.setDistinctValue(property, this.title);
        this.putProperty(property, "TEXT", this.text);
        if (property.getMetaProperty().allows("OBJE")) {
            this.putMediaItems(property);
        }
        if (this.title.trim().isEmpty()) {
            property.delProperties("TITL");
        }
        if (this.text.trim().isEmpty()) {
            property.delProperties("TEXT");
        }
    }

    public void remove() {
        if (this.hostingProperty == null) {
            return;
        }
        this.hostingProperty.getParent().delProperty(this.hostingProperty);
    }

    private void putProperty(Property property, String tag, String value) {
        Property prop = property.getProperty(tag, true);
        if (prop != null) {
            Utils.setDistinctValue(prop, value);
        } else {
            property.addProperty(tag, value);
        }
    }

    private void putMediaItems(Property property) {
        if ((this.sourceMediaSet == null || this.sourceMediaSet.isEmpty()) && (this.sourceMediaRemovedSet == null || this.sourceMediaRemovedSet.isEmpty())) {
            return;
        }
        int index = 0;
        for (MediaWrapper media2 : this.sourceMediaSet) {
            media2.update(index, property);
            ++index;
        }
        this.sourceMediaRemovedSet.forEach(media -> media.remove());
    }

    private Property getDefaultHost(Property property) {
        String gedcomName;
        Integer type;
        if (mounts == null) {
            mounts = new HashMap<String, Integer>();
        }
        if ((type = mounts.get(gedcomName = property.getGedcom().getOrigin().getFile().getAbsolutePath())) == null) {
            type = this.getMountType(property.getGedcom());
            mounts.put(gedcomName, type);
        }
        return type == ENTITY_MOUNT ? property : this.hostingProperty;
    }

    private Integer getMountType(Gedcom gedcom) {
        String[] ENTITIES;
        double count = 0.0;
        double total = 0.0;
        for (String type : ENTITIES = new String[]{"INDI", "FAM"}) {
            Collection entities = gedcom.getEntities(type);
            for (Entity entity : entities) {
                List properties = entity.getProperties(PropertySource.class);
                total += (double)properties.size();
                for (PropertySource prop : properties) {
                    count += (double)prop.getProperties("OBJE", false).length;
                }
            }
        }
        if (total == 0.0 || count == 0.0) {
            return ENTITY_MOUNT;
        }
        double ratio = count / total;
        if (ratio > 0.5) {
            return CITATION_MOUNT;
        }
        return ENTITY_MOUNT;
    }
}

