/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties;

import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import modules.editors.gedcomproperties.Constants;
import modules.editors.gedcomproperties.GedcomPropertiesWizardIterator;
import modules.editors.gedcomproperties.GedcomPropertiesWizardPanel3;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class GedcomPropertiesVisualPanel3
extends JPanel
implements Constants {
    private final int mode = GedcomPropertiesWizardIterator.getMode();
    private Registry registry = null;
    private final String winWidth = "gedcomProperties3Width";
    private final String winHeight = "gedcomProperties3Height";
    private final GedcomPropertiesWizardPanel3 parent;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JScrollPane jScrollPane1;

    public GedcomPropertiesVisualPanel3(GedcomPropertiesWizardPanel3 parent) {
        this.parent = parent;
        this.initComponents();
        this.registry = Registry.get(this.getClass());
        this.setPreferredSize(new Dimension(this.registry.get("gedcomProperties3Width", this.getPreferredSize().width), this.registry.get("gedcomProperties3Height", this.getPreferredSize().height)));
        this.updateDisplay();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)"STEP_3_name");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox<String>(Gedcom.TRANSLATED_LANGUAGES.values().toArray(new String[Gedcom.TRANSLATED_LANGUAGES.values().size()]));
        this.jLabel2 = new JLabel();
        this.jComboBox2 = new JComboBox<String>(Gedcom.ENCODINGS);
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jCheckBox2 = new JCheckBox();
        this.setBorder(null);
        this.setAutoscrolls(true);
        this.setPreferredSize(new Dimension(520, 360));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                GedcomPropertiesVisualPanel3.this.formComponentResized(evt);
            }
        });
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setViewportBorder(null);
        this.jScrollPane1.setPreferredSize(new Dimension(520, 360));
        this.jPanel1.setBorder(null);
        this.jPanel1.setPreferredSize(new Dimension(520, 360));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)(this.mode == 1 ? "Panel3.jLabel1.create" : "Panel3.jLabel1.update")));
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)(this.mode == 1 ? "Panel3.jLabel2.create" : "Panel3.jLabel2.update")));
        this.jComboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GedcomPropertiesVisualPanel3.this.jComboBox2ItemStateChanged(evt);
            }
        });
        this.jLabel5.setFont(new Font("DejaVu Sans", 2, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jLabel5.text"));
        this.jLabel5.setVerticalAlignment(1);
        this.jLabel5.setAutoscrolls(true);
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)(this.mode == 1 ? "Panel3.jLabel3.create" : "Panel3.jLabel3.update")));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jRadioButton1.Yes"));
        this.jRadioButton1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GedcomPropertiesVisualPanel3.this.jRadioButton1StateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jRadioButton2.No"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)(this.mode == 1 ? "Panel3.jCheckBox1.create" : "Panel3.jCheckBox1.update")));
        this.jCheckBox1.setToolTipText(NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jCheckBox1.toolTipText"));
        this.jLabel4.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)(this.mode == 1 ? "Panel3.jLabel4.create" : "Panel3.jLabel4.update")));
        this.jLabel4.setToolTipText(NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jLabel4.toolTipText"));
        this.buttonGroup2.add(this.jRadioButton3);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton3, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jRadioButton3.Any"));
        this.buttonGroup2.add(this.jRadioButton4);
        this.jRadioButton4.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton4, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jRadioButton4.Anstfile"));
        this.buttonGroup2.add(this.jRadioButton5);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton5, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jRadioButton5.TempleReady"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox2, (String)NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)(this.mode == 1 ? "Panel3.jCheckBox2.create" : "Panel3.jCheckBox2.update")));
        this.jCheckBox2.setToolTipText(NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"Panel3.jCheckBox2.toolTipText"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1)).addComponent(this.jCheckBox2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBox2, -2, 164, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, 332, -2)).addComponent(this.jComboBox1, -2, 306, -2)).addGap(0, 6, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.jLabel5, -2, 101, -2)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5)).addContainerGap(109, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GedcomPropertiesVisualPanel3.class, (String)"GedcomPropertiesVisualPanel3.jPanel1.AccessibleContext.accessibleName"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 439, Short.MAX_VALUE));
    }

    private void jRadioButton1StateChanged(ChangeEvent evt) {
        this.updateDisplay();
    }

    private void jComboBox2ItemStateChanged(ItemEvent evt) {
        this.updateDisplay();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("gedcomProperties3Width", evt.getComponent().getWidth());
        this.registry.put("gedcomProperties3Height", evt.getComponent().getHeight());
    }

    public boolean getConversionToBeDone() {
        return this.jCheckBox1.isSelected();
    }

    public String getMediaTransformation() {
        return this.jCheckBox2.isSelected() && this.jRadioButton1.isSelected() ? "1" : "0";
    }

    public void setLANG(String str) {
        this.jComboBox1.setSelectedItem(Gedcom.TRANSLATED_LANGUAGES.get(str));
        if (this.jComboBox1.getSelectedIndex() == -1) {
            this.jComboBox1.setSelectedItem(Gedcom.TRANSLATED_LANGUAGES.get(Locale.getDefault().getDisplayLanguage(new Locale("en", "EN"))));
        }
    }

    public void setCHAR(String str) {
        this.jComboBox2.setSelectedItem(str);
        this.updateDisplay();
    }

    public void setVERS(String str) {
        if (str.equals("5.5.1")) {
            this.jRadioButton1.setSelected(true);
        } else {
            this.jRadioButton2.setSelected(true);
        }
        this.updateDisplay();
    }

    public void setDEST(String str) {
        if (str.equals("ANSTFILE")) {
            this.jRadioButton4.setSelected(true);
        } else if (str.equals("TempleReady")) {
            this.jRadioButton5.setSelected(true);
        } else {
            this.jRadioButton3.setSelected(true);
        }
    }

    public String getLANG() {
        String[] tab = Gedcom.TRANSLATED_LANGUAGES.keySet().toArray(new String[Gedcom.TRANSLATED_LANGUAGES.keySet().size()]);
        return tab[this.jComboBox1.getSelectedIndex()];
    }

    public String getCHAR() {
        return this.jComboBox2.getSelectedItem().toString();
    }

    public String getVERS() {
        return this.jRadioButton1.isSelected() ? "5.5.1" : "5.5";
    }

    public String getDEST() {
        return this.jRadioButton4.isSelected() ? "ANSTFILE" : (this.jRadioButton5.isSelected() ? "TempleReady" : "ANY");
    }

    private void updateDisplay() {
        this.jLabel5.setText(NbBundle.getMessage(GedcomPropertiesWizardIterator.class, (String)(this.jComboBox2.getSelectedItem().toString() + "_label")));
        boolean canBeConverted = this.mode == 2 && !this.getVERS().equals(this.parent.getOriginalVersion());
        this.jCheckBox1.setVisible(canBeConverted);
        this.jCheckBox2.setVisible(this.jRadioButton1.isSelected() && canBeConverted);
        this.parent.warnVersionChange(canBeConverted);
    }
}

