/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import ancestris.modules.views.graph.GraphParameter;
import ancestris.modules.views.graph.GraphTopComponent;
import ancestris.modules.views.graph.LabelFamEnum;
import ancestris.modules.views.graph.LabelIndiEnum;
import ancestris.util.swing.ColorChooserButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GraphSettings
extends JPanel {
    private final GraphTopComponent theGTC;
    private final LabelIndiEnum[] labelIndi = LabelIndiEnum.values();
    private final LabelFamEnum[] labelFam = LabelFamEnum.values();
    private ColorChooserButton colorButtonAssociation;
    private ColorChooserButton colorButtonBackground;
    private ColorChooserButton colorButtonCujus;
    private ColorChooserButton colorButtonDefault;
    private ColorChooserButton colorButtonMarriage;
    private ColorChooserButton colorButtonMarriageSosa;
    private ColorChooserButton colorButtonSelected;
    private ColorChooserButton colorButtonSosa;
    private JButton jButtonApply;
    private JButton jButtonReset;
    private JCheckBox jCheckBoxColorScheme;
    private JComboBox<LabelFamEnum> jComboBoxFamLabels;
    private JComboBox<LabelIndiEnum> jComboBoxIndiLabels;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelColor;
    private JLabel jLabelEdge;
    private JLabel jLabelNode;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextFieldCujusNodeSize;
    private JTextField jTextFieldDefaultEdgeSize;
    private JTextField jTextFieldDefaultNodeSize;
    private JTextField jTextFieldEdgeWeight;
    private JTextField jTextFieldFamNodeWeght;
    private JTextField jTextFieldIndiNodeWeght;
    private JTextField jTextFieldSosaEdgeSize;
    private JTextField jTextFieldSosaNodeSize;
    private Label labelColorAssociation;
    private Label labelColorBackground;
    private Label labelColorCujus;
    private Label labelColorDefault;
    private Label labelColorMariage;
    private Label labelColorMariageSosa;
    private Label labelColorSelected;
    private Label labelColorSosa;
    private Label labelCujusNodeSize;
    private Label labelDefaultEdgeSize;
    private Label labelDefaultNodeSize;
    private Label labelEdgeWeight;
    private Label labelFamNodeWeight;
    private Label labelIndiNodeWeight;
    private Label labelSosaEdgeSize;
    private Label labelSosaNodeSize;

    public GraphSettings(GraphTopComponent gtc) {
        this.theGTC = gtc;
        this.initComponents();
        this.initValues();
        this.colorButtonSosa.addColorChangedListener(newColor -> {
            this.getParam().setColorSosa(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonDefault.addColorChangedListener(newColor -> {
            this.getParam().setColorDef(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonMarriage.addColorChangedListener(newColor -> {
            this.getParam().setColorMariage(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonAssociation.addColorChangedListener(newColor -> {
            this.getParam().setColorAsso(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonCujus.addColorChangedListener(newColor -> {
            this.getParam().setColorCujus(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonSelected.addColorChangedListener(newColor -> {
            this.getParam().setColorSticked(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonBackground.addColorChangedListener(newColor -> {
            this.getParam().setColorBack(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
        this.colorButtonMarriageSosa.addColorChangedListener(newColor -> {
            this.getParam().setColorMariageSosa(GraphSettings.toHexString(newColor));
            this.theGTC.updateCss();
        });
    }

    private void initValues() {
        this.colorButtonSosa.setSelectedColor(Color.decode(this.getParam().getColorSosa()), false);
        this.colorButtonDefault.setSelectedColor(Color.decode(this.getParam().getColorDef()), false);
        this.colorButtonMarriage.setSelectedColor(Color.decode(this.getParam().getColorMariage()), false);
        this.colorButtonAssociation.setSelectedColor(Color.decode(this.getParam().getColorAsso()), false);
        this.colorButtonCujus.setSelectedColor(Color.decode(this.getParam().getColorCujus()), false);
        this.colorButtonSelected.setSelectedColor(Color.decode(this.getParam().getColorSticked()), false);
        this.colorButtonBackground.setSelectedColor(Color.decode(this.getParam().getColorBack()), false);
        this.colorButtonMarriageSosa.setSelectedColor(Color.decode(this.getParam().getColorMariageSosa()), false);
        this.jTextFieldDefaultNodeSize.setText(this.getParam().getSizeNode());
        this.jTextFieldDefaultEdgeSize.setText(this.getParam().getSizeEdge());
        this.jTextFieldSosaNodeSize.setText(this.getParam().getSizeNodeSosa());
        this.jTextFieldSosaEdgeSize.setText(this.getParam().getSizeEdgeSosa());
        this.jTextFieldCujusNodeSize.setText(this.getParam().getSizeCujus());
        this.jTextFieldEdgeWeight.setText(String.valueOf(this.getParam().getEdgeWeight()));
        this.jTextFieldIndiNodeWeght.setText(String.valueOf(this.getParam().getIndiNodeWeight()));
        this.jTextFieldFamNodeWeght.setText(String.valueOf(this.getParam().getMariageNodeWeight()));
        this.jComboBoxFamLabels.setSelectedItem((Object)this.getParam().getLabelFam());
        this.jComboBoxIndiLabels.setSelectedItem((Object)this.getParam().getLabelIndi());
        this.jCheckBoxColorScheme.setSelected(this.getParam().isUseGenerationScheme());
    }

    public static final String toHexString(Color colour) {
        String hexColour = Integer.toHexString(colour.getRGB() & 0xFFFFFF);
        if (hexColour.length() < 6) {
            hexColour = "000000".substring(0, 6 - hexColour.length()) + hexColour;
        }
        return "#" + hexColour;
    }

    private GraphParameter getParam() {
        return this.theGTC.getGraphParam();
    }

    private void initComponents() {
        this.jLabelColor = new JLabel();
        this.jLabelNode = new JLabel();
        this.jLabelEdge = new JLabel();
        this.jPanel1 = new JPanel();
        this.labelColorDefault = new Label();
        this.colorButtonDefault = new ColorChooserButton();
        this.labelColorSosa = new Label();
        this.colorButtonSosa = new ColorChooserButton();
        this.labelColorMariage = new Label();
        this.colorButtonMarriage = new ColorChooserButton();
        this.labelColorMariageSosa = new Label();
        this.colorButtonMarriageSosa = new ColorChooserButton();
        this.labelColorAssociation = new Label();
        this.colorButtonAssociation = new ColorChooserButton();
        this.labelColorCujus = new Label();
        this.colorButtonCujus = new ColorChooserButton();
        this.labelColorSelected = new Label();
        this.colorButtonSelected = new ColorChooserButton();
        this.labelColorBackground = new Label();
        this.colorButtonBackground = new ColorChooserButton();
        this.jCheckBoxColorScheme = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.labelDefaultNodeSize = new Label();
        this.jTextFieldDefaultNodeSize = new JTextField();
        this.jLabel1 = new JLabel();
        this.labelDefaultEdgeSize = new Label();
        this.jTextFieldDefaultEdgeSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.labelSosaNodeSize = new Label();
        this.jTextFieldSosaNodeSize = new JTextField();
        this.jLabel3 = new JLabel();
        this.labelSosaEdgeSize = new Label();
        this.jTextFieldSosaEdgeSize = new JTextField();
        this.jLabel4 = new JLabel();
        this.labelCujusNodeSize = new Label();
        this.jTextFieldCujusNodeSize = new JTextField();
        this.jLabel5 = new JLabel();
        this.labelIndiNodeWeight = new Label();
        this.jTextFieldIndiNodeWeght = new JTextField();
        this.labelEdgeWeight = new Label();
        this.jTextFieldEdgeWeight = new JTextField();
        this.jTextFieldFamNodeWeght = new JTextField();
        this.labelFamNodeWeight = new Label();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jComboBoxIndiLabels = new JComboBox<LabelIndiEnum>(this.labelIndi);
        this.jLabel7 = new JLabel();
        this.jComboBoxFamLabels = new JComboBox<LabelFamEnum>(this.labelFam);
        this.jButtonApply = new JButton();
        this.jButtonReset = new JButton();
        this.setMaximumSize(new Dimension(700, 500));
        this.setMinimumSize(new Dimension(700, 500));
        this.setPreferredSize(new Dimension(700, 500));
        this.jLabelColor.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabelColor, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelColor.text"));
        this.jLabelColor.setMaximumSize(new Dimension(500, 40));
        this.jLabelColor.setMinimumSize(new Dimension(220, 40));
        this.jLabelColor.setPreferredSize(new Dimension(220, 40));
        this.jLabelNode.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabelNode, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelNode.text"));
        this.jLabelNode.setMaximumSize(new Dimension(500, 40));
        this.jLabelNode.setMinimumSize(new Dimension(220, 40));
        this.jLabelNode.setPreferredSize(new Dimension(220, 40));
        this.jLabelEdge.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabelEdge, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabelEdge.text"));
        this.jLabelEdge.setMaximumSize(new Dimension(500, 40));
        this.jLabelEdge.setMinimumSize(new Dimension(220, 40));
        this.jLabelEdge.setPreferredSize(new Dimension(220, 40));
        this.jPanel1.setPreferredSize(new Dimension(220, 220));
        this.labelColorDefault.setAlignment(2);
        this.labelColorDefault.setMaximumSize(new Dimension(250, 25));
        this.labelColorDefault.setMinimumSize(new Dimension(150, 25));
        this.labelColorDefault.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorDefault.text"));
        this.colorButtonDefault.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonDefault.toolTipText"));
        this.colorButtonDefault.setMaximumSize(new Dimension(50, 25));
        this.colorButtonDefault.setMinimumSize(new Dimension(50, 25));
        this.colorButtonDefault.setPreferredSize(new Dimension(50, 25));
        this.labelColorSosa.setAlignment(2);
        this.labelColorSosa.setMaximumSize(new Dimension(250, 25));
        this.labelColorSosa.setMinimumSize(new Dimension(150, 25));
        this.labelColorSosa.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorSosa.text"));
        this.colorButtonSosa.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonSosa.toolTipText"));
        this.colorButtonSosa.setMaximumSize(new Dimension(50, 25));
        this.colorButtonSosa.setMinimumSize(new Dimension(50, 25));
        this.colorButtonSosa.setPreferredSize(new Dimension(50, 25));
        this.labelColorMariage.setAlignment(2);
        this.labelColorMariage.setMaximumSize(new Dimension(250, 25));
        this.labelColorMariage.setMinimumSize(new Dimension(150, 25));
        this.labelColorMariage.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorMariage.text"));
        this.colorButtonMarriage.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonMarriage.toolTipText"));
        this.colorButtonMarriage.setMaximumSize(new Dimension(50, 25));
        this.colorButtonMarriage.setMinimumSize(new Dimension(50, 25));
        this.colorButtonMarriage.setPreferredSize(new Dimension(50, 25));
        this.labelColorMariageSosa.setAlignment(2);
        this.labelColorMariageSosa.setMaximumSize(new Dimension(250, 25));
        this.labelColorMariageSosa.setMinimumSize(new Dimension(150, 25));
        this.labelColorMariageSosa.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorMariageSosa.text"));
        this.colorButtonMarriageSosa.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonMarriageSosa.toolTipText"));
        this.colorButtonMarriageSosa.setMaximumSize(new Dimension(50, 25));
        this.colorButtonMarriageSosa.setMinimumSize(new Dimension(50, 25));
        this.colorButtonMarriageSosa.setPreferredSize(new Dimension(50, 25));
        this.labelColorAssociation.setAlignment(2);
        this.labelColorAssociation.setMaximumSize(new Dimension(250, 25));
        this.labelColorAssociation.setMinimumSize(new Dimension(150, 25));
        this.labelColorAssociation.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorAssociation.text"));
        this.colorButtonAssociation.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonAssociation.toolTipText"));
        this.colorButtonAssociation.setMaximumSize(new Dimension(50, 25));
        this.colorButtonAssociation.setMinimumSize(new Dimension(50, 25));
        this.colorButtonAssociation.setPreferredSize(new Dimension(50, 25));
        this.labelColorCujus.setAlignment(2);
        this.labelColorCujus.setMaximumSize(new Dimension(250, 25));
        this.labelColorCujus.setMinimumSize(new Dimension(150, 25));
        this.labelColorCujus.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorCujus.text"));
        this.colorButtonCujus.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonCujus.toolTipText"));
        this.colorButtonCujus.setMaximumSize(new Dimension(50, 25));
        this.colorButtonCujus.setMinimumSize(new Dimension(50, 25));
        this.colorButtonCujus.setPreferredSize(new Dimension(50, 25));
        this.labelColorSelected.setAlignment(2);
        this.labelColorSelected.setMaximumSize(new Dimension(250, 25));
        this.labelColorSelected.setMinimumSize(new Dimension(150, 25));
        this.labelColorSelected.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorSelected.text"));
        this.colorButtonSelected.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonSelected.toolTipText"));
        this.colorButtonSelected.setMaximumSize(new Dimension(50, 25));
        this.colorButtonSelected.setMinimumSize(new Dimension(50, 25));
        this.colorButtonSelected.setPreferredSize(new Dimension(50, 25));
        this.labelColorBackground.setAlignment(2);
        this.labelColorBackground.setMaximumSize(new Dimension(250, 25));
        this.labelColorBackground.setMinimumSize(new Dimension(150, 25));
        this.labelColorBackground.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorBackground.text_1"));
        this.colorButtonBackground.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.colorButtonBackground.toolTipText_1"));
        this.colorButtonBackground.setMaximumSize(new Dimension(50, 25));
        this.colorButtonBackground.setMinimumSize(new Dimension(50, 25));
        this.colorButtonBackground.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxColorScheme, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCheckBoxColorScheme.text"));
        this.jCheckBoxColorScheme.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jCheckBoxColorScheme.toolTipText"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 7, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorDefault, -2, -1, -2).addComponent(this.labelColorSosa, -2, -1, -2).addComponent(this.labelColorMariage, -2, -1, -2).addComponent(this.labelColorMariageSosa, -2, -1, -2).addComponent(this.labelColorAssociation, -2, -1, -2).addComponent(this.labelColorCujus, -2, -1, -2).addComponent(this.labelColorSelected, -2, -1, -2).addComponent(this.labelColorBackground, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.colorButtonDefault, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonSosa, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonMarriage, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonMarriageSosa, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonAssociation, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonCujus, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonSelected, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent((Component)this.colorButtonBackground, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGap(69, 69, 69)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxColorScheme).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorDefault, -2, -1, -2).addComponent((Component)this.colorButtonDefault, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorSosa, -2, -1, -2).addComponent((Component)this.colorButtonSosa, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorMariage, -2, -1, -2).addComponent((Component)this.colorButtonMarriage, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorMariageSosa, -2, -1, -2).addComponent((Component)this.colorButtonMarriageSosa, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorAssociation, -2, -1, -2).addComponent((Component)this.colorButtonAssociation, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorCujus, -2, -1, -2).addComponent((Component)this.colorButtonCujus, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorSelected, -2, -1, -2).addComponent((Component)this.colorButtonSelected, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelColorBackground, -2, -1, -2).addComponent((Component)this.colorButtonBackground, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxColorScheme).addGap(20, 20, 20)));
        this.labelColorSosa.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelColorSosa.AccessibleContext.accessibleName"));
        this.jPanel2.setPreferredSize(new Dimension(500, 280));
        this.labelDefaultNodeSize.setAlignment(2);
        this.labelDefaultNodeSize.setMaximumSize(new Dimension(500, 25));
        this.labelDefaultNodeSize.setPreferredSize(new Dimension(150, 25));
        this.labelDefaultNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelDefaultNodeSize.text"));
        this.jTextFieldDefaultNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultNodeSize.text"));
        this.jTextFieldDefaultNodeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultNodeSize.toolTipText"));
        this.jTextFieldDefaultNodeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldDefaultNodeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel1.text"));
        this.jLabel1.setMaximumSize(new Dimension(20, 25));
        this.jLabel1.setPreferredSize(new Dimension(20, 25));
        this.labelDefaultEdgeSize.setAlignment(2);
        this.labelDefaultEdgeSize.setMaximumSize(new Dimension(500, 25));
        this.labelDefaultEdgeSize.setPreferredSize(new Dimension(150, 25));
        this.labelDefaultEdgeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelDefaultEdgeSize.text"));
        this.jTextFieldDefaultEdgeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultEdgeSize.text"));
        this.jTextFieldDefaultEdgeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldDefaultEdgeSize.toolTipText"));
        this.jTextFieldDefaultEdgeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldDefaultEdgeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel2.text"));
        this.jLabel2.setMaximumSize(new Dimension(20, 25));
        this.jLabel2.setPreferredSize(new Dimension(20, 25));
        this.labelSosaNodeSize.setAlignment(2);
        this.labelSosaNodeSize.setMaximumSize(new Dimension(500, 25));
        this.labelSosaNodeSize.setPreferredSize(new Dimension(150, 25));
        this.labelSosaNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelSosaNodeSize.text"));
        this.jTextFieldSosaNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaNodeSize.text"));
        this.jTextFieldSosaNodeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaNodeSize.toolTipText"));
        this.jTextFieldSosaNodeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldSosaNodeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel3.text"));
        this.jLabel3.setMaximumSize(new Dimension(20, 25));
        this.jLabel3.setPreferredSize(new Dimension(20, 25));
        this.labelSosaEdgeSize.setAlignment(2);
        this.labelSosaEdgeSize.setMaximumSize(new Dimension(500, 25));
        this.labelSosaEdgeSize.setPreferredSize(new Dimension(150, 25));
        this.labelSosaEdgeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelSosaEdgeSize.text"));
        this.jTextFieldSosaEdgeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaEdgeSize.text"));
        this.jTextFieldSosaEdgeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldSosaEdgeSize.toolTipText"));
        this.jTextFieldSosaEdgeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldSosaEdgeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel4.text"));
        this.jLabel4.setMaximumSize(new Dimension(20, 25));
        this.jLabel4.setPreferredSize(new Dimension(20, 25));
        this.labelCujusNodeSize.setAlignment(2);
        this.labelCujusNodeSize.setMaximumSize(new Dimension(500, 25));
        this.labelCujusNodeSize.setPreferredSize(new Dimension(150, 25));
        this.labelCujusNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelCujusNodeSize.text"));
        this.jTextFieldCujusNodeSize.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldCujusNodeSize.text"));
        this.jTextFieldCujusNodeSize.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldCujusNodeSize.toolTipText"));
        this.jTextFieldCujusNodeSize.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldCujusNodeSize.setPreferredSize(new Dimension(50, 25));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel5.text"));
        this.jLabel5.setMaximumSize(new Dimension(20, 25));
        this.jLabel5.setPreferredSize(new Dimension(20, 25));
        this.labelIndiNodeWeight.setAlignment(2);
        this.labelIndiNodeWeight.setMaximumSize(new Dimension(150, 25));
        this.labelIndiNodeWeight.setPreferredSize(new Dimension(150, 25));
        this.labelIndiNodeWeight.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelIndiNodeWeight.text"));
        this.jTextFieldIndiNodeWeght.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldIndiNodeWeght.text"));
        this.jTextFieldIndiNodeWeght.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldIndiNodeWeght.toolTipText"));
        this.jTextFieldIndiNodeWeght.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldIndiNodeWeght.setPreferredSize(new Dimension(50, 25));
        this.labelEdgeWeight.setAlignment(2);
        this.labelEdgeWeight.setMaximumSize(new Dimension(150, 25));
        this.labelEdgeWeight.setPreferredSize(new Dimension(150, 25));
        this.labelEdgeWeight.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelEdgeWeight.text"));
        this.jTextFieldEdgeWeight.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldEdgeWeight.text"));
        this.jTextFieldEdgeWeight.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldEdgeWeight.toolTipText"));
        this.jTextFieldEdgeWeight.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldEdgeWeight.setPreferredSize(new Dimension(50, 25));
        this.jTextFieldFamNodeWeght.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldFamNodeWeght.text"));
        this.jTextFieldFamNodeWeght.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jTextFieldFamNodeWeght.toolTipText"));
        this.jTextFieldFamNodeWeght.setMaximumSize(new Dimension(50, 25));
        this.jTextFieldFamNodeWeght.setPreferredSize(new Dimension(50, 25));
        this.labelFamNodeWeight.setAlignment(2);
        this.labelFamNodeWeight.setMaximumSize(new Dimension(150, 25));
        this.labelFamNodeWeight.setPreferredSize(new Dimension(150, 25));
        this.labelFamNodeWeight.setText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.labelFamNodeWeight.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.labelFamNodeWeight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFamNodeWeght, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.labelIndiNodeWeight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldIndiNodeWeght, -2, 50, -2)))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.labelCujusNodeSize, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jTextFieldCujusNodeSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.labelSosaNodeSize, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jTextFieldSosaNodeSize, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.labelDefaultNodeSize, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jTextFieldDefaultNodeSize, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDefaultEdgeSize, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jTextFieldDefaultEdgeSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelEdgeWeight, -2, -1, -2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3, -2, -1, -2).addGap(9, 9, 9).addComponent(this.labelSosaEdgeSize, -2, -1, -2))).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSosaEdgeSize, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jTextFieldEdgeWeight, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, -1, -2))))).addGap(77, 77, 77)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelDefaultNodeSize, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDefaultNodeSize, -2, -1, -2).addComponent(this.jLabel1, -2, -1, -2)).addComponent(this.labelDefaultEdgeSize, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jTextFieldDefaultEdgeSize, -2, -1, -2))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSosaNodeSize, -2, -1, -2).addComponent(this.jTextFieldSosaNodeSize, -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.labelSosaEdgeSize, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSosaEdgeSize, -2, -1, -2).addComponent(this.jLabel4, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 83, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelCujusNodeSize, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCujusNodeSize, -2, -1, -2).addComponent(this.jLabel5, -2, -1, -2))).addGap(49, 49, 49).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldEdgeWeight, -2, -1, -2).addComponent(this.labelEdgeWeight, -2, -1, -2).addComponent(this.labelIndiNodeWeight, -2, -1, -2).addComponent(this.jTextFieldIndiNodeWeght, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFamNodeWeght, -2, -1, -2).addComponent(this.labelFamNodeWeight, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setPreferredSize(new Dimension(750, 100));
        this.jLabel6.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel6.text"));
        this.jLabel6.setMaximumSize(new Dimension(150, 25));
        this.jLabel6.setMinimumSize(new Dimension(150, 25));
        this.jLabel6.setPreferredSize(new Dimension(150, 25));
        this.jComboBoxIndiLabels.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jComboBoxIndiLabels.toolTipText"));
        this.jComboBoxIndiLabels.setPreferredSize(new Dimension(440, 25));
        this.jLabel7.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jLabel7.text"));
        this.jLabel7.setMaximumSize(new Dimension(150, 25));
        this.jLabel7.setMinimumSize(new Dimension(150, 25));
        this.jLabel7.setPreferredSize(new Dimension(150, 25));
        this.jComboBoxFamLabels.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jComboBoxFamLabels.toolTipText"));
        this.jComboBoxFamLabels.setPreferredSize(new Dimension(440, 25));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonApply, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonApply.text"));
        this.jButtonApply.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonApply.toolTipText"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphSettings.this.jButtonApplyActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonReset, (String)NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonReset.text"));
        this.jButtonReset.setToolTipText(NbBundle.getMessage(GraphSettings.class, (String)"GraphSettings.jButtonReset.toolTipText"));
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphSettings.this.jButtonResetActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jLabel6, -2, 244, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxIndiLabels, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxFamLabels, 0, -1, Short.MAX_VALUE)).addGap(0, 14, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonApply).addGap(108, 108, 108).addComponent(this.jButtonReset).addGap(48, 48, 48)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.jComboBoxIndiLabels, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.jComboBoxFamLabels, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonReset)).addContainerGap(53, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelColor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelEdge, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addComponent(this.jPanel3, -2, 703, -2)).addGap(23, 23, 23)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelColor, -2, -1, -2).addComponent(this.jLabelNode, -2, -1, -2).addComponent(this.jLabelEdge, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 280, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, 153, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        GraphParameter gp = new GraphParameter();
        gp.setAutoDisplay(this.getParam().isAutoDisplay());
        gp.setCenterGraph(this.getParam().isCenterGraph());
        gp.setShowLabel(this.getParam().isShowLabel());
        gp.setHideNodes(this.getParam().isHideNodes());
        this.theGTC.setGraphParam(gp);
        this.theGTC.updateCss();
        this.theGTC.updateWeight();
        this.initValues();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.getParam().setSizeCujus(this.jTextFieldCujusNodeSize.getText());
        this.getParam().setSizeEdgeSosa(this.jTextFieldSosaEdgeSize.getText());
        this.getParam().setSizeNodeSosa(this.jTextFieldSosaNodeSize.getText());
        this.getParam().setSizeEdge(this.jTextFieldDefaultEdgeSize.getText());
        this.getParam().setSizeNode(this.jTextFieldDefaultNodeSize.getText());
        this.getParam().setLabelFam((LabelFamEnum)((Object)this.jComboBoxFamLabels.getSelectedItem()));
        this.getParam().setLabelIndi((LabelIndiEnum)((Object)this.jComboBoxIndiLabels.getSelectedItem()));
        this.getParam().setUseGenerationScheme(this.jCheckBoxColorScheme.isSelected());
        this.theGTC.updateCss();
        this.getParam().setEdgeWeight(Double.parseDouble(this.jTextFieldEdgeWeight.getText()));
        this.getParam().setIndiNodeWeight(Double.parseDouble(this.jTextFieldIndiNodeWeght.getText()));
        this.getParam().setMariageNodeWeight(Double.parseDouble(this.jTextFieldFamNodeWeght.getText()));
        this.theGTC.updateWeight();
    }
}

