/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.family;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.TagPath;
import genj.report.Report;

public class ReportFamily
extends Report {
    public boolean reportParents = true;
    public boolean reportOtherSpouses = true;
    public boolean reportDetailedChildrenData = true;

    public void start(Gedcom gedcom) {
        Entity[] fams = gedcom.getEntities("FAM", "");
        for (int i = 0; i < fams.length; ++i) {
            this.analyzeFam((Fam)fams[i]);
            this.println();
            this.println("=====");
            this.println();
        }
    }

    public void start(Fam fam) {
        this.analyzeFam(fam);
    }

    private String trim(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private String familyToString(Fam f) {
        Indi husband = f.getHusband();
        Indi wife = f.getWife();
        String str = f.getId() + " ";
        if (husband != null) {
            str = str + husband;
        }
        if (husband != null && wife != null) {
            str = str + " + ";
        }
        if (wife != null) {
            str = str + wife;
        }
        return str;
    }

    private void analyzeFam(Fam f) {
        this.println(this.familyToString(f));
        if (this.trim(f.getMarriageDate()).length() > 0 || this.trim(f.getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
            this.println(this.OPTIONS.getMarriageSymbol() + this.trim(f.getMarriageDate()) + " " + this.trim(f.getProperty(new TagPath("FAM:MARR:PLAC"))));
        }
        this.analyzeIndi(f.getHusband(), f);
        this.analyzeIndi(f.getWife(), f);
        this.analyzeChildren(f);
    }

    private void analyzeIndi(Indi indi, Fam f) {
        Fam[] families;
        Fam fam;
        if (indi == null) {
            return;
        }
        this.println(this.getIndent(2) + indi);
        if (this.reportParents && (fam = indi.getFamilyWhereBiologicalChild()) != null) {
            this.println(this.getIndent(3) + this.OPTIONS.getChildOfSymbol() + this.familyToString(fam));
        }
        if (this.trim(indi.getBirthAsString()).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:BIRT:PLAC"))).length() > 0) {
            this.println(this.getIndent(3) + this.OPTIONS.getBirthSymbol() + this.trim(indi.getBirthAsString()) + " " + this.trim(indi.getProperty(new TagPath("INDI:BIRT:PLAC"))));
        }
        if (indi.getProperty("DEAT") != null && (this.trim(indi.getDeathAsString()).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:DEAT:PLAC"))).length() > 0)) {
            this.println(this.getIndent(3) + this.OPTIONS.getDeathSymbol() + this.trim(indi.getDeathAsString()) + " " + this.trim(indi.getProperty(new TagPath("INDI:DEAT:PLAC"))));
        }
        if (this.reportOtherSpouses && (families = indi.getFamiliesWhereSpouse()).length > 1) {
            this.println(this.getIndent(3) + this.translate("otherSpouses"));
            for (int i = 0; i < families.length; ++i) {
                if (families[i] == f) continue;
                String str = "";
                if (this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                    str = this.OPTIONS.getMarriageSymbol() + this.trim(families[i].getMarriageDate()) + " " + this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))) + " ";
                }
                this.println(this.getIndent(4) + str + " " + families[i]);
            }
        }
    }

    private void analyzeChildren(Fam f) {
        Indi[] children = f.getChildren();
        if (children.length > 0) {
            this.println(this.getIndent(2) + this.translate("children"));
        }
        for (int i = 0; i < children.length; ++i) {
            Indi child = children[i];
            this.println(this.getIndent(3) + child);
            if (!this.reportDetailedChildrenData) continue;
            if (this.trim(child.getBirthAsString()).length() > 0 || this.trim(child.getProperty(new TagPath("INDI:BIRT:PLAC"))).length() > 0) {
                this.println(this.getIndent(4) + this.OPTIONS.getBirthSymbol() + this.trim(child.getBirthAsString()) + " " + this.trim(child.getProperty(new TagPath("INDI:BIRT:PLAC"))));
            }
            this.printBaptism(child, "BAPM");
            this.printBaptism(child, "BAPL");
            this.printBaptism(child, "CHR");
            this.printBaptism(child, "CHRA");
            Fam[] families = child.getFamiliesWhereSpouse();
            for (int j = 0; j < families.length; ++j) {
                Fam family = families[j];
                this.println(this.getIndent(4) + this.OPTIONS.getMarriageSymbol() + family + " " + this.trim(family.getMarriageDate()) + " " + this.trim(family.getProperty(new TagPath("FAM:MARR:PLAC"))));
            }
            if (child.getProperty("DEAT") == null || this.trim(child.getDeathAsString()).length() <= 0 && this.trim(child.getProperty(new TagPath("INDI:DEAT:PLAC"))).length() <= 0) continue;
            this.println(this.getIndent(4) + this.OPTIONS.getDeathSymbol() + this.trim(child.getDeathAsString()) + " " + this.trim(child.getProperty(new TagPath("INDI:DEAT:PLAC"))));
        }
    }

    private void printBaptism(Indi indi, String tag) {
        if (indi.getProperty(tag) != null && (this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":DATE"))).length() > 0 || this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":PLAC"))).length() > 0)) {
            this.println(this.getIndent(4) + this.OPTIONS.getBaptismSymbol() + "(" + tag + "): " + this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":DATE"))) + " " + this.trim(indi.getProperty(new TagPath("INDI:" + tag + ":PLAC"))));
        }
    }
}

