/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.SubMenuAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.core.report.ReportTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.report.Bundle;
import genj.report.Report;
import genj.report.ReportLoader;
import genj.report.ReportView;
import genj.report.ReportViewFactory;
import genj.util.Resources;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Icon;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class ReportPlugin {
    private static final Resources RESOURCES = Resources.get(ReportPlugin.class);
    private static final int MAX_HISTORY = 5;
    private boolean showReportPickerOnOpen = true;
    public static final int POSITION = 2000;

    public ReportPlugin() {
        AncestrisPlugin.register((Object)this);
    }

    protected static Collection<Action> getReportActions(Object context, Gedcom gedcom) {
        TreeMap<String, SubMenuAction> categories = new TreeMap<String, SubMenuAction>();
        ArrayList<Action> result = new ArrayList<Action>(5);
        for (Report report : ReportLoader.getInstance().getReports()) {
            try {
                String accept = report.accepts(context);
                if (accept == null) continue;
                ActionRun run = new ActionRun(accept, context, report, gedcom);
                String cat = report.getCategory().getDisplayName();
                if (cat == null) {
                    result.add((Action)((Object)run));
                    continue;
                }
                SubMenuAction catgroup = (SubMenuAction)categories.get(cat);
                if (catgroup == null) {
                    catgroup = new SubMenuAction(RESOURCES.getString("title") + " (" + cat + ")", report.getIcon());
                    categories.put(cat, catgroup);
                }
                catgroup.addAction((Action)((Object)run));
            }
            catch (Throwable t) {
                ReportView.LOG.log(Level.WARNING, "Report " + report.getClass().getName() + " failed in accept()", t);
            }
        }
        result.addAll(categories.values());
        return result;
    }

    private static Context getContextFromLookup(Lookup lookup) {
        Context ctx;
        Collection properties = lookup.lookupAll(Property.class);
        if (properties.isEmpty()) {
            ctx = new Context();
        } else {
            Gedcom gedcom = ((Property)properties.iterator().next()).getGedcom();
            ctx = new Context(gedcom, null, properties);
        }
        return ctx;
    }

    public static ReportView getReportView(Context contextToOpen) {
        ReportView view = null;
        ReportTopComponent atc = null;
        for (ReportTopComponent tc : AncestrisPlugin.lookupAll(ReportTopComponent.class)) {
            if (!contextToOpen.getGedcom().equals(tc.getGedcom()) || !(tc.getView() instanceof ReportView)) continue;
            atc = tc;
            atc.init(contextToOpen);
            view = (ReportView)tc.getView();
        }
        if (view == null) {
            ReportTopComponent tc = (ReportTopComponent)ReportTopComponent.getFactory().create(contextToOpen);
            view = (ReportView)tc.getView();
            view.setContext(contextToOpen);
            atc = tc;
        }
        if (view != null) {
            atc.open();
            atc.requestActive();
            return view;
        }
        return view;
    }

    private static class ActionRun
    extends AbstractAncestrisAction {
        private Object context;
        private Report report;
        private Gedcom gedcom;

        private ActionRun(String txt, Object context, Report report, Gedcom gedcom) {
            this.context = context;
            this.report = report;
            this.gedcom = gedcom;
            this.setText(txt);
            StringBuffer tip = new StringBuffer();
            tip.append("<html><body><table width=500><tr><td>");
            String info = report.getInfo();
            int br = info.indexOf("</p>");
            if (br > 0) {
                info = info.substring(0, br + 4);
            }
            tip.append(info);
            tip.append("</td></tr></table>");
            this.setTip(tip.toString());
        }

        public void actionPerformed(ActionEvent event) {
            if (this.context == null) {
                return;
            }
            Context lookupContext = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
            ReportView view = ReportPlugin.getReportView(lookupContext);
            if (view != null) {
                view.startReport(this.report, this.context, this.gedcom);
            }
        }
    }

    public static class GedcomReportSubMenu
    extends SubMenuAction {
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup context) {
            Gedcom gedcom = ReportPlugin.getContextFromLookup(context).getGedcom();
            this.clearActions();
            if (gedcom != null) {
                this.setText(Bundle.report_runon_gedcom(gedcom.getName()));
                this.setImage((Icon)Gedcom.getImage());
                this.setImage((Icon)ReportViewFactory.IMG);
                this.addActions(ReportPlugin.getReportActions(gedcom, gedcom));
            }
            return super.createContextAwareInstance(context);
        }
    }

    public static class EntitiesReportSubMenu
    extends SubMenuAction {
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup context) {
            Context ctx = ReportPlugin.getContextFromLookup(context);
            List entities = ctx.getEntities();
            this.clearActions();
            if (entities.size() > 1) {
                this.setText(Bundle.report_runon_group(Property.getPropertyNames((Iterable)entities, (int)5), entities.size()));
                this.addActions(ReportPlugin.getReportActions(entities, ctx.getGedcom()));
            } else if (entities.size() == 1) {
                Entity entity = (Entity)entities.iterator().next();
                this.setText(Bundle.report_runon("", entity.getDisplayTitle()));
                this.setImage((Icon)entity.getImage());
                this.setImage((Icon)ReportViewFactory.IMG);
                this.addActions(ReportPlugin.getReportActions(entity, entity.getGedcom()));
            }
            return super.createContextAwareInstance(context);
        }
    }

    public static class PropertiesReportSubMenu
    extends SubMenuAction {
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup context) {
            Context ctx = ReportPlugin.getContextFromLookup(context);
            List properties = ctx.getProperties();
            this.clearActions();
            if (properties.size() > 1) {
                this.setText(Bundle.report_runon_group(Property.getPropertyNames((Iterable)properties, (int)5), properties.size()));
                this.addActions(ReportPlugin.getReportActions(properties, ctx.getGedcom()));
            } else if (properties.size() == 1) {
                Property property = (Property)properties.iterator().next();
                this.setText(Bundle.report_runon("", property.getDisplayTitle()));
                this.setImage((Icon)property.getImage(false));
                this.setImage((Icon)ReportViewFactory.IMG);
                this.addActions(ReportPlugin.getReportActions(property, property.getGedcom()));
            }
            return super.createContextAwareInstance(context);
        }
    }
}

