/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.TagPath;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SelectEntityWidget
extends JPanel {
    private static final Resources RESOURCES = Resources.get(SelectEntityWidget.class);
    private static final Registry REGISTRY = Registry.get(SelectEntityWidget.class);
    public static final String NEW = RESOURCES.getString("select.new");
    private String type = "INDI";
    private Gedcom gedcom;
    private Entity[] list;
    private Object none;
    private boolean isInitialized = false;
    private TagPath sort;
    private List<TagPath> sorts;
    private static final String[] SORTS = new String[]{"INDI:NAME", "INDI", "INDI:BIRT:DATE", "INDI:DEAT:DATE", "FAM", "FAM:MARR:DATE", "FAM:HUSB:*:..:NAME", "FAM:WIFE:*:..:NAME", "OBJE", "OBJE:TITL", "OBJE:FILE:TITL", "NOTE", "NOTE:NOTE", "SOUR", "SOUR:TITL", "SOUR:ABBR", "SOUR:AUTH", "SOUR:REPO", "SUBM", "REPO", "REPO:NAME", "REPO:REFN", "REPO:RIN"};
    private JComboBox listWidget;
    private PopupWidget sortWidget;

    public SelectEntityWidget(Gedcom gedcom, String type, String none, boolean init) {
        this.gedcom = gedcom;
        this.type = type;
        this.none = none;
        Collection<? extends Entity> entities = gedcom.getEntities(type);
        this.list = new Entity[entities.size()];
        int e = 0;
        for (Entity entity : entities) {
            this.list[e++] = entity;
        }
        this.sorts = new ArrayList<TagPath>(SORTS.length);
        for (int i = 0; i < SORTS.length; ++i) {
            String string = SORTS[i];
            if (!string.startsWith(type)) continue;
            TagPath p = new TagPath(string);
            this.sorts.add(p);
            if (this.sort != null && !string.equals(REGISTRY.get("select.sort." + type, ""))) continue;
            this.sort = p;
        }
        this.initComponents();
        for (TagPath tagPath : this.sorts) {
            this.sortWidget.addItem(new Sort(tagPath));
        }
        this.listWidget.setRenderer(new Renderer());
        if (init) {
            this.sort(this.sort);
            if (none != null || this.list.length > 0) {
                this.listWidget.setSelectedIndex(0);
            }
            this.isInitialized = true;
        } else {
            String[] emptyList = new String[]{""};
            JComboBox<String> jComboBox = new JComboBox<String>(emptyList);
            this.listWidget.setModel(jComboBox.getModel());
        }
    }

    private void initComponents() {
        this.sortWidget = new PopupWidget();
        this.listWidget = new JComboBox();
        this.setPreferredSize(new Dimension(310, 24));
        Mnemonics.setLocalizedText((AbstractButton)this.sortWidget, (String)NbBundle.getMessage(SelectEntityWidget.class, (String)"SelectEntityWidget.sortWidget.text"));
        this.listWidget.setMaximumRowCount(16);
        this.listWidget.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sortWidget, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.listWidget, 0, 272, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sortWidget, -1, -1, Short.MAX_VALUE).addComponent(this.listWidget)).addGap(0, 0, 0)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectEntityWidget.class, (String)"SelectEntityWidget.AccessibleContext.accessibleName"));
    }

    public void init() {
        if (this.isInitialized) {
            return;
        }
        this.sort(this.sort);
        if (this.none != null || this.list.length > 0) {
            this.listWidget.setSelectedIndex(0);
        }
        this.isInitialized = true;
    }

    public void sort(TagPath path) {
        this.sort = path;
        REGISTRY.put("select.sort." + this.type, path.toString());
        PropertyComparator comparator = new PropertyComparator(path);
        Arrays.sort(this.list, comparator);
        Entity selection = this.getSelection();
        this.listWidget.setModel(new Model());
        this.sortWidget.setIcon(this.getPathImage(path));
        this.sortWidget.setToolTipText(this.getPathText(path));
        this.setSelection(selection);
    }

    public int getEntityCount() {
        return this.listWidget.getItemCount() - 1;
    }

    public Entity getSelection() {
        Object item = this.listWidget.getSelectedItem();
        if (!(item instanceof Entity)) {
            return null;
        }
        return (Entity)item;
    }

    public void setSelection(Entity set) {
        if (set == null) {
            this.listWidget.setSelectedItem(this.none != null ? this.none : null);
        } else if (set.getTag().equals(this.type)) {
            this.listWidget.setSelectedItem(set);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listWidget.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listWidget.removeActionListener(listener);
    }

    private MetaProperty getMeta(TagPath tagPath) {
        MetaProperty meta = tagPath.length() > 1 && !tagPath.getLast().equals("TITL") ? this.gedcom.getGrammar().getMeta(new TagPath(tagPath, 2), false) : this.gedcom.getGrammar().getMeta(tagPath, false);
        return meta;
    }

    private ImageIcon getPathImage(TagPath tagPath) {
        return this.getMeta(tagPath).getImage();
    }

    private String getPathText(TagPath tagPath) {
        String ID = RESOURCES.getString("select.sortID");
        return RESOURCES.getString("select.sort", tagPath.length() == 1 ? ID : this.getMeta(tagPath).getName());
    }

    private class Sort
    extends AbstractAncestrisAction {
        private TagPath tagPath;

        private Sort(TagPath path) {
            this.tagPath = path;
            this.setImage(SelectEntityWidget.this.getPathImage(path));
            this.setText(SelectEntityWidget.this.getPathText(path));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SelectEntityWidget.this.sort(this.tagPath);
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String txt;
            if (value instanceof Entity) {
                txt = this.getString((Entity)value);
            } else {
                String string = txt = value != null ? value.toString() : "";
            }
            if (txt != null && !"".equals(txt)) {
                String[] texte;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                for (String s : texte = txt.split("(?<=\\G.{50})")) {
                    sb.append(s).append("<br>");
                }
                sb.append("</html>");
                list.setToolTipText(sb.toString());
            }
            return super.getListCellRendererComponent((JList<?>)list, txt, index, isSelected, cellHasFocus);
        }

        private String getString(Entity e) {
            if (SelectEntityWidget.this.sort == null) {
                return e.toString();
            }
            WordBuffer value = new WordBuffer(", ");
            value.append(this.getString(e.getProperty(SelectEntityWidget.this.sort), "?"));
            for (TagPath other : SelectEntityWidget.this.sorts) {
                if (other.equals(SelectEntityWidget.this.sort) || !other.getFirst().equals(SelectEntityWidget.this.sort.getFirst())) continue;
                value.append(this.getString(e.getProperty(other), ""));
            }
            return value.toString();
        }

        private String getString(Property p, String fallback) {
            if (p instanceof Entity) {
                return ((Entity)p).getId();
            }
            return p != null && p.isValid() ? p.getDisplayValue() : fallback;
        }
    }

    private class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private Object selection;

        private Model() {
        }

        @Override
        public Object getSelectedItem() {
            return this.selection;
        }

        @Override
        public void setSelectedItem(Object set) {
            this.selection = set;
        }

        @Override
        public Object getElementAt(int index) {
            if (SelectEntityWidget.this.none != null) {
                return index == 0 ? SelectEntityWidget.this.none : SelectEntityWidget.this.list[index - 1];
            }
            return SelectEntityWidget.this.list[index];
        }

        @Override
        public int getSize() {
            return SelectEntityWidget.this.list.length + (SelectEntityWidget.this.none != null ? 1 : 0);
        }
    }
}

