/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing;

import ancestris.core.resources.Images;
import ancestris.util.swing.DialogManager;
import genj.gedcom.GedcomOptions;
import genj.util.Registry;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class FileChooserBuilder {
    static final Logger LOG = Logger.getLogger("ancestris.FileChooserBuilder");
    private boolean dirsOnly;
    private BadgeProvider badger;
    private String title;
    private String approveText;
    private String approveTooltipText = null;
    private final String dirKey;
    private File failoverDir;
    private FileFilter filter;
    private boolean fileHiding = true;
    private boolean controlButtonsShown = true;
    private String aDescription;
    private boolean filesOnly;
    private static final boolean DONT_STORE_DIRECTORIES = false;
    private SelectionApprover approver;
    private final List<FileFilter> filters = new ArrayList<FileFilter>(3);
    private Map<String, String> formats = new HashMap<String, String>();
    private boolean useAcceptAllFileFilter = true;
    private boolean imagePreviewer = false;
    private JComponent accessory;
    private boolean badgeProvider = false;
    private File selectedFile;
    public static String[] gedExtensions = new String[]{"ged"};
    public static String[] imgExtensions = new String[]{"png", "jpg", "jpeg", "gif", "tiff", "bmp", "svg"};
    public static String[] sndExtensions = new String[]{"mp3", "wav", "ogg", "flac"};
    public static String[] vidExtensions = new String[]{"mp4", "flv", "ogg", "avi", "mov", "mpeg", "mts", "ts", "wmv", "mkv", "asf"};
    public static String[] pdfExtensions = new String[]{"pdf", "ps"};
    public static String[] txtExtensions = new String[]{"txt"};
    public static String[] docExtensions = new String[]{"txt", "doc", "odt"};
    public static String[] csvExtensions = new String[]{"csv"};
    public static String[] tblExtensions = new String[]{"txt", "csv"};
    public static String[] htmExtensions = new String[]{"html"};
    public static String[] zipExtensions = new String[]{"zip"};
    public static String[] almExtensions = new String[]{"almanac"};
    public static String[] pngExtensions = new String[]{"png"};
    private static String DIMX = "dimX";
    private static String DIMY = "dimY";
    private static String DIMW = "dimW";
    private static String DIMH = "dimH";
    private JFileChooser activeChooser = null;
    private String defaultExtension = null;
    private boolean force = false;
    private Component parent = null;

    public FileChooserBuilder(Class type) {
        this(type.getName());
    }

    public FileChooserBuilder(String dirKey) {
        Parameters.notNull((CharSequence)"dirKey", (Object)dirKey);
        this.dirKey = dirKey;
        this.localizeLabels();
    }

    public FileChooserBuilder setDirectoriesOnly(boolean val) {
        this.dirsOnly = val;
        assert (!this.filesOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setFilesOnly(boolean val) {
        this.filesOnly = val;
        assert (!this.dirsOnly) : "FilesOnly and DirsOnly are mutually exclusive";
        return this;
    }

    public FileChooserBuilder setBadgeProvider(BadgeProvider provider) {
        this.badger = provider;
        return this;
    }

    public FileChooserBuilder setDefaultBadgeProvider() {
        this.badgeProvider = true;
        return this;
    }

    public FileChooserBuilder setDefaultPreviewer() {
        this.imagePreviewer = true;
        return this;
    }

    public FileChooserBuilder setAccessory(JComponent accessory) {
        this.accessory = accessory;
        return this;
    }

    public FileChooserBuilder setTitle(String val) {
        this.title = val;
        return this;
    }

    public FileChooserBuilder setDefaultTitle() {
        this.title = NbBundle.getMessage(this.getClass(), (String)"TITL_ChooseFile");
        return this;
    }

    public FileChooserBuilder setApproveText(String val) {
        this.approveText = val;
        return this;
    }

    public FileChooserBuilder setApproveTooltipText(String val) {
        this.approveTooltipText = val;
        return this;
    }

    public FileChooserBuilder setDefaultExtension(String extension) {
        this.defaultExtension = extension;
        return this;
    }

    public FileChooserBuilder setFileFilter(FileFilter filter) {
        this.filter = filter;
        return this;
    }

    public FileChooserBuilder setFileFilters(Map<String, String> formats) {
        this.formats = formats;
        for (String key : formats.keySet()) {
            this.filters.add(new FileNameExtensionFilter(key, formats.get(key)));
        }
        return this;
    }

    public FileChooserBuilder forceFileFilter(FileFilter filter) {
        if (this.activeChooser != null) {
            this.activeChooser.resetChoosableFileFilters();
            this.activeChooser.setFileFilter(filter);
            this.activeChooser.setAcceptAllFileFilterUsed(false);
        }
        return this;
    }

    public FileChooserBuilder addFileFilter(FileFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public FileChooserBuilder addDefaultFileFilters() {
        return this;
    }

    public FileChooserBuilder setAcceptAllFileFilterUsed(boolean accept) {
        this.useAcceptAllFileFilter = accept;
        return this;
    }

    public FileChooserBuilder setDefaultWorkingDirectory(File dir) {
        this.failoverDir = dir;
        return this;
    }

    public FileChooserBuilder setDefaultDirAsReportDirectory() {
        this.failoverDir = new File(Registry.get(GedcomOptions.class).get("reportDir", System.getProperty("user.home")));
        return this;
    }

    public FileChooserBuilder forceUseOfDefaultWorkingDirectory(boolean val) {
        this.force = val;
        return this;
    }

    public FileChooserBuilder setSelectedFile(File selectedFile) {
        this.selectedFile = selectedFile;
        return this;
    }

    public FileChooserBuilder forceSelectedFile(File selectedFile) {
        if (this.activeChooser != null) {
            this.activeChooser.setSelectedFile(selectedFile);
        }
        return this;
    }

    public FileChooserBuilder setFileHiding(boolean fileHiding) {
        this.fileHiding = fileHiding;
        return this;
    }

    public FileChooserBuilder setControlButtonsAreShown(boolean val) {
        this.controlButtonsShown = val;
        return this;
    }

    public FileChooserBuilder setAccessibleDescription(String aDescription) {
        this.aDescription = aDescription;
        return this;
    }

    public FileChooserBuilder setParent(Component parent) {
        this.parent = parent;
        return this;
    }

    public JFileChooser createFileChooser() {
        SavedDirFileChooser result = new SavedDirFileChooser(this.dirKey, this.failoverDir, this.force, this.approver);
        this.prepareFileChooser(result);
        return result;
    }

    public FileChooserBuilder setSelectionApprover(SelectionApprover approver) {
        this.approver = approver;
        return this;
    }

    public File[] showMultiOpenDialog() {
        JFileChooser chooser = this.createFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(this.findDialogParent());
        if (0 == result) {
            this.saveDialogSize(chooser);
            File[] files = chooser.getSelectedFiles();
            return files == null ? new File[]{} : files;
        }
        this.saveDialogSize(chooser);
        return null;
    }

    public File showOpenDialog() {
        FileDialog fileDialog;
        JFileChooser chooser = this.createFileChooser();
        if (Boolean.getBoolean("nb.native.filechooser") && null != (fileDialog = this.createFileDialog(chooser.getCurrentDirectory()))) {
            return this.showFileDialog(fileDialog, 0);
        }
        chooser.setMultiSelectionEnabled(false);
        Component w = this.findDialogParent();
        LOG.log(Level.FINER, "Launching showOpenDialog which scans directory.");
        int dlgResult = chooser.showOpenDialog(w);
        LOG.log(Level.FINER, "User pressed OK\u00a0or Cancel in file dialog.");
        if (0 == dlgResult) {
            this.saveDialogSize(chooser);
            File result = chooser.getSelectedFile();
            if (result != null && !result.exists()) {
                result = null;
            }
            return result;
        }
        this.saveDialogSize(chooser);
        return null;
    }

    public File showSaveDialog() {
        return this.showSaveDialog(true);
    }

    public File showSaveDialog(boolean askForOverwrite) {
        FileDialog fileDialog;
        JFileChooser chooser = this.createFileChooser();
        if (Boolean.getBoolean("nb.native.filechooser") && null != (fileDialog = this.createFileDialog(chooser.getCurrentDirectory()))) {
            return this.showFileDialog(fileDialog, 1);
        }
        File file = null;
        if (0 == chooser.showSaveDialog(this.findDialogParent())) {
            file = chooser.getSelectedFile();
        }
        this.saveDialogSize(chooser);
        if (file == null) {
            return null;
        }
        if (file.getName().indexOf(46) == -1) {
            String extension = this.getExtensionFromFilter(chooser.getFileFilter());
            if (extension != null && !extension.isEmpty()) {
                this.defaultExtension = extension;
            }
            if (this.defaultExtension != null && !this.defaultExtension.isEmpty()) {
                file = new File(file.getAbsolutePath() + "." + this.defaultExtension);
            }
        }
        if (askForOverwrite && file.exists() && DialogManager.YES_OPTION != DialogManager.createYesNo(NbBundle.getMessage(FileChooserBuilder.class, (String)"TITL_fileOverwrite"), NbBundle.getMessage(FileChooserBuilder.class, (String)"MSG_fileOverwrite", (Object)file.getName())).setMessageType(2).show()) {
            file = null;
        }
        return file;
    }

    public static String getExtension(String s) {
        int j;
        String ext = "";
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1 && (j = (ext = s.substring(i + 1).toLowerCase()).indexOf(63)) > 0 && j <= ext.length()) {
            ext = ext.substring(0, j);
        }
        return ext;
    }

    public static Icon getIconFromFileExtension(File file) {
        String extension = FileChooserBuilder.getExtension(file.getName());
        ImageIcon icon = null;
        if (Arrays.asList(gedExtensions).contains(extension)) {
            icon = Images.imgGedcom;
        } else if (Arrays.asList(imgExtensions).contains(extension)) {
            icon = Images.imgImage;
        } else if (Arrays.asList(sndExtensions).contains(extension)) {
            icon = Images.imgSound;
        } else if (Arrays.asList(vidExtensions).contains(extension)) {
            icon = Images.imgVideo;
        } else if (Arrays.asList(pdfExtensions).contains(extension)) {
            icon = Images.imgPDF;
        } else if (Arrays.asList(txtExtensions).contains(extension)) {
            icon = Images.imgText;
        } else if (Arrays.asList(zipExtensions).contains(extension)) {
            icon = Images.imgZip;
        } else if (Arrays.asList(almExtensions).contains(extension)) {
            icon = Images.imgAlm;
        }
        return icon;
    }

    public static FileFilter getAllFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_ALLTYPES");
            }
        };
    }

    public static FileNameExtensionFilter getGedcomFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_GEDCOM"), gedExtensions);
    }

    public static FileNameExtensionFilter getTextFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_TEXT"), txtExtensions);
    }

    public static FileNameExtensionFilter getTableFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_TABLE"), tblExtensions);
    }

    public static FileNameExtensionFilter getPdfFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_PDF"), pdfExtensions);
    }

    public static FileNameExtensionFilter getHtmlFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_HTML"), htmExtensions);
    }

    public static FileNameExtensionFilter getCSVFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_CSV"), csvExtensions);
    }

    public static FileNameExtensionFilter getImageFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_Images"), imgExtensions);
    }

    public static FileNameExtensionFilter getSoundFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_Sounds"), sndExtensions);
    }

    public static FileNameExtensionFilter getVideoFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_Videos"), vidExtensions);
    }

    public static FileNameExtensionFilter getZipFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_Zip"), zipExtensions);
    }

    public static FileNameExtensionFilter getAlmanacFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_Almanac"), almExtensions);
    }

    public static FileNameExtensionFilter getPngFilter() {
        return new FileNameExtensionFilter(NbBundle.getMessage(FileChooserBuilder.class, (String)"Filter_PNG"), pngExtensions);
    }

    private Component findDialogParent() {
        return null;
    }

    private File showFileDialog(FileDialog fileDialog, int mode) {
        String oldFileDialogProp = System.getProperty("apple.awt.fileDialogForDirectories");
        if (this.dirsOnly) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        fileDialog.setMode(mode);
        fileDialog.setVisible(true);
        if (this.dirsOnly) {
            if (null != oldFileDialogProp) {
                System.setProperty("apple.awt.fileDialogForDirectories", oldFileDialogProp);
            } else {
                System.clearProperty("apple.awt.fileDialogForDirectories");
            }
        }
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            String selFile = fileDialog.getFile();
            File dir = new File(fileDialog.getDirectory());
            return new File(dir, selFile);
        }
        return null;
    }

    private void prepareFileChooser(JFileChooser chooser) {
        this.setDialogSize(chooser);
        chooser.setFileSelectionMode(this.dirsOnly ? 1 : (this.filesOnly ? 0 : 2));
        this.addFileHidingCheckBox(chooser);
        chooser.setControlButtonsAreShown(this.controlButtonsShown);
        chooser.setAcceptAllFileFilterUsed(this.useAcceptAllFileFilter);
        if (this.title != null) {
            chooser.setDialogTitle(this.title);
        }
        if (this.approveText != null) {
            chooser.setApproveButtonText(this.approveText);
        }
        if (this.badgeProvider) {
            this.badger = new DefaultBadgeProvider();
        }
        if (this.badger != null) {
            chooser.setFileView(new CustomFileView(new BadgeIconProvider(this.badger), chooser.getFileSystemView()));
        }
        if (this.filter != null) {
            chooser.setFileFilter(this.filter);
        }
        if (this.selectedFile != null) {
            chooser.setSelectedFile(this.selectedFile);
        }
        if (this.aDescription != null) {
            chooser.getAccessibleContext().setAccessibleDescription(this.aDescription);
        }
        if (!this.filters.isEmpty()) {
            for (FileFilter f : this.filters) {
                chooser.addChoosableFileFilter(f);
            }
        }
        if (this.imagePreviewer) {
            chooser.setAccessory(new DefaultImagePreviewer(chooser));
        } else if (this.accessory != null) {
            chooser.setAccessory(this.accessory);
        }
        this.removeButtonTooltips(chooser);
        if (this.approveTooltipText != null) {
            chooser.setApproveButtonToolTipText(this.approveTooltipText);
        }
        this.activeChooser = chooser;
    }

    private void addFileHidingCheckBox(final JFileChooser chooser) {
        Container c = null;
        final FileChooserUI fcui = chooser.getUI();
        JButton button = fcui.getDefaultButton(chooser);
        if (button != null && (c = button.getParent()) != null) {
            c = c.getParent();
        }
        if (c != null && c instanceof JPanel) {
            JPanel panel = (JPanel)c;
            final JCheckBox cbHide = new JCheckBox(NbBundle.getMessage(this.getClass(), (String)"FileChooser.showHiddenFiles"));
            chooser.setFileHidingEnabled(this.fileHiding);
            cbHide.setSelected(!this.fileHiding);
            JPanel panelHide = new JPanel();
            panelHide.setLayout(new BorderLayout());
            panelHide.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            panelHide.add((Component)cbHide, "Before");
            cbHide.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean isSelected = cbHide.isSelected();
                    chooser.setFileHidingEnabled(!isSelected);
                    fcui.rescanCurrentDirectory(chooser);
                }
            });
            panel.add(panelHide);
        } else {
            this.fileHiding = false;
            chooser.setFileHidingEnabled(this.fileHiding);
        }
    }

    private FileDialog createFileDialog(File currentDirectory) {
        if (this.badger != null) {
            return null;
        }
        if (!Boolean.getBoolean("nb.native.filechooser")) {
            return null;
        }
        if (this.dirsOnly && !Utilities.isMac()) {
            return null;
        }
        Component parentComponent = this.findDialogParent();
        Frame parentFrame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parentComponent);
        FileDialog fileDialog = new FileDialog(parentFrame);
        if (this.title != null) {
            fileDialog.setTitle(this.title);
        }
        if (null != currentDirectory) {
            fileDialog.setDirectory(currentDirectory.getAbsolutePath());
        }
        return fileDialog;
    }

    private void setDialogSize(JFileChooser chooser) {
        int x = Integer.valueOf(NbPreferences.forModule(FileChooserBuilder.class).get(DIMX, "-1"));
        int y = Integer.valueOf(NbPreferences.forModule(FileChooserBuilder.class).get(DIMY, "-1"));
        int w = Integer.valueOf(NbPreferences.forModule(FileChooserBuilder.class).get(DIMW, "650"));
        int h = Integer.valueOf(NbPreferences.forModule(FileChooserBuilder.class).get(DIMH, "400"));
        if (x >= 0 && y >= 0) {
            chooser.setLocation(x, y);
        }
        chooser.setPreferredSize(new Dimension(w, h));
    }

    private void saveDialogSize(JFileChooser chooser) {
        int x = chooser.getLocation().x;
        int y = chooser.getLocation().y;
        NbPreferences.forModule(FileChooserBuilder.class).put(DIMX, "" + x);
        NbPreferences.forModule(FileChooserBuilder.class).put(DIMY, "" + y);
        int w = chooser.getSize().width;
        int h = chooser.getSize().height;
        NbPreferences.forModule(FileChooserBuilder.class).put(DIMW, "" + w);
        NbPreferences.forModule(FileChooserBuilder.class).put(DIMH, "" + h);
    }

    private void removeButtonTooltips(Container container) {
        Component[] jc = container.getComponents();
        for (int i = 0; i < jc.length; ++i) {
            Component c = jc[i];
            if (c instanceof JButton) {
                JButton j = (JButton)c;
                if (j.getText() == null || j.getText().isEmpty()) continue;
                j.setToolTipText(null);
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.removeButtonTooltips((Container)c);
        }
    }

    private String getExtensionFromFilter(FileFilter fileFilter) {
        String ret = this.formats.get(fileFilter.getDescription());
        if (ret == null) {
            for (FileFilter f : this.filters) {
                FileNameExtensionFilter fef;
                String[] exts;
                if (!(f instanceof FileNameExtensionFilter) || !f.getDescription().equals(fileFilter.getDescription()) || (exts = (fef = (FileNameExtensionFilter)f).getExtensions()).length <= 0) continue;
                return exts[0];
            }
        }
        return ret;
    }

    private void localizeLabels() {
        String[] KEYS;
        for (String key : KEYS = new String[]{"acceptAllFileFilterText", "lookInLabelText", "cancelButtonText", "cancelButtonToolTipText", "openButtonText", "openButtonToolTipText", "filesOfTypeLabelText", "fileNameLabelText", "folderNameLabelText", "listViewButtonToolTipText", "listViewButtonAccessibleName", "detailsViewButtonToolTipText", "detailsViewButtonAccessibleName", "upFolderToolTipText", "upFolderAccessibleName", "homeFolderToolTipText", "homeFolderAccessibleName", "fileNameHeaderText", "fileSizeHeaderText", "fileTypeHeaderText", "fileDateHeaderText", "fileAttrHeaderText", "openDialogTitleText", "newFolderToolTipText", "saveButtonText", "updateButtonText", "helpButtonText", "saveButtonToolTipText", "updateButtonToolTipText", "helpButtonToolTipText"}) {
            UIManager.put("FileChooser." + key, NbBundle.getMessage(FileChooserBuilder.class, (String)("FileChooser." + key)));
        }
    }

    private static final class DefaultBadgeProvider
    implements BadgeProvider {
        @Override
        public Icon getBadge(File file) {
            return FileChooserBuilder.getIconFromFileExtension(file);
        }

        @Override
        public int getXOffset() {
            return 5;
        }

        @Override
        public int getYOffset() {
            return 5;
        }
    }

    private static final class DefaultImagePreviewer
    extends JLabel {
        public DefaultImagePreviewer(JFileChooser chooser) {
            int size = 120;
            this.setText("");
            this.setPreferredSize(new Dimension(120, 120));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            chooser.addPropertyChangeListener(evt -> {
                File f;
                if (evt.getPropertyName().equals("SelectedFileChangedProperty") && (f = (File)evt.getNewValue()) != null) {
                    javax.swing.ImageIcon icon = new javax.swing.ImageIcon(f.getPath());
                    if (icon.getIconWidth() > 120) {
                        icon = new javax.swing.ImageIcon(icon.getImage().getScaledInstance(120, -1, 1));
                    }
                    this.setIcon(icon);
                }
            });
        }
    }

    private static class MergedIcon
    implements Icon {
        private final Icon icon1;
        private final Icon icon2;
        private final int xMerge;
        private final int yMerge;

        MergedIcon(Icon icon1, Icon icon2, int xMerge, int yMerge) {
            assert (icon1 != null);
            assert (icon2 != null);
            this.icon1 = icon1;
            this.icon2 = icon2;
            if (xMerge == -1) {
                xMerge = icon1.getIconWidth() - icon2.getIconWidth();
            }
            if (yMerge == -1) {
                yMerge = icon1.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = xMerge;
            this.yMerge = yMerge;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon1.paintIcon(c, g, x, y);
            this.icon2.paintIcon(c, g, x + this.xMerge, y + this.yMerge);
        }
    }

    private static final class CustomFileView
    extends FileView {
        private final IconProvider provider;
        private final FileSystemView view;

        CustomFileView(IconProvider provider, FileSystemView view) {
            this.provider = provider;
            this.view = view;
        }

        @Override
        public Icon getIcon(File f) {
            Icon result = this.view.getSystemIcon(f);
            result = this.provider.getIcon(f, result);
            return result;
        }
    }

    private static final class BadgeIconProvider
    implements IconProvider {
        private final BadgeProvider badger;

        public BadgeIconProvider(BadgeProvider badger) {
            this.badger = badger;
        }

        @Override
        public Icon getIcon(File file, Icon orig) {
            Icon badge = this.badger.getBadge(file);
            if (badge != null && orig != null) {
                return new MergedIcon(orig, badge, this.badger.getXOffset(), this.badger.getYOffset());
            }
            return orig;
        }
    }

    public static interface BadgeProvider {
        public Icon getBadge(File var1);

        public int getXOffset();

        public int getYOffset();
    }

    static interface IconProvider {
        public Icon getIcon(File var1, Icon var2);
    }

    private static final class SavedDirFileChooser
    extends JFileChooser {
        private final String dirKey;
        private final SelectionApprover approver;

        SavedDirFileChooser(String dirKey, File failoverDir, boolean force, SelectionApprover approver) {
            this.dirKey = dirKey;
            this.approver = approver;
            if (force && failoverDir != null && failoverDir.exists() && failoverDir.isDirectory()) {
                this.setCurrentDirectory(failoverDir);
            } else {
                String path = NbPreferences.forModule(FileChooserBuilder.class).get(dirKey, null);
                if (path != null) {
                    File f = new File(path);
                    if (f.exists() && f.isDirectory()) {
                        this.setCurrentDirectory(f);
                    } else if (failoverDir != null) {
                        this.setCurrentDirectory(failoverDir);
                    }
                } else if (failoverDir != null) {
                    this.setCurrentDirectory(failoverDir);
                }
            }
        }

        @Override
        public void approveSelection() {
            if (this.approver != null) {
                boolean approved;
                File[] selected = this.getSelectedFiles();
                File sf = this.getSelectedFile();
                if ((selected == null || selected.length == 0) && sf != null) {
                    selected = new File[]{sf};
                }
                if (approved = this.approver.approve(selected)) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }

        @Override
        public int showOpenDialog(Component parent) throws HeadlessException {
            int result = super.showOpenDialog(parent);
            if (result == 0) {
                this.saveCurrentDir();
            }
            return result;
        }

        @Override
        public int showSaveDialog(Component parent) throws HeadlessException {
            int result = this.getApproveButtonText() == null ? super.showSaveDialog(parent) : super.showDialog(parent, this.getApproveButtonText());
            if (result == 0) {
                this.saveCurrentDir();
            }
            return result;
        }

        private void saveCurrentDir() {
            File dir = super.getCurrentDirectory();
            if (dir != null && dir.exists() && dir.isDirectory()) {
                NbPreferences.forModule(FileChooserBuilder.class).put(this.dirKey, dir.getPath());
            }
        }
    }

    public static interface SelectionApprover {
        public boolean approve(File[] var1);
    }
}

