/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.app.ActionClose;
import ancestris.app.ActionProperties;
import ancestris.app.ActionSave;
import ancestris.explorer.EntitiesChildren;
import ancestris.explorer.EntitiesNode;
import ancestris.explorer.ExplorerNode;
import ancestris.explorer.GedcomEntities;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.AUtilities;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

class GedcomFileNode
extends AbstractNode
implements ExplorerNode {
    Context context;
    Action saveAction = null;
    Action propertiesAction = null;
    Action closeAction = null;

    public GedcomFileNode(Gedcom gedcom) {
        super((Children)new EntitiesChildren(gedcom), Lookups.singleton((Object)gedcom));
        this.context = new Context(gedcom);
        this.saveAction = new ActionSave(this.context);
        this.propertiesAction = new ActionProperties(this.context);
        this.closeAction = new ActionClose(this.context);
        this.setDisplayName(gedcom.getDisplayName());
    }

    public PasteType getDropType(Transferable t, final int action, int index) {
        GedcomEntities movie;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (null != dropNode && null != (movie = (GedcomEntities)dropNode.getLookup().lookup(GedcomEntities.class)) && !this.equals(dropNode.getParentNode())) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    GedcomFileNode.this.getChildren().add(new Node[]{new EntitiesNode(GedcomFileNode.this.context.getGedcom(), movie)});
                    if ((action & 2) != 0) {
                        dropNode.getParentNode().getChildren().remove(new Node[]{dropNode});
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        try {
            return (T)GedcomDirectory.getDefault().getDataObject(this.context).getCookie(clazz);
        }
        catch (GedcomDirectory.ContextNotFoundException ex) {
            return null;
        }
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 1, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean isContext) {
        ArrayList<Action> nodeactions = new ArrayList<Action>(8);
        nodeactions.add(this.saveAction);
        nodeactions.add(this.propertiesAction);
        nodeactions.add(this.closeAction);
        nodeactions.addAll(AUtilities.actionsForPath((String)"Ancestris/Actions/GedcomProperty"));
        return nodeactions.toArray(new Action[0]);
    }

    public boolean canDestroy() {
        return true;
    }

    public Image getIcon(int type) {
        return Gedcom.getImage().getImage();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

