/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.api.editor.AncestrisEditor;
import ancestris.app.AppOptions;
import ancestris.app.OptionDataOptionsPanelController;
import ancestris.core.CoreOptions;
import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.util.Lifecycle;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.util.AncestrisPreferences;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

final class OptionDataPanel
extends JPanel {
    private final OptionDataOptionsPanelController controller;
    String[] encodings = Gedcom.ENCODINGS;
    private AncestrisPreferences gedcomPrefs = null;
    private GedcomOptions gedcomOptions = null;
    private DefaultComboBoxModel comboModel = null;
    private List<AncestrisEditor> editors = null;
    private JPanel IDPanel;
    private JCheckBox cbAddAge;
    private JCheckBox cbAutoCommit;
    private JCheckBox cbCreateSpouse;
    private JCheckBox cbDetectDuplicate;
    private JCheckBox cbDuplicateEachTime;
    private JCheckBox cbGivenName;
    private JCheckBox cbNamesInUppercase;
    private JCheckBox cbReuseIDs;
    private JCheckBox cbSameSpouseName;
    private JCheckBox cbSaveEncoding;
    private JCheckBox cbSplitJuridictions;
    private JCheckBox cbUseSpace;
    private JComboBox cboxDefaultEditor;
    private JComboBox cboxEncoding;
    private JPanel editingPanel;
    private JPanel encodingPanel;
    private JSpinner idLength;
    private JScrollPane jScrollPane1;
    private JTextField jtGivenTag;
    private JLabel lCancellations;
    private JLabel lDefaultEditor;
    private JLabel lDefaultIDLength;
    private JLabel lFileEncoding;
    private JPanel mainPanel;
    private JPanel namesPanel;
    private JSpinner nbCancellations;
    private JPanel placePanel;

    OptionDataPanel(OptionDataOptionsPanelController controller) {
        this.controller = controller;
        this.gedcomPrefs = Registry.get(GedcomOptions.class);
        this.gedcomOptions = GedcomOptions.getInstance();
        this.editors = new ArrayList<AncestrisEditor>();
        Indi indi = new Indi();
        for (AncestrisEditor edt : AncestrisEditor.findEditors()) {
            if (!edt.canEdit((Property)indi)) continue;
            this.editors.add(edt);
        }
        AncestrisEditor[] arrayEditors = this.editors.toArray(new AncestrisEditor[this.editors.size()]);
        this.comboModel = new DefaultComboBoxModel<AncestrisEditor>(arrayEditors);
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.namesPanel = new JPanel();
        this.cbNamesInUppercase = new JCheckBox();
        this.cbSameSpouseName = new JCheckBox();
        this.cbGivenName = new JCheckBox();
        this.jtGivenTag = new JTextField();
        this.IDPanel = new JPanel();
        this.cbReuseIDs = new JCheckBox();
        this.lDefaultIDLength = new JLabel();
        this.idLength = new JSpinner();
        this.placePanel = new JPanel();
        this.cbUseSpace = new JCheckBox();
        this.cbSplitJuridictions = new JCheckBox();
        this.encodingPanel = new JPanel();
        this.lFileEncoding = new JLabel();
        this.cboxEncoding = new JComboBox<String>(this.encodings);
        this.cbSaveEncoding = new JCheckBox();
        this.editingPanel = new JPanel();
        this.lDefaultEditor = new JLabel();
        this.cboxDefaultEditor = new JComboBox();
        this.cbAutoCommit = new JCheckBox();
        this.nbCancellations = new JSpinner(new SpinnerNumberModel(10, 10, 300, 5));
        this.lCancellations = new JLabel();
        this.cbCreateSpouse = new JCheckBox();
        this.cbDetectDuplicate = new JCheckBox();
        this.cbDuplicateEachTime = new JCheckBox();
        this.cbAddAge = new JCheckBox();
        this.setRequestFocusEnabled(false);
        this.mainPanel.setPreferredSize(new Dimension(582, 384));
        this.namesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.namesPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbNamesInUppercase, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbNamesInUppercase.text"));
        this.cbNamesInUppercase.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbNamesInUppercase.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSameSpouseName, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSameSpouseName.text"));
        this.cbSameSpouseName.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSameSpouseName.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbGivenName, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbGivenName.text"));
        this.cbGivenName.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbGivenName.toolTipText"));
        this.cbGivenName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDataPanel.this.cbGivenNameActionPerformed(evt);
            }
        });
        this.jtGivenTag.setText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.jtGivenTag.text"));
        this.jtGivenTag.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.jtGivenTag.toolTipText"));
        this.jtGivenTag.setMinimumSize(new Dimension(64, 23));
        GroupLayout namesPanelLayout = new GroupLayout(this.namesPanel);
        this.namesPanel.setLayout(namesPanelLayout);
        namesPanelLayout.setHorizontalGroup(namesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(namesPanelLayout.createSequentialGroup().addContainerGap().addGroup(namesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNamesInUppercase).addComponent(this.cbSameSpouseName).addGroup(namesPanelLayout.createSequentialGroup().addComponent(this.cbGivenName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jtGivenTag, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        namesPanelLayout.setVerticalGroup(namesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(namesPanelLayout.createSequentialGroup().addComponent(this.cbNamesInUppercase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSameSpouseName).addGap(3, 3, 3).addGroup(namesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbGivenName).addComponent(this.jtGivenTag, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.IDPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.IDPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuseIDs, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbReuseIDs.text"));
        this.cbReuseIDs.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbReuseIDs.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lDefaultIDLength, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultIDLength.text"));
        this.lDefaultIDLength.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultIDLength.toolTipText"));
        this.idLength.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.idLength.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.idLength.toolTipText"));
        GroupLayout IDPanelLayout = new GroupLayout(this.IDPanel);
        this.IDPanel.setLayout(IDPanelLayout);
        IDPanelLayout.setHorizontalGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(IDPanelLayout.createSequentialGroup().addContainerGap().addGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(IDPanelLayout.createSequentialGroup().addComponent(this.cbReuseIDs).addGap(0, 39, Short.MAX_VALUE)).addGroup(IDPanelLayout.createSequentialGroup().addComponent(this.lDefaultIDLength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.idLength))).addContainerGap()));
        IDPanelLayout.setVerticalGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(IDPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbReuseIDs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lDefaultIDLength).addComponent(this.idLength, -2, -1, -2)).addContainerGap()));
        this.placePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.placePanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbUseSpace, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbUseSpace.text"));
        this.cbUseSpace.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbUseSpace.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSplitJuridictions, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSplitJuridictions.text"));
        this.cbSplitJuridictions.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSplitJuridictions.toolTipText"));
        GroupLayout placePanelLayout = new GroupLayout(this.placePanel);
        this.placePanel.setLayout(placePanelLayout);
        placePanelLayout.setHorizontalGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(placePanelLayout.createSequentialGroup().addContainerGap().addGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbUseSpace, -1, 309, Short.MAX_VALUE).addComponent(this.cbSplitJuridictions, -1, -1, Short.MAX_VALUE))));
        placePanelLayout.setVerticalGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(placePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbUseSpace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSplitJuridictions).addContainerGap(-1, Short.MAX_VALUE)));
        this.encodingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.encodingPanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.lFileEncoding, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lFileEncoding.text"));
        this.lFileEncoding.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lFileEncoding.toolTipText"));
        this.cboxEncoding.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cboxEncoding.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSaveEncoding, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSaveEncoding.text"));
        this.cbSaveEncoding.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSaveEncoding.toolTipText"));
        GroupLayout encodingPanelLayout = new GroupLayout(this.encodingPanel);
        this.encodingPanel.setLayout(encodingPanelLayout);
        encodingPanelLayout.setHorizontalGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingPanelLayout.createSequentialGroup().addContainerGap().addGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingPanelLayout.createSequentialGroup().addComponent(this.lFileEncoding).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboxEncoding, 0, -1, Short.MAX_VALUE)).addGroup(encodingPanelLayout.createSequentialGroup().addComponent(this.cbSaveEncoding).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        encodingPanelLayout.setVerticalGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingPanelLayout.createSequentialGroup().addContainerGap().addGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lFileEncoding).addComponent(this.cboxEncoding, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSaveEncoding).addContainerGap(11, Short.MAX_VALUE)));
        this.editingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.editingPanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.lDefaultEditor, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultEditor.text"));
        this.lDefaultEditor.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultEditor.toolTipText"));
        this.cboxDefaultEditor.setModel(this.comboModel);
        this.cboxDefaultEditor.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cboxDefaultEditor.toolTipText"));
        this.cboxDefaultEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDataPanel.this.cboxDefaultEditorActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbAutoCommit, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbAutoCommit.text"));
        this.cbAutoCommit.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbAutoCommit.toolTipText"));
        this.cbAutoCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDataPanel.this.cbAutoCommitActionPerformed(evt);
            }
        });
        this.nbCancellations.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.nbCancellations.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lCancellations, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lCancellations.text"));
        this.lCancellations.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lCancellations.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCreateSpouse, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbCreateSpouse.text_1"));
        this.cbCreateSpouse.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbCreateSpouse.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDetectDuplicate, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbDetectDuplicate.text"));
        this.cbDetectDuplicate.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbDetectDuplicate.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDuplicateEachTime, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbDuplicateEachTime.text"));
        this.cbDuplicateEachTime.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbDuplicateEachTime.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAddAge, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbAddAge.text"));
        GroupLayout editingPanelLayout = new GroupLayout(this.editingPanel);
        this.editingPanel.setLayout(editingPanelLayout);
        editingPanelLayout.setHorizontalGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingPanelLayout.createSequentialGroup().addContainerGap().addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingPanelLayout.createSequentialGroup().addComponent(this.lDefaultEditor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboxDefaultEditor, 0, -1, Short.MAX_VALUE)).addGroup(editingPanelLayout.createSequentialGroup().addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbAutoCommit).addGroup(editingPanelLayout.createSequentialGroup().addComponent(this.nbCancellations, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lCancellations)).addComponent(this.cbCreateSpouse).addComponent(this.cbDuplicateEachTime).addComponent(this.cbDetectDuplicate).addComponent(this.cbAddAge)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        editingPanelLayout.setVerticalGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingPanelLayout.createSequentialGroup().addContainerGap().addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lDefaultEditor).addComponent(this.cboxDefaultEditor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAutoCommit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nbCancellations, -2, -1, -2).addComponent(this.lCancellations)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCreateSpouse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAddAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDuplicateEachTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDetectDuplicate).addContainerGap(11, Short.MAX_VALUE)));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editingPanel, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.namesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.placePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encodingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.IDPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.namesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.placePanel, -2, -1, -2)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.IDPanel, -2, -1, -2).addGap(10, 10, 10).addComponent(this.encodingPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editingPanel, -2, -1, -2).addGap(105, 105, 105)));
        this.namesPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.namesPanel.AccessibleContext.accessibleName"));
        this.IDPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.IDPanel.AccessibleContext.accessibleName"));
        this.placePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.placePanel.AccessibleContext.accessibleName"));
        this.encodingPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.encodingPanel.AccessibleContext.accessibleName"));
        this.jScrollPane1.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 655, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 442, Short.MAX_VALUE).addContainerGap()));
    }

    private void cbAutoCommitActionPerformed(ActionEvent evt) {
    }

    private void cboxDefaultEditorActionPerformed(ActionEvent evt) {
    }

    private void cbGivenNameActionPerformed(ActionEvent evt) {
        this.jtGivenTag.setEnabled(this.cbGivenName.isSelected());
    }

    void load() {
        this.cbNamesInUppercase.setSelected(this.gedcomOptions.isUpperCaseNames());
        this.cbGivenName.setSelected(!this.gedcomOptions.getGivenTag().isEmpty());
        this.jtGivenTag.setText(this.gedcomOptions.getGivenTag());
        this.cbGivenNameActionPerformed(new ActionEvent(this, 0, null));
        this.setNamesSpouse(this.gedcomPrefs.get("setWifeLastname", ""));
        this.setIDFilling(this.gedcomPrefs.get("isFillGapsInIDs", ""));
        this.idLength.setValue(this.gedcomOptions.getEntityIdLength());
        this.cbUseSpace.setSelected(this.gedcomOptions.isUseSpacedPlaces());
        this.cbSplitJuridictions.setSelected(CoreOptions.getInstance().isSplitJurisdictions());
        this.setEncoding(this.gedcomPrefs.get("defaultEncoding", ""));
        this.cbSaveEncoding.setSelected(AppOptions.isWriteBOM());
        this.cbSaveEncoding.setVisible(false);
        this.cboxDefaultEditor.setSelectedItem(this.getEditorFromCanonicalName(this.gedcomOptions.getDefaultEditor()));
        this.cbAutoCommit.setSelected(ConfirmChangeWidget.getAutoCommit());
        this.nbCancellations.setValue(this.gedcomOptions.getNumberOfUndos());
        this.cbCreateSpouse.setSelected(this.gedcomOptions.getCreateSpouse());
        this.cbAddAge.setSelected(this.gedcomOptions.isAddAge());
        this.cbDetectDuplicate.setVisible(false);
        this.cbDetectDuplicate.setSelected(this.gedcomOptions.getDetectDuplicate());
        this.cbDuplicateEachTime.setSelected(this.gedcomOptions.getDuplicateAnyTime());
    }

    void store() {
        this.gedcomOptions.setUpperCaseNames(this.cbNamesInUppercase.isSelected());
        this.gedcomOptions.setGivenTag(this.cbGivenName.isSelected() ? this.jtGivenTag.getText().trim() : "");
        this.gedcomPrefs.put("setWifeLastname", this.getNamesSpouse());
        this.gedcomPrefs.put("isFillGapsInIDs", this.getIdFilling());
        this.gedcomOptions.setEntityIdLength(Integer.valueOf(this.idLength.getValue().toString()).intValue());
        if (this.cbUseSpace.isSelected() != this.gedcomOptions.isUseSpacedPlaces()) {
            Lifecycle.askForRestart();
            this.gedcomOptions.setUseSpacedPlaces(this.cbUseSpace.isSelected());
        }
        CoreOptions.getInstance().setSplitJurisdictions(this.cbSplitJuridictions.isSelected());
        this.gedcomPrefs.put("defaultEncoding", this.getEncoding());
        AppOptions.setWriteBOM(this.cbSaveEncoding.isSelected());
        this.gedcomOptions.setDefaultEditor(((AncestrisEditor)this.cboxDefaultEditor.getSelectedItem()).getName(true));
        ConfirmChangeWidget.setAutoCommit((boolean)this.cbAutoCommit.isSelected());
        this.gedcomOptions.setNumberOfUndos(((Integer)this.nbCancellations.getValue()).intValue());
        this.gedcomOptions.setCreateSpouse(this.cbCreateSpouse.isSelected());
        this.gedcomOptions.setAddAge(this.cbAddAge.isSelected());
        this.gedcomOptions.setDetectDuplicate(this.cbDetectDuplicate.isSelected());
        this.gedcomOptions.setDuplicateAnyTime(this.cbDuplicateEachTime.isSelected());
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionPanel.saved.statustext"));
    }

    public boolean valid() {
        return true;
    }

    void setNamesSpouse(String str) {
        this.cbSameSpouseName.setSelected(str.equals("true"));
    }

    String getNamesSpouse() {
        return this.cbSameSpouseName.isSelected() ? "true" : "false";
    }

    void setIDFilling(String str) {
        if (str.equals("")) {
            str = "true";
        }
        this.cbReuseIDs.setSelected(str.equals("true"));
    }

    String getIdFilling() {
        return this.cbReuseIDs.isSelected() ? "true" : "false";
    }

    void setEncoding(String str) {
        Integer i;
        if (str.equals("-1")) {
            str = "0";
        }
        if ((i = this.getIntFromStr(str)) == -1) {
            i = 0;
        }
        if (i > this.encodings.length) {
            i = this.encodings.length;
        }
        this.cboxEncoding.setSelectedIndex(i);
    }

    String getEncoding() {
        return this.cboxEncoding.getSelectedIndex() + "";
    }

    private Integer getIntFromStr(String str) {
        Integer i = 0;
        try {
            i = Integer.valueOf(str);
        }
        catch (Exception e) {
            i = -1;
        }
        return i;
    }

    private AncestrisEditor getEditorFromCanonicalName(String defaultEditor) {
        for (AncestrisEditor edt : this.editors) {
            if (!edt.getName(true).startsWith(defaultEditor)) continue;
            return edt;
        }
        return this.editors != null ? this.editors.get(0) : null;
    }
}

