/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import ancestris.api.editor.Editor;
import genj.edit.BeanPanel;
import genj.edit.EditView;
import genj.edit.actions.EditNote;
import genj.edit.actions.EditSource;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

class BasicEditor
extends Editor {
    static final Registry REGISTRY = Registry.get(BasicEditor.class);
    private Gedcom gedcom = null;
    private Entity currentEntity = null;
    private EditView view;
    private BeanPanel beanPanel;
    private boolean isIgnoreSetContext = false;

    public BasicEditor(Gedcom gedcom, EditView edit) {
        this.gedcom = gedcom;
        this.view = edit;
        this.beanPanel = new BeanPanel();
        this.beanPanel.addChangeListener((ChangeListener)this.changes);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.beanPanel));
    }

    public Component getEditorComponent() {
        return this.beanPanel;
    }

    public ViewContext getContext() {
        PropertyBean bean = this.getFocus();
        if (bean != null && bean.getContext() != null) {
            return bean.getContext();
        }
        if (this.currentEntity != null) {
            return new ViewContext(this.currentEntity);
        }
        return new ViewContext(this.gedcom);
    }

    protected void setContextImpl(Context context) {
        if (this.isIgnoreSetContext) {
            return;
        }
        this.actions.clear();
        if (context.getGedcom() == null) {
            this.setEntity(null, null);
            return;
        }
        if (this.changes.hasChanged() || this.currentEntity != context.getEntity()) {
            this.setEntity(context.getEntity(), context.getProperty());
        } else if (this.beanPanel != null && this.view.isGrabFocus()) {
            if (context.getProperties().size() == 1) {
                this.beanPanel.select(context.getProperty());
            } else if (context.getProperties().isEmpty() && context.getEntities().size() == 1) {
                this.beanPanel.select((Property)context.getEntity());
            }
        }
        this.actions.addAll(this.beanPanel.getActions());
    }

    public void commit() throws GedcomException {
        Property focus;
        try {
            this.isIgnoreSetContext = true;
            this.beanPanel.commit();
        }
        finally {
            this.isIgnoreSetContext = false;
        }
        PropertyBean focussedBean = this.getFocus();
        Property property = focus = focussedBean != null ? focussedBean.getProperty() : null;
        if (this.view.isGrabFocus()) {
            this.beanPanel.select(focus);
        }
    }

    public void setEntity(Entity set, Property focus) {
        this.currentEntity = set;
        if (focus == null) {
            PropertyBean bean = this.getFocus();
            if (bean != null && bean.getProperty() != null && bean.getProperty().getEntity() == this.currentEntity) {
                focus = bean.getProperty();
            }
            if (focus == null) {
                focus = this.currentEntity;
            }
        }
        this.beanPanel.setRoot((Property)this.currentEntity);
        if (this.currentEntity != null && this.currentEntity.getMetaProperty().allows("NOTE")) {
            this.actions.add(new EditNote((Property)this.currentEntity));
        }
        if (this.currentEntity != null && this.currentEntity.getMetaProperty().allows("SOUR")) {
            this.actions.add(new EditSource((Property)this.currentEntity));
        }
        if (focus != null && this.view.isGrabFocus()) {
            this.beanPanel.select(focus);
        }
        this.changes.setChanged(false);
    }

    private PropertyBean getFocus() {
        Component focus;
        for (focus = FocusManager.getCurrentManager().getFocusOwner(); focus != null && !(focus instanceof PropertyBean); focus = focus.getParent()) {
        }
        if (focus == null) {
            return null;
        }
        return SwingUtilities.isDescendingFrom(focus, (Component)((Object)this)) ? (PropertyBean)focus : null;
    }

    public Entity getEditedEntity() {
        return this.currentEntity;
    }
}

