/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.geneanet.utils;

import ancestris.modules.exports.geneanet.entity.GeneanetMedia;
import ancestris.modules.exports.geneanet.entity.GeneanetParserResult;
import ancestris.modules.exports.geneanet.entity.GeneanetStepEnum;
import ancestris.modules.exports.geneanet.entity.GeneanetToken;
import ancestris.modules.exports.geneanet.entity.GeneanetUpdateStatus;
import ancestris.modules.exports.geneanet.entity.GenenaetIndiId;
import ancestris.modules.exports.geneanet.utils.GeneanetException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

public class GeneanetUtil {
    private static final String GENEANET_API = "https://api.geneanet.org";
    private static final String GENEANET_TOKEN = "https://api.geneanet.org/oauth/v2/token";
    private static final String GENEANET_USER_INFO = "https://api.geneanet.org/media/user";
    private static final String GENEANET_UPLOAD = "https://api.geneanet.org/geneweb/tree/upload";
    private static final String GENEANET_STATUS = "https://api.geneanet.org/geneweb/tree/lock/status";
    private static final String GENEANET_MEDIA_PARSER = "https://api.geneanet.org/geneweb/gedcom/media-parser";
    private static final String GENEANET_DEPOSIT = "https://api.geneanet.org/media/deposits";
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);

    private GeneanetUtil() {
    }

    public static GeneanetToken getToken(String id, String pwd, String clientId, String secret) throws GeneanetException {
        JSONObject body = new JSONObject();
        body.put("username", (Object)id);
        body.put("password", (Object)pwd);
        body.put("grant_type", (Object)"password");
        body.put("client_id", (Object)clientId);
        body.put("client_secret", (Object)secret);
        JSONObject jToken = GeneanetUtil.post(GENEANET_TOKEN, (HttpEntity)new StringEntity(body.toString(), ContentType.APPLICATION_JSON), null, "token.error.message");
        GeneanetToken retour = new GeneanetToken(jToken.getString("access_token"), new Date(), clientId, secret);
        retour.setRefreshToken(jToken.getString("refresh_token"));
        return retour;
    }

    public static boolean getUserInfo(GeneanetToken token) throws GeneanetException {
        GeneanetUtil.checkRefreshToken(token);
        JSONObject userInfo = GeneanetUtil.get(GENEANET_USER_INFO, new ArrayList<NameValuePair>(), token.getToken(), "userinfo.error.message");
        JSONObject user = userInfo.getJSONObject("user");
        return user.getBoolean("tree");
    }

    public static void sendFile(GeneanetToken token, File file) throws GeneanetException {
        GeneanetUtil.checkRefreshToken(token);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("file", file, ContentType.APPLICATION_OCTET_STREAM, file.getName()).build();
        try {
            JSONObject jSONObject = GeneanetUtil.post(GENEANET_UPLOAD, reqEntity, token.getToken(), "tree.error.message");
        }
        catch (GeneanetException e) {
            JSONObject errorMessage = new JSONObject(e.getGeneanetError());
            if ("Base is locked.".equals(errorMessage.getString("msg"))) {
                GeneanetUtil.getStatus(token);
                JSONObject jSONObject = GeneanetUtil.post(GENEANET_UPLOAD, reqEntity, token.getToken(), "tree.error.message");
            }
            throw e;
        }
    }

    public static GeneanetUpdateStatus getStatus(GeneanetToken token) throws GeneanetException {
        GeneanetUtil.checkRefreshToken(token);
        ArrayList<NameValuePair> param = new ArrayList<NameValuePair>(1);
        param.add((NameValuePair)new BasicNameValuePair("release", "true"));
        JSONObject status = GeneanetUtil.get(GENEANET_STATUS, param, token.getToken(), "status.error.message");
        String statu = status.getString("status");
        String action = status.getString("action");
        String step = status.optString("step", GeneanetStepEnum.PREPARE.getStepName());
        return new GeneanetUpdateStatus(statu, action, step);
    }

    public static GeneanetParserResult getMediaStatus(GeneanetToken token) throws GeneanetException {
        GeneanetUtil.checkRefreshToken(token);
        JSONObject status = GeneanetUtil.get(GENEANET_MEDIA_PARSER, new ArrayList<NameValuePair>(), token.getToken(), "media.status.error.message");
        GeneanetParserResult pResult = new GeneanetParserResult(status.getInt("nb_media"), status.getInt("nb_ind"));
        JSONObject okMedia = status.getJSONObject("media");
        Set keys = okMedia.keySet();
        for (String key : keys) {
            JSONArray ids = okMedia.getJSONArray(key);
            ArrayList<GenenaetIndiId> lIds = new ArrayList<GenenaetIndiId>();
            for (int j = 0; j < ids.length(); ++j) {
                lIds.add(new GenenaetIndiId(ids.getString(j)));
            }
            pResult.addOkMedia(new GeneanetMedia(key, lIds));
        }
        JSONArray koMedia = status.getJSONArray("error");
        for (int i = 0; i < koMedia.length(); ++i) {
            pResult.addKoMedia(koMedia.getString(i));
        }
        return pResult;
    }

    public static void sendMedia(GeneanetToken token, GeneanetMedia media) throws GeneanetException {
        GeneanetUtil.checkRefreshToken(token);
        MultipartEntityBuilder meb = MultipartEntityBuilder.create().setCharset(Charset.forName("UTF-8"));
        meb.addTextBody("deposit[type]", media.getType().getType()).addTextBody("deposit[private]", String.valueOf(media.getPrive()));
        String title = media.getTitle();
        if (title == null) {
            title = media.getFichier().getName();
        }
        if (title.length() > 100) {
            title = title.substring(title.length() - 99);
        }
        meb.addTextBody("deposit[title]", title, ContentType.create((String)"text/plain", (String)"UTF-8"));
        ContentType content = GeneanetUtil.getContentType(media.getForm());
        HttpEntity reqEntity = meb.addBinaryBody("deposit[views][][uploadedFile]", media.getFichier(), content, media.getFichier().getName()).build();
        JSONObject retour = GeneanetUtil.post(GENEANET_DEPOSIT, reqEntity, token.getToken(), "media.deposit.error");
        media.setDepositId(String.valueOf(retour.getLong("id")));
        JSONArray views = retour.getJSONArray("views");
        if (views.length() > 0) {
            JSONObject view = views.getJSONObject(0);
            media.setViewsId(String.valueOf(view.getLong("id")));
        }
    }

    private static ContentType getContentType(String form) {
        if (form == null) {
            return ContentType.APPLICATION_OCTET_STREAM;
        }
        String uppercase = form.toUpperCase();
        if ("PDF".equals(uppercase)) {
            return ContentType.create((String)"application/pdf");
        }
        if ("JPG".equals(uppercase) || "JPEG".equals(uppercase)) {
            return ContentType.IMAGE_JPEG;
        }
        if ("PNG".equals(uppercase)) {
            return ContentType.IMAGE_PNG;
        }
        if ("BMP".equals(uppercase)) {
            return ContentType.IMAGE_BMP;
        }
        if ("GIF".equals(uppercase)) {
            return ContentType.IMAGE_GIF;
        }
        return ContentType.APPLICATION_OCTET_STREAM;
    }

    public static void referenceMedia(GeneanetToken token, GeneanetMedia media) throws GeneanetException {
        GeneanetUtil.checkRefreshToken(token);
        for (GenenaetIndiId idGedcom : media.getIds()) {
            JSONObject body = new JSONObject();
            body.put("id_gedcom", (Object)idGedcom.getId());
            JSONObject jSONObject = GeneanetUtil.post("https://api.geneanet.org/media/deposits/" + media.getDepositId() + "/views/" + media.getViewsId() + "/references", (HttpEntity)new StringEntity(body.toString(), ContentType.APPLICATION_JSON), token.getToken(), "reference.error.message");
        }
    }

    private static void checkRefreshToken(GeneanetToken token) throws GeneanetException {
        if (token.isExpired()) {
            JSONObject body = new JSONObject();
            body.put("refresh_token", (Object)token.getRefreshToken());
            body.put("grant_type", (Object)"refresh_token");
            body.put("client_id", (Object)token.getClientId());
            body.put("client_secret", (Object)token.getSecretId());
            JSONObject jToken = GeneanetUtil.post(GENEANET_TOKEN, (HttpEntity)new StringEntity(body.toString(), ContentType.APPLICATION_JSON), null, "token.error.message");
            token.setToken(jToken.getString("access_token"));
            token.setRefreshToken(jToken.getString("refresh_token"));
            token.setBeginning(new Date());
        }
    }

    /*
     * Exception decompiling
     */
    private static JSONObject post(String url, HttpEntity body, String leToken, String errorMessage) throws GeneanetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static JSONObject get(String url, List<NameValuePair> parameters, String leToken, String errorMessage) throws GeneanetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

