/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.tree.Model;
import genj.tree.TreeArc;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import gj.awt.geom.Path;
import gj.layout.tree.Branch;
import gj.layout.tree.Orientation;
import gj.model.Node;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class Parser {
    protected Model model;
    protected TreeMetrics metrics;
    protected Path shapeMarrs;
    protected Path shapePlus;
    protected Path shapeMinus;
    protected Path shapeNext;
    protected Path shapeIndis;
    protected Path shapeIndisSquared;
    protected Path shapeIndisRounded;
    protected Path shapeFams;
    protected Path shapeFamsSquared;
    protected Path shapeFamsRounded;
    protected int[] padIndis;
    protected int[] padMinusPlus;
    protected int[] padMarrs;

    public static Parser getInstance(boolean ancestors, boolean families, Model model, TreeMetrics metrics) {
        if (ancestors) {
            if (families) {
                return new AncestorsWithFams(model, metrics);
            }
            return new AncestorsNoFams(model, metrics);
        }
        if (families) {
            return new DescendantsWithFams(model, metrics);
        }
        return new DescendantsNoFams(model, metrics);
    }

    protected Parser(Model mOdel, TreeMetrics mEtrics) {
        this.model = mOdel;
        this.metrics = mEtrics;
        this.initEntityShapes();
        this.initFoldUnfoldShapes();
        this.initMarrShapes();
        this.initNextFamShapes();
        this.shapeIndis = this.model.isRoundedRectangle() ? this.shapeIndisRounded : this.shapeIndisSquared;
        this.shapeFams = this.model.isRoundedRectangle() ? this.shapeFamsRounded : this.shapeFamsSquared;
    }

    public final TreeNode parse(Entity root) {
        return root instanceof Indi ? this.parse((Indi)root) : this.parse((Fam)root);
    }

    public TreeNode align(TreeNode other) {
        return other;
    }

    protected abstract TreeNode parse(Indi var1);

    protected abstract TreeNode parse(Fam var1);

    private void initEntityShapes() {
        this.padIndis = new int[]{(this.metrics.pad + 1) / 2, (this.metrics.pad + 1) / 2, (this.metrics.pad + 1) / 2, (this.metrics.pad + 1) / 2};
        this.shapeIndisSquared = new Path().append((Shape)new Rectangle2D.Double(-this.metrics.wIndis / 2, -this.metrics.hIndis / 2, this.metrics.wIndis, this.metrics.hIndis));
        this.shapeIndisRounded = new Path().append((Shape)new RoundRectangle2D.Double(-this.metrics.wIndis / 2, -this.metrics.hIndis / 2, this.metrics.wIndis, this.metrics.hIndis, 5.0, 5.0));
        this.shapeFamsSquared = new Path().append((Shape)new Rectangle2D.Double(-this.metrics.wFams / 2, -this.metrics.hFams / 2, this.metrics.wFams, this.metrics.hFams));
        this.shapeFamsRounded = new Path().append((Shape)new RoundRectangle2D.Double(-this.metrics.wFams / 2, -this.metrics.hFams / 2, this.metrics.wFams, this.metrics.hFams, 5.0, 5.0));
    }

    private void initFoldUnfoldShapes() {
        int pi = (this.model.getMetrics().indisThick + 1) / 4;
        this.padMinusPlus = new int[]{-this.padIndis[0] + pi, 1, 1, this.padIndis[3] - pi};
        double d = 8.0;
        this.shapePlus = new Path();
        this.shapePlus.moveTo((Point2D)new Point2D.Double(0.0, -d * 0.3));
        this.shapePlus.lineTo((Point2D)new Point2D.Double(0.0, d * 0.3));
        this.shapePlus.moveTo((Point2D)new Point2D.Double(-d * 0.3, 0.0));
        this.shapePlus.lineTo((Point2D)new Point2D.Double(d * 0.3, 0.0));
        this.shapePlus.append((Shape)new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
        this.shapeMinus = new Path();
        this.shapeMinus.moveTo((Point2D)new Point2D.Double(-d * 0.3, 0.0));
        this.shapeMinus.lineTo((Point2D)new Point2D.Double(d * 0.3, 0.0));
        this.shapeMinus.append((Shape)new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
    }

    private void initMarrShapes() {
        this.shapeMarrs = new Path();
        int d = Math.min(this.metrics.wIndis / 4, this.metrics.hIndis / 4);
        if (!this.model.isMarrSymbols()) {
            this.shapeMarrs.append((Shape)new Rectangle2D.Double((float)(-(d /= 4)) * 0.3f, (float)(-d) * 0.3f, (float)d * 0.6f, (float)d * 0.6f));
        } else {
            Ellipse2D.Float e = new Ellipse2D.Float((float)(-d) * 0.3f, (float)(-d) * 0.3f, (float)d * 0.6f, (float)d * 0.6f);
            float dx = this.model.isVertical() ? (float)d * 0.2f : (float)d * 0.0f;
            float dy = this.model.isVertical() ? (float)d * 0.0f : (float)d * 0.2f;
            AffineTransform at1 = AffineTransform.getTranslateInstance(-dx, -dy);
            AffineTransform at2 = AffineTransform.getTranslateInstance(dx, dy);
            this.shapeMarrs.append(e.getPathIterator(at1));
            this.shapeMarrs.append(e.getPathIterator(at2));
        }
        int t = (this.model.getMetrics().indisThick + 1) / 2;
        int l = this.model.isVertical() ? this.metrics.hIndis / 2 : this.metrics.wIndis / 2;
        this.padMarrs = new int[]{this.padIndis[0] + l - (int)((float)d * 0.3f), t, t, 0};
    }

    private void initNextFamShapes() {
        double h;
        double w;
        double d;
        this.shapeNext = new Path();
        Path tmpShape = new Path();
        if (this.model.isVertical()) {
            d = Math.max((double)this.metrics.hIndis / 12.0, (double)0.2f);
            w = Math.min(2.0 * d, (double)this.metrics.wIndis / 2.0);
            h = 4.0 * d;
        } else {
            d = Math.max((double)this.metrics.wIndis / 12.0, (double)0.2f);
            w = Math.min(2.0 * d, (double)this.metrics.hIndis / 4.0);
            h = 4.0 * d;
        }
        tmpShape = new Path();
        tmpShape.moveTo((Point2D)new Point2D.Double(0.0, 0.0));
        tmpShape.lineTo((Point2D)new Point2D.Double(w / 2.0, 0.0));
        tmpShape.curveTo((Point2D)new Point2D.Double(w, 0.0), (Point2D)new Point2D.Double(w, 0.0), (Point2D)new Point2D.Double(w, d));
        tmpShape.lineTo((Point2D)new Point2D.Double(w, h));
        tmpShape.curveTo((Point2D)new Point2D.Double(w, h + d), (Point2D)new Point2D.Double(w, h + d), (Point2D)new Point2D.Double(w / 2.0, h + d));
        tmpShape.lineTo((Point2D)new Point2D.Double(0.0, h + d));
        tmpShape.moveTo((Point2D)new Point2D.Double(w / 4.0, (h + d) / 2.0));
        tmpShape.lineTo((Point2D)new Point2D.Double(3.0 * w / 4.0, (h + d) / 2.0));
        tmpShape.moveTo((Point2D)new Point2D.Double(w / 2.0, h / 2.0));
        tmpShape.lineTo((Point2D)new Point2D.Double(w / 2.0, h / 2.0 + d));
        if (this.model.isVertical()) {
            this.shapeNext.append((Shape)tmpShape);
        } else {
            AffineTransform tx = new AffineTransform();
            tx.rotate(4.71238899230957);
            this.shapeNext.append(tx.createTransformedShape((Shape)tmpShape));
        }
    }

    protected TreeNode insertPlusMinus(Indi indi, TreeNode parent, boolean ancestors, boolean plus) {
        if (!this.model.isFoldSymbols()) {
            return parent;
        }
        Model model = this.model;
        model.getClass();
        TreeNode node = this.model.add(new TreeNode(model.new Model.FoldUnfold(indi, ancestors), (Shape)(plus ? this.shapePlus : this.shapeMinus), this.padMinusPlus));
        this.model.add(new TreeArc(parent, node, false));
        return node;
    }

    private static class DescendantsWithFams
    extends Parser {
        private TreeNode origin;
        private int[] padFams;
        private int[] padHusband;
        private int[] padWife;
        private int[] padNext;
        private int offsetHusband;

        protected DescendantsWithFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
            this.padHusband = new int[]{this.padIndis[0], this.padIndis[1], 0, this.padIndis[3]};
            this.padWife = new int[]{this.padIndis[0], 0, this.padIndis[2], 0};
            this.padFams = new int[]{-((int)((double)metrics.pad * 0.4)), this.padIndis[1], this.padIndis[2], this.padIndis[3]};
            int pf = (model.getMetrics().famsThick + 1) / 2;
            this.padMinusPlus = new int[]{-this.padIndis[0] + pf, 1, 1, this.padIndis[3]};
            if (model.isVertical()) {
                this.padNext = new int[]{this.padIndis[0] + metrics.hIndis / 2 - (int)(this.shapeNext.getBounds2D().getHeight() / 2.0), -this.padIndis[1], 0, 0};
                this.offsetHusband = -(metrics.wIndis + this.shapeMarrs.getBounds().width + model.getMetrics().indisThick / 2) / 2;
            } else {
                this.padNext = new int[]{this.padIndis[0] + metrics.wIndis / 2 - (int)(this.shapeNext.getBounds2D().getWidth() / 2.0), -this.padIndis[1], 0, 0};
                this.offsetHusband = -(metrics.hIndis + this.shapeMarrs.getBounds().height + model.getMetrics().indisThick / 2) / 2;
            }
        }

        @Override
        public TreeNode align(TreeNode other) {
            other.getPosition().setLocation(this.origin.getPosition());
            return other;
        }

        @Override
        protected TreeNode parse(Indi indi) {
            TreeNode nPivot = this.model.add(new TreeNode(null, null, null));
            this.origin = this.parse(indi, nPivot, 0);
            return nPivot;
        }

        @Override
        protected TreeNode parse(Fam fam) {
            TreeNode nFam = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padIndis));
            Indi[] children = fam.getChildren();
            if (!this.model.isVertical()) {
                List<Indi> childrenList = Arrays.asList(children);
                Collections.reverse(childrenList);
                children = childrenList.toArray(new Indi[0]);
            }
            for (int c = 0; c < children.length; ++c) {
                this.parse(children[c], nFam, 0);
            }
            this.origin = nFam;
            return nFam;
        }

        private TreeNode parse(Indi indi, TreeNode pivot, int generation) {
            Fam[] fams = indi.getFamiliesWhereSpouse();
            if (fams.length == 0) {
                TreeNode nIndi = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
                this.model.add(new TreeArc(pivot, nIndi, pivot.getShape() != null));
                return nIndi;
            }
            Fam fam = this.model.getFamily(indi, fams, false);
            TreeNode nIndi = null;
            TreeNode nSpouse = null;
            TreeNode nNext = null;
            TreeNode nMarr = null;
            TreeNode nFam = null;
            if (this.model.isVertical()) {
                nIndi = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padHusband){

                    @Override
                    public int getLongitude(Node node, Branch[] children, Orientation o) {
                        return super.getLongitude(node, children, o) + offsetHusband;
                    }
                });
                nSpouse = this.model.add(new TreeNode(fam.getOtherSpouse(indi), (Shape)this.shapeIndis, this.padWife));
            } else {
                nIndi = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padWife));
                nSpouse = this.model.add(new TreeNode(fam.getOtherSpouse(indi), (Shape)this.shapeIndis, this.padHusband){

                    @Override
                    public int getLongitude(Node node, Branch[] children, Orientation o) {
                        return super.getLongitude(node, children, o) + offsetHusband;
                    }
                });
            }
            if (fams.length > 1 && this.model.isFoldSymbols()) {
                Model model = this.model;
                model.getClass();
                nNext = this.model.add(new TreeNode(model.new Model.NextFamily(indi, fams), (Shape)this.shapeNext, this.padNext));
            }
            nMarr = this.model.add(new TreeNode(null, (Shape)this.shapeMarrs, this.padMarrs));
            nFam = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padFams));
            if (this.model.isVertical()) {
                this.model.add(new TreeArc(pivot, nIndi, pivot.getShape() != null));
                this.model.add(new TreeArc(pivot, nMarr, false));
                this.model.add(new TreeArc(pivot, nSpouse, false));
                if (nNext != null) {
                    this.model.add(new TreeArc(pivot, nNext, false));
                }
                this.model.add(new TreeArc(nIndi, nFam, false));
            } else {
                this.model.add(new TreeArc(pivot, nSpouse, false));
                this.model.add(new TreeArc(pivot, nMarr, false));
                this.model.add(new TreeArc(pivot, nIndi, pivot.getShape() != null));
                this.model.add(new TreeArc(nSpouse, nFam, false));
                if (nNext != null) {
                    this.model.add(new TreeArc(pivot, nNext, false));
                }
            }
            Indi[] children = fam.getChildren();
            if (!this.model.isVertical()) {
                List<Indi> childrenList = Arrays.asList(children);
                Collections.reverse(childrenList);
                children = childrenList.toArray(new Indi[0]);
            }
            for (int c = 0; c < children.length; ++c) {
                if (c == 0) {
                    if (generation >= this.model.getMaxGenerations() || this.model.isHideDescendants(indi)) {
                        this.insertPlusMinus(indi, nFam, false, true);
                        break;
                    }
                    nFam = this.insertPlusMinus(indi, nFam, false, false);
                }
                this.parse(children[c], nFam, generation + 1);
            }
            return nIndi;
        }
    }

    private static class DescendantsNoFams
    extends Parser {
        protected DescendantsNoFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
        }

        @Override
        protected TreeNode parse(Indi indi) {
            return this.parse(indi, 0);
        }

        private TreeNode parse(Indi indi, int generation) {
            TreeNode node = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
            Fam[] fams = indi.getFamiliesWhereSpouse();
            TreeNode pivot = node;
            ArrayList<Indi> l = new ArrayList<Indi>(fams.length);
            block0: for (int f = 0; f < fams.length; ++f) {
                Indi[] children = fams[f].getChildren();
                if (!this.model.isVertical()) {
                    List<Indi> childrenList = Arrays.asList(children);
                    Collections.reverse(childrenList);
                    children = childrenList.toArray(new Indi[0]);
                }
                for (int c = 0; c < children.length; ++c) {
                    if (l.contains(children[c])) continue;
                    l.add(children[c]);
                    if (node.getArcs().isEmpty()) {
                        if (generation >= this.model.getMaxGenerations() || this.model.isHideDescendants(indi)) {
                            this.insertPlusMinus(indi, node, false, true);
                            continue block0;
                        }
                        pivot = this.insertPlusMinus(indi, node, false, false);
                    }
                    this.model.add(new TreeArc(pivot, this.parse(children[c], generation + 1), true));
                }
            }
            return node;
        }

        @Override
        protected TreeNode parse(Fam fam) {
            throw new IllegalArgumentException();
        }
    }

    private static class AncestorsWithFams
    extends Parser {
        private int[] padFams;
        private int[] padHusband;
        private int[] padWife;
        private int offsetSpouse;

        protected AncestorsWithFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
            int pi = (model.getMetrics().indisThick + 1) / 4;
            this.padMinusPlus = new int[]{-this.padIndis[0] + pi, 1, 1, this.padIndis[3] - pi};
            this.padFams = new int[]{this.padIndis[0], this.padIndis[1], this.padIndis[2], -((int)((double)metrics.pad * 0.4))};
            this.padHusband = new int[]{this.padIndis[0], this.padIndis[1], 0, this.padIndis[3]};
            this.padWife = new int[]{this.padIndis[0], 0, this.padIndis[2], this.padIndis[3]};
            this.offsetSpouse = (model.isVertical() ? metrics.wIndis : metrics.hIndis) / 2;
        }

        @Override
        protected TreeNode parse(Fam fam) {
            return this.parse(fam, 0);
        }

        private TreeNode parse(Fam fam, int generation) {
            TreeNode node = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padFams));
            Indi wife = fam.getWife();
            Indi husb = fam.getHusband();
            if (!this.model.isVertical()) {
                Indi i = wife;
                wife = husb;
                husb = i;
            }
            TreeNode nWife = this.model.add(new TreeNode(wife, (Shape)this.shapeIndis, this.padHusband));
            this.model.add(new TreeArc(node, this.parse(wife, nWife, this.hasParents(husb) ? -this.offsetSpouse : 0, generation + 1), false));
            TreeNode nMarr = this.model.add(new TreeNode(null, (Shape)this.shapeMarrs, this.padMarrs));
            this.model.add(new TreeArc(node, nMarr, false));
            TreeNode nHusb = this.model.add(new TreeNode(husb, (Shape)this.shapeIndis, this.padWife));
            this.model.add(new TreeArc(node, this.parse(husb, nHusb, this.hasParents(wife) ? this.offsetSpouse : 0, generation + 1), false));
            return node;
        }

        @Override
        protected TreeNode parse(Indi indi) {
            return this.parse(indi, this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis)), 0, 0);
        }

        private TreeNode parse(Indi indi, TreeNode nIndi, int align, int generation) {
            if (indi == null) {
                return nIndi;
            }
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                if (generation >= this.model.getMaxGenerations() || this.model.isHideAncestors(indi)) {
                    this.insertPlusMinus(indi, nIndi, true, true);
                } else {
                    TreeNode nMinus = this.insertPlusMinus(indi, nIndi, true, false);
                    this.model.add(new TreeArc(nMinus, this.parse(famc, generation), true));
                    nMinus.align = align;
                }
            }
            return nIndi;
        }

        private boolean hasParents(Indi indi) {
            if (indi == null) {
                return false;
            }
            if (this.model.isHideAncestors(indi)) {
                return false;
            }
            return indi.getFamiliesWhereChild() != null;
        }
    }

    private static class AncestorsNoFams
    extends Parser {
        protected AncestorsNoFams(Model model, TreeMetrics metrics) {
            super(model, metrics);
        }

        @Override
        protected TreeNode parse(Fam fam) {
            throw new IllegalArgumentException();
        }

        @Override
        protected TreeNode parse(Indi indi) {
            return this.parse(indi, 0);
        }

        private TreeNode parse(Indi indi, int generation) {
            TreeNode node = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                if (generation >= this.model.getMaxGenerations() || this.model.isHideAncestors(indi)) {
                    this.insertPlusMinus(indi, node, true, true);
                } else {
                    TreeNode minus = this.insertPlusMinus(indi, node, true, false);
                    Indi wife = famc.getWife();
                    Indi husb = famc.getHusband();
                    if (!this.model.isVertical()) {
                        Indi i = wife;
                        wife = husb;
                        husb = i;
                    }
                    if (wife != null) {
                        this.model.add(new TreeArc(minus, this.parse(wife, generation + 1), true));
                    }
                    if (husb != null) {
                        this.model.add(new TreeArc(minus, this.parse(husb, generation + 1), true));
                    }
                }
            }
            return node;
        }
    }
}

