/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.geoplace;

import ancestris.api.place.Place;
import ancestris.api.place.PlaceFactory;
import ancestris.modules.editors.geoplace.GedcomPlaceEditorPanel;
import ancestris.modules.editors.geoplace.GeonamePlacesListModel;
import ancestris.modules.editors.geoplace.ReferencesTableModel;
import ancestris.modules.place.geonames.GeonamesResearcher;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.Registry;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableRowSorter;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.util.ProjectProperties;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.empty.EmptyTileFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

public class PlaceEditorPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(PlaceEditorPanel.class.getName(), null);
    private static final int DEFAULT_LAT = 45;
    private static final int DEFAULT_LON = -4;
    private Gedcom mGedcom = null;
    private PropertyPlace mPlace;
    Set<PropertyPlace> mPropertyPlaces = null;
    private Registry registry = null;
    private Map<String, Set<PropertyPlace>> placesMap = null;
    private final DefaultListModel<String> gedcomPlacesListModel = new DefaultListModel();
    private boolean listIsBusy = false;
    private ReferencesTableModel referencesTableModel = new ReferencesTableModel();
    private GeonamesResearcher geonamesSearcher = new GeonamesResearcher();
    private final GeonamePlacesListModel geonamePlacesListModel = new GeonamePlacesListModel();
    private MapPopupMenu popupMenu;
    private JButton OKButton;
    private boolean isConnectionOn = true;
    private URL osmUrl;
    private boolean isBusyChecking = false;
    private JScrollPane MapScrollPane;
    private JButton completePlaceButton;
    private JLabel eventsLabel;
    private JPanel gedcomListPanel;
    private JScrollPane gedcomListScrollPane;
    private GedcomPlaceEditorPanel gedcomPlaceEditorPanel;
    private JList<String> gedcomPlacesListResult;
    private JList<String> geonamesPlacesListResult;
    private JScrollPane geonamesScrollPane;
    private JPanel internetListPanel;
    private JXMapKit jXMapKit1;
    private JPanel listPanel;
    private JPanel mapPanel;
    private JLabel placeDetailsLabel;
    private JTabbedPane placeEditorTabbedPane;
    private JLabel placeLabel;
    private JScrollPane placeReferenceScrollPane;
    private JTable placeReferencesTable;
    private JButton replacePlaceButton;
    private JButton searchPlaceButton;
    private JTextField searchPlaceTextField;
    private JSeparator separator;
    private JSplitPane splitPane;
    private JLabel tipLabel;

    public PlaceEditorPanel() {
        this.registry = Registry.get(this.getClass());
        try {
            this.osmUrl = new URL("http://tile.openstreetmap.org/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.initComponents();
        this.searchPlaceTextField.getDocument().addDocumentListener(new FilterListener());
        this.jXMapKit1.setDataProviderCreditShown(true);
        this.jXMapKit1.setMiniMapVisible(false);
        this.setMouseListener();
        TableRowSorter<ReferencesTableModel> sorter = new TableRowSorter<ReferencesTableModel>((ReferencesTableModel)this.placeReferencesTable.getModel());
        this.placeReferencesTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        sorter.sort();
    }

    private void initComponents() {
        this.placeLabel = new JLabel();
        this.searchPlaceTextField = new JTextField();
        this.searchPlaceButton = new JButton();
        this.splitPane = new JSplitPane();
        this.listPanel = new JPanel();
        this.placeEditorTabbedPane = new JTabbedPane();
        this.gedcomListPanel = new JPanel();
        this.gedcomListScrollPane = new JScrollPane();
        this.gedcomPlacesListResult = new JList();
        this.eventsLabel = new JLabel();
        this.placeReferenceScrollPane = new JScrollPane();
        this.placeReferencesTable = new JTable();
        this.internetListPanel = new JPanel();
        this.geonamesScrollPane = new JScrollPane();
        this.geonamesPlacesListResult = new JList();
        this.replacePlaceButton = new JButton();
        this.completePlaceButton = new JButton();
        this.mapPanel = new JPanel();
        this.MapScrollPane = new JScrollPane();
        this.jXMapKit1 = new JXMapKit();
        this.tipLabel = new JLabel();
        this.placeDetailsLabel = new JLabel();
        this.separator = new JSeparator();
        this.gedcomPlaceEditorPanel = new GedcomPlaceEditorPanel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                PlaceEditorPanel.this.formComponentResized(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.placeLabel, (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.placeLabel.text"));
        this.searchPlaceTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/geoplace/Bundle").getString("PlaceEditorPanel.searchPlaceTextField.text"), new Object[0]));
        this.searchPlaceTextField.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.searchPlaceTextField.toolTipText"));
        this.searchPlaceTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceEditorPanel.this.searchPlaceButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchPlaceButton, (String)MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/geoplace/Bundle").getString("PlaceEditorPanel.searchPlaceButton.text"), new Object[0]));
        this.searchPlaceButton.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.searchPlaceButton.toolTipText"));
        this.searchPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceEditorPanel.this.searchPlaceButtonActionPerformed(evt);
            }
        });
        this.splitPane.setDividerLocation(250);
        this.splitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PlaceEditorPanel.this.splitPanePropertyChange(evt);
            }
        });
        this.placeEditorTabbedPane.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"RightClicOnMap"));
        this.gedcomPlacesListResult.setModel(this.gedcomPlacesListModel);
        this.gedcomPlacesListResult.setSelectionMode(0);
        this.gedcomPlacesListResult.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.gedcomPlacesListResult.toolTipText"));
        this.gedcomPlacesListResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlaceEditorPanel.this.gedcomPlacesListResultMouseClicked(evt);
            }
        });
        this.gedcomPlacesListResult.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PlaceEditorPanel.this.gedcomPlacesListResultValueChanged(evt);
            }
        });
        this.gedcomListScrollPane.setViewportView(this.gedcomPlacesListResult);
        this.eventsLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/association.png")));
        Mnemonics.setLocalizedText((JLabel)this.eventsLabel, (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.eventsLabel.text"));
        this.placeReferenceScrollPane.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.placeReferenceScrollPane.toolTipText"));
        this.placeReferencesTable.setModel(this.referencesTableModel);
        this.placeReferencesTable.setSelectionMode(0);
        this.placeReferencesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlaceEditorPanel.this.placeReferencesTableMouseClicked(evt);
            }
        });
        this.placeReferencesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlaceEditorPanel.this.placeReferencesTableMouseClicked(evt);
            }
        });
        this.placeReferenceScrollPane.setViewportView(this.placeReferencesTable);
        GroupLayout gedcomListPanelLayout = new GroupLayout(this.gedcomListPanel);
        this.gedcomListPanel.setLayout(gedcomListPanelLayout);
        gedcomListPanelLayout.setHorizontalGroup(gedcomListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gedcomListScrollPane, GroupLayout.Alignment.TRAILING, -1, 250, Short.MAX_VALUE).addGroup(gedcomListPanelLayout.createSequentialGroup().addContainerGap().addGroup(gedcomListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.placeReferenceScrollPane, -2, 0, Short.MAX_VALUE).addGroup(gedcomListPanelLayout.createSequentialGroup().addComponent(this.eventsLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        gedcomListPanelLayout.setVerticalGroup(gedcomListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gedcomListPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.gedcomListScrollPane, -1, 280, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.eventsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.placeReferenceScrollPane, -2, 164, -2)));
        this.placeEditorTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/geoplace/Bundle").getString("PlaceEditorPanel.gedcomListPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/Gedcom.png")), this.gedcomListPanel);
        this.geonamesPlacesListResult.setModel(this.geonamePlacesListModel);
        this.geonamesPlacesListResult.setSelectionMode(0);
        this.geonamesPlacesListResult.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.geonamesPlacesListResult.toolTipText"));
        this.geonamesPlacesListResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlaceEditorPanel.this.geonamesPlacesListResultMouseClicked(evt);
            }
        });
        this.geonamesPlacesListResult.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PlaceEditorPanel.this.geonamesPlacesListResultValueChanged(evt);
            }
        });
        this.geonamesScrollPane.setViewportView(this.geonamesPlacesListResult);
        GroupLayout internetListPanelLayout = new GroupLayout(this.internetListPanel);
        this.internetListPanel.setLayout(internetListPanelLayout);
        internetListPanelLayout.setHorizontalGroup(internetListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.geonamesScrollPane, GroupLayout.Alignment.TRAILING, -1, 250, Short.MAX_VALUE));
        internetListPanelLayout.setVerticalGroup(internetListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(internetListPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.geonamesScrollPane, -1, 478, Short.MAX_VALUE)));
        this.placeEditorTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/geoplace/Bundle").getString("PlaceEditorPanel.internetListPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/InternetSearch.png")), this.internetListPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.replacePlaceButton, (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.replacePlaceButton.text"));
        this.replacePlaceButton.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.replacePlaceButton.toolTipText"));
        this.replacePlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceEditorPanel.this.replacePlaceButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.completePlaceButton, (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.completePlaceButton.text"));
        this.completePlaceButton.setToolTipText(NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.completePlaceButton.toolTipText"));
        this.completePlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceEditorPanel.this.completePlaceButtonActionPerformed(evt);
            }
        });
        GroupLayout listPanelLayout = new GroupLayout(this.listPanel);
        this.listPanel.setLayout(listPanelLayout);
        listPanelLayout.setHorizontalGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, listPanelLayout.createSequentialGroup().addGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, listPanelLayout.createSequentialGroup().addComponent(this.replacePlaceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.completePlaceButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.placeEditorTabbedPane, GroupLayout.Alignment.LEADING)).addContainerGap()));
        listPanelLayout.setVerticalGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(listPanelLayout.createSequentialGroup().addComponent(this.placeEditorTabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.completePlaceButton).addComponent(this.replacePlaceButton))));
        this.splitPane.setLeftComponent(this.listPanel);
        this.jXMapKit1.setDataProviderCreditShown(true);
        this.jXMapKit1.setZoom(8);
        this.MapScrollPane.setViewportView((Component)this.jXMapKit1);
        this.tipLabel.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.tipLabel, (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.tipLabel.text"));
        GroupLayout mapPanelLayout = new GroupLayout(this.mapPanel);
        this.mapPanel.setLayout(mapPanelLayout);
        mapPanelLayout.setHorizontalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MapScrollPane).addGroup(mapPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tipLabel, -1, -1, Short.MAX_VALUE)));
        mapPanelLayout.setVerticalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapPanelLayout.createSequentialGroup().addComponent(this.MapScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tipLabel)));
        this.splitPane.setRightComponent(this.mapPanel);
        this.placeDetailsLabel.setFont(new Font("DejaVu Sans", 1, 12));
        this.placeDetailsLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.placeDetailsLabel, (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.placeDetailsLabel.text"));
        this.placeDetailsLabel.setVerticalAlignment(3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.placeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPlaceTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPlaceButton)).addComponent(this.splitPane)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.separator).addComponent(this.gedcomPlaceEditorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.placeDetailsLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchPlaceTextField, -2, -1, -2).addComponent(this.searchPlaceButton).addComponent(this.placeLabel).addComponent(this.placeDetailsLabel)).addGap(2, 2, 2).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.splitPane).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.gedcomPlaceEditorPanel, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)))));
    }

    private void replacePlaceButtonActionPerformed(ActionEvent evt) {
        if (this.placeEditorTabbedPane.getSelectedIndex() == 0) {
            Place place = this.getSelectedPlace();
            if (place == null) {
                return;
            }
            this.gedcomPlaceEditorPanel.updatePlace(place, 0, true);
            this.displayLocationOnMap(place);
        } else if (this.geonamesPlacesListResult.getSelectedIndex() != -1) {
            Place place = this.geonamePlacesListModel.getPlaceAt(this.geonamesPlacesListResult.getSelectedIndex());
            if (place == null) {
                return;
            }
            this.gedcomPlaceEditorPanel.updatePlace(place, 0, true);
            this.displayLocationOnMap(place);
        }
    }

    private void completePlaceButtonActionPerformed(ActionEvent evt) {
        if (this.placeEditorTabbedPane.getSelectedIndex() == 0) {
            Place place = this.getSelectedPlace();
            if (place == null) {
                return;
            }
            this.gedcomPlaceEditorPanel.updatePlace(place, 0, false);
            this.displayLocationOnMap(place);
        } else if (this.geonamesPlacesListResult.getSelectedIndex() != -1) {
            Place place = this.geonamePlacesListModel.getPlaceAt(this.geonamesPlacesListResult.getSelectedIndex());
            if (place == null) {
                return;
            }
            this.gedcomPlaceEditorPanel.updatePlace(place, 0, false);
            this.displayLocationOnMap(place);
        }
    }

    private void geonamesPlacesListResultValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting() && this.geonamesPlacesListResult.getSelectedIndex() != -1) {
            Place place = this.geonamePlacesListModel.getPlaceAt(this.geonamesPlacesListResult.getSelectedIndex());
            this.displayLocationOnMap(place);
        }
    }

    private void searchPlaceButtonActionPerformed(ActionEvent evt) {
        String placePieces = this.searchPlaceTextField.getText().replaceAll(",", " ").replaceAll(" +", " ").trim();
        if (placePieces.isEmpty()) {
            DialogManager.createError((String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"TITL_SearchCriteriaEmpty"), (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"MSG_SearchCriteriaEmpty")).show();
        } else {
            this.checkConnection(true);
            if (this.isConnectionOn) {
                this.searchPlace(placePieces);
                this.placeEditorTabbedPane.setSelectedComponent(this.internetListPanel);
            }
        }
    }

    private void placeReferencesTableMouseClicked(MouseEvent evt) {
        Entity entity;
        int rowIndex;
        if (evt.getClickCount() >= 2 && (rowIndex = this.placeReferencesTable.convertRowIndexToModel(this.placeReferencesTable.getSelectedRow())) != -1 && (entity = this.referencesTableModel.getValueAt(rowIndex)) != null) {
            SelectionDispatcher.fireSelection((AWTEvent)evt, (Context)new Context(entity));
        }
    }

    private void gedcomPlacesListResultValueChanged(ListSelectionEvent evt) {
        int index = this.gedcomPlacesListResult.getSelectedIndex();
        if (index != -1) {
            String placeStr = this.gedcomPlacesListModel.elementAt(index);
            PropertyPlace place = null;
            this.referencesTableModel.clear();
            Set<PropertyPlace> propertyPlaces = this.placesMap.get(placeStr);
            for (PropertyPlace propertyPlace : propertyPlaces) {
                if (place == null) {
                    place = propertyPlace;
                }
                this.referencesTableModel.addRow(propertyPlace);
            }
            this.referencesTableModel.fireTableDataChanged();
            this.setRefTableColumnWidths();
            this.displayLocationOnMap((Place)new PlaceFactory(place));
        }
    }

    private void splitPanePropertyChange(PropertyChangeEvent evt) {
        this.saveSize();
    }

    private void gedcomPlacesListResultMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            this.replacePlaceButton.doClick();
            if (this.OKButton != null) {
                this.OKButton.doClick();
            }
        }
    }

    private void geonamesPlacesListResultMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            this.replacePlaceButton.doClick();
            if (this.OKButton != null) {
                this.OKButton.doClick();
            }
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.saveSize();
    }

    public PropertyPlace get() {
        return this.mPlace;
    }

    public void setOKButton(JButton OKButton) {
        this.OKButton = OKButton;
    }

    public void set(Gedcom gedcom, PropertyPlace place, boolean allPlaces) {
        if (place == null) {
            place = new PropertyPlace("PLAC");
        }
        this.checkConnection(false);
        if (this.isConnectionOn) {
            this.jXMapKit1.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        } else {
            this.jXMapKit1.setTileFactory((TileFactory)new EmptyTileFactory());
        }
        this.mGedcom = gedcom;
        this.mPlace = place;
        this.placesMap = this.getGeoPlaces();
        this.mPropertyPlaces = new HashSet<PropertyPlace>();
        Set<PropertyPlace> tmpSet = this.placesMap.get(place.getGeoValue());
        if (allPlaces && tmpSet != null) {
            this.mPropertyPlaces.addAll(tmpSet);
        } else {
            this.mPropertyPlaces.add(place);
        }
        this.set(gedcom, this.mPropertyPlaces);
    }

    public void set(Gedcom gedcom, Set<PropertyPlace> propertyPlaces) {
        this.checkConnection(false);
        if (this.isConnectionOn) {
            this.jXMapKit1.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        } else {
            this.jXMapKit1.setTileFactory((TileFactory)new EmptyTileFactory());
        }
        if (this.mPropertyPlaces == null) {
            this.mPropertyPlaces = propertyPlaces;
        }
        Object[] propertyPlaceArray = propertyPlaces.toArray();
        this.mGedcom = gedcom;
        this.mPlace = (PropertyPlace)propertyPlaceArray[0];
        this.setPreferredSize(new Dimension(this.registry.get("placeWindowWidth", this.getPreferredSize().width), this.registry.get("placeWindowHeight", this.getPreferredSize().height)));
        this.splitPane.setDividerLocation(this.registry.get("placeSplitDividerLocation", this.splitPane.getDividerLocation()));
        this.gedcomPlacesListModel.clear();
        if (this.placesMap == null) {
            this.placesMap = this.getGeoPlaces();
        }
        Set<String> places = this.placesMap.keySet();
        for (String place : places) {
            this.gedcomPlacesListModel.addElement(place);
        }
        this.gedcomPlaceEditorPanel.set(gedcom, this.mPlace);
        this.listIsBusy = true;
        this.searchPlaceTextField.setText(this.mPlace.getValue().replaceAll(",", " ").replaceAll(" +", " ").trim());
        this.listIsBusy = false;
        this.displayLocationOnMap((Place)new PlaceFactory(this.mPlace));
        this.gedcomPlaceEditorPanel.setMapHandle(this);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                PlaceEditorPanel.this.selectPlace(PlaceEditorPanel.this.mPlace);
                if (!PlaceEditorPanel.this.gedcomPlacesListModel.isEmpty() && PlaceEditorPanel.this.mPlace.getLatitude(true) != null) {
                    PlaceEditorPanel.this.placeEditorTabbedPane.setSelectedComponent(PlaceEditorPanel.this.gedcomListPanel);
                } else if (!PlaceEditorPanel.this.geonamePlacesListModel.isEmpty()) {
                    PlaceEditorPanel.this.placeEditorTabbedPane.setSelectedComponent(PlaceEditorPanel.this.internetListPanel);
                    PlaceEditorPanel.this.geonamesPlacesListResult.setSelectedIndex(0);
                } else {
                    PlaceEditorPanel.this.placeEditorTabbedPane.setSelectedComponent(PlaceEditorPanel.this.internetListPanel);
                }
                PlaceEditorPanel.this.searchPlaceTextField.setSelectionStart(0);
                PlaceEditorPanel.this.searchPlaceTextField.setSelectionEnd(PlaceEditorPanel.this.searchPlaceTextField.getText().length());
                PlaceEditorPanel.this.searchPlaceTextField.requestFocus();
            }
        });
    }

    public void selectPlace(PropertyPlace place) {
        int index = this.gedcomPlacesListModel.indexOf(place.getGeoValue());
        this.gedcomPlacesListResult.ensureIndexIsVisible(0);
        this.gedcomPlacesListResult.setSelectedIndex(index);
        int firstIndex = this.gedcomPlacesListResult.getFirstVisibleIndex();
        int lastIndex = this.gedcomPlacesListResult.getLastVisibleIndex();
        int visibleIndex = index + (lastIndex - firstIndex) / 2;
        if (visibleIndex > this.gedcomPlacesListModel.getSize()) {
            visibleIndex = this.gedcomPlacesListModel.getSize() - 1;
        }
        this.gedcomPlacesListResult.ensureIndexIsVisible(visibleIndex);
    }

    public void setGeoPoint(GeoPosition geoPoint) {
        this.geonamePlacesListModel.clear();
        if (geoPoint == null) {
            PlaceFactory place = new PlaceFactory(this.mPlace);
        } else {
            PlaceFactory place = new PlaceFactory(this.mPlace, geoPoint);
            this.geonamePlacesListModel.add((Place)place);
        }
    }

    private void searchPlace(String placePieces) {
        this.searchPlaceButton.setEnabled(false);
        this.geonamePlacesListModel.clear();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.geonamesSearcher.searchIndividualPlace(placePieces, (List)this.geonamePlacesListModel, new TaskListener(){

                public void taskFinished(Task task) {
                    PlaceEditorPanel.this.searchPlaceButton.setEnabled(true);
                    if (PlaceEditorPanel.this.geonamePlacesListModel.getSize() > 0) {
                        PlaceEditorPanel.this.geonamesPlacesListResult.setSelectionInterval(0, 0);
                    }
                    PlaceEditorPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public void copyValue(PropertyPlace place) {
        place.setValue(this.gedcomPlaceEditorPanel.getPlaceString(0));
        String lat = this.gedcomPlaceEditorPanel.getLatitude();
        String lon = this.gedcomPlaceEditorPanel.getLongitude();
        if (!lat.isEmpty() && !lon.isEmpty()) {
            place.setCoordinates(lat, lon);
        } else {
            place.setCoordinates("", "");
        }
    }

    public void commit() {
        HashSet<PropertyPlace> tmpList = new HashSet<PropertyPlace>();
        tmpList.addAll(this.mPropertyPlaces);
        if (this.gedcomPlaceEditorPanel.isModified()) {
            for (PropertyPlace propertyPlace : tmpList) {
                this.copyValue(propertyPlace);
            }
        }
    }

    public void commit(Property parent, PropertyPlace place) {
        if (this.gedcomPlaceEditorPanel.isModified()) {
            if (place == null) {
                place = (PropertyPlace)parent.addProperty("PLAC", "");
            }
            this.copyValue(place);
        }
    }

    public void runSearch() {
        this.searchPlaceButton.doClick();
    }

    private void saveSize() {
        int h;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getWidth();
        if (w > dim.width * 90 / 100) {
            w = dim.width * 90 / 100;
        }
        if ((h = this.getHeight()) > dim.height * 80 / 100) {
            h = dim.height * 80 / 100;
        }
        this.registry.put("placeWindowWidth", w);
        this.registry.put("placeWindowHeight", h);
        this.registry.put("placeSplitDividerLocation", this.splitPane.getDividerLocation());
        this.setRefTableColumnWidths();
    }

    public void close() {
        this.geonamePlacesListModel.clear();
    }

    private void setPopuMenu() {
        this.popupMenu = new MapPopupMenu(this.jXMapKit1.getMainMap());
        this.popupMenu.add(new MapPopupAction("ACTION_MapCopyPoint", null, this.popupMenu));
        this.popupMenu.add(new MapPopupAction("ACTION_MapNearestPoint", null, this.popupMenu));
    }

    public void showLocation(GeoPosition geoPoint) {
        this.jXMapKit1.setAddressLocation(geoPoint);
    }

    private Place getSelectedPlace() {
        int index = this.gedcomPlacesListResult.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        String placeStr = this.gedcomPlacesListModel.elementAt(index);
        Set<PropertyPlace> propertyPlaces = this.placesMap.get(placeStr);
        Iterator<PropertyPlace> iterator = propertyPlaces.iterator();
        if (iterator.hasNext()) {
            PropertyPlace place = iterator.next();
            return new PlaceFactory(place);
        }
        return null;
    }

    private void displayLocationOnMap(Place place) {
        if (place != null) {
            Double latitude = place.getLatitude();
            Double longitude = place.getLongitude();
            if (longitude != null && latitude != null) {
                this.showLocation(new GeoPosition(latitude.doubleValue(), longitude.doubleValue()));
                return;
            }
        }
        this.showLocation(new GeoPosition(45.0, -4.0));
    }

    private void setRefTableColumnWidths() {
        int nbCols = this.referencesTableModel.getColumnCount();
        int nbRows = this.referencesTableModel.getRowCount();
        for (int c = 0; c < nbCols; ++c) {
            String str = this.referencesTableModel.getColumnName(c);
            int maxWidth = this.getFontMetrics(this.getFont()).stringWidth(str);
            for (int i = 0; i < nbRows; ++i) {
                str = (String)this.referencesTableModel.getValueAt(i, c);
                maxWidth = Math.max(maxWidth, this.getFontMetrics(this.getFont()).stringWidth(str));
            }
            this.placeReferencesTable.getColumnModel().getColumn(c).setPreferredWidth(c == 0 ? maxWidth * 2 : maxWidth);
        }
    }

    private Map<String, Set<PropertyPlace>> getGeoPlaces() {
        TreeMap<String, Set<PropertyPlace>> ret = new TreeMap<String, Set<PropertyPlace>>();
        for (String placeStr : this.mGedcom.getReferenceSet("PLAC").getKeys((Comparator)this.mGedcom.getCollator())) {
            Set props = this.mGedcom.getReferenceSet("PLAC").getReferences((Object)placeStr);
            for (Property prop : props) {
                String geoPlace = ((PropertyPlace)prop).getGeoValue();
                HashSet<PropertyPlace> set = (HashSet<PropertyPlace>)ret.get(geoPlace);
                if (set == null) {
                    set = new HashSet<PropertyPlace>();
                    ret.put(geoPlace, set);
                }
                set.add((PropertyPlace)prop);
            }
        }
        return ret;
    }

    public void setSearchPlace(String place) {
        this.searchPlaceTextField.setText(place.replaceAll(",", " ").replaceAll(" +", " ").trim());
    }

    private void checkConnection(boolean mute) {
        try {
            if (this.isBusyChecking) {
                return;
            }
            this.isBusyChecking = true;
            URLConnection uc = this.osmUrl.openConnection();
            uc.setRequestProperty("User-Agent", ProjectProperties.INSTANCE.getName() + '/' + ProjectProperties.INSTANCE.getVersion());
            uc.getInputStream();
        }
        catch (IOException ex) {
            if (!mute) {
                DialogManager.createError((String)(NbBundle.getMessage(PlaceEditorPanel.class, (String)"OpenIDE-Module-Name") + " - " + NbBundle.getMessage(PlaceEditorPanel.class, (String)"TITL_ConnectionError")), (String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"MSG_ConnectionError")).show();
            }
            this.isConnectionOn = false;
            this.isBusyChecking = false;
            return;
        }
        this.isConnectionOn = true;
        this.isBusyChecking = false;
    }

    private void setMouseListener() {
        PlaceMouseInputListener mia = new PlaceMouseInputListener();
        this.jXMapKit1.getMainMap().addMouseListener((MouseListener)mia);
        this.jXMapKit1.getMainMap().addMouseMotionListener((MouseMotionListener)mia);
    }

    private class PlaceMouseInputListener
    implements MouseInputListener {
        private Component focusedComponent = null;

        private PlaceMouseInputListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                PlaceEditorPanel.this.setPopuMenu();
                PlaceEditorPanel.this.popupMenu.setPoint(e.getPoint());
                PlaceEditorPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.focusedComponent != null) {
                this.focusedComponent.requestFocus();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class MapPopupAction
    extends AbstractAction {
        private String actionName = "";
        private MapPopupMenu mpm = null;

        public MapPopupAction(String name, Object o, MapPopupMenu mpm) {
            this.actionName = name;
            this.mpm = mpm;
            this.putValue("Name", NbBundle.getMessage(PlaceEditorPanel.class, (String)name));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.actionName.equals("ACTION_MapCopyPoint")) {
                Double dLat = (double)Math.round(this.mpm.getGeoPoint().getLatitude() * 100000.0) / 100000.0;
                Double dLon = (double)Math.round(this.mpm.getGeoPoint().getLongitude() * 100000.0) / 100000.0;
                PlaceEditorPanel.this.gedcomPlaceEditorPanel.modifyCoordinates(String.valueOf(dLat), String.valueOf(dLon), true);
                PlaceEditorPanel.this.showLocation(this.mpm.getGeoPoint());
            }
            if (this.actionName.equals("ACTION_MapNearestPoint")) {
                PlaceEditorPanel.this.gedcomPlaceEditorPanel.updatePlace(PlaceEditorPanel.this.geonamesSearcher.searchNearestPlace(this.mpm.getGeoPoint().getLatitude(), this.mpm.getGeoPoint().getLongitude()), 0, true);
                PlaceEditorPanel.this.showLocation(this.mpm.getGeoPoint());
            }
        }
    }

    private class MapPopupMenu
    extends JPopupMenu {
        private JXMapViewer map = null;
        private Point point = new Point(0, 0);

        public MapPopupMenu(JXMapViewer map) {
            this.map = map;
        }

        public void setPoint(Point point) {
            this.point = point;
        }

        public GeoPosition getGeoPoint() {
            return this.map.convertPointToGeoPosition((Point2D)this.point);
        }
    }

    private class FilterListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.filterPlaces();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.filterPlaces();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.filterPlaces();
        }

        private void filterPlaces() {
            if (PlaceEditorPanel.this.listIsBusy) {
                return;
            }
            if (!PlaceEditorPanel.this.searchPlaceButton.isEnabled()) {
                PlaceEditorPanel.this.searchPlaceButton.setEnabled(true);
            }
            String filter = PlaceEditorPanel.this.searchPlaceTextField.getText();
            PlaceEditorPanel.this.gedcomPlacesListModel.clear();
            for (String place : PlaceEditorPanel.this.placesMap.keySet()) {
                if (!place.toLowerCase().contains(filter.toLowerCase())) continue;
                PlaceEditorPanel.this.gedcomPlacesListModel.addElement(place);
            }
        }
    }
}

