/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.api.search.SearchCommunicator;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.libs.geonames.GeonamesOptions;
import ancestris.modules.geo.GeoFilter;
import ancestris.modules.geo.GeoListTopComponent;
import ancestris.modules.geo.GeoNodeObject;
import ancestris.modules.geo.GeoPlacesList;
import ancestris.modules.geo.GeoPlacesListener;
import ancestris.modules.geo.GeoPoint;
import ancestris.modules.geo.GeoToken;
import ancestris.modules.geo.HoverPanel;
import ancestris.modules.geo.SettingsPanel;
import ancestris.modules.geo.renderer.NameWaypointRenderer;
import ancestris.modules.geo.renderer.NoNameWaypointRenderer;
import ancestris.modules.utilities.search.SearchTopComponent;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.SelectionActionEvent;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.io.Filter;
import genj.util.Registry;
import genj.view.ScreenshotAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputListener;
import org.geonames.Toponym;
import org.geonames.WebService;
import org.jxmapviewer.JXMapKit;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.util.ProjectProperties;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.WaypointPainter;
import org.jxmapviewer.viewer.WaypointRenderer;
import org.jxmapviewer.viewer.empty.EmptyTileFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class GeoMapTopComponent
extends AncestrisTopComponent
implements GeoPlacesListener,
Filter {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private Registry registry = null;
    private boolean isConnectionOn = true;
    private URL osmUrl;
    private boolean isBusyChecking = false;
    private long lastCheckTimeStamp = 0L;
    static final String ICON_PATH = "ancestris/modules/geo/geo.png";
    private static final String PREFERRED_ID = "GeoMapTopComponent";
    private GeoPlacesList gpl = null;
    private GeoNodeObject[] markers = null;
    private List<GeoPoint> geoPoints = new LinkedList<GeoPoint>();
    private HoverPanel hoverPanel = null;
    private int markersSizeMax = 50;
    private MapPopupMenu popupMenu;
    private int mapToDisplay = 0;
    private double mapCenterLat = 47.0;
    private double mapCenterLon = 3.0;
    private int mapZoom = 11;
    private boolean displayZoom = true;
    private boolean displayMiniMap = true;
    private boolean displayMarkers = true;
    private int markersSize = 10;
    private boolean resizeWithZoom = true;
    private Color markersColor;
    private boolean useNames = false;
    private GeoFilter geoFilter = new GeoFilter();
    private boolean isBusyRecalc = false;
    private boolean refreshFlag = false;
    private Set<Entity> filteredIndis;
    private SearchCommunicator searchCommunicator = null;
    private Lookup.Result<SelectionActionEvent> result;
    private DialogManager settingsDialog;
    private Set<Entity> connectedEntities = new HashSet<Entity>();
    private JLabel blankLabel;
    private Box.Filler filler1;
    private JLabel jActiveFilters;
    private JButton jCaptureButton;
    private JButton jGoToListButton;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JTextField jPlaceFilter;
    private JButton jRefreshButton;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JButton jSettingsButton;
    private JToggleButton jSwapMarkersButton;
    private JToggleButton jToggleMarkersButton;
    private JToggleButton jToggleOverviewButton;
    private JToggleButton jToggleShowUnknown;
    private JToggleButton jToggleSliderButton;
    private JToolBar jToolBar;
    private JButton jViewAllButton;
    private JXMapKit jXMapKit1;

    public String getAncestrisDockMode() {
        return "ancestris-output";
    }

    public void open() {
        if (this.isConnectionOn) {
            super.open();
        }
    }

    public Image getImageIcon() {
        return ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public void setName() {
        this.setName(NbBundle.getMessage(GeoMapTopComponent.class, (String)"CTL_GeoMapTopComponent"));
    }

    public void setToolTipText() {
        this.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"HINT_GeoMapTopComponent"));
    }

    public void init(Context context) {
        LOG.fine("GeoMap enter init : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        super.init(context);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.searchCommunicator = new SearchCommunicator(){

            public void changedResults(Gedcom gedcom) {
                GeoMapTopComponent.this.applyFilters();
            }

            public void closing(Gedcom gedcom) {
                ((GeoMapTopComponent)GeoMapTopComponent.this).geoFilter.selectedSearch = false;
                GeoMapTopComponent.this.applyFilters();
            }
        };
        this.searchCommunicator.setGedcom(context.getGedcom());
        if (this.result == null) {
            this.result = this.addLookupListener(context);
        }
        LOG.fine("GeoMap exit init : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
    }

    public boolean createPanel() {
        LOG.fine("GeoMap enter createPanel : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        try {
            this.osmUrl = new URL("http://tile.openstreetmap.org/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.checkConnection(false);
        LOG.fine("GeoMap enter initComponents : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        this.initComponents();
        LOG.fine("GeoMap exit initComponents : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        this.loadSettings();
        this.geoFilter.setGedcom(this.getGedcom());
        this.hoverPanel = new HoverPanel(this);
        this.hoverPanel.setVisible(false);
        LOG.fine("GeoMap enter JMapKit : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        if (this.isConnectionOn) {
            this.jXMapKit1.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        } else {
            this.jXMapKit1.setTileFactory((TileFactory)new EmptyTileFactory());
        }
        this.jXMapKit1.getMainMap().add((Component)this.hoverPanel);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(107, 0), "zoomout");
        this.getActionMap().put("zoomout", this.jXMapKit1.getZoomOutAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(109, 0), "zoomin");
        this.getActionMap().put("zoomin", this.jXMapKit1.getZoomInAction());
        this.jXMapKit1.getMainMap().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GeoMapTopComponent.this.jXMapKit1PropertyChange(evt);
            }
        });
        LOG.fine("GeoMap exit JMapKit : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        this.customiseFromSettings();
        this.setMouseListener();
        this.setPopuMenu();
        this.jRefreshButton.setEnabled(false);
        this.initMarkersList();
        this.applyFilters();
        this.jXMapKit1.setDataProviderCreditShown(true);
        LOG.fine("GeoMap exit CreatePanel : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        return true;
    }

    private void initMarkersList() {
        if (this.getGedcom() == null) {
            JOptionPane.showMessageDialog(null, "Vous devez d'abord ouvrir un fichier gedcom pour lancer le module G\u00e9ographique");
            return;
        }
        this.gpl = GeoPlacesList.getInstance(this.getGedcom());
        if (this.gpl.getNodes() == null) {
            this.gpl.launchPlacesSearch(0, true, false, null, null);
        } else {
            this.geoPlacesChanged(this.gpl, GeoPlacesList.TYPEOFCHANGE_GEDCOM);
        }
        this.gpl.addGeoPlacesListener(this);
    }

    public GeoNodeObject[] getMarkers() {
        return this.markers;
    }

    private Lookup.Result<SelectionActionEvent> addLookupListener(Context context) {
        Lookup.Result r;
        try {
            r = GedcomDirectory.getDefault().getDataObject(context).getLookup().lookupResult(SelectionActionEvent.class);
        }
        catch (GedcomDirectory.ContextNotFoundException ex) {
            r = null;
        }
        final Lookup.Result returnValue = r;
        if (returnValue != null) {
            returnValue.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    for (SelectionActionEvent e : returnValue.allInstances()) {
                        if (e == null) continue;
                        GeoMapTopComponent.this.applyFilters();
                    }
                }
            });
        }
        return returnValue;
    }

    private void initComponents() {
        this.jToolBar = new JToolBar();
        this.jGoToListButton = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.jToggleSliderButton = new JToggleButton();
        this.jViewAllButton = new JButton();
        this.jToggleOverviewButton = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jToggleMarkersButton = new JToggleButton();
        this.jSwapMarkersButton = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jPanel1 = new JPanel();
        this.jPlaceFilter = new JTextField();
        this.jToggleShowUnknown = new JToggleButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jCaptureButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jSeparator3 = new JToolBar.Separator();
        this.jActiveFilters = new JLabel();
        this.jRefreshButton = new JButton();
        this.jSettingsButton = new JButton();
        this.blankLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel6 = new JPanel();
        this.jXMapKit1 = new JXMapKit();
        this.setPreferredSize(new Dimension(906, 627));
        this.jToolBar.setFloatable(false);
        this.jToolBar.setMinimumSize(new Dimension(11, 30));
        this.jToolBar.setPreferredSize(new Dimension(100, 30));
        this.jToolBar.setRequestFocusEnabled(false);
        this.jToolBar.setVerifyInputWhenFocusTarget(false);
        this.jGoToListButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/GoToList.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jGoToListButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jGoToListButton.text"));
        this.jGoToListButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jGoToListButton.toolTipText"));
        this.jGoToListButton.setFocusable(false);
        this.jGoToListButton.setHorizontalTextPosition(0);
        this.jGoToListButton.setVerticalTextPosition(3);
        this.jGoToListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jGoToListButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jGoToListButton);
        this.jToolBar.add(this.jSeparator5);
        this.jToggleSliderButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Zoom.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleSliderButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleSliderButton.text"));
        this.jToggleSliderButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleSliderButton.toolTipText"));
        this.jToggleSliderButton.setFocusable(false);
        this.jToggleSliderButton.setHorizontalTextPosition(0);
        this.jToggleSliderButton.setVerticalTextPosition(3);
        this.jToggleSliderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jToggleSliderButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jToggleSliderButton);
        this.jViewAllButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Zoomadjust.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jViewAllButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jViewAllButton.text"));
        this.jViewAllButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jViewAllButton.toolTipText"));
        this.jViewAllButton.setFocusable(false);
        this.jViewAllButton.setHorizontalTextPosition(0);
        this.jViewAllButton.setVerticalTextPosition(3);
        this.jViewAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jViewAllButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jViewAllButton);
        this.jToggleOverviewButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Overview.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleOverviewButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleOverviewButton.text"));
        this.jToggleOverviewButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleOverviewButton.toolTipText"));
        this.jToggleOverviewButton.setFocusable(false);
        this.jToggleOverviewButton.setHorizontalTextPosition(0);
        this.jToggleOverviewButton.setVerticalTextPosition(3);
        this.jToggleOverviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jToggleOverviewButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jToggleOverviewButton);
        this.jToolBar.add(this.jSeparator1);
        this.jToggleMarkersButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Pointer.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleMarkersButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleMarkersButton.text"));
        this.jToggleMarkersButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleMarkersButton.toolTipText"));
        this.jToggleMarkersButton.setFocusable(false);
        this.jToggleMarkersButton.setHorizontalTextPosition(0);
        this.jToggleMarkersButton.setVerticalTextPosition(3);
        this.jToggleMarkersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jToggleMarkersButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jToggleMarkersButton);
        this.jSwapMarkersButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/SwitchPointers.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jSwapMarkersButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jSwapMarkersButton.text"));
        this.jSwapMarkersButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jSwapMarkersButton.toolTipText"));
        this.jSwapMarkersButton.setFocusable(false);
        this.jSwapMarkersButton.setHorizontalTextPosition(0);
        this.jSwapMarkersButton.setVerticalTextPosition(3);
        this.jSwapMarkersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jSwapMarkersButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jSwapMarkersButton);
        this.jToolBar.add(this.jSeparator2);
        this.jPanel1.setFont(new Font("DejaVu Sans", 0, 10));
        this.jPlaceFilter.setColumns(10);
        this.jPlaceFilter.setText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jPlaceFilter.text"));
        this.jPlaceFilter.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jPlaceFilter.toolTipText"));
        this.jPlaceFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jPlaceFilterActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jPlaceFilter, -2, -1, -2).addGap(1, 1, 1)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPlaceFilter, -2, -1, -2).addGap(0, 0, 0)));
        this.jToolBar.add(this.jPanel1);
        this.jToggleShowUnknown.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/unknown.png")));
        this.jToggleShowUnknown.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jToggleShowUnknown, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleShowUnknown.text"));
        this.jToggleShowUnknown.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jToggleShowUnknown.toolTipText"));
        this.jToggleShowUnknown.setFocusable(false);
        this.jToggleShowUnknown.setHorizontalTextPosition(0);
        this.jToggleShowUnknown.setVerticalTextPosition(3);
        this.jToggleShowUnknown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jToggleShowUnknownActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jToggleShowUnknown);
        this.jToolBar.add(this.jSeparator4);
        this.jCaptureButton.setAction((Action)new ScreenshotAction((JComponent)this.jXMapKit1));
        this.jCaptureButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Camera.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jCaptureButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jCaptureButton.text"));
        this.jCaptureButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jCaptureButton.toolTipText"));
        this.jCaptureButton.setFocusable(false);
        this.jCaptureButton.setHorizontalTextPosition(0);
        this.jCaptureButton.setVerticalTextPosition(3);
        this.jToolBar.add(this.jCaptureButton);
        this.jToolBar.add(this.filler1);
        this.jToolBar.add(this.jSeparator3);
        this.jActiveFilters.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Filter.png")));
        Mnemonics.setLocalizedText((JLabel)this.jActiveFilters, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jActiveFilters.text"));
        this.jActiveFilters.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jActiveFilters.toolTipText"));
        this.jToolBar.add(this.jActiveFilters);
        this.jRefreshButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jRefreshButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jRefreshButton.text"));
        this.jRefreshButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jRefreshButton.toolTipText"));
        this.jRefreshButton.setFocusable(false);
        this.jRefreshButton.setHorizontalTextPosition(0);
        this.jRefreshButton.setVerticalTextPosition(3);
        this.jRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jRefreshButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jRefreshButton);
        this.jSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/geo/Settings.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jSettingsButton, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jSettingsButton.text"));
        this.jSettingsButton.setToolTipText(NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.jSettingsButton.toolTipText"));
        this.jSettingsButton.setFocusable(false);
        this.jSettingsButton.setHorizontalTextPosition(0);
        this.jSettingsButton.setVerticalTextPosition(3);
        this.jSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoMapTopComponent.this.jSettingsButtonActionPerformed(evt);
            }
        });
        this.jToolBar.add(this.jSettingsButton);
        Mnemonics.setLocalizedText((JLabel)this.blankLabel, (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.blankLabel.text"));
        this.jToolBar.add(this.blankLabel);
        this.jScrollPane1.setFont(new Font("Cantarell", 0, 12));
        this.jScrollPane1.setPreferredSize(new Dimension(908, 302));
        this.jPanel6.setFont(new Font("Cantarell", 0, 12));
        this.jPanel6.setPreferredSize(new Dimension(905, 300));
        this.jXMapKit1.setMiniMapVisible(false);
        this.jXMapKit1.setZoom(8);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXMapKit1, -1, 905, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXMapKit1, -1, 574, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanel6);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 911, Short.MAX_VALUE).addGap(1, 1, 1)).addComponent(this.jToolBar, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jToolBar, -2, 30, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 597, Short.MAX_VALUE)));
    }

    private void jToggleOverviewButtonActionPerformed(ActionEvent evt) {
        this.displayMiniMap = this.jToggleOverviewButton.isSelected();
        this.jXMapKit1.setMiniMapVisible(this.displayMiniMap);
        this.saveSettings();
    }

    private void jToggleSliderButtonActionPerformed(ActionEvent evt) {
        this.displayZoom = this.jToggleSliderButton.isSelected();
        this.jXMapKit1.setZoomSliderVisible(this.displayZoom);
        this.jXMapKit1.setZoomButtonsVisible(this.displayZoom);
        this.saveSettings();
    }

    private void jViewAllButtonActionPerformed(ActionEvent evt) {
        this.checkConnection(false);
        if (this.isConnectionOn) {
            this.jXMapKit1.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
            if (this.jXMapKit1 != null && this.jXMapKit1.getMainMap() != null) {
                this.jXMapKit1.getMainMap().calculateZoomFrom(this.getPositionsFromMarkers());
            }
        }
    }

    private void jToggleMarkersButtonActionPerformed(ActionEvent evt) {
        this.displayMarkers = this.jToggleMarkersButton.isSelected();
        this.jSwapMarkersButton.setEnabled(this.displayMarkers);
        this.saveSettings();
        this.displayMarkers();
    }

    private void jSwapMarkersButtonActionPerformed(ActionEvent evt) {
        this.useNames = this.jSwapMarkersButton.isSelected();
        this.saveSettings();
        this.displayMarkers();
    }

    private void jPlaceFilterActionPerformed(ActionEvent evt) {
        this.geoFilter.location = this.jPlaceFilter.getText();
        this.geoFilter.save();
        this.applyFilters();
    }

    private void jSettingsButtonActionPerformed(ActionEvent evt) {
        this.showSettings();
    }

    private void jRefreshButtonActionPerformed(ActionEvent evt) {
        this.checkConnection(true);
        if (!this.isConnectionOn) {
            String txt = NbBundle.getMessage(GeoMapTopComponent.class, (String)"MSG_RefreshingError");
            DialogManager.createError((String)(NbBundle.getMessage(GeoMapTopComponent.class, (String)"CTL_GeoMapTopComponent") + " - " + NbBundle.getMessage(GeoMapTopComponent.class, (String)"TITL_ConnectionError")), (String)txt).show();
            return;
        }
        this.jXMapKit1.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        this.jRefreshButton.setEnabled(false);
        GeoPlacesList.getInstance(this.getGedcom()).launchPlacesSearch(2, true, false, null, null);
        this.refreshFlag = true;
    }

    private void jGoToListButtonActionPerformed(ActionEvent evt) {
        GeoNodeObject gno = null;
        this.showListAtLocation(gno);
    }

    private void jToggleShowUnknownActionPerformed(ActionEvent evt) {
        this.geoFilter.showUnknown = this.jToggleShowUnknown.isSelected();
        this.geoFilter.save();
        this.applyFilters();
    }

    private void jXMapKit1PropertyChange(PropertyChangeEvent evt) {
        String pn = evt.getPropertyName();
        if ("zoom".equals(pn) || "center".equals(pn)) {
            boolean isBeforeOn = this.isConnectionOn;
            if (System.currentTimeMillis() - this.lastCheckTimeStamp > 5000L) {
                this.checkConnection(true);
            }
            if (this.isConnectionOn) {
                if (!isBeforeOn) {
                    this.jXMapKit1.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
                }
                if ("zoom".equals(pn) && this.resizeWithZoom) {
                    this.resizeWithZoom();
                }
            } else if (isBeforeOn) {
                this.jXMapKit1.setTileFactory((TileFactory)new EmptyTileFactory());
            }
            this.saveSettings();
        }
        this.jXMapKit1.setDataProviderCreditShown(true);
    }

    public void componentClosed() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom != null) {
            GeoPlacesList gpl2 = GeoPlacesList.getInstance(this.getGedcom());
            GeoPlacesList.remove(gedcom);
            gpl2.removeGeoPlacesListener(this);
            this.geoFilter.save();
        }
        SearchCommunicator.unregister((SearchCommunicator)this.searchCommunicator);
        AncestrisPlugin.unregister((Object)this);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void loadSettings() {
        if (this.registry == null) {
            this.registry = this.getGedcom().getRegistry();
        }
        this.markersSize = this.registry.get("GEO.markers.size", 10);
        this.markersColor = this.registry.get("GEO.markers.color", Color.BLUE);
        this.resizeWithZoom = this.registry.get("GEO.markers.resizeWithZoom", true);
        this.mapCenterLat = Double.valueOf(this.registry.get("mapCenterLat", "47"));
        this.mapCenterLon = Double.valueOf(this.registry.get("mapCenterLon", "3"));
        this.mapZoom = Integer.valueOf(this.registry.get("mapZoom", "11"));
        this.mapToDisplay = Integer.valueOf(this.registry.get("mapToDisplay", "0"));
        this.displayZoom = Boolean.valueOf(this.registry.get("displayZoom", "true"));
        this.displayMiniMap = Boolean.valueOf(this.registry.get("displayMiniMap", "true"));
        this.displayMarkers = Boolean.valueOf(this.registry.get("displayMarkers", "true"));
        this.useNames = Boolean.valueOf(this.registry.get("useNames", "false"));
    }

    public void saveSettings() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                if (GeoMapTopComponent.this.jXMapKit1 == null || GeoMapTopComponent.this.registry == null) {
                    return;
                }
                GeoMapTopComponent.this.registry.put("mapCenterLat", String.valueOf(GeoMapTopComponent.this.jXMapKit1.getCenterPosition().getLatitude()));
                GeoMapTopComponent.this.registry.put("mapCenterLon", String.valueOf(GeoMapTopComponent.this.jXMapKit1.getCenterPosition().getLongitude()));
                GeoMapTopComponent.this.registry.put("mapZoom", String.valueOf(GeoMapTopComponent.this.jXMapKit1.getZoomSlider().getValue()));
                GeoMapTopComponent.this.registry.put("mapToDisplay", String.valueOf(GeoMapTopComponent.this.mapToDisplay));
                GeoMapTopComponent.this.registry.put("displayZoom", Boolean.toString(GeoMapTopComponent.this.displayZoom));
                GeoMapTopComponent.this.registry.put("displayMiniMap", Boolean.toString(GeoMapTopComponent.this.displayMiniMap));
                GeoMapTopComponent.this.registry.put("displayMarkers", Boolean.toString(GeoMapTopComponent.this.displayMarkers));
                GeoMapTopComponent.this.registry.put("useNames", Boolean.toString(GeoMapTopComponent.this.useNames));
            }
        });
    }

    public void getHelp() {
        String id = NbBundle.getMessage(GeoMapTopComponent.class, (String)"GeoMapTopComponent.HelpPage");
        try {
            Desktop.getDesktop().browse(new URI(id));
        }
        catch (IOException | URISyntaxException ex) {
            LOG.log(Level.FINE, "Unable to open File", ex);
        }
    }

    private void customiseFromSettings() {
        this.jXMapKit1.setCenterPosition(new GeoPosition(this.mapCenterLat, this.mapCenterLon));
        this.jXMapKit1.setZoom(this.mapZoom);
        this.jToggleSliderButton.setSelected(this.displayZoom);
        this.jXMapKit1.setZoomSliderVisible(this.displayZoom);
        this.jXMapKit1.setZoomButtonsVisible(this.displayZoom);
        this.jToggleOverviewButton.setSelected(this.displayMiniMap);
        this.jXMapKit1.setMiniMapVisible(this.displayMiniMap);
        this.jToggleMarkersButton.setSelected(this.displayMarkers);
        this.jSwapMarkersButton.setEnabled(this.displayMarkers);
        this.jSwapMarkersButton.setSelected(this.useNames);
        this.jPlaceFilter.setText(this.geoFilter.location);
        this.jToggleShowUnknown.setSelected(this.geoFilter.showUnknown);
    }

    @Override
    public void geoPlacesChanged(GeoPlacesList gpl, String change) {
        if (change.equals(GeoPlacesList.TYPEOFCHANGE_COORDINATES) || change.equals(GeoPlacesList.TYPEOFCHANGE_NAME) || change.equals(GeoPlacesList.TYPEOFCHANGE_GEDCOM)) {
            this.hoverPanel.setVisible(false);
            this.markers = gpl.getNodes();
            this.applyFilters();
        }
        if (change.equals(GeoPlacesList.TYPEOFCHANGE_GEDCOM) && this.refreshFlag) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(this.getClass(), (String)"GeoMapTopComponent.jRefreshButton.resultText"), NbBundle.getMessage(this.getClass(), (String)"GeoMapTopComponent.jRefreshButton.toolTipText"), 1);
                    GeoMapTopComponent.this.refreshFlag = false;
                }
            });
        }
    }

    private void applyFilters() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                GeoMapTopComponent.this.applyFiltersNow();
            }
        });
    }

    private void applyFiltersNow() {
        LOG.fine("GeoMap enter geopointList : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        if (this.isBusyRecalc) {
            return;
        }
        this.isBusyRecalc = true;
        String msg = NbBundle.getMessage(GeoMapTopComponent.class, (String)"filters.inprogress");
        this.jActiveFilters.setToolTipText(msg);
        this.geoPoints.clear();
        boolean filterIsOn = false;
        if (this.markers != null) {
            if (this.geoFilter.selectedSearch && this.findSearchWindow() == null) {
                this.geoFilter.selectedSearch = false;
            }
            this.geoFilter.calculatesIndividuals(this.getGedcom());
            for (int i = 0; i < this.markers.length; ++i) {
                GeoNodeObject geoNodeObject = this.markers[i];
                if (geoNodeObject.isEvent) continue;
                if (this.geoFilter.compliesNode(geoNodeObject)) {
                    GeoPoint wp = new GeoPoint(geoNodeObject);
                    this.geoPoints.add(wp);
                    continue;
                }
                filterIsOn = true;
            }
            this.displayMarkers();
            this.jActiveFilters.setVisible(filterIsOn);
            this.jActiveFilters.setToolTipText(msg);
            if (this.geoPoints.size() < this.markers.length) {
                msg = NbBundle.getMessage(GeoMapTopComponent.class, (String)"filters.Applied");
                msg = msg + " - ";
                msg = msg + this.geoFilter.getShortDescription();
                this.jActiveFilters.setToolTipText(msg);
            }
        }
        this.hoverPanel.setVisible(false);
        this.jRefreshButton.setEnabled(true);
        this.isBusyRecalc = false;
        LOG.fine("GeoMap exit GeopointList : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
    }

    private void displayMarkers() {
        LOG.fine("GeoMap enter displayList : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        WaypointPainter painter = new WaypointPainter();
        if (this.displayMarkers) {
            painter.setWaypoints(new HashSet<GeoPoint>(this.geoPoints));
            if (this.useNames) {
                painter.setRenderer((WaypointRenderer)new NameWaypointRenderer(this.markersSize, this.markersColor));
            } else {
                painter.setRenderer((WaypointRenderer)new NoNameWaypointRenderer(this.markersSize, this.markersColor));
            }
        }
        this.jXMapKit1.setAddressLocationPainter(painter);
        this.jXMapKit1.repaint();
        LOG.fine("GeoMap exit DisplayList : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
    }

    Set<GeoPosition> getPositionsFromMarkers() {
        if (this.markers == null) {
            return null;
        }
        HashSet<GeoPosition> set = new HashSet<GeoPosition>();
        for (int i = 0; i < this.markers.length; ++i) {
            GeoNodeObject geoNodeObject = this.markers[i];
            set.add(new GeoPosition(geoNodeObject.getLatitude().doubleValue(), geoNodeObject.getLongitude().doubleValue()));
        }
        return set;
    }

    private void setMouseListener() {
        GeoMouseInputListener mia = new GeoMouseInputListener();
        this.jXMapKit1.getMainMap().addMouseListener((MouseListener)mia);
        this.jXMapKit1.getMainMap().addMouseMotionListener((MouseMotionListener)mia);
    }

    public void showMarker(GeoNodeObject geoNodeObject) {
        if (geoNodeObject != null && !geoNodeObject.isEvent) {
            this.hoverPanel.setPanel(geoNodeObject, this.markersColor);
            JXMapViewer map = this.jXMapKit1.getMainMap();
            GeoPosition gpm = geoNodeObject.getGeoPosition();
            Point2D gp_pt = map.getTileFactory().geoToPixel(gpm, map.getZoom());
            Rectangle rect = map.getViewportBounds();
            Point converted_gp_pt = new Point((int)gp_pt.getX() - rect.x, (int)gp_pt.getY() - rect.y);
            map.setLayout(null);
            this.hoverPanel.setSize(this.hoverPanel.getPreferredSize());
            this.hoverPanel.setLocation(converted_gp_pt.x + this.markersSize + 5, converted_gp_pt.y - 35);
            this.hoverPanel.setVisible(true);
        } else {
            this.hoverPanel.setVisible(false);
        }
    }

    public void centerMarker(GeoNodeObject geoNodeObject) {
        if (geoNodeObject != null) {
            this.jXMapKit1.getMainMap().setCenterPosition(geoNodeObject.getGeoPosition());
        }
    }

    public void setZoom(int zoom) {
        this.jXMapKit1.getMainMap().setZoom(zoom);
    }

    private void setPopuMenu() {
        this.popupMenu = new MapPopupMenu(this.jXMapKit1.getMainMap());
        this.popupMenu.addSubmenu("ACTION_MapSearchNearby");
        this.popupMenu.add(new MapPopupAction("ACTION_MapCopyPoint", null, this.popupMenu));
    }

    private void showSettings() {
        SettingsPanel settingsPanel = new SettingsPanel(this);
        this.settingsDialog = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITL_Setting"), (JComponent)settingsPanel).setOptionType(10).setDialogId(SettingsPanel.class);
        this.settingsDialog.show();
        settingsPanel.saveDates();
        this.geoFilter.save();
    }

    public Color getMarkersColor() {
        return this.markersColor;
    }

    public void setMarkersColor(Color c) {
        this.markersColor = c;
        if (c != null) {
            this.registry.put("GEO.markers.color", c);
            this.displayMarkers();
        }
    }

    public int getMarkersSize() {
        return this.markersSize;
    }

    public void setMarkersSize(int s) {
        this.markersSize = s;
        if (s > 1 && s <= this.markersSizeMax) {
            this.registry.put("GEO.markers.size", this.markersSize);
            this.displayMarkers();
        }
    }

    public boolean getResizeWithZoom() {
        return this.resizeWithZoom;
    }

    public void setResizeWithZoom(boolean selected) {
        this.resizeWithZoom = selected;
        this.registry.put("GEO.markers.resizeWithZoom", Boolean.valueOf(this.resizeWithZoom));
        if (this.resizeWithZoom) {
            this.resizeWithZoom();
        }
    }

    public void resizeWithZoom() {
        int z = this.jXMapKit1.getMainMap().getZoom();
        int s = this.markersSize;
        switch (z) {
            case 1: {
                s = 50;
                break;
            }
            case 2: {
                s = 49;
                break;
            }
            case 3: {
                s = 47;
                break;
            }
            case 4: {
                s = 45;
                break;
            }
            case 5: {
                s = 40;
                break;
            }
            case 6: {
                s = 35;
                break;
            }
            case 7: {
                s = 30;
                break;
            }
            case 8: {
                s = 20;
                break;
            }
            case 9: {
                s = 12;
                break;
            }
            case 10: {
                s = 8;
                break;
            }
            case 11: {
                s = 6;
                break;
            }
            case 12: {
                s = 5;
                break;
            }
            case 13: {
                s = 4;
                break;
            }
            case 14: {
                s = 3;
                break;
            }
            case 15: {
                s = 2;
            }
        }
        this.setMarkersSize(s);
    }

    public GeoFilter getFilter() {
        return this.geoFilter;
    }

    public void setShownUnknown(boolean selected) {
        this.geoFilter.showUnknown = selected;
        this.applyFilters();
    }

    public void setFilterAscendants(boolean selected) {
        this.geoFilter.ascendants = selected;
        this.applyFilters();
    }

    void setFilterDescendants(boolean selected) {
        this.geoFilter.descendants = selected;
        this.applyFilters();
    }

    public void setFilterCousins(boolean selected) {
        this.geoFilter.cousins = selected;
        this.applyFilters();
    }

    public void setFilterAncestors(boolean selected) {
        this.geoFilter.otherAncestors = selected;
        this.applyFilters();
    }

    public void setFilterSelectedIndi(boolean selected) {
        this.geoFilter.selectedIndividual = selected;
        this.applyFilters();
    }

    private SearchTopComponent findSearchWindow() {
        SearchTopComponent searchWindow = null;
        for (TopComponent tc : WindowManager.getDefault().getRegistry().getOpened()) {
            SearchTopComponent gltc;
            if (!(tc instanceof SearchTopComponent) || (gltc = (SearchTopComponent)tc).getGedcom() != this.getGedcom()) continue;
            searchWindow = gltc;
            break;
        }
        return searchWindow;
    }

    public void setFilterSelectedSearch(boolean selected) {
        if (selected) {
            SearchTopComponent searchWindow = this.findSearchWindow();
            if (searchWindow == null) {
                searchWindow = new SearchTopComponent();
            }
            if (!searchWindow.isOpen) {
                searchWindow.init(this.getContext());
                searchWindow.open();
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(this.getClass(), (String)"GeoMapTopComponent.jSelectionWindow.Message"), NbBundle.getMessage(this.getClass(), (String)"GeoMapTopComponent.jSelectionWindow.Title"), 1);
                searchWindow.requestActive();
                this.settingsDialog.cancel();
            }
        }
        this.geoFilter.selectedSearch = selected;
        this.applyFilters();
    }

    public void setFilterMales(boolean selected) {
        this.geoFilter.males = selected;
        this.applyFilters();
    }

    public String setFilterRootIndi() {
        Indi indi = this.geoFilter.askRootIndi();
        if (indi != null) {
            this.geoFilter.rootIndi = indi;
        }
        this.applyFilters();
        return indi.toString(true);
    }

    public String setFilterDeCujusIndi() {
        Indi indi = this.geoFilter.getDeCujusIndi();
        if (indi == null) {
            indi = this.geoFilter.getRootIndi();
        }
        if (indi != null) {
            this.geoFilter.rootIndi = indi;
        }
        this.applyFilters();
        return indi != null ? indi.toString(true) : "";
    }

    public String setFilterSelectedIndi() {
        Indi indi = this.geoFilter.getSelectedIndi();
        if (indi != null) {
            this.geoFilter.rootIndi = indi;
        }
        this.applyFilters();
        return indi.toString(true);
    }

    public void setFilterFemales(boolean selected) {
        this.geoFilter.females = selected;
        this.applyFilters();
    }

    public void setFilterYearStart(String text) {
        this.geoFilter.yearStart = text;
        this.applyFilters();
    }

    public void setFilterYearEnd(String text) {
        this.geoFilter.yearEnd = text;
        this.applyFilters();
    }

    public void setFilterBirths(boolean selected) {
        this.geoFilter.births = selected;
        this.applyFilters();
    }

    public void setFilterMarriages(boolean selected) {
        this.geoFilter.marriages = selected;
        this.applyFilters();
    }

    public void setFilterDeaths(boolean selected) {
        this.geoFilter.deaths = selected;
        this.applyFilters();
    }

    public void setFilterEvents(boolean selected) {
        this.geoFilter.otherEvents = selected;
        this.applyFilters();
    }

    public boolean getShowUnknown() {
        return this.geoFilter.showUnknown;
    }

    public boolean getFilterAscendants() {
        return this.geoFilter.ascendants;
    }

    public boolean getFilterDescendants() {
        return this.geoFilter.descendants;
    }

    public boolean getFilterCousins() {
        return this.geoFilter.cousins;
    }

    public boolean getFilterAncestors() {
        return this.geoFilter.otherAncestors;
    }

    public boolean getFilterSelectedIndi() {
        return this.geoFilter.selectedIndividual;
    }

    public boolean getFilterSearch() {
        return this.geoFilter.selectedSearch;
    }

    public boolean getFilterMales() {
        return this.geoFilter.males;
    }

    public boolean getFilterFemales() {
        return this.geoFilter.females;
    }

    public String getFilterYearStart() {
        return this.geoFilter.yearStart;
    }

    public String getFilterYearEnd() {
        return this.geoFilter.yearEnd;
    }

    public boolean getFilterBirths() {
        return this.geoFilter.births;
    }

    public boolean getFilterMarriages() {
        return this.geoFilter.marriages;
    }

    public boolean getFilterDeaths() {
        return this.geoFilter.deaths;
    }

    public boolean getFilterEvents() {
        return this.geoFilter.otherEvents;
    }

    public String getFilerRootIndi() {
        return this.geoFilter.getRootIndi().toString(true);
    }

    public String getSelectedIndividual() {
        return this.geoFilter.getSelectedIndi().toString(true);
    }

    public void showListAtLocation(final GeoNodeObject gno) {
        int delay = 0;
        GeoListTopComponent theList = null;
        for (TopComponent tc : WindowManager.getDefault().getRegistry().getOpened()) {
            GeoListTopComponent gltc;
            if (!(tc instanceof GeoListTopComponent) || (gltc = (GeoListTopComponent)tc).getGedcom() != this.getGedcom()) continue;
            theList = gltc;
            break;
        }
        if (theList == null) {
            theList = new GeoListTopComponent();
            delay = 500;
        }
        if (!theList.isInitialised()) {
            theList.init(this.getContext());
            theList.open();
        }
        theList.requestActive();
        final GeoListTopComponent tmpList = theList;
        if (delay != 0) {
            Timer timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tmpList.showLocation(gno);
                }
            });
            timer.setRepeats(false);
            timer.start();
        } else {
            tmpList.showLocation(gno);
        }
    }

    public String getFilterName() {
        this.filteredIndis = this.getIndisFromGeoPoints();
        return NbBundle.getMessage(GeoMapTopComponent.class, (String)"TTL_Filter", (Object)this.filteredIndis.size(), (Object)NbBundle.getMessage(GeoMapTopComponent.class, (String)"CTL_GeoMapTopComponent"));
    }

    public boolean veto(Entity entity) {
        if (this.filteredIndis == null) {
            this.filteredIndis = this.getIndisFromGeoPoints();
        }
        if (this.connectedEntities.isEmpty()) {
            for (Entity hit : this.filteredIndis) {
                this.connectedEntities.addAll(Utilities.getDependingEntitiesRecursively((Entity)hit));
            }
        }
        return !this.connectedEntities.contains(entity);
    }

    public boolean veto(Property property) {
        PropertyXRef xref;
        return property instanceof PropertyXRef && (xref = (PropertyXRef)property).isValid() && !this.connectedEntities.contains(xref.getTargetEntity());
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return gedcom != null && gedcom.equals(this.getGedcom());
    }

    private Set<Entity> getIndisFromGeoPoints() {
        HashSet<Entity> ret = new HashSet<Entity>();
        if (this.geoPoints == null || this.geoPoints.isEmpty()) {
            return ret;
        }
        for (GeoPoint gno : this.geoPoints) {
            for (GeoNodeObject event : gno.getGeoNodeObject().getFilteredEvents(this.geoFilter)) {
                if (!this.geoFilter.compliesEvent(event)) continue;
                ret.add(event.getProperty().getEntity());
            }
        }
        return ret;
    }

    private void checkConnection(boolean mute) {
        LOG.fine("GeoMap enter checkConnection : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        try {
            if (this.isBusyChecking) {
                return;
            }
            this.isBusyChecking = true;
            this.lastCheckTimeStamp = System.currentTimeMillis();
            LOG.fine("GeoMap check server : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
            URLConnection uc = this.osmUrl.openConnection();
            uc.setRequestProperty("User-Agent", ProjectProperties.INSTANCE.getName() + '/' + ProjectProperties.INSTANCE.getVersion());
            uc.getInputStream();
            LOG.fine("GeoMap end check server : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
        }
        catch (IOException ex) {
            if (!mute) {
                DialogManager.createError((String)(NbBundle.getMessage(GeoMapTopComponent.class, (String)"CTL_GeoMapTopComponent") + " - " + NbBundle.getMessage(GeoMapTopComponent.class, (String)"TITL_ConnectionError")), (String)NbBundle.getMessage(GeoMapTopComponent.class, (String)"MSG_ConnectionError")).show();
            }
            this.isConnectionOn = false;
            this.isBusyChecking = false;
            return;
        }
        this.isConnectionOn = true;
        this.isBusyChecking = false;
        LOG.fine("GeoMap exit checkConnexion : " + GeoMapTopComponent.displayTime(System.currentTimeMillis()));
    }

    private static String displayTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
        Date d = new Date(time);
        return df.format(d);
    }

    public static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    private class MapPopupAction
    extends AbstractAction {
        private String actionName = "";
        private MapPopupMenu mpm = null;
        private Toponym topo = null;

        public MapPopupAction(String name, Object o, MapPopupMenu mpm) {
            this.actionName = name;
            this.mpm = mpm;
            this.putValue("Name", NbBundle.getMessage(GeoMapTopComponent.class, (String)name, (Object)o));
        }

        public MapPopupAction(String name, Object o, MapPopupMenu mpm, Toponym topo) {
            this.actionName = "location";
            this.mpm = mpm;
            this.topo = topo;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.actionName.equals("ACTION_MapCopyPoint")) {
                Clipboard clipboard = GeoMapTopComponent.getClipboard();
                clipboard.setContents(new GeoToken(this.mpm.getGeoPoint()), null);
            } else if (this.topo != null) {
                Clipboard clipboard = GeoMapTopComponent.getClipboard();
                clipboard.setContents(new GeoToken(this.topo), null);
            }
        }
    }

    private class MapPopupMenu
    extends JPopupMenu {
        private JMenu submenu = null;
        private JXMapViewer map = null;
        private Point point = new Point(0, 0);

        public MapPopupMenu(JXMapViewer map) {
            this.map = map;
        }

        private void addSubmenu(String name) {
            this.submenu = new JMenu(NbBundle.getMessage(GeoMapTopComponent.class, (String)name));
            GeoMapTopComponent.this.popupMenu.add(this.submenu);
        }

        public void setPoint(Point point) {
            this.point = point;
            this.rebuildSubmenu(this.getGeoPoint());
            this.remove(1);
            this.add(new MapPopupAction("ACTION_MapCopyPoint", this.getCoordinates(), this));
        }

        public GeoPosition getGeoPoint() {
            return this.map.convertPointToGeoPosition((Point2D)this.point);
        }

        public String getCoordinates() {
            return this.getCoordinates(this.getGeoPoint());
        }

        public String getCoordinates(GeoPosition geoPoint) {
            Double lat = geoPoint != null ? geoPoint.getLatitude() : 0.0;
            Double lon = geoPoint != null ? geoPoint.getLongitude() : 0.0;
            char we = 'E';
            char ns = 'N';
            if (lat < 0.0) {
                lat = -lat.doubleValue();
                ns = 'S';
            }
            if (lon < 0.0) {
                lon = -lon.doubleValue();
                we = 'W';
            }
            DecimalFormat format = new DecimalFormat("0.00000");
            return ns + format.format(lat) + " " + we + format.format(lon);
        }

        private void rebuildSubmenu(final GeoPosition localGeoPoint) {
            final MapPopupMenu localPopupMenu = GeoMapTopComponent.this.popupMenu;
            final JMenu localSubmenu = this.submenu;
            this.submenu.removeAll();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    List<Toponym> topos = this.getToposNearbyPoint(localGeoPoint);
                    if (topos != null) {
                        TreeMap<String, Toponym> uniqueMap = new TreeMap<String, Toponym>();
                        for (Toponym toponym : topos) {
                            String name = toponym.getName() + " [" + MapPopupMenu.this.getCoordinates(new GeoPosition(toponym.getLatitude(), toponym.getLongitude())) + "]";
                            uniqueMap.put(name, toponym);
                        }
                        for (String name : uniqueMap.keySet()) {
                            localSubmenu.add(new MapPopupAction(name, localPopupMenu.getCoordinates(), localPopupMenu, (Toponym)uniqueMap.get(name)));
                        }
                    }
                }

                private List<Toponym> getToposNearbyPoint(GeoPosition localGeoPoint2) {
                    if (localGeoPoint2 == null) {
                        return null;
                    }
                    ArrayList<Toponym> topoList = new ArrayList();
                    try {
                        WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
                        topoList = WebService.findNearbyPlaceName((double)localGeoPoint2.getLatitude(), (double)localGeoPoint2.getLongitude(), (double)8.0, (int)15);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                    return topoList;
                }
            }).start();
        }
    }

    private class GeoMouseInputListener
    implements MouseInputListener {
        private GeoMouseInputListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                GeoMapTopComponent.this.popupMenu.setPoint(e.getPoint());
                GeoMapTopComponent.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (GeoMapTopComponent.this.geoPoints == null || GeoMapTopComponent.this.isBusyRecalc) {
                return;
            }
            JXMapViewer map = GeoMapTopComponent.this.jXMapKit1.getMainMap();
            GeoNodeObject geoNodeObject = null;
            Point converted_gp_pt = null;
            for (GeoPoint wp : GeoMapTopComponent.this.geoPoints) {
                GeoPosition gpm = wp.getGeoNodeObject().getGeoPosition();
                Point2D gp_pt = map.getTileFactory().geoToPixel(gpm, map.getZoom());
                Rectangle rect = map.getViewportBounds();
                converted_gp_pt = new Point((int)gp_pt.getX() - rect.x, (int)gp_pt.getY() - rect.y);
                if (!(converted_gp_pt.distance(e.getPoint()) < (double)(10 + GeoMapTopComponent.this.markersSize))) continue;
                geoNodeObject = wp.getGeoNodeObject();
                break;
            }
            if (geoNodeObject != null) {
                GeoMapTopComponent.this.hoverPanel.setPanel(geoNodeObject, GeoMapTopComponent.this.markersColor);
                map.setLayout(null);
                GeoMapTopComponent.this.hoverPanel.setSize(GeoMapTopComponent.this.hoverPanel.getPreferredSize());
                GeoMapTopComponent.this.hoverPanel.setLocation(converted_gp_pt.x + GeoMapTopComponent.this.markersSize + 5, converted_gp_pt.y - 35);
                GeoMapTopComponent.this.hoverPanel.setVisible(true);
            } else {
                GeoMapTopComponent.this.hoverPanel.setVisible(false);
            }
        }
    }
}

