/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.geo.GeoNode;
import ancestris.modules.geo.GeoNodeObject;
import ancestris.modules.geo.GeoPlacesList;
import ancestris.modules.geo.GeoPlacesListener;
import ancestris.util.EventUsage;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Gedcom;
import java.awt.BorderLayout;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class GeoListTopComponent
extends AncestrisTopComponent
implements ExplorerManager.Provider,
GeoPlacesListener,
PropertyChangeListener {
    static final String ICON_PATH = "ancestris/modules/geo/list.png";
    private static final String PREFERRED_ID = "GeoListTopComponent";
    private GeoPlacesList gpl = null;
    private int selectedNode = -1;
    private ExplorerManager mgr = new ExplorerManager();
    private boolean isInitialised = false;
    private static Map<String, EventUsage> eventUsages = null;
    private JScrollPane jScrollPane1;
    public static Comparator<GeoNodeObject> sortEvents = new Comparator<GeoNodeObject>(){

        @Override
        public int compare(GeoNodeObject o1, GeoNodeObject o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (eventUsages == null) {
                GeoListTopComponent.initEventUsages();
            }
            EventUsage eu1 = (EventUsage)eventUsages.get(o1.getEventTag());
            EventUsage eu2 = (EventUsage)eventUsages.get(o2.getEventTag());
            if (eu1 == null) {
                return 1;
            }
            if (eu2 == null) {
                return -1;
            }
            String s1 = eu1.getOrder() + o1.toDisplayString();
            String s2 = eu2.getOrder() + o2.toDisplayString();
            return s1.compareTo(s2);
        }
    };

    public GeoListTopComponent() {
        GeoListTopComponent.initEventUsages();
    }

    public String getAncestrisDockMode() {
        return "ancestris-output";
    }

    private static void initEventUsages() {
        eventUsages = new HashMap<String, EventUsage>();
        EventUsage.init(eventUsages);
    }

    public Image getImageIcon() {
        return ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public void setName() {
        this.setName(NbBundle.getMessage(GeoListTopComponent.class, (String)"CTL_GeoListTopComponent"));
    }

    public void setToolTipText() {
        this.setToolTipText(NbBundle.getMessage(GeoListTopComponent.class, (String)"HINT_GeoListTopComponent", (Object)(this.getGedcom() != null ? this.getGedcom().getDisplayName() : ""), (Object)(this.gpl != null ? this.gpl.getNodes().length : 0)));
    }

    public boolean createPanel() {
        this.initComponents();
        ((BeanTreeView)this.jScrollPane1).setSelectionMode(1);
        ((MyBeanTreeView)((Object)this.jScrollPane1)).setQuickSearchAllowed(true);
        this.initTree();
        this.isInitialised = true;
        return true;
    }

    private void initTree() {
        this.setPlaceFormatStartingWithCity();
        this.gpl = GeoPlacesList.getInstance(this.getGedcom());
        if (this.gpl.getNodes() == null) {
            this.gpl.launchPlacesSearch(0, true, false, null, null);
        } else {
            this.geoPlacesChanged(this.gpl, GeoPlacesList.TYPEOFCHANGE_GEDCOM);
        }
        this.gpl.addGeoPlacesListener(this);
    }

    @Override
    public void geoPlacesChanged(GeoPlacesList gpl, String change) {
        if (change.equals(GeoPlacesList.TYPEOFCHANGE_COORDINATES) || change.equals(GeoPlacesList.TYPEOFCHANGE_NAME) || change.equals(GeoPlacesList.TYPEOFCHANGE_GEDCOM)) {
            int currentNode = this.getSelectedNode();
            if (currentNode != -1 && currentNode != this.selectedNode) {
                this.selectedNode = currentNode;
            }
            this.mgr.setRootContext((Node)new GeoNode(gpl));
            ((BeanTreeView)this.jScrollPane1).setRootVisible(false);
            this.jScrollPane1.repaint();
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    GeoListTopComponent.this.jScrollPane1.updateUI();
                    GeoListTopComponent.this.selectNode(GeoListTopComponent.this.selectedNode);
                    GeoListTopComponent.this.setToolTipText();
                }
            });
        }
    }

    private int getSelectedNode() {
        Node[] geonodes = this.mgr.getSelectedNodes();
        if (geonodes.length == 0) {
            return -1;
        }
        GeoNodeObject selectedObj = (GeoNodeObject)geonodes[0].getLookup().lookup(GeoNodeObject.class);
        Node[] scannedNodes = this.mgr.getRootContext().getChildren().getNodes();
        for (int i = 0; i < scannedNodes.length; ++i) {
            Node node = scannedNodes[i];
            GeoNodeObject obj = (GeoNodeObject)node.getLookup().lookup(GeoNodeObject.class);
            if (!obj.equals(selectedObj)) continue;
            return i;
        }
        return -1;
    }

    private void selectNode(int nodeIndex) {
        Node[] scannedNodes;
        if (nodeIndex < 0) {
            nodeIndex = 0;
        }
        if (nodeIndex >= (scannedNodes = this.mgr.getRootContext().getChildren().getNodes()).length) {
            nodeIndex = scannedNodes.length - 1;
        }
        Node node = scannedNodes[nodeIndex];
        try {
            this.mgr.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void setPlaceFormatStartingWithCity() {
        String displayFormat = "";
        Gedcom gedcom = this.getGedcom();
        displayFormat = gedcom.getPlaceDisplayFormat();
        if (displayFormat == null) {
            gedcom.setPlaceDisplayFormat(gedcom.getPlaceDisplayFormatStartingWithCity());
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new MyBeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
    }

    public void componentOpened() {
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom != null) {
            GeoPlacesList gpl2 = GeoPlacesList.getInstance(this.getGedcom());
            GeoPlacesList.remove(gedcom);
            gpl2.removeGeoPlacesListener(this);
        }
        this.mgr.removePropertyChangeListener((PropertyChangeListener)this);
        AncestrisPlugin.unregister((Object)this);
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr;
    }

    public boolean isInitialised() {
        return this.isInitialised;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }

    public void showLocation(GeoNodeObject gno) {
        if (this.mgr == null || gno == null) {
            return;
        }
        Node rootNode = this.mgr.getRootContext();
        Node[] kids = rootNode.getChildren().getNodes();
        for (int i = 0; i < kids.length; ++i) {
            Node node = kids[i];
            ((BeanTreeView)this.jScrollPane1).collapseNode(node);
            GeoNodeObject obj = (GeoNodeObject)node.getLookup().lookup(GeoNodeObject.class);
            if (!obj.toDisplayString().equals(gno.toDisplayString())) continue;
            ((MyBeanTreeView)((Object)this.jScrollPane1)).setScrollOnExpand(true);
            ((MyBeanTreeView)((Object)this.jScrollPane1)).expandNode(node);
            try {
                this.mgr.setSelectedNodes(new Node[]{kids[kids.length - 1]});
                this.mgr.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean scroll) {
            this.tree.setScrollsOnExpand(scroll);
        }
    }
}

