/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.networksimplex;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.graphstream.algorithm.Dijkstra;
import org.graphstream.algorithm.networksimplex.NetworkSimplex;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;
import org.graphstream.stream.Sink;

public class DynamicOneToAllShortestPath
extends NetworkSimplex {
    protected String sourceId;

    public DynamicOneToAllShortestPath(String costName) {
        super(null, null, costName);
    }

    public String getSource() {
        return this.sourceId;
    }

    public void setSource(String sourceId) {
        this.sourceId = sourceId;
        if (this.nodes != null) {
            for (NetworkSimplex.NSNode node : this.nodes.values()) {
                this.changeSupply(node, node.id.equals(sourceId) ? this.nodes.size() - 1 : -1);
            }
        }
    }

    @Override
    protected void cloneGraph() {
        super.cloneGraph();
        for (NetworkSimplex.NSNode node : this.nodes.values()) {
            node.supply = node.id.equals(this.sourceId) ? this.nodes.size() - 1 : -1;
        }
    }

    protected void bfsFromDijkstra() {
        NetworkSimplex.NSNode node2;
        if (this.nodes.get(this.sourceId) == null) {
            return;
        }
        for (NetworkSimplex.NSArc arc : this.arcs.values()) {
            if (!arc.cost.isNegative()) continue;
            return;
        }
        Dijkstra dijkstra = new Dijkstra(Dijkstra.Element.EDGE, null, this.costName);
        dijkstra.init(this.graph);
        dijkstra.setSource(this.graph.getNode(this.sourceId));
        dijkstra.compute();
        HashMap<NetworkSimplex.NSNode, NetworkSimplex.NSNode> last = new HashMap<NetworkSimplex.NSNode, NetworkSimplex.NSNode>(4 * (this.nodes.size() + 1) / 3 + 1);
        last.put(this.root, this.root);
        this.root.thread = this.root;
        for (NetworkSimplex.NSNode node2 : this.nodes.values()) {
            last.put(node2, node2);
            node2.artificialArc.status = NetworkSimplex.ArcStatus.NONBASIC_LOWER;
            node2.artificialArc.flow = 0;
            node2.thread = node2;
        }
        for (NetworkSimplex.NSNode node2 : this.nodes.values()) {
            NetworkSimplex.NSNode parent;
            Node gNode = this.graph.getNode(node2.id);
            Object gParent = dijkstra.getParent(gNode);
            node2.parent = parent = gParent == null ? this.root : (NetworkSimplex.NSNode)this.nodes.get(gParent.getId());
            NetworkSimplex.NSArc arc = node2.artificialArc;
            if (gParent != null) {
                Object gEdge = dijkstra.getEdgeFromParent(gNode);
                arc = gEdge.getSourceNode() == gParent ? (NetworkSimplex.NSArc)this.arcs.get(gEdge.getId()) : (NetworkSimplex.NSArc)this.arcs.get("__NS_REVERSE_" + gEdge.getId());
            }
            node2.arcToParent = arc;
            arc.status = NetworkSimplex.ArcStatus.BASIC;
            this.nonBasicArcs.remove(arc);
            NetworkSimplex.NSNode nodeLast = (NetworkSimplex.NSNode)last.get(node2);
            nodeLast.thread = parent.thread;
            parent.thread = node2;
            NetworkSimplex.NSNode x = parent;
            while (last.get(x) == parent) {
                last.put(x, nodeLast);
                x = x.parent;
            }
        }
        last.clear();
        dijkstra.clear();
        NetworkSimplex.NSNode node3 = this.root.thread;
        while (node3 != this.root) {
            node3.depth = node3.parent.depth + 1;
            node3.computePotential();
            NetworkSimplex.NSNode x = node3;
            while (x != this.root) {
                ++x.arcToParent.flow;
                x = x.parent;
            }
            node3 = node3.thread;
        }
        NetworkSimplex.NSArc arc = ((NetworkSimplex.NSNode)this.nodes.get((Object)this.sourceId)).arcToParent;
        arc.flow = this.nodes.size() - arc.flow;
        this.objectiveValue.set(0L);
        node2 = this.root.thread;
        while (node2 != this.root) {
            this.objectiveValue.plusTimes(node2.arcToParent.flow, node2.arcToParent.cost);
            node2 = node2.thread;
        }
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
        this.cloneGraph();
        this.createInitialBFS();
        this.bfsFromDijkstra();
        graph.addSink((Sink)this);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        NetworkSimplex.NSNode node = new NetworkSimplex.NSNode(this, this.graph.getNode(nodeId));
        if (nodeId.equals(this.sourceId)) {
            node.supply = this.nodes.size();
            this.addNode(node);
        } else {
            node.supply = -1;
            this.addNode(node);
            NetworkSimplex.NSNode source = (NetworkSimplex.NSNode)this.nodes.get(this.sourceId);
            if (source != null) {
                this.changeSupply(source, this.nodes.size() - 1);
            }
        }
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        NetworkSimplex.NSNode source;
        this.removeNode((NetworkSimplex.NSNode)this.nodes.get(nodeId));
        if (!nodeId.equals(this.sourceId) && (source = (NetworkSimplex.NSNode)this.nodes.get(this.sourceId)) != null) {
            this.changeSupply(source, this.nodes.size() - 1);
        }
    }

    public long getPathLength(Node node) {
        NetworkSimplex.NSNode nsNode = (NetworkSimplex.NSNode)this.nodes.get(node.getId());
        if (nsNode.id.equals(this.sourceId)) {
            return 0L;
        }
        if (nsNode.parent == this.root) {
            return Long.MAX_VALUE;
        }
        return -nsNode.potential.small;
    }

    public <T extends Node> Iterator<T> getPathNodesIterator(Node target) {
        return new NodeIterator((NetworkSimplex.NSNode)this.nodes.get(target.getId()));
    }

    public <T extends Node> Iterable<T> getPathNodes(final Node target) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return DynamicOneToAllShortestPath.this.getPathNodesIterator(target);
            }
        };
    }

    public <T extends Edge> Iterator<T> getPathEdgesIterator(Node target) {
        return new EdgeIterator((NetworkSimplex.NSNode)this.nodes.get(target.getId()));
    }

    public <T extends Edge> Iterable<T> getPathEdges(final Node target) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return DynamicOneToAllShortestPath.this.getPathEdgesIterator(target);
            }
        };
    }

    public Path getPath(Node target) {
        Path path = new Path();
        if (this.getPathLength(target) == Long.MAX_VALUE) {
            return path;
        }
        Stack<Edge> stack = new Stack<Edge>();
        for (Edge e : this.getPathEdges(target)) {
            stack.push(e);
        }
        path.setRoot(this.graph.getNode(this.sourceId));
        while (!stack.isEmpty()) {
            path.add((Edge)stack.pop());
        }
        return path;
    }

    protected class EdgeIterator<T extends Edge>
    implements Iterator<T> {
        protected NetworkSimplex.NSNode nextNode;

        protected EdgeIterator(NetworkSimplex.NSNode target) {
            this.nextNode = target;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode.parent != DynamicOneToAllShortestPath.this.root;
        }

        @Override
        public T next() {
            if (this.nextNode.parent == DynamicOneToAllShortestPath.this.root) {
                throw new NoSuchElementException();
            }
            Edge edge = DynamicOneToAllShortestPath.this.graph.getEdge(this.nextNode.arcToParent.getOriginalId());
            this.nextNode = this.nextNode.parent;
            return (T)edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove");
        }
    }

    protected class NodeIterator<T extends Node>
    implements Iterator<T> {
        protected NetworkSimplex.NSNode nextNode;

        protected NodeIterator(NetworkSimplex.NSNode target) {
            this.nextNode = target.id.equals(DynamicOneToAllShortestPath.this.sourceId) || target.parent != DynamicOneToAllShortestPath.this.root ? target : DynamicOneToAllShortestPath.this.root;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != DynamicOneToAllShortestPath.this.root;
        }

        @Override
        public T next() {
            if (this.nextNode == DynamicOneToAllShortestPath.this.root) {
                throw new NoSuchElementException();
            }
            Node node = DynamicOneToAllShortestPath.this.graph.getNode(this.nextNode.id);
            this.nextNode = this.nextNode.parent;
            return (T)node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove");
        }
    }
}

