/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.ArrayList;
import java.util.HashMap;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;

public class SurpriseMeasure
implements Algorithm {
    public static final String ATTRIBUTE = "measure.surprise";
    private static final Object NULL = new Object();
    protected String communityAttributeKey;
    protected String surpriseAttributeKey;
    protected Graph graph;

    public SurpriseMeasure() {
        this("meta.index");
    }

    public SurpriseMeasure(String communityAttributeKey) {
        this(communityAttributeKey, ATTRIBUTE);
    }

    public SurpriseMeasure(String communityAttributeKey, String surpriseAttributeKey) {
        this.communityAttributeKey = communityAttributeKey;
        this.surpriseAttributeKey = surpriseAttributeKey;
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        int i;
        HashMap<Object, Integer> communities = new HashMap<Object, Integer>();
        ArrayList<Integer> communitiesCount = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.graph.getNodeCount(); ++i2) {
            Object community = this.graph.getNode(i2).getAttribute(this.communityAttributeKey);
            if (community == null) {
                community = NULL;
            }
            if (!communities.containsKey(community)) {
                communities.put(community, communities.size());
                communitiesCount.add(0);
            }
            int idx = (Integer)communities.get(community);
            communitiesCount.set(idx, (Integer)communitiesCount.get(idx) + 1);
        }
        if (communities.containsKey(NULL)) {
            System.err.printf("[WARNING] Some nodes do not have community.\n", new Object[0]);
        }
        double F = this.graph.getNodeCount() * (this.graph.getNodeCount() - 1) / 2;
        double p = 0.0;
        double M = 0.0;
        double n = this.graph.getEdgeCount();
        double S = 0.0;
        for (i = 0; i < this.graph.getEdgeCount(); ++i) {
            Object idx1;
            Edge e = this.graph.getEdge(i);
            Object idx0 = e.getNode0().getAttribute(this.communityAttributeKey);
            if (!idx0.equals(idx1 = e.getNode1().getAttribute(this.communityAttributeKey))) continue;
            p += 1.0;
        }
        for (i = 0; i < communitiesCount.size(); ++i) {
            int k = (Integer)communitiesCount.get(i);
            M += (double)(k * (k - 1) / 2);
        }
        double W = Math.min(M, n);
        S = SurpriseMeasure.cumulativeHypergeometricDistribution(p, W, F, n, M);
        S = -Math.log(S);
        this.graph.setAttribute(this.surpriseAttributeKey, new Object[]{S});
    }

    public double getSurprise() {
        if (this.graph == null) {
            throw new NullPointerException("Graph is null. Is this algorithm initialized ?");
        }
        if (!this.graph.hasNumber(this.surpriseAttributeKey)) {
            throw new RuntimeException("No surprise value found. Have you called the compute() method ?");
        }
        return this.graph.getNumber(this.surpriseAttributeKey);
    }

    public static double binomialCoefficient(double n, double r) {
        if (r > n) {
            return 0.0;
        }
        if (r == 0.0 || n == r) {
            return 1.0;
        }
        double C = n;
        double t = 1.0;
        int i = 1;
        while ((double)i < r) {
            C *= n - (double)i;
            t *= (double)(i + 1);
            ++i;
        }
        return C / t;
    }

    public static double hypergeometricDistribution(double x, double N2, double n, double k) {
        return SurpriseMeasure.binomialCoefficient(k, x) * SurpriseMeasure.binomialCoefficient(N2 - k, n - x) / SurpriseMeasure.binomialCoefficient(N2, n);
    }

    public static double cumulativeHypergeometricDistribution(double xStart, double xEnd, double N2, double n, double k) {
        double chd = 0.0;
        for (double x = xStart; x <= xEnd; x += 1.0) {
            chd += SurpriseMeasure.hypergeometricDistribution(x, N2, n, k);
        }
        return chd;
    }
}

