/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import org.graphstream.algorithm.APSP;
import org.graphstream.algorithm.util.RandomTools;
import org.graphstream.graph.BreadthFirstIterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.Sink;
import org.graphstream.ui.graphicGraph.GraphPosLengthUtils;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;

public class Toolkit
extends GraphPosLengthUtils {
    public static double weightedDegree(Node node, String weightAttribute) {
        return Toolkit.weightedDegree(node, weightAttribute, 1.0);
    }

    public static double weightedDegree(Node node, String weightAttribute, double defaultWeightValue) {
        double wdegree = 0.0;
        for (Edge edge : node.getEachEdge()) {
            if (edge.hasNumber(weightAttribute)) {
                if (edge.getSourceNode() == edge.getTargetNode()) {
                    wdegree += edge.getNumber(weightAttribute) * 2.0;
                    continue;
                }
                wdegree += edge.getNumber(weightAttribute);
                continue;
            }
            if (edge.getSourceNode() == edge.getTargetNode()) {
                wdegree += defaultWeightValue * 2.0;
                continue;
            }
            wdegree += defaultWeightValue;
        }
        return wdegree;
    }

    public static double enteringWeightedDegree(Node node, String weightAttribute) {
        return Toolkit.enteringWeightedDegree(node, weightAttribute, 1.0);
    }

    public static double enteringWeightedDegree(Node node, String weightAttribute, double defaultWeightValue) {
        double wdegree = 0.0;
        for (Edge edge : node.getEnteringEdgeSet()) {
            if (edge.hasNumber(weightAttribute)) {
                wdegree += edge.getNumber(weightAttribute);
                continue;
            }
            wdegree += defaultWeightValue;
        }
        return wdegree;
    }

    public static double leavingWeightedDegree(Node node, String weightAttribute) {
        return Toolkit.leavingWeightedDegree(node, weightAttribute, 1.0);
    }

    public static double leavingWeightedDegree(Node node, String weightAttribute, double defaultWeightValue) {
        double wdegree = 0.0;
        for (Edge edge : node.getLeavingEdgeSet()) {
            if (edge.hasNumber(weightAttribute)) {
                wdegree += edge.getNumber(weightAttribute);
                continue;
            }
            wdegree += defaultWeightValue;
        }
        return wdegree;
    }

    public static int[] degreeDistribution(Graph graph) {
        int d;
        if (graph.getNodeCount() == 0) {
            return null;
        }
        int max = 0;
        for (Node node : graph) {
            d = node.getDegree();
            if (d <= max) continue;
            max = d;
        }
        int[] dd = new int[max + 1];
        for (Node node : graph) {
            int n = d = node.getDegree();
            dd[n] = dd[n] + 1;
        }
        return dd;
    }

    public static ArrayList<Node> degreeMap(Graph graph) {
        ArrayList<Node> map = new ArrayList<Node>();
        for (Node node : graph) {
            map.add(node);
        }
        Collections.sort(map, new Comparator<Node>(){

            @Override
            public int compare(Node a, Node b) {
                return b.getDegree() - a.getDegree();
            }
        });
        return map;
    }

    public static ArrayList<Node> weightedDegreeMap(Graph graph, String weightAttribute, double defaultWeightValue) {
        ArrayList<Node> map = new ArrayList<Node>();
        for (Node node : graph) {
            map.add(node);
        }
        Collections.sort(map, new WeightComparator(weightAttribute, defaultWeightValue));
        return map;
    }

    public static ArrayList<Node> weightedDegreeMap(Graph graph, String weightAttribute) {
        return Toolkit.weightedDegreeMap(graph, weightAttribute, 1.0);
    }

    public static double averageDegree(Graph graph) {
        float m = graph.getEdgeCount() * 2;
        float n = graph.getNodeCount();
        if (n > 0.0f) {
            return m / n;
        }
        return 0.0;
    }

    public static double degreeAverageDeviation(Graph graph) {
        double average = Toolkit.averageDegree(graph);
        double sum = 0.0;
        for (Node node : graph) {
            double d = (double)node.getDegree() - average;
            sum += d * d;
        }
        return Math.sqrt(sum / (double)graph.getNodeCount());
    }

    public static double density(Graph graph) {
        float m = graph.getEdgeCount();
        float n = graph.getNodeCount();
        if (n > 0.0f) {
            return 2.0f * m / (n * (n - 1.0f));
        }
        return 0.0;
    }

    public static double[] clusteringCoefficients(Graph graph) {
        int n = graph.getNodeCount();
        if (n > 0) {
            int j = 0;
            double[] coefs = new double[n];
            for (Node node : graph) {
                coefs[j++] = Toolkit.clusteringCoefficient(node);
            }
            assert (j == n);
            return coefs;
        }
        return new double[0];
    }

    public static double averageClusteringCoefficient(Graph graph) {
        int n = graph.getNodeCount();
        if (n > 0) {
            double cc = 0.0;
            for (Node node : graph) {
                cc += Toolkit.clusteringCoefficient(node);
            }
            return cc / (double)n;
        }
        return 0.0;
    }

    public static double clusteringCoefficient(Node node) {
        double coef = 0.0;
        int n = node.getDegree();
        if (n > 1) {
            int i;
            Node[] nodes = new Node[n];
            for (i = 0; i < n; ++i) {
                nodes[i] = node.getEdge(i).getOpposite(node);
            }
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Edge e;
                    if (j == i || (e = nodes[j].getEdgeToward(nodes[i].getId())) == null || e.getSourceNode() != nodes[j]) continue;
                    coef += 1.0;
                }
            }
            coef /= (double)(n * (n - 1)) / 2.0;
        }
        return coef;
    }

    public static Node randomNode(Graph graph) {
        return Toolkit.randomNode(graph, new Random());
    }

    public static Node randomNode(Graph graph, Random random) {
        int n = graph.getNodeCount();
        if (n > 0) {
            return graph.getNode(random.nextInt(n));
        }
        return null;
    }

    public static Edge randomEdge(Graph graph) {
        return Toolkit.randomEdge(graph, new Random());
    }

    public static Edge randomEdge(Graph graph, Random random) {
        int n = graph.getEdgeCount();
        if (n > 0) {
            return graph.getEdge(random.nextInt(n));
        }
        return null;
    }

    public static Edge randomEdge(Node node) {
        return Toolkit.randomEdge(node, new Random());
    }

    public static Edge randomInEdge(Node node) {
        return Toolkit.randomInEdge(node, new Random());
    }

    public static Edge randomOutEdge(Node node) {
        return Toolkit.randomOutEdge(node, new Random());
    }

    public static Edge randomEdge(Node node, Random random) {
        int n = node.getDegree();
        if (n > 0) {
            return node.getEdge(random.nextInt(n));
        }
        return null;
    }

    public static Edge randomInEdge(Node node, Random random) {
        int n = node.getInDegree();
        if (n > 0) {
            return node.getEnteringEdge(random.nextInt(n));
        }
        return null;
    }

    public static Edge randomOutEdge(Node node, Random random) {
        int n = node.getOutDegree();
        if (n > 0) {
            return node.getLeavingEdge(random.nextInt(n));
        }
        return null;
    }

    public static HashMap<Object, HashSet<Node>> communities(Graph graph, String marker) {
        HashMap<Object, HashSet<Node>> communities = new HashMap<Object, HashSet<Node>>();
        for (Node node : graph) {
            HashSet<Object> community;
            Object communityMarker = node.getAttribute(marker);
            if (communityMarker == null) {
                communityMarker = "NULL_COMMUNITY";
            }
            if ((community = communities.get(communityMarker)) == null) {
                community = new HashSet();
                communities.put(communityMarker, community);
            }
            community.add(node);
        }
        return communities;
    }

    public static double[][] modularityMatrix(Graph graph, HashMap<Object, HashSet<Node>> communities) {
        return Toolkit.modularityMatrix(graph, communities, null);
    }

    public static double[][] modularityMatrix(Graph graph, HashMap<Object, HashSet<Node>> communities, String weightMarker) {
        double edgeCount = 0.0;
        if (weightMarker == null) {
            edgeCount = graph.getEdgeCount();
        } else {
            for (Edge e : graph.getEdgeSet()) {
                if (!e.hasAttribute(weightMarker)) continue;
                edgeCount += ((Double)e.getAttribute(weightMarker)).doubleValue();
            }
        }
        int communityCount = communities.size();
        double[][] E = new double[communityCount][];
        Object[] keys = new Object[communityCount];
        int k = 0;
        for (Object key : communities.keySet()) {
            keys[k++] = key;
        }
        for (int i = 0; i < communityCount; ++i) {
            E[i] = new double[communityCount];
        }
        for (int y = 0; y < communityCount; ++y) {
            for (int x = y; x < communityCount; ++x) {
                E[x][y] = Toolkit.modularityCountEdges(communities.get(keys[x]), communities.get(keys[y]), weightMarker);
                double[] dArray = E[x];
                int n = y;
                dArray[n] = dArray[n] / edgeCount;
                if (x == y) continue;
                E[y][x] = E[x][y] / 2.0;
                E[x][y] = E[y][x];
            }
        }
        return E;
    }

    public static double modularity(double[][] E) {
        double sumE = 0.0;
        double Tr = 0.0;
        double communityCount = E.length;
        int i = 0;
        while ((double)i < communityCount) {
            Tr += E[i][i];
            double a = 0.0;
            int j = 0;
            while ((double)j < communityCount) {
                a += E[i][j];
                ++j;
            }
            sumE += a * a;
            ++i;
        }
        return Tr - sumE;
    }

    public static double modularity(Graph graph, String marker) {
        return Toolkit.modularity(Toolkit.modularityMatrix(graph, Toolkit.communities(graph, marker)));
    }

    public static double modularity(Graph graph, String marker, String weightMarker) {
        return Toolkit.modularity(Toolkit.modularityMatrix(graph, Toolkit.communities(graph, marker), weightMarker));
    }

    protected static double modularityCountEdges(HashSet<Node> community, HashSet<Node> otherCommunity) {
        return Toolkit.modularityCountEdges(community, otherCommunity, null);
    }

    protected static double modularityCountEdges(HashSet<Node> community, HashSet<Node> otherCommunity, String weightMarker) {
        HashSet<Edge> marked = new HashSet<Edge>();
        float edgeCount = 0.0f;
        if (community != otherCommunity) {
            for (Node node : community) {
                for (Edge edge : node.getEdgeSet()) {
                    if (marked.contains(edge)) continue;
                    marked.add(edge);
                    if ((!community.contains(edge.getNode0()) || !otherCommunity.contains(edge.getNode1())) && (!community.contains(edge.getNode1()) || !otherCommunity.contains(edge.getNode0()))) continue;
                    if (weightMarker == null) {
                        edgeCount += 1.0f;
                        continue;
                    }
                    if (!edge.hasAttribute(weightMarker)) continue;
                    edgeCount = (float)((double)edgeCount + (Double)edge.getAttribute(weightMarker));
                }
            }
        } else {
            for (Node node : community) {
                for (Edge edge : node.getEdgeSet()) {
                    if (marked.contains(edge)) continue;
                    marked.add(edge);
                    if (!community.contains(edge.getNode0()) || !community.contains(edge.getNode1())) continue;
                    if (weightMarker == null) {
                        edgeCount += 1.0f;
                        continue;
                    }
                    if (!edge.hasAttribute(weightMarker)) continue;
                    edgeCount = (float)((double)edgeCount + (Double)edge.getAttribute(weightMarker));
                }
            }
        }
        return edgeCount;
    }

    public static double diameter(Graph graph) {
        return Toolkit.diameter(graph, null, false);
    }

    public static double diameter(Graph graph, String weightAttributeName, boolean directed) {
        double diameter = Double.MIN_VALUE;
        if (weightAttributeName == null) {
            int d = 0;
            for (Node node : graph) {
                d = Toolkit.unweightedEccentricity(node, directed);
                if (!((double)d > diameter)) continue;
                diameter = d;
            }
        } else {
            APSP apsp = new APSP(graph, weightAttributeName, directed);
            apsp.compute();
            for (Node node : graph) {
                APSP.APSPInfo info = (APSP.APSPInfo)node.getAttribute("APSPInfo");
                for (APSP.TargetPath path : info.targets.values()) {
                    if (!(path.distance > diameter)) continue;
                    diameter = path.distance;
                }
            }
        }
        return diameter;
    }

    public static int unweightedEccentricity(Node node, boolean directed) {
        BreadthFirstIterator k = new BreadthFirstIterator(node, directed);
        while (k.hasNext()) {
            k.next();
        }
        return k.getDepthMax();
    }

    public static boolean isClique(Collection<? extends Node> nodes) {
        if (nodes.isEmpty()) {
            return false;
        }
        for (Node node : nodes) {
            for (Node node2 : nodes) {
                if (node == node2 || node.getEdgeBetween(node2.getId()) != null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMaximalClique(Collection<? extends Node> nodes, Graph graph) {
        if (!Toolkit.isClique(nodes)) {
            return false;
        }
        for (Node x : graph) {
            String xId = x.getId();
            boolean isXConnectedToAll = true;
            for (Node node : nodes) {
                if (node != x && node.getEdgeBetween(xId) != null) continue;
                isXConnectedToAll = false;
                break;
            }
            if (!isXConnectedToAll) continue;
            return false;
        }
        return true;
    }

    public static <T extends Node> Iterator<List<T>> getMaximalCliqueIterator(Graph graph) {
        for (Edge edge : graph.getEachEdge()) {
            if (!edge.isLoop()) continue;
            throw new IllegalArgumentException("The graph must not have loop edges");
        }
        return new BronKerboschIterator(graph);
    }

    public static <T extends Node> Iterable<List<T>> getMaximalCliques(final Graph graph) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Toolkit.getMaximalCliqueIterator(graph);
            }
        };
    }

    public static <T extends Node> int getDegeneracy(Graph graph, List<T> ordering) {
        int n = graph.getNodeCount();
        if (ordering != null) {
            ordering.clear();
        }
        int maxDeg = 0;
        for (Node x : graph) {
            if (x.getDegree() <= maxDeg) continue;
            maxDeg = x.getDegree();
        }
        ArrayList<DegenEntry> heads = new ArrayList<DegenEntry>(maxDeg + 1);
        for (int d = 0; d <= maxDeg; ++d) {
            heads.add(null);
        }
        HashMap<Node, DegenEntry> map = new HashMap<Node, DegenEntry>(4 * (n + 2) / 3);
        for (Node x : graph) {
            DegenEntry entry = new DegenEntry();
            entry.node = x;
            entry.deg = x.getDegree();
            entry.addToList(heads);
            map.put(x, entry);
        }
        int degeneracy = 0;
        for (int j = 0; j < n; ++j) {
            DegenEntry entry;
            int i = 0;
            while ((entry = (DegenEntry)heads.get(i)) == null) {
                ++i;
            }
            if (i > degeneracy) {
                degeneracy = i;
            }
            entry.removeFromList(heads);
            entry.deg = -1;
            if (ordering != null) {
                ordering.add(entry.node);
            }
            Iterator neighborIt = entry.node.getNeighborNodeIterator();
            while (neighborIt.hasNext()) {
                Node x = (Node)neighborIt.next();
                DegenEntry entryX = (DegenEntry)map.get(x);
                if (entryX.deg == -1) continue;
                entryX.removeFromList(heads);
                --entryX.deg;
                entryX.addToList(heads);
            }
        }
        if (ordering != null) {
            Collections.reverse(ordering);
        }
        return degeneracy;
    }

    public static void fillAdjacencyMatrix(Graph graph, int[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            Arrays.fill(matrix[i], 0);
        }
        for (Edge e : graph.getEachEdge()) {
            int i = e.getSourceNode().getIndex();
            int j = e.getTargetNode().getIndex();
            int[] nArray = matrix[i];
            int n = j;
            nArray[n] = nArray[n] + 1;
            if (e.isDirected()) continue;
            int[] nArray2 = matrix[j];
            int n2 = i;
            nArray2[n2] = nArray2[n2] + 1;
        }
    }

    public static int[][] getAdjacencyMatrix(Graph graph) {
        int n = graph.getNodeCount();
        int[][] matrix = new int[n][n];
        Toolkit.fillAdjacencyMatrix(graph, matrix);
        return matrix;
    }

    public static void fillIncidenceMatrix(Graph graph, byte[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            Arrays.fill(matrix[i], (byte)0);
        }
        for (Edge e : graph.getEachEdge()) {
            int j = e.getIndex();
            byte[] byArray = matrix[e.getSourceNode().getIndex()];
            int n = j;
            byArray[n] = (byte)(byArray[n] + (e.isDirected() ? -1 : 1));
            byte[] byArray2 = matrix[e.getTargetNode().getIndex()];
            int n2 = j;
            byArray2[n2] = (byte)(byArray2[n2] + 1);
        }
    }

    public static byte[][] getIncidenceMatrix(Graph graph) {
        byte[][] matrix = new byte[graph.getNodeCount()][graph.getEdgeCount()];
        Toolkit.fillIncidenceMatrix(graph, matrix);
        return matrix;
    }

    public static void computeLayout(Graph g, Layout layout, double stab) {
        GraphReplay r = new GraphReplay(g.getId());
        stab = Math.min(stab, 1.0);
        layout.addAttributeSink((AttributeSink)g);
        r.addSink((Sink)layout);
        r.replay(g);
        r.removeSink((Sink)layout);
        layout.shake();
        layout.compute();
        do {
            layout.compute();
        } while (layout.getStabilization() < stab);
        layout.removeAttributeSink((AttributeSink)g);
    }

    public static void computeLayout(Graph g, double stab) {
        Toolkit.computeLayout(g, (Layout)new SpringBox(), stab);
    }

    public static void computeLayout(Graph g) {
        Toolkit.computeLayout(g, (Layout)new SpringBox(), 0.99);
    }

    public static <T extends Node> List<T> randomNodeSet(Graph graph, int k) {
        return Toolkit.randomNodeSet(graph, k, new Random());
    }

    public static <T extends Node> List<T> randomNodeSet(Graph graph, int k, Random random) {
        if (k < 0 || k > graph.getNodeCount()) {
            throw new IllegalArgumentException("k must be between 0 and " + graph.getNodeCount());
        }
        Set<Integer> subset = RandomTools.randomKsubset(graph.getNodeCount(), k, null, random);
        ArrayList<Node> result = new ArrayList<Node>(subset.size());
        for (int i : subset) {
            result.add(graph.getNode(i));
        }
        return result;
    }

    public static <T extends Node> List<T> randomNodeSet(Graph graph, double p) {
        return Toolkit.randomNodeSet(graph, p, new Random());
    }

    public static <T extends Node> List<T> randomNodeSet(Graph graph, double p, Random random) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be between 0 and 1");
        }
        Set<Integer> subset = RandomTools.randomPsubset(graph.getNodeCount(), p, null, random);
        ArrayList<Node> result = new ArrayList<Node>(subset.size());
        for (int i : subset) {
            result.add(graph.getNode(i));
        }
        return result;
    }

    public static <T extends Edge> List<T> randomEdgeSet(Graph graph, int k) {
        return Toolkit.randomEdgeSet(graph, k, new Random());
    }

    public static <T extends Edge> List<T> randomEdgeSet(Graph graph, int k, Random random) {
        if (k < 0 || k > graph.getEdgeCount()) {
            throw new IllegalArgumentException("k must be between 0 and " + graph.getEdgeCount());
        }
        Set<Integer> subset = RandomTools.randomKsubset(graph.getEdgeCount(), k, null, random);
        ArrayList<Edge> result = new ArrayList<Edge>(subset.size());
        for (int i : subset) {
            result.add(graph.getEdge(i));
        }
        return result;
    }

    public static <T extends Edge> List<T> randomEdgeSet(Graph graph, double p) {
        return Toolkit.randomEdgeSet(graph, p, new Random());
    }

    public static <T extends Edge> List<T> randomEdgeSet(Graph graph, double p, Random random) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be between 0 and 1");
        }
        Set<Integer> subset = RandomTools.randomPsubset(graph.getEdgeCount(), p, null, random);
        ArrayList<Edge> result = new ArrayList<Edge>(subset.size());
        for (int i : subset) {
            result.add(graph.getEdge(i));
        }
        return result;
    }

    public static boolean isConnected(Graph graph) {
        if (graph.getNodeCount() == 0) {
            return true;
        }
        Iterator it = graph.getNode(0).getBreadthFirstIterator(false);
        int visited = 0;
        while (it.hasNext()) {
            it.next();
            ++visited;
        }
        return visited == graph.getNodeCount();
    }

    protected static class DegenEntry {
        Node node;
        int deg;
        DegenEntry prev;
        DegenEntry next;

        protected DegenEntry() {
        }

        protected void addToList(List<DegenEntry> heads) {
            DegenEntry oldHead = heads.get(this.deg);
            heads.set(this.deg, this);
            this.prev = null;
            this.next = oldHead;
            if (oldHead != null) {
                oldHead.prev = this;
            }
        }

        protected void removeFromList(List<DegenEntry> heads) {
            if (this.prev == null) {
                heads.set(this.deg, this.next);
            } else {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
        }
    }

    protected static class BronKerboschIterator<T extends Node>
    implements Iterator<List<T>> {
        protected Stack<StackElement<T>> stack;
        protected Stack<T> clique = new Stack();

        protected void constructNextClique() {
            while (!this.clique.isEmpty() && !this.stack.peek().moreCandidates()) {
                this.stack.pop();
                this.clique.pop();
            }
            StackElement<T> currentElement = this.stack.peek();
            while (currentElement.moreCandidates()) {
                this.clique.push(currentElement.currentCandidate());
                this.stack.push(currentElement.nextElement());
                currentElement.forward();
                currentElement = this.stack.peek();
            }
        }

        protected void constructNextMaximalClique() {
            do {
                this.constructNextClique();
            } while (!this.clique.isEmpty() && !this.stack.peek().excluded.isEmpty());
        }

        protected BronKerboschIterator(Graph graph) {
            this.stack = new Stack();
            StackElement initial = new StackElement();
            initial.candidates = new ArrayList(graph.getNodeCount());
            Toolkit.getDegeneracy(graph, initial.candidates);
            initial.excluded = new ArrayList();
            initial.setPivot();
            initial.candidateIndex = 0;
            initial.forwardIndex();
            this.stack.push(initial);
            this.constructNextMaximalClique();
        }

        @Override
        public boolean hasNext() {
            return !this.clique.isEmpty();
        }

        @Override
        public List<T> next() {
            if (this.clique.isEmpty()) {
                throw new NoSuchElementException();
            }
            ArrayList<T> result = new ArrayList<T>(this.clique);
            this.constructNextMaximalClique();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove");
        }
    }

    protected static class StackElement<T extends Node> {
        protected List<T> candidates;
        protected int candidateIndex;
        protected List<T> excluded;
        protected String pivotId;

        protected StackElement() {
        }

        protected boolean moreCandidates() {
            return this.candidateIndex < this.candidates.size();
        }

        protected T currentCandidate() {
            return (T)((Node)this.candidates.get(this.candidateIndex));
        }

        protected int nonNeighborCandidateCount(Node node) {
            int count = 0;
            String nodeId = node.getId();
            for (Node c : this.candidates) {
                if (c.getEdgeBetween(nodeId) != null) continue;
                ++count;
            }
            return count;
        }

        protected void setPivot() {
            int count;
            this.pivotId = null;
            int minCount = this.candidates.size() + 1;
            for (Node x : this.candidates) {
                count = this.nonNeighborCandidateCount(x);
                if (count >= minCount) continue;
                minCount = count;
                this.pivotId = x.getId();
            }
            for (Node x : this.excluded) {
                count = this.nonNeighborCandidateCount(x);
                if (count >= minCount) continue;
                minCount = count;
                this.pivotId = x.getId();
            }
        }

        protected boolean skipCurrentCandidate() {
            return this.currentCandidate().getEdgeBetween(this.pivotId) != null;
        }

        protected void forwardIndex() {
            while (this.moreCandidates() && this.skipCurrentCandidate()) {
                ++this.candidateIndex;
            }
        }

        protected StackElement<T> nextElement() {
            StackElement<T> next = new StackElement<T>();
            String currentId = this.currentCandidate().getId();
            next.candidates = new ArrayList<T>();
            for (Node x : this.candidates) {
                if (x.getEdgeBetween(currentId) == null) continue;
                next.candidates.add(x);
            }
            next.excluded = new ArrayList<T>();
            for (Node x : this.excluded) {
                if (x.getEdgeBetween(currentId) == null) continue;
                next.excluded.add(x);
            }
            next.setPivot();
            next.candidateIndex = 0;
            next.forwardIndex();
            return next;
        }

        protected void forward() {
            this.excluded.add(this.candidates.remove(this.candidateIndex));
            this.forwardIndex();
        }
    }

    private static class WeightComparator
    implements Comparator<Node> {
        private String weightAttribute = "weight";
        private double defaultWeightValue = 1.0;

        public WeightComparator(String watt, double dwv) {
            this.weightAttribute = watt;
            this.defaultWeightValue = dwv;
        }

        @Override
        public int compare(Node a, Node b) {
            double ba;
            double bw = Toolkit.weightedDegree(b, this.weightAttribute, this.defaultWeightValue);
            if (bw < (ba = Toolkit.weightedDegree(a, this.weightAttribute, this.defaultWeightValue))) {
                return -1;
            }
            if (bw > ba) {
                return 1;
            }
            return 0;
        }
    }
}

