/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.place.geonames;

import ancestris.api.place.Place;
import ancestris.api.place.SearchPlace;
import ancestris.libs.geonames.GeonamesOptions;
import ancestris.modules.place.geonames.GeonamesPlace;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import org.geonames.PostalCode;
import org.geonames.PostalCodeSearchCriteria;
import org.geonames.Style;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WebService;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class GeonamesResearcher
implements SearchPlace {
    private static final Toponym DEFAULT_TOPONYM = GeonamesResearcher.defaultToponym();
    private static final int MAX_ROWS = 20;
    private static final Logger LOG = Logger.getLogger(GeonamesResearcher.class.getName(), null);
    private RequestProcessor.Task theTask;
    private RequestProcessor RP = null;
    private static final String KEYMAP = "geonamesPlaceConversionMap";
    private CountryBias countryBias = null;
    private String username = "";

    public GeonamesResearcher() {
        if (this.RP == null) {
            this.RP = new RequestProcessor("GeonamesResearcher", 1, true);
        }
        this.username = GeonamesOptions.getInstance().getUserName();
        WebService.setUserName((String)this.username);
        this.countryBias = new CountryBias();
    }

    public RequestProcessor.Task getTask() {
        return this.theTask;
    }

    public Place searchMassPlace(String placePieces, String city, Place defaultPlace) {
        Place retPlace = defaultPlace;
        ToponymSearchCriteria searchCriteria = new ToponymSearchCriteria();
        searchCriteria.setStyle(Style.FULL);
        searchCriteria.setLanguage(Locale.getDefault().getLanguage().substring(0, 2));
        searchCriteria.setMaxRows(1);
        searchCriteria.setQ(placePieces);
        String bias = this.countryBias.getValue();
        if (!bias.isEmpty()) {
            searchCriteria.setCountryBias(bias);
        }
        boolean found = false;
        int cnt = 1;
        while (!found && cnt <= 2) {
            ToponymSearchResult toponymSearchResult = null;
            try {
                toponymSearchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("user does not exist")) {
                    DialogManager.createError((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_ErrorUser"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"MESS_ErrorUser", (Object)this.username)).show();
                } else if (e.getMessage() != null && e.getMessage().contains("user account not enabled")) {
                    DialogManager.createError((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_ErrorEnabled"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"MESS_ErrorEnabled", (Object)this.username)).show();
                } else if (e.getMessage() != null && e.getMessage().contains("hourly limit")) {
                    DialogManager.createError((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_ErrorLimit"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"MESS_ErrorLimit", (Object)this.username)).show();
                } else {
                    DialogManager.createError((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_ErrorOther"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"MESS_ErrorOther", (Object)e.getMessage())).show();
                    LOG.log(Level.SEVERE, "Error during geonames search.", e);
                }
                retPlace = null;
                break;
            }
            if (toponymSearchResult != null) {
                Toponym iTopo;
                Iterator iterator = toponymSearchResult.getToponyms().iterator();
                while (iterator.hasNext() && (iTopo = (Toponym)iterator.next()).getCountryCode() != null && !iTopo.getCountryCode().trim().isEmpty() && iTopo.getName() != null && !iTopo.getName().trim().isEmpty()) {
                    retPlace = new GeonamesPlace(iTopo);
                    this.countryBias.add(iTopo.getCountryCode());
                    found = true;
                }
            }
            if (found) continue;
            searchCriteria.setQ(city);
            ++cnt;
        }
        return retPlace;
    }

    public void searchIndividualPlace(String placePieces, List<Place> placesList, TaskListener taskListener) {
        String city = this.getFirstPiece(placePieces);
        Runnable runnable = () -> {
            try {
                ToponymSearchCriteria searchCriteria = new ToponymSearchCriteria();
                searchCriteria.setStyle(Style.FULL);
                searchCriteria.setLanguage(Locale.getDefault().getLanguage().substring(0, 2));
                searchCriteria.setMaxRows(20);
                searchCriteria.setQ(placePieces);
                ToponymSearchResult toponymSearchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
                for (Toponym iTopo : toponymSearchResult.getToponyms()) {
                    if (iTopo.getCountryCode() == null || iTopo.getCountryCode().trim().isEmpty() || iTopo.getName() == null || iTopo.getName().trim().isEmpty()) continue;
                    placesList.add(new GeonamesPlace(iTopo));
                }
                if (placesList.isEmpty()) {
                    searchCriteria.setQ(city);
                    toponymSearchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
                    for (Toponym iTopo : toponymSearchResult.getToponyms()) {
                        if (iTopo.getCountryCode() == null || iTopo.getCountryCode().trim().isEmpty() || iTopo.getName() == null || iTopo.getName().trim().isEmpty()) continue;
                        placesList.add(new GeonamesPlace(iTopo));
                    }
                }
                if (GeonamesOptions.getInstance().searchPostalCodes()) {
                    block4: for (Place place : placesList) {
                        PostalCodeSearchCriteria postalCodeSearchCriteria = new PostalCodeSearchCriteria();
                        postalCodeSearchCriteria.setStyle(Style.SHORT);
                        postalCodeSearchCriteria.setMaxRows(30);
                        String criteria = place.getName() + " " + place.getCountryCode();
                        postalCodeSearchCriteria.setPlaceName(criteria);
                        List postalCodeSearch = WebService.postalCodeSearch((PostalCodeSearchCriteria)postalCodeSearchCriteria);
                        for (PostalCode pc : postalCodeSearch) {
                            if (pc.getPlaceName().equals(place.getName())) {
                                ((GeonamesPlace)place).setPostalCode(pc);
                                continue block4;
                            }
                            if (pc.getLatitude() == Double.NaN || pc.getLongitude() == Double.NaN || !(Math.abs(place.getLatitude() - pc.getLatitude()) < 0.1) || !(Math.abs(place.getLongitude() - pc.getLongitude()) < 0.1)) continue;
                            ((GeonamesPlace)place).setPostalCode(pc);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("hourly limit")) {
                    DialogManager dm = DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_ErrorLimit"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"MESS_ErrorLimit", (Object)this.username));
                    dm.show();
                }
                LOG.log(Level.SEVERE, "Error during geonames search.", e);
            }
        };
        this.theTask = this.RP.create(runnable);
        this.theTask.addTaskListener(taskListener);
        this.theTask.schedule(0);
    }

    public Place searchNearestPlace(double latitude, double longitude) {
        WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
        try {
            List results = WebService.findNearbyPlaceName((double)latitude, (double)longitude);
            if (!results.isEmpty()) {
                int geonameId = ((Toponym)results.get(0)).getGeoNameId();
                Toponym toponym = WebService.get((int)geonameId, null, null);
                return new GeonamesPlace(toponym);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getGeonamesMapString(Gedcom gedcom) {
        return gedcom.getRegistry().get(KEYMAP, "");
    }

    public static String[] getGeonamesMap(Gedcom gedcom) {
        String[] format = null;
        String placeMap = GeonamesResearcher.getGeonamesMapString(gedcom);
        PlaceFormatConverterPanel pfc = new PlaceFormatConverterPanel(GeonamesPlace.getPlaceFormat(), gedcom.getPlaceFormat(), placeMap);
        pfc.setTextTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionTitle"));
        pfc.setLeftTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionLeftTitle"));
        pfc.setRightTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionRightTitle"));
        Object o = DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (JComponent)pfc).setMessageType(-1).show();
        if (o == DialogManager.OK_OPTION) {
            String map = pfc.getConversionMapAsString();
            if (!map.replace(",", "").trim().isEmpty()) {
                gedcom.getRegistry().put(KEYMAP, map);
                format = PropertyPlace.getFormat((String)map);
            } else if (placeMap.isEmpty()) {
                DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"ERR_EmptyConversion")).setMessageType(0).show();
            } else {
                DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"ERR_NothingSaved")).setMessageType(0).show();
            }
        }
        return format;
    }

    private String getFirstPiece(String text) {
        String[] bits;
        for (String bit : bits = text.split(" ")) {
            String str = bit.replaceAll("[0-9]", "");
            if (str.length() <= 1) continue;
            return str;
        }
        return text;
    }

    private String getFirstCode(String text) {
        String[] bits;
        for (String bit : bits = text.split(" ")) {
            String str = bit.replaceAll("[^0-9]", "");
            if (str.length() <= 1) continue;
            return str;
        }
        return "";
    }

    public Place defaultPlace() {
        return new GeonamesPlace(DEFAULT_TOPONYM);
    }

    private static Toponym defaultToponym() {
        Toponym topo = new Toponym();
        topo.setLatitude(45.0);
        topo.setLongitude(-4.0);
        topo.setPopulation(Long.getLong("0"));
        return topo;
    }

    private static class CountryBias {
        private HashMap<String, Integer> map = new HashMap();

        private CountryBias() {
        }

        public void add(String country) {
            Integer count = this.map.get(country);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.map.put(country, count);
        }

        public String getValue() {
            int max = 0;
            String countryBias = "";
            for (String str : this.map.keySet()) {
                if (this.map.get(str) <= max) continue;
                max = this.map.get(str);
                countryBias = str;
            }
            return countryBias;
        }
    }
}

