/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.models.MultiMediaObjectsTableModel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.modules.editors.genealogyeditor.utilities.AriesFilterPanel;
import ancestris.modules.editors.genealogyeditor.utilities.FilterToolBar;
import genj.gedcom.Media;
import genj.gedcom.Property;
import java.awt.Color;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class MultimediaObjectTablePanel
extends JPanel
implements AriesFilterPanel {
    private final MultiMediaObjectsTableModel mMultiMediaObjectsTableModel = new MultiMediaObjectsTableModel();
    private final TableRowSorter<TableModel> objetTableSorter;
    private JScrollPane MultimediaObjectTableScrollPane;
    private FilterToolBar filterToolBar;
    private EditorTable multimediaObjectsTable;

    public MultimediaObjectTablePanel() {
        this.initComponents();
        this.multimediaObjectsTable.setID(MultimediaObjectTablePanel.class.getName());
        this.objetTableSorter = new TableRowSorter<TableModel>(this.multimediaObjectsTable.getModel());
        this.multimediaObjectsTable.setRowSorter(this.objetTableSorter);
    }

    private void initComponents() {
        this.filterToolBar = new FilterToolBar(this);
        this.MultimediaObjectTableScrollPane = new JScrollPane();
        this.multimediaObjectsTable = new EditorTable();
        this.multimediaObjectsTable.setModel(this.mMultiMediaObjectsTableModel);
        this.multimediaObjectsTable.setSelectionBackground(new Color(89, 142, 195));
        this.MultimediaObjectTableScrollPane.setViewportView(this.multimediaObjectsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MultimediaObjectTableScrollPane, GroupLayout.Alignment.TRAILING, -1, 539, Short.MAX_VALUE).addComponent(this.filterToolBar, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.filterToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.MultimediaObjectTableScrollPane, -2, 155, -2)));
    }

    public void set(Property root, List<Media> MultimediaObjectsList) {
        this.mMultiMediaObjectsTableModel.clear();
        this.mMultiMediaObjectsTableModel.addAll(MultimediaObjectsList);
    }

    public Media getSelectedMultiMediaObject() {
        int selectedRow = this.multimediaObjectsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.multimediaObjectsTable.convertRowIndexToModel(selectedRow);
            return this.mMultiMediaObjectsTableModel.getValueAt(rowIndex);
        }
        return null;
    }

    @Override
    public ComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(this.mMultiMediaObjectsTableModel.getColumnsName());
    }

    @Override
    public void filter(int index, String searchFilter) {
        RowFilter rf;
        try {
            rf = RowFilter.regexFilter("(?i)" + searchFilter, index);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.objetTableSorter.setRowFilter(rf);
    }
}

