/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.models.IndividualsTableModel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.modules.editors.genealogyeditor.utilities.AriesFilterPanel;
import ancestris.modules.editors.genealogyeditor.utilities.FilterToolBar;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.util.Exceptions;

public class IndividualsTablePanel
extends JPanel
implements AriesFilterPanel {
    private final IndividualsTableModel mIndividualsTableModel = new IndividualsTableModel();
    private Property mRoot;
    Indi mIndividual;
    private final TableRowSorter<TableModel> mPlaceTableSorter;
    private JButton addIndividualButton;
    private JButton deleteIndividualButton;
    private JButton editIndividualButton;
    private FilterToolBar filterToolBar;
    private JToolBar individualsEditToolBar;
    private EditorTable individualsTable;
    private JScrollPane individualsTableScrollPane;
    private JToolBar individualsToolBar;

    public IndividualsTablePanel() {
        this.initComponents();
        this.individualsTable.setID(IndividualsTablePanel.class.getName());
        this.mPlaceTableSorter = new TableRowSorter<TableModel>(this.individualsTable.getModel());
        this.individualsTable.setRowSorter(this.mPlaceTableSorter);
    }

    private void initComponents() {
        this.individualsToolBar = new JToolBar();
        this.individualsEditToolBar = new JToolBar();
        this.addIndividualButton = new JButton();
        this.editIndividualButton = new JButton();
        this.deleteIndividualButton = new JButton();
        this.filterToolBar = new FilterToolBar(this);
        this.individualsTableScrollPane = new JScrollPane();
        this.individualsTable = new EditorTable();
        this.individualsToolBar.setFloatable(false);
        this.individualsToolBar.setRollover(true);
        this.individualsEditToolBar.setFloatable(false);
        this.individualsEditToolBar.setRollover(true);
        this.addIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addIndividualButton.setFocusable(false);
        this.addIndividualButton.setHorizontalTextPosition(0);
        this.addIndividualButton.setVerticalTextPosition(3);
        this.addIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.addIndividualButtonActionPerformed(evt);
            }
        });
        this.individualsEditToolBar.add(this.addIndividualButton);
        this.editIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editIndividualButton.setFocusable(false);
        this.editIndividualButton.setHorizontalTextPosition(0);
        this.editIndividualButton.setVerticalTextPosition(3);
        this.editIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.editIndividualButtonActionPerformed(evt);
            }
        });
        this.individualsEditToolBar.add(this.editIndividualButton);
        this.deleteIndividualButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteIndividualButton.setFocusable(false);
        this.deleteIndividualButton.setHorizontalTextPosition(0);
        this.deleteIndividualButton.setVerticalTextPosition(3);
        this.deleteIndividualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndividualsTablePanel.this.deleteIndividualButtonActionPerformed(evt);
            }
        });
        this.individualsEditToolBar.add(this.deleteIndividualButton);
        this.individualsToolBar.add(this.individualsEditToolBar);
        this.individualsToolBar.add(this.filterToolBar);
        this.individualsTable.setModel(this.mIndividualsTableModel);
        this.individualsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IndividualsTablePanel.this.individualsTableMouseClicked(evt);
            }
        });
        this.individualsTableScrollPane.setViewportView(this.individualsTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.individualsToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.individualsTableScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.individualsToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.individualsTableScrollPane, -1, 110, Short.MAX_VALUE)));
    }

    private void addIndividualButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    IndividualsTablePanel.this.mIndividual = (Indi)gedcom.createEntity("INDI");
                }
            });
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)this.mIndividual));
            if (individualEditor.showPanel()) {
                this.mIndividualsTableModel.add(this.mIndividual);
                this.editIndividualButton.setEnabled(true);
                this.deleteIndividualButton.setEnabled(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editIndividualButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.individualsTable.convertRowIndexToModel(this.individualsTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1) {
            Indi individual = this.mIndividualsTableModel.getValueAt(rowIndex);
            IndividualEditor individualEditor = new IndividualEditor();
            individualEditor.setContext(new Context((Entity)individual));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(individualEditor);
            individualEditor.showPanel();
            atc.getOpenEditors().remove((Object)individualEditor);
        }
    }

    private void deleteIndividualButtonActionPerformed(ActionEvent evt) {
    }

    private void individualsTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            int rowIndex = this.individualsTable.convertRowIndexToModel(this.individualsTable.getSelectedRow());
            Gedcom gedcom = this.mRoot.getGedcom();
            if (rowIndex != -1) {
                Indi individual = this.mIndividualsTableModel.getValueAt(rowIndex);
                IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(new Context((Entity)individual));
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(individualEditor);
                individualEditor.showPanel();
                atc.getOpenEditors().remove((Object)individualEditor);
            }
        }
    }

    public void set(Property root, List<Indi> individualsList) {
        this.mRoot = root;
        this.mIndividualsTableModel.clear(individualsList);
        this.mIndividualsTableModel.addAll(individualsList);
        if (this.mIndividualsTableModel.getRowCount() > 0) {
            this.editIndividualButton.setEnabled(true);
            this.deleteIndividualButton.setEnabled(true);
        } else {
            this.editIndividualButton.setEnabled(false);
            this.deleteIndividualButton.setEnabled(false);
        }
    }

    public Indi getSelectedIndividual() {
        int selectedRow = this.individualsTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.individualsTable.convertRowIndexToModel(selectedRow);
            return this.mIndividualsTableModel.getValueAt(rowIndex);
        }
        return null;
    }

    public void setToolBarVisible(boolean visible) {
        this.individualsEditToolBar.setVisible(visible);
    }

    @Override
    public ComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(this.mIndividualsTableModel.getColumnsName());
    }

    @Override
    public void filter(int index, String searchFilter) {
        RowFilter rf;
        try {
            rf = RowFilter.regexFilter("(?i)" + searchFilter, index);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.mPlaceTableSorter.setRowFilter(rf);
    }
}

