/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertySource;
import genj.gedcom.TagPath;
import java.io.IOException;
import java.util.List;

public class ImportMyHeritage
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importmyheritage_name();
    }

    protected String getImportComment() {
        return Bundle.importmyheritage_note();
    }

    protected void init() {
        super.init();
        this.invalidPaths.add("FAM:NCHI:NOTE");
        this.invalidPaths.add("ALBUM:TITL");
    }

    protected void firstPass() {
        super.firstPass();
    }

    protected boolean process() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        if ("_ALBUM".equalsIgnoreCase(tag)) {
            this.output.writeLine(this.input.getLevel(), "NOTE", valueBefore);
            String newTag = ":NOTE";
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + newTag, valueBefore, valueBefore));
            return true;
        }
        if ("ALBUM".equalsIgnoreCase(tag) || "_PUBLISH".equalsIgnoreCase(tag)) {
            String xref = this.currentXref;
            this.output.writeLine(this.input.getLevel(), xref, "NOTE", valueBefore);
            String newTag = "NOTE";
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + newTag, valueBefore, valueBefore));
            return true;
        }
        if (super.process()) {
            return true;
        }
        return this.processOther();
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.fixOther(gedcom);
    }

    public void complete() {
        super.complete();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    private boolean processOther() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        if ("RIN".equals(tag) && path.length() != 2) {
            this.fixes.add(new ImportFix(this.currentXref, "invalidTagLocation.1", pathBefore, path.getParent().getShortName() + ":_RIN", valueBefore, valueBefore));
            return true;
        }
        return false;
    }

    public boolean fixOther(Gedcom gedcom) {
        boolean hasErrors = false;
        List sourceLinks = gedcom.getPropertiesByClass(PropertySource.class);
        for (PropertySource ps : sourceLinks) {
            Property[] props = ps.getProperties("PAGE");
            if (props.length <= 1) continue;
            int cnt = 0;
            for (Property page : props) {
                if (++cnt <= 1) continue;
                String pathBefore = page.getPath(true).getShortName();
                String valueBefore = page.getValue();
                Property p = ps.addProperty("_PAGE", valueBefore);
                ps.delProperty(page);
                this.fixes.add(new ImportFix(ps.getEntity().getId(), "eventsCardinality.2", pathBefore, p.getPath(true).getParent().getShortName() + ":_PAGE", valueBefore, valueBefore));
                hasErrors = true;
            }
        }
        return hasErrors;
    }
}

