/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;

abstract class TabLayoutManager {
    protected final List<SingleRowTabTable> rows;
    protected final Container container;
    protected final TabDataModel tabModel;
    private final Timer layoutTimer;

    public static TabLayoutManager create(List<SingleRowTabTable> rows, Container container, TabDataModel tabModel) {
        if (Settings.getDefault().isTabRowPerProject()) {
            return new RowPerProjectTabLayoutManager(rows, container, tabModel);
        }
        return new FlowTabLayoutManager(rows, container, tabModel);
    }

    protected TabLayoutManager(List<SingleRowTabTable> rows, Container container, TabDataModel tabModel) {
        this.rows = rows;
        this.container = container;
        this.tabModel = tabModel;
        this.layoutTimer = new Timer(350, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabLayoutManager.this.doLayout();
            }
        });
        this.layoutTimer.setRepeats(false);
    }

    Rectangle getTabBounds(int tabIndex) {
        TabData tab = this.tabModel.getTab(tabIndex);
        if (null == tab) {
            return null;
        }
        for (SingleRowTabTable table : this.rows) {
            if (!table.hasTabIndex(tabIndex)) continue;
            Rectangle rect = table.getTabBounds(tabIndex);
            if (null != rect) {
                rect = SwingUtilities.convertRectangle(table, rect, this.container);
            }
            return rect;
        }
        return null;
    }

    TabData getTabAt(Point p) {
        for (TabTable tabTable : this.rows) {
            Point location;
            if (!tabTable.contains(location = SwingUtilities.convertPoint(this.container, p, tabTable))) continue;
            return tabTable.getTabAt(location);
        }
        return null;
    }

    final void resizeContainer() {
        JComponent c = (JComponent)this.container.getParent();
        c.invalidate();
        c.revalidate();
        c.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidate() {
        Timer timer = this.layoutTimer;
        synchronized (timer) {
            if (this.layoutTimer.isRunning()) {
                this.layoutTimer.restart();
                return;
            }
            this.layoutTimer.start();
        }
    }

    protected abstract void doLayout();

    private static class FlowTabLayoutManager
    extends TabLayoutManager {
        private final TabDataRenderer renderer = new TabDataRenderer();
        private final int columnPadding;

        FlowTabLayoutManager(List<SingleRowTabTable> rows, Container container, TabDataModel tabModel) {
            super(rows, container, tabModel);
            this.columnPadding = new JTable().getIntercellSpacing().width;
            container.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.invalidate();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }

        @Override
        protected void doLayout() {
            int rowCount = this.rows.size();
            int availableWidth = this.container.getWidth();
            int currentRow = 0;
            int[] rowWidth = new int[rowCount];
            int[] lastIndexInRow = new int[rowCount];
            Arrays.fill(lastIndexInRow, -1);
            int tabCount = this.tabModel.size();
            int[] tabWidth = new int[tabCount];
            for (int i = 0; i < tabCount; ++i) {
                int colWidth;
                TabData td = this.tabModel.getTab(i);
                tabWidth[i] = colWidth = this.renderer.getPreferredWidth(td) + this.columnPadding;
            }
            int tabIndex = 0;
            while (tabIndex < tabCount) {
                int width = tabWidth[tabIndex];
                if (width + rowWidth[currentRow] <= availableWidth || width > availableWidth) {
                    lastIndexInRow[currentRow] = tabIndex++;
                    int n = currentRow;
                    rowWidth[n] = rowWidth[n] + width;
                    continue;
                }
                if (++currentRow < rowCount) continue;
                break;
            }
            if (tabIndex < tabCount) {
                currentRow = 0;
                while (true) {
                    int n = currentRow;
                    lastIndexInRow[n] = lastIndexInRow[n] + 1;
                    int n2 = currentRow;
                    rowWidth[n2] = rowWidth[n2] + tabWidth[lastIndexInRow[currentRow]];
                    availableWidth = Math.max(availableWidth, rowWidth[currentRow]);
                    for (int i = currentRow + 1; i < rowCount; ++i) {
                        lastIndexInRow[i] = -1;
                        rowWidth[i] = 0;
                    }
                    tabIndex = lastIndexInRow[currentRow] + 1;
                    int nextRow = currentRow + 1;
                    while (tabIndex < tabCount) {
                        int width = tabWidth[tabIndex];
                        if (width + rowWidth[nextRow] <= availableWidth || width > availableWidth) {
                            lastIndexInRow[nextRow] = tabIndex++;
                            int n3 = nextRow;
                            rowWidth[n3] = rowWidth[n3] + width;
                            continue;
                        }
                        if (++nextRow < rowCount) continue;
                        break;
                    }
                    if (tabIndex >= tabCount) break;
                    if (++currentRow < rowCount - 1) continue;
                    currentRow = 0;
                }
            }
            ArrayList<Integer> tabs = new ArrayList<Integer>(tabCount);
            int prevTab = -1;
            for (int i = 0; i < lastIndexInRow.length; ++i) {
                tabs.clear();
                for (int j = prevTab + 1; j <= lastIndexInRow[i]; ++j) {
                    tabs.add(j);
                }
                ((SingleRowTabTable)this.rows.get(i)).setTabs(tabs);
                prevTab = lastIndexInRow[i];
            }
            this.resizeContainer();
        }
    }

    private static class RowPerProjectTabLayoutManager
    extends TabLayoutManager {
        public RowPerProjectTabLayoutManager(List<SingleRowTabTable> rows, Container container, TabDataModel tabModel) {
            super(rows, container, tabModel);
        }

        @Override
        protected void doLayout() {
            int i;
            if (this.rows.isEmpty()) {
                return;
            }
            ProjectSupport projectSupport = ProjectSupport.getDefault();
            List<ProjectSupport.ProjectProxy> projects = Arrays.asList(projectSupport.getOpenProjects());
            int tabCount = this.tabModel.size();
            int rowCount = this.rows.size();
            ArrayList[] rowIndexes = new ArrayList[rowCount];
            for (i = 0; i < rowCount; ++i) {
                rowIndexes[i] = new ArrayList(tabCount);
            }
            for (i = 0; i < tabCount; ++i) {
                TabData td = this.tabModel.getTab(i);
                ProjectSupport.ProjectProxy p = projectSupport.getProjectForTab(td);
                int index = projects.indexOf(p);
                index = index < 0 || index >= rowIndexes.length - 1 || rowCount == 1 ? 0 : ++index;
                rowIndexes[index].add(i);
            }
            for (i = 0; i < rowCount; ++i) {
                ((SingleRowTabTable)this.rows.get(i)).setTabs(rowIndexes[i]);
            }
            this.resizeContainer();
        }
    }
}

