/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;

public class GraphFileWriter {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private static final String UI_LABEL = "ui.label";
    private static final char COLON = ':';
    private final File out;
    private final GraphicGraph leGraphic;

    public GraphFileWriter(File fichierToWrite, GraphicGraph graphic) {
        this.out = fichierToWrite;
        this.leGraphic = graphic;
    }

    public void start(String gedcomName) {
        try (OutputStreamWriter bw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.out), StandardCharsets.UTF_8);){
            String line;
            bw.write(gedcomName + "\n");
            for (Node n : this.leGraphic.getEachNode()) {
                line = this.createNodeLine(n);
                bw.write(line);
            }
            for (Edge e : this.leGraphic.getEachEdge()) {
                line = this.createEdgeLine(e);
                bw.write(line);
            }
            bw.flush();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to write Graph File.", e);
        }
    }

    private String createNodeLine(Node node) {
        StringBuilder retour = new StringBuilder("N:");
        retour.append(node.getId()).append(':');
        String label = (String)node.getAttribute(UI_LABEL);
        retour.append(label).append(':');
        GraphicNode gn = (GraphicNode)this.leGraphic.getNode(node.getId());
        retour.append(gn.x).append(':');
        retour.append(gn.y).append(':');
        retour.append(gn.z).append(':');
        retour.append('\n');
        return retour.toString();
    }

    private String createEdgeLine(Edge edge) {
        StringBuilder retour = new StringBuilder("E:");
        retour.append(edge.getId()).append(':');
        retour.append(edge.getNode0().getId()).append(':');
        retour.append(edge.getNode1().getId()).append(':');
        retour.append('\n');
        return retour.toString();
    }
}

