/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import genj.gedcom.Gedcom;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class GraphFileReader {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private static final String COLON = ":";
    private final File in;
    private final Graph leGraphe;
    private final Gedcom leGedcom;

    public GraphFileReader(File fichierToRead, Graph graph, Gedcom gedcom) {
        this.in = fichierToRead;
        this.leGraphe = graph;
        this.leGedcom = gedcom;
    }

    public void start() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.in), StandardCharsets.UTF_8));){
            String st = br.readLine();
            if (this.leGedcom.getName().equals(st)) {
                this.leGraphe.clear();
            } else {
                return;
            }
            while ((st = br.readLine()) != null) {
                this.manageLine(st);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to read Graph File.", e);
        }
        Object style = this.leGraphe.getAttribute("ui.stylesheet");
        this.leGraphe.setAttribute("ui.stylesheet", new Object[]{style});
        this.leGraphe.setAttribute("ui.antialias", new Object[0]);
    }

    private void manageLine(String line) {
        String[] split = line.split(COLON);
        if ("N".equals(split[0])) {
            this.createNode(split);
        }
        if ("E".equals(split[0])) {
            this.createEdge(split);
        }
    }

    private void createNode(String[] split) {
        if (this.leGedcom.getEntity(split[1]) == null) {
            return;
        }
        Node noeud = this.leGraphe.addNode(split[1]);
        if (!("0".equals(split[3]) && "0".equals(split[4]) && "0".equals(split[5]))) {
            noeud.addAttribute("xyz", new Object[]{Double.valueOf(split[3]), Double.valueOf(split[4]), Double.valueOf(split[5])});
        }
    }

    private void createEdge(String[] split) {
        if (this.leGraphe.getEdge(split[2]) == null || this.leGraphe.getEdge(split[3]) == null) {
            return;
        }
        this.leGraphe.addEdge(split[1], split[2], split[3]);
    }
}

