/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.spi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.java.html.BrwsrCtx;
import org.netbeans.html.json.spi.PropertyBinding;
import org.netbeans.html.json.spi.Proto;

public abstract class FunctionBinding {
    FunctionBinding() {
    }

    public abstract String getFunctionName();

    public abstract void call(Object var1, Object var2);

    public abstract FunctionBinding weak();

    static <M> FunctionBinding registerFunction(String name, int index, M model, Proto.Type<M> access) {
        return new Impl<M>(model, name, index, access);
    }

    private static abstract class AImpl<M>
    extends FunctionBinding {
        final String name;
        final Proto.Type<M> access;
        final int index;

        public AImpl(String name, int index, Proto.Type<M> access) {
            this.name = name;
            this.index = index;
            this.access = access;
        }

        protected abstract M model();

        @Override
        public String getFunctionName() {
            return this.name;
        }

        @Override
        public void call(final Object data, final Object ev) {
            final M model = this.model();
            if (model == null) {
                return;
            }
            BrwsrCtx ctx = this.access.protoFor(model).getContext();
            class Dispatch
            implements Runnable {
                Dispatch() {
                }

                @Override
                public void run() {
                    try {
                        AImpl.this.access.call(model, AImpl.this.index, data, ev);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
            ctx.execute((Runnable)new Dispatch());
        }
    }

    private static final class Impl<M>
    extends AImpl<M> {
        private final M model;

        public Impl(M model, String name, int index, Proto.Type<M> access) {
            super(name, index, access);
            this.model = model;
        }

        @Override
        protected M model() {
            return this.model;
        }

        @Override
        public FunctionBinding weak() {
            if (PropertyBinding.weakSupported) {
                return new Weak<M>(this.model, this.name, this.index, this.access);
            }
            return this;
        }
    }

    private static final class Weak<M>
    extends AImpl<M> {
        private final Reference<M> ref;

        public Weak(M model, String name, int index, Proto.Type<M> access) {
            super(name, index, access);
            this.ref = new WeakReference<M>(model);
        }

        @Override
        protected M model() {
            return this.ref.get();
        }

        @Override
        public FunctionBinding weak() {
            return this;
        }
    }
}

