/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyXRef;
import javax.swing.Icon;

public class CreateChild
extends CreateRelationship {
    private Entity parentOrFamily;
    private int sex;

    public CreateChild() {
        this(null, 0);
    }

    public CreateChild(Entity entity, int sex) {
        super(CreateChild.calcText(sex), "INDI");
        this.sex = sex;
        this.setImage((Icon)(sex == 1 ? PropertyChild.IMG_MALE : (sex == 2 ? PropertyChild.IMG_FEMALE : PropertyChild.IMG_UNKNOWN)));
        this.setContextProperties((Property)entity);
        this.contextChanged();
    }

    private static String calcText(int sex) {
        if (sex == 2) {
            return resources.getString("add.daughter");
        }
        if (sex == 1) {
            return resources.getString("add.son");
        }
        return resources.getString("add.child");
    }

    protected final void contextChanged() {
        this.parentOrFamily = null;
        if (this.contextProperties.size() == 1 && (this.contextProperties.get(0) instanceof Indi || this.contextProperties.get(0) instanceof Fam)) {
            this.parentOrFamily = (Entity)this.contextProperties.get(0);
        }
        if (this.parentOrFamily != null) {
            this.setEnabled(true);
            this.setTip(resources.getString("link", new Object[]{this.getDescription()}));
        } else {
            this.setEnabled(false);
            this.setTip(null);
        }
    }

    @Override
    public String getDescription() {
        if (this.parentOrFamily instanceof Indi) {
            return resources.getString(this.sex == 1 ? "add.son.of" : (this.sex == 2 ? "add.daughter.of" : "add.child.of"), new Object[]{this.parentOrFamily});
        }
        return resources.getString(this.sex == 1 ? "add.son.in" : (this.sex == 2 ? "add.daughter.in" : "add.child.in"), new Object[]{this.parentOrFamily});
    }

    @Override
    public String getWarning(Entity indi) {
        Fam fam;
        if (indi != null && (fam = ((Indi)indi).getFamilyWhereBiologicalChild()) != null) {
            return PropertyChild.getLabelChildAlreadyinFamily((Indi)((Indi)indi), (Fam)fam);
        }
        return null;
    }

    @Override
    protected Property change(Entity target, boolean targetIsNew) throws GedcomException {
        PropertyXRef CHIL;
        Fam family;
        Indi parent;
        Indi child = (Indi)target;
        Gedcom ged = child.getGedcom();
        if (this.parentOrFamily instanceof Indi) {
            parent = (Indi)this.parentOrFamily;
            Fam[] fams = parent.getFamiliesWhereSpouse();
            if (fams.length > 0) {
                family = fams[0];
                CHIL = family.addChild(child);
            } else {
                family = (Fam)ged.createEntity("FAM");
                try {
                    CHIL = family.addChild(child);
                }
                catch (GedcomException e) {
                    ged.deleteEntity((Entity)family);
                    throw e;
                }
                family.setSpouse(parent);
                family.setSpouse((Indi)ged.createEntity("INDI").addDefaultProperties());
            }
        } else {
            family = (Fam)this.parentOrFamily;
            CHIL = family.addChild(child);
        }
        if (targetIsNew) {
            parent = family.getHusband();
            if (parent == null) {
                parent = family.getWife();
            }
            if (parent != null) {
                child.setName("", parent.getLastName());
            }
            child.setSex(this.sex);
        }
        return CHIL.getTarget();
    }
}

