/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.feedback;

import ancestris.modules.feedback.PasswordPanel;
import ancestris.util.swing.DialogManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SendMailWorker
implements Runnable {
    private static final Logger logger = Logger.getLogger(SendMailWorker.class.getName());
    private String name;
    private String from;
    private String to;
    private String subject;
    private String messageBody;
    private File attachedZIP;
    private File attachedFile;
    private Preferences modulePreferences = NbPreferences.forModule(SendMailWorker.class);

    public SendMailWorker(String name, String from, String to, String subject, String messageBody, File attachedZIP, File attachedFile) {
        this.name = name;
        this.from = from;
        this.to = to;
        this.subject = subject;
        this.messageBody = messageBody;
        this.attachedZIP = attachedZIP;
        this.attachedFile = attachedFile;
    }

    @Override
    public void run() {
        if (!this.checkConnection()) {
            return;
        }
        Session session = null;
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"SendMailWorker.Sending-In-Progress"));
        if (this.modulePreferences.getBoolean("mail.host.TLSEncryption", false)) {
            logger.log(Level.INFO, "Get TLS session ...");
            session = this.createTLSSession();
        } else if (this.modulePreferences.getBoolean("mail.host.SSLEncryption", false)) {
            logger.log(Level.INFO, "Get SSL session ...");
            session = this.createSSLSession();
        } else {
            logger.log(Level.INFO, "Get no encryption session ...");
            session = this.createSession();
        }
        if (session == null) {
            logger.log(Level.INFO, "... canceled by user");
            return;
        }
        logger.log(Level.INFO, "... done");
        progressHandle.start();
        logger.log(Level.INFO, "create message ...");
        Message msg = this.createMessage(session);
        logger.log(Level.INFO, "... done");
        logger.log(Level.INFO, "sending ...");
        boolean ok = false;
        try {
            try {
                Transport.send((Message)msg);
                logger.log(Level.INFO, "... done");
                progressHandle.finish();
                DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"fb.title"), (String)NbBundle.getMessage(this.getClass(), (String)"fb.msg.thankyou")).show();
                ok = true;
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            progressHandle.finish();
            logger.log(Level.SEVERE, "{0}", ex);
            DialogManager.createError((String)NbBundle.getMessage(this.getClass(), (String)"fb.title"), (String)(NbBundle.getMessage(this.getClass(), (String)"fb.msg.senderror") + "\n(" + ex.getMessage() + ").")).show();
        }
        if (!ok) {
            progressHandle.finish();
            DialogManager.createError((String)NbBundle.getMessage(this.getClass(), (String)"fb.title"), (String)NbBundle.getMessage(this.getClass(), (String)"fb.msg.senderror")).show();
        }
    }

    private String getPassword() {
        PasswordPanel passwordPanel = new PasswordPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)passwordPanel, NbBundle.getMessage(this.getClass(), (String)"FeedBackPasswordPanel.title"));
        DialogDisplayer.getDefault().createDialog(dd);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (dd.getValue().equals(DialogDescriptor.OK_OPTION)) {
            return passwordPanel.getPassword();
        }
        return null;
    }

    private boolean checkConnection() {
        try {
            new URL("https://www.ancestris.org/").openStream();
        }
        catch (IOException ex) {
            DialogManager.createError((String)NbBundle.getMessage(this.getClass(), (String)"fb.title"), (String)(NbBundle.getMessage(this.getClass(), (String)"fb.nointernet") + "\n" + NbBundle.getMessage(this.getClass(), (String)"fb.msg.senderror"))).show();
            return false;
        }
        return true;
    }

    private Session createSSLSession() {
        Session session = null;
        Properties props = new Properties();
        props.put("mail.smtp.socketFactory.port", this.modulePreferences.get("mail.host.port", "465"));
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.host", this.modulePreferences.get("mail.host", ""));
        props.put("mail.smtp.port", this.modulePreferences.get("mail.host.port", "465"));
        if (this.modulePreferences.getBoolean("mail.host.AuthenticationRequired", false)) {
            logger.log(Level.INFO, "Authenticated SSL session");
            props.put("mail.smtp.auth", "true");
            final String password = this.getPassword();
            if (password == null) {
                return null;
            }
            session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SendMailWorker.this.modulePreferences.get("mail.host.login", "username"), password);
                }
            });
        } else {
            logger.log(Level.INFO, "SSL session without Authentication");
            props.put("mail.smtp.auth", "false");
            session = Session.getInstance((Properties)props, null);
        }
        return session;
    }

    private Session createTLSSession() {
        Session session = null;
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.port", this.modulePreferences.get("mail.host.port", "25"));
        props.put("mail.smtp.host", this.modulePreferences.get("mail.host", ""));
        if (this.modulePreferences.getBoolean("mail.host.AuthenticationRequired", false)) {
            logger.log(Level.INFO, "Authenticated TLS session");
            final String password = this.getPassword();
            if (password == null) {
                return null;
            }
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SendMailWorker.this.modulePreferences.get("mail.host.login", "username"), password);
                }
            });
        } else {
            logger.log(Level.INFO, "TLS session without Authentication");
            props.put("mail.smtp.auth", "false");
            session = Session.getInstance((Properties)props, null);
        }
        return session;
    }

    private Session createSession() {
        Session session = null;
        Properties props = new Properties();
        props.put("mail.smtp.host", this.modulePreferences.get("mail.host", ""));
        props.put("mail.smtp.port", this.modulePreferences.get("mail.host.port", "25"));
        if (this.modulePreferences.getBoolean("mail.host.AuthenticationRequired", false)) {
            logger.log(Level.INFO, "Authenticated session");
            props.put("mail.smtp.auth", "true");
            session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SendMailWorker.this.modulePreferences.get("mail.host.login", "username"), SendMailWorker.this.modulePreferences.get("mail.host.password", "password"));
                }
            });
        } else {
            logger.log(Level.INFO, "session without Authentication");
            props.put("mail.smtp.auth", "false");
            session = Session.getInstance((Properties)props, null);
        }
        return session;
    }

    private Message createMessage(Session session) {
        try {
            MimeMessage message = new MimeMessage(session);
            InternetAddress fromInternetAddress = new InternetAddress(this.from);
            logger.log(Level.INFO, "setFrom {0}", fromInternetAddress);
            message.setFrom((Address)fromInternetAddress);
            for (String recipient : this.to.split(",")) {
                InternetAddress recipientInternetAddress = new InternetAddress(recipient);
                logger.log(Level.INFO, "addRecipient {0}", recipientInternetAddress);
                message.addRecipient(Message.RecipientType.TO, (Address)recipientInternetAddress);
            }
            logger.log(Level.INFO, "setSubject {0}", this.subject);
            message.setSubject(this.subject);
            if (this.attachedZIP != null || this.attachedFile != null) {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(this.messageBody);
                MimeBodyPart mbp2 = null;
                MimeBodyPart mbp3 = null;
                if (this.attachedZIP != null) {
                    mbp2 = new MimeBodyPart();
                    mbp2.attachFile(this.attachedZIP);
                }
                if (this.attachedFile != null) {
                    mbp3 = new MimeBodyPart();
                    mbp3.attachFile(this.attachedFile);
                }
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                if (mbp2 != null) {
                    mp.addBodyPart((BodyPart)mbp2);
                }
                if (mbp3 != null) {
                    mp.addBodyPart((BodyPart)mbp3);
                }
                message.setContent((Multipart)mp);
                message.setHeader("X-Mailer", "smtpsend");
                message.setSentDate(new Date());
            } else {
                message.setText(this.messageBody);
            }
            return message;
        }
        catch (Exception ex) {
            DialogManager.createError((String)NbBundle.getMessage(this.getClass(), (String)"fb.title"), (String)(ex.getLocalizedMessage() + "\n\n" + NbBundle.getMessage(this.getClass(), (String)"fb.msg.senderror"))).show();
            logger.log(Level.INFO, ex.getLocalizedMessage());
            return null;
        }
    }
}

