/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.util.WordBuffer;
import genj.view.ViewContext;
import java.util.List;
import org.openide.util.NbBundle;

class TestDate
extends Test {
    static final int AFTER = 0;
    static final int BEFORE = 1;
    private TagPath path1;
    private TagPath path2;
    private int comparison;

    TestDate(String trigger, int comp, String path2) {
        this(new String[]{trigger}, null, comp, path2);
    }

    TestDate(String trigger, String path1, int comp, String path2) {
        this(new String[]{trigger}, path1, comp, path2);
    }

    TestDate(String[] triggers, int comp, String path2) {
        this(triggers, null, comp, path2);
    }

    TestDate(String[] triggers, String path1, int comp, String path2) {
        super(triggers, path1 == null ? PropertyDate.class : Property.class);
        this.comparison = comp;
        this.path1 = path1 != null ? new TagPath(path1) : null;
        this.path2 = new TagPath(path2);
    }

    @Override
    void test(Property prop, TagPath trigger, List<ViewContext> issues, GedcomValidate report) {
        Entity entity = prop.getEntity();
        PropertyDate date1 = this.path1 != null ? (PropertyDate)prop.getProperty(this.path1) : (PropertyDate)prop;
        if (date1 == null) {
            return;
        }
        Property date2 = entity.getProperty(this.path2);
        if (!(date2 instanceof PropertyDate)) {
            return;
        }
        if (this.isError(date1, (PropertyDate)date2)) {
            WordBuffer buf = new WordBuffer();
            String event1 = Gedcom.getName((String)trigger.get(trigger.length() - (trigger.getLast().equals("DATE") ? 2 : 1)));
            String event2 = Gedcom.getName((String)this.path2.get(this.path2.length() - 2));
            if (this.comparison == 1) {
                buf.append(NbBundle.getMessage(this.getClass(), (String)"err.date.before", (Object)event1, (Object)date1.getDisplayValue(), (Object)event2, (Object)date2.getDisplayValue(), (Object[])new Object[0]));
            } else {
                buf.append(NbBundle.getMessage(this.getClass(), (String)"err.date.after", (Object)event1, (Object)date1.getDisplayValue(), (Object)event2, (Object)date2.getDisplayValue(), (Object[])new Object[0]));
            }
            entity = date2.getEntity();
            if (entity instanceof Indi) {
                buf.append(NbBundle.getMessage(this.getClass(), (String)"err.date.of", (Object)entity.toString()));
            }
            issues.add(new ViewContext(prop).setCode(this.getCode()).setText(buf.toString()).setImage(prop instanceof PropertyDate ? prop.getParent().getImage(false) : prop.getImage(false)));
        }
    }

    private boolean isError(PropertyDate date1, PropertyDate date2) {
        int sign;
        PointInTime pit2;
        PointInTime pit1;
        if (!date1.isComparable() || !date2.isComparable()) {
            return false;
        }
        if (this.comparison == 0) {
            pit1 = date1.getStart();
            pit2 = date2.isRange() ? date2.getEnd() : date2.getStart();
            sign = 1;
        } else {
            pit1 = date1.isRange() ? date1.getEnd() : date1.getStart();
            pit2 = date2.getStart();
            sign = -1;
        }
        if (!(pit1.isComplete() && pit2.isComplete() || pit1.getYear() != pit2.getYear())) {
            return false;
        }
        return pit1.compareTo(pit2) * sign > 0;
    }

    @Override
    String getCode() {
        return "04";
    }
}

