/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import org.openide.awt.AlwaysEnabledAction;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.awt.GlobalManager;
import org.openide.awt.PropertyMonitor;
import org.openide.awt.StatefulAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;

final class GeneralAction {
    static final Logger LOG = Logger.getLogger(GeneralAction.class.getName());

    private GeneralAction() {
    }

    public static ContextAwareAction callback(String key, Action defaultDelegate, Lookup context, boolean surviveFocusChange, boolean async) {
        if (key == null) {
            throw new NullPointerException();
        }
        return new DelegateAction(null, key, context, defaultDelegate, surviveFocusChange, async);
    }

    public static Action alwaysEnabled(Map map) {
        return new AlwaysEnabledAction(map);
    }

    public static ContextAwareAction callback(Map map) {
        Action fallback = (Action)map.get("fallback");
        DelegateAction d = new DelegateAction(map, fallback);
        Parameters.notNull((CharSequence)"key", (Object)d.key);
        return d;
    }

    public static <T> ContextAwareAction context(ContextAction.Performer<? super T> perf, ContextSelection selectionType, Lookup context, Class<T> dataType) {
        return new ContextAction<T>(perf, selectionType, context, dataType, false, null);
    }

    public static ContextAwareAction context(Map map) {
        return GeneralAction.context(map, false);
    }

    static ContextAwareAction context(Map map, boolean instanceReady) {
        Class<?> dataType = GeneralAction.readClass(map.get("type"));
        ContextAwareAction ca = GeneralAction._context(map, dataType, Utilities.actionsGlobalContext(), instanceReady);
        if (ca.getValue("SwingSelectedKey") != null) {
            return new StateDelegateAction(map, (Action)ca);
        }
        return new DelegateAction(map, (Action)ca);
    }

    public static Action bindContext(Map map, Lookup context) {
        Class<?> dataType = GeneralAction.readClass(map.get("type"));
        return new BaseDelAction(map, (Action)GeneralAction._context(map, dataType, context, false));
    }

    private static <T> ContextAwareAction _context(Map map, Class<T> dataType, Lookup context, boolean instanceReady) {
        ContextAction a;
        Class<?> c;
        ContextSelection sel = GeneralAction.readSelection(map.get("selectionType"));
        ContextAction.Performer perf = new ContextAction.Performer(map);
        boolean survive = Boolean.TRUE.equals(map.get("surviveFocusChange"));
        PropertyMonitor<Object> enableMonitor = null;
        PropertyMonitor<Object> checkMonitor = null;
        Class<Object> enableType = GeneralAction.tryReadClass(map.get("enableOnType"));
        if (enableType == null) {
            enableType = dataType;
        }
        Object del = map.get("enableOnActionProperty");
        Object o = map.get("enableOnProperty");
        if (o instanceof String || o == null && del instanceof String) {
            enableMonitor = new PropertyMonitor(enableType, (String)o, "enableOn", map);
        }
        if ((o = map.get("checkedOnProperty")) instanceof String && (c = GeneralAction.tryReadClass(map.get("checkedOnType"))) != null) {
            checkMonitor = new PropertyMonitor(c, (String)o, "checkedOn", map);
        }
        if (instanceReady) {
            enableMonitor = new PropertyMonitor<Action>(Action.class, "enabled");
            Object ao = map.get("delegate");
            if (ao instanceof Action && ((Action)ao).getValue("SwingSelectedKey") != null) {
                checkMonitor = new PropertyMonitor<Action>(Action.class, "SwingSelectedKey");
            }
        }
        if (checkMonitor == null) {
            a = new ContextAction(perf, sel, context, dataType, survive, enableMonitor);
        } else {
            a = new StatefulAction(perf, sel, context, dataType, survive, enableMonitor, checkMonitor);
            LOG.log(Level.FINE, "Created stateful delegate for {0}, instance {1}, value monitor {2}", new Object[]{map, a, checkMonitor});
        }
        return a;
    }

    private static ContextSelection readSelection(Object obj) {
        if (obj instanceof ContextSelection) {
            return (ContextSelection)((Object)obj);
        }
        if (obj instanceof String) {
            return ContextSelection.valueOf((String)obj);
        }
        throw new IllegalStateException("Cannot parse 'selectionType' value: " + obj);
    }

    static Class<?> readClass(Object obj) {
        Class<?> r = GeneralAction.tryReadClass(obj);
        if (r == null) {
            throw new IllegalStateException("Cannot read 'type' value: " + obj);
        }
        return r;
    }

    static Class<?> tryReadClass(Object obj) {
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof String) {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == null) {
                l = GeneralAction.class.getClassLoader();
            }
            try {
                return Class.forName((String)obj, false, l);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return null;
    }

    static final Object extractCommonAttribute(Map fo, Action action, String name) {
        return AlwaysEnabledAction.extractCommonAttribute(fo, name);
    }

    public Logger getLOG() {
        return LOG;
    }

    static class BaseDelAction
    implements Action,
    PropertyChangeListener {
        final Map map;
        final Action fallback;
        final Object key;
        final boolean async;
        final GlobalManager global;
        private PropertyChangeSupport support;
        PropertyChangeListener weakL;
        Map<String, Object> attrs;

        protected BaseDelAction(Map map, Object key, Lookup actionContext, Action fallback, boolean surviveFocusChange, boolean async) {
            this.map = map;
            this.key = key;
            this.fallback = fallback;
            this.global = GlobalManager.findManager(actionContext, surviveFocusChange);
            this.weakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)fallback);
            this.async = async;
            if (fallback != null) {
                LOG.log(Level.FINER, "Action {0}: Attaching propchange to {1}", new Object[]{this, fallback});
                fallback.addPropertyChangeListener(this.weakL);
            }
        }

        protected BaseDelAction(Map map, Action fallback) {
            this(map, map.get("key"), Utilities.actionsGlobalContext(), fallback, Boolean.TRUE.equals(map.get("surviveFocusChange")), Boolean.TRUE.equals(map.get("asynchronous")));
        }

        public String toString() {
            return super.toString() + "[key=" + this.key + ", map=" + this.map + "]";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (EventQueue.isDispatchThread());
            Action a = this.findAction();
            if (a != null) {
                ActionInvoker.invokeAction((Action)a, (ActionEvent)e, (boolean)this.async, null);
            }
        }

        @Override
        public boolean isEnabled() {
            assert (EventQueue.isDispatchThread());
            Action a = this.findAction();
            return a == null ? false : a.isEnabled();
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            boolean first = false;
            if (this.support == null) {
                this.support = new PropertyChangeSupport(this);
                first = true;
            }
            this.support.addPropertyChangeListener(listener);
            if (first) {
                LOG.log(Level.FINER, "Action {0}: Adding global listener for key {1}", new Object[]{this, this.key});
                this.global.registerListener(this.key, this);
            }
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.support != null) {
                this.support.removePropertyChangeListener(listener);
                if (!this.support.hasListeners(null)) {
                    this.global.unregisterListener(this.key, this);
                    LOG.log(Level.FINER, "Action {0}: Removed global listener for key {1}", new Object[]{this, this.key});
                    this.support = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putValue(String key, Object value) {
            PropertyChangeSupport s;
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Object>();
            }
            BaseDelAction baseDelAction = this;
            synchronized (baseDelAction) {
                s = this.support;
            }
            Object old = null;
            if (s != null) {
                old = this.getValue(key);
            }
            this.attrs.put(key, value);
            if (s != null) {
                s.firePropertyChange(key, old, old != null ? value : null);
            }
        }

        @Override
        public Object getValue(String key) {
            if (this.attrs != null && this.attrs.containsKey(key)) {
                return this.attrs.get(key);
            }
            Object ret = GeneralAction.extractCommonAttribute(this.map, this, key);
            if (ret != null) {
                return ret;
            }
            Action a = this.findAction();
            return a == null ? null : a.getValue(key);
        }

        @Override
        public void setEnabled(boolean b) {
        }

        void updateState(ActionMap prev, ActionMap now, boolean fire) {
            Action prevAction;
            if (this.key == null) {
                return;
            }
            boolean prevEnabled = false;
            if (prev != null && (prevAction = prev.get(this.key)) != null) {
                prevEnabled = fire && prevAction.isEnabled();
                prevAction.removePropertyChangeListener(this.weakL);
            }
            if (now != null) {
                PropertyChangeSupport sup;
                boolean nowEnabled;
                Action nowAction = now.get(this.key);
                if (nowAction != null) {
                    nowAction.addPropertyChangeListener(this.weakL);
                    nowEnabled = nowAction.isEnabled();
                } else {
                    nowEnabled = this.fallback != null && this.fallback.isEnabled();
                }
                PropertyChangeSupport propertyChangeSupport = sup = fire ? this.support : null;
                if (sup != null && nowEnabled != prevEnabled) {
                    sup.firePropertyChange("enabled", prevEnabled, !prevEnabled);
                }
            }
        }

        private Action findAction() {
            Action a = this.global.findGlobalAction(this.key);
            return a == null ? this.fallback : a;
        }

        protected BaseDelAction copyDelegate(Action f, Lookup actionContext) {
            return new DelegateAction(this.map, this.key, actionContext, f, this.global.isSurvive(), this.async);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            Action f = this.fallback;
            if (f instanceof ContextAwareAction) {
                f = ((ContextAwareAction)f).createContextAwareInstance(actionContext);
            }
            BaseDelAction other = this.copyDelegate(f, actionContext);
            if (this.attrs != null) {
                if (other.attrs == null) {
                    other.attrs = new HashMap<String, Object>(this.attrs);
                } else {
                    for (String k : this.attrs.keySet()) {
                        other.attrs.putIfAbsent(k, this.attrs.get(k));
                    }
                }
            }
            return other;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                PropertyChangeSupport sup;
                LOG.log(Level.FINE, "Action {0}: got property change from fallback {1}", new Object[]{this, this.fallback});
                BaseDelAction baseDelAction = this;
                synchronized (baseDelAction) {
                    sup = this.support;
                }
                if (sup != null) {
                    sup.firePropertyChange("enabled", evt.getOldValue(), evt.getNewValue());
                }
            }
        }

        public int hashCode() {
            int k = this.key == null ? 37 : this.key.hashCode();
            int m = this.map == null ? 17 : this.map.hashCode();
            int f = this.fallback == null ? 7 : this.fallback.hashCode();
            return (k << 2) + (m << 1) + f;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DelegateAction) {
                DelegateAction d = (DelegateAction)obj;
                if (this.key != null && !this.key.equals(d.key)) {
                    return false;
                }
                if (this.map != null && !this.map.equals(d.map)) {
                    return false;
                }
                return this.fallback == null || this.fallback.equals(d.fallback);
            }
            return false;
        }
    }

    static final class DelegateAction
    extends BaseDelAction
    implements ContextAwareAction {
        public DelegateAction(Map map, Object key, Lookup actionContext, Action fallback, boolean surviveFocusChange, boolean async) {
            super(map, key, actionContext, fallback, surviveFocusChange, async);
        }

        public DelegateAction(Map map, Action fallback) {
            super(map, fallback);
        }
    }

    static final class StateDelegateAction
    extends BaseDelAction
    implements ContextAwareAction,
    Presenter.Toolbar,
    Presenter.Menu,
    Presenter.Popup,
    PropertyChangeListener {
        public StateDelegateAction(Map map, Object key, Lookup actionContext, Action fallback, boolean surviveFocusChange, boolean async) {
            super(map, key, actionContext, fallback, surviveFocusChange, async);
            this.putValue("SwingSelectedKey", fallback.getValue("SwingSelectedKey"));
        }

        public StateDelegateAction(Map map, Action fallback) {
            super(map, fallback);
        }

        public Component getToolbarPresenter() {
            return ActionPresenterProvider.getDefault().createToolbarPresenter((Action)this);
        }

        public JMenuItem getMenuPresenter() {
            return ActionPresenterProvider.getDefault().createMenuPresenter((Action)this);
        }

        public JMenuItem getPopupPresenter() {
            return ActionPresenterProvider.getDefault().createPopupPresenter((Action)this);
        }

        @Override
        void updateState(ActionMap prev, ActionMap now, boolean fire) {
            Boolean ns;
            Action na;
            super.updateState(prev, now, fire);
            if (this.key == null) {
                return;
            }
            Action pa = prev.get(this.key);
            if (pa == (na = now.get(this.key))) {
                return;
            }
            Boolean os = pa != null ? Boolean.valueOf(Boolean.TRUE.equals(pa.getValue("SwingSelectedKey"))) : Boolean.valueOf(Boolean.TRUE.equals(this.fallback.getValue("SwingSelectedKey")));
            if (os != (ns = na != null ? Boolean.valueOf(Boolean.TRUE.equals(na.getValue("SwingSelectedKey"))) : Boolean.valueOf(Boolean.TRUE.equals(this.fallback.getValue("SwingSelectedKey"))))) {
                this.putValue("SwingSelectedKey", ns);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if ("SwingSelectedKey".equals(evt.getPropertyName())) {
                Object o = evt.getNewValue();
                this.putValue("SwingSelectedKey", o != null ? this.fallback.getValue("SwingSelectedKey") : o);
            }
        }

        @Override
        protected BaseDelAction copyDelegate(Action f, Lookup actionContext) {
            return new StateDelegateAction(this.map, this.key, actionContext, f, this.global.isSurvive(), this.async);
        }
    }
}

