/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.communication.UserProfile;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TechInfoPanel
extends JPanel {
    private String ipaddress = "";
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel8;
    private JLabel jLabel9;

    public TechInfoPanel(UserProfile mp) {
        this.initComponents();
        this.jLabel3.setText(mp.name);
        this.jLabel10.setText(this.getIPLocation(mp.ipAddress));
        this.jButton1.setText(mp.ipAddress);
        this.ipaddress = mp.ipAddress;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jButton1.setFont(new Font("DejaVu Sans", 0, 9));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jButton1.toolTipText"));
        this.jButton1.setPreferredSize(new Dimension(136, 20));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TechInfoPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/techinfo.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jLabel8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(TechInfoPanel.class, (String)"TechInfoPanel.jLabel10.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel2).addComponent(this.jLabel9)).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, 150, Short.MAX_VALUE).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3)).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jButton1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        TechInfoPanel.openIpLocator(this.ipaddress);
    }

    public static void openIpLocator(String ipaddress) {
        try {
            URI uri = new URI("http://ip-api.com/#" + ipaddress);
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(uri);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getIPLocation(String ipaddress) {
        String ret = "";
        try {
            Node node;
            String outputString = "";
            String responseString = "";
            URL data = new URL("http://ip-api.com/xml/" + ipaddress);
            HttpURLConnection connection = (HttpURLConnection)data.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((responseString = in.readLine()) != null) {
                outputString = outputString + responseString;
            }
            in.close();
            connection.disconnect();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(outputString));
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("query");
            if (nodeList != null && (node = nodeList.item(0)).getNodeType() == 1) {
                Element member = (Element)node;
                String country = StringEscapeUtils.unescapeHtml((String)member.getElementsByTagName("country").item(0).getTextContent());
                String city = StringEscapeUtils.unescapeHtml((String)member.getElementsByTagName("city").item(0).getTextContent());
                ret = city + ", " + country;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

