/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.FilteredIcon;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.util.spi.SVGLoader;

public final class ImageUtilities {
    private static final Logger LOGGER = Logger.getLogger(ImageUtilities.class.getName());
    static final String TOOLTIP_SEPAR = "<br>";
    private static final ActiveRef<String> NO_ICON = new ActiveRef<Object>(null, null, null);
    private static final Map<String, ActiveRef<String>> cache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<String, ActiveRef<String>> localizedCache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<CompositeImageKey, ActiveRef<CompositeImageKey>> compositeCache = new HashMap<CompositeImageKey, ActiveRef<CompositeImageKey>>(128);
    private static final Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> imageToolTipCache = new HashMap<ToolTipImageKey, ActiveRef<ToolTipImageKey>>(128);
    private static RGBImageFilter imageIconFilter = null;
    private static final Set<String> extraInitialSlashes = new HashSet<String>();
    private static final CachedLookupLoader<ClassLoader> classLoaderLoader = new CachedLookupLoader<ClassLoader>(ClassLoader.class);
    private static final CachedLookupLoader<SVGLoader> svgLoaderLoader = new CachedLookupLoader<SVGLoader>(SVGLoader.class);
    private static final Component component = new Component(){};
    private static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID;
    private static ImageReader PNG_READER;
    private static final Logger ERR;
    private static final String DARK_LAF_SUFFIX = "_dark";
    private static volatile Component dummyIconComponent;

    private ImageUtilities() {
    }

    public static final Image loadImage(String resourceID) {
        return ImageUtilities.loadImage(resourceID, false);
    }

    public static final Image loadImage(String resource, boolean localized) {
        return ImageUtilities.loadImageInternal(resource, localized);
    }

    private static ToolTipImage loadImageInternal(String resource, boolean localized) {
        if (resource == null) {
            return null;
        }
        ToolTipImage image = null;
        if (ImageUtilities.isDarkLaF()) {
            image = ImageUtilities.getIcon(ImageUtilities.addDarkSuffix(resource), localized);
        }
        if (null == image) {
            image = ImageUtilities.getIcon(resource, localized);
            RGBImageFilter imageFilter = ImageUtilities.getImageIconFilter();
            if (null != image && null != imageFilter) {
                image = ImageUtilities.icon2ToolTipImage(FilteredIcon.create(imageFilter, image), image.url);
            }
        }
        return image;
    }

    public static final ImageIcon loadImageIcon(String resource, boolean localized) {
        ToolTipImage image = ImageUtilities.loadImageInternal(resource, localized);
        if (image == null) {
            return null;
        }
        return image.asImageIcon();
    }

    private static boolean isDarkLaF() {
        return UIManager.getBoolean("nb.dark.theme");
    }

    private static String addDarkSuffix(String resourceName) {
        int dotIndex = resourceName.lastIndexOf(46);
        if (dotIndex > 0) {
            return resourceName.substring(0, dotIndex) + DARK_LAF_SUFFIX + resourceName.substring(dotIndex);
        }
        return resourceName + DARK_LAF_SUFFIX;
    }

    private static RGBImageFilter getImageIconFilter() {
        Object obj;
        if (null == imageIconFilter && (obj = UIManager.get("nb.imageicon.filter")) instanceof RGBImageFilter) {
            imageIconFilter = (RGBImageFilter)obj;
        }
        return imageIconFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image mergeImages(Image image1, Image image2, int x, int y) {
        if (image1 == null || image2 == null) {
            throw new NullPointerException();
        }
        CompositeImageKey k = new CompositeImageKey(image1, image2, x, y);
        Map<CompositeImageKey, ActiveRef<CompositeImageKey>> map = compositeCache;
        synchronized (map) {
            ToolTipImage cached;
            ActiveRef<CompositeImageKey> r = compositeCache.get(k);
            if (r != null && (cached = (ToolTipImage)r.get()) != null) {
                return cached;
            }
            cached = ImageUtilities.doMergeImages(image1, image2, x, y);
            compositeCache.put(k, new ActiveRef<CompositeImageKey>(cached, compositeCache, k));
            return cached;
        }
    }

    public static final Icon image2Icon(Image image) {
        return image instanceof ToolTipImage ? (ToolTipImage)image : ImageUtilities.assignToolTipToImageInternal(image, "");
    }

    public static final Image icon2Image(Icon icon) {
        Image ret;
        if (icon == null) {
            LOGGER.log(Level.WARNING, null, new NullPointerException());
            return ImageUtilities.loadImage("org/openide/nodes/defaultNode.png", true);
        }
        if (icon instanceof ToolTipImage) {
            return (ToolTipImage)icon;
        }
        if (icon instanceof IconImageIcon) {
            return ImageUtilities.icon2Image(((IconImageIcon)icon).getDelegateIcon());
        }
        if (icon instanceof ImageIcon && (ret = ((ImageIcon)icon).getImage()) != null) {
            return ret;
        }
        return ImageUtilities.icon2ToolTipImage(icon, null);
    }

    private static ToolTipImage icon2ToolTipImage(Icon icon, URL url) {
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        if (icon instanceof ToolTipImage) {
            return (ToolTipImage)icon;
        }
        ToolTipImage image = new ToolTipImage(icon, "", url, 2);
        Graphics g = image.getGraphics();
        icon.paintIcon(dummyIconComponent, g, 0, 0);
        g.dispose();
        return image;
    }

    public static final Image assignToolTipToImage(Image image, String text) {
        return ImageUtilities.assignToolTipToImageInternal(image, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToolTipImage assignToolTipToImageInternal(Image image, String text) {
        Parameters.notNull((CharSequence)"image", (Object)image);
        Parameters.notNull((CharSequence)"text", (Object)text);
        ToolTipImageKey key = new ToolTipImageKey(image, text);
        Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> map = imageToolTipCache;
        synchronized (map) {
            ToolTipImage cached;
            ActiveRef<ToolTipImageKey> r = imageToolTipCache.get(key);
            if (r != null && (cached = (ToolTipImage)r.get()) != null) {
                return cached;
            }
            cached = ToolTipImage.createNew(text, image, null);
            imageToolTipCache.put(key, new ActiveRef<ToolTipImageKey>(cached, imageToolTipCache, key));
            return cached;
        }
    }

    public static final String getImageToolTip(Image image) {
        if (image instanceof ToolTipImage) {
            return ((ToolTipImage)image).toolTipText;
        }
        return "";
    }

    public static final Image addToolTipToImage(Image image, String text) {
        if (image instanceof ToolTipImage) {
            ToolTipImage tti = (ToolTipImage)image;
            StringBuilder str = new StringBuilder(tti.toolTipText);
            if (str.length() > 0 && text.length() > 0) {
                str.append(TOOLTIP_SEPAR);
            }
            str.append(text);
            return ImageUtilities.assignToolTipToImage(image, str.toString());
        }
        return ImageUtilities.assignToolTipToImage(image, text);
    }

    public static Icon createDisabledIcon(Icon icon) {
        Parameters.notNull((CharSequence)"icon", (Object)icon);
        return FilteredIcon.create(DisabledButtonFilter.INSTANCE, icon);
    }

    public static Image createDisabledImage(Image image) {
        Parameters.notNull((CharSequence)"image", (Object)image);
        return ImageUtilities.icon2Image(ImageUtilities.createDisabledIcon(ImageUtilities.image2Icon(image)));
    }

    private static SVGLoader getSVGLoader() {
        return svgLoaderLoader.getLoader();
    }

    static ClassLoader getClassLoader() {
        return classLoaderLoader.getLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ToolTipImage getIcon(String resource, boolean localized) {
        if (localized) {
            if (resource == null) {
                return null;
            }
            Map<String, ActiveRef<String>> map = localizedCache;
            synchronized (map) {
                String ext;
                String base;
                ActiveRef<String> ref = localizedCache.get(resource);
                ToolTipImage img = null;
                if (ref == NO_ICON) {
                    return null;
                }
                if (ref != null) {
                    img = (ToolTipImage)ref.get();
                }
                if (img != null) {
                    return img;
                }
                ClassLoader loader = ImageUtilities.getClassLoader();
                int idx = (resource = new String(resource).intern()).lastIndexOf(46);
                if (idx != -1 && idx > resource.lastIndexOf(47)) {
                    base = resource.substring(0, idx);
                    ext = resource.substring(idx);
                } else {
                    base = resource;
                    ext = "";
                }
                URL baseurl = loader != null ? loader.getResource(resource) : ImageUtilities.class.getClassLoader().getResource(resource);
                Iterator it = NbBundle.getLocalizingSuffixes();
                while (it.hasNext()) {
                    String suffix = (String)it.next();
                    ToolTipImage i = suffix.length() == 0 ? ImageUtilities.getIcon(resource, loader, false) : ImageUtilities.getIcon(base + suffix + ext, loader, true);
                    if (i == null) continue;
                    localizedCache.put(resource, new ActiveRef<String>(i, localizedCache, resource));
                    return i;
                }
                localizedCache.put(resource, NO_ICON);
                return null;
            }
        }
        return ImageUtilities.getIcon(resource, ImageUtilities.getClassLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ToolTipImage getIcon(String name, ClassLoader loader, boolean localizedQuery) {
        if (name == null) {
            return null;
        }
        ActiveRef<String> ref = cache.get(name);
        ToolTipImage img = null;
        if (ref == NO_ICON) {
            return null;
        }
        if (ref != null) {
            img = (ToolTipImage)ref.get();
        }
        if (img != null) {
            return img;
        }
        Map<String, ActiveRef<String>> map = cache;
        synchronized (map) {
            BufferedImage result;
            URL url;
            String n;
            boolean warn;
            block30: {
                URL svgURL;
                ref = cache.get(name);
                if (ref == NO_ICON) {
                    return null;
                }
                if (ref != null) {
                    img = (ToolTipImage)ref.get();
                }
                if (img != null) {
                    return img;
                }
                if (name.startsWith("/")) {
                    warn = true;
                    n = name.substring(1);
                } else {
                    warn = false;
                    n = name;
                }
                SVGLoader svgLoader = null;
                ClassLoader useClassLoader = loader != null ? loader : ImageUtilities.class.getClassLoader();
                url = null;
                if ((n.endsWith(".png") || n.endsWith(".gif") || n.endsWith(".svg")) && (svgURL = useClassLoader.getResource(n.substring(0, n.length() - 4) + ".svg")) != null) {
                    svgLoader = ImageUtilities.getSVGLoader();
                    if (svgLoader != null) {
                        url = svgURL;
                    } else {
                        ERR.log(Level.INFO, "No SVG loader available for loading {0}", svgURL);
                    }
                }
                if (url == null && !n.endsWith(".svg")) {
                    url = useClassLoader.getResource(n);
                }
                result = null;
                try {
                    if (url == null) break block30;
                    if (svgLoader != null) {
                        try {
                            result = ImageUtilities.icon2ToolTipImage(svgLoader.loadIcon(url), url);
                        }
                        catch (IOException e) {
                            ERR.log(Level.INFO, "Failed to load SVG image " + url, e);
                        }
                    } else if (name.endsWith(".png")) {
                        ImageInputStream stream = ImageIO.createImageInputStream(url.openStream());
                        ImageReadParam param = PNG_READER.getDefaultReadParam();
                        try {
                            PNG_READER.setInput(stream, true, true);
                            result = PNG_READER.read(0, param);
                        }
                        catch (IOException ioe1) {
                            ERR.log(Level.INFO, "Image " + name + " is not PNG", ioe1);
                        }
                        stream.close();
                    }
                    if (result == null) {
                        result = ImageIO.read(url);
                    }
                }
                catch (IOException ioe) {
                    ERR.log(Level.WARNING, "Cannot load " + name + " image", ioe);
                }
            }
            if (result != null) {
                if (warn && extraInitialSlashes.add(name)) {
                    ERR.warning("Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
                }
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.log(Level.FINE, "loading icon {0} = {1}", new Object[]{n, result});
                }
                name = new String(name).intern();
                BufferedImage toolTipImage = result instanceof ToolTipImage ? result : ToolTipImage.createNew("", result, url);
                cache.put(name, new ActiveRef<String>((ToolTipImage)toolTipImage, cache, name));
                return toolTipImage;
            }
            if (!localizedQuery) {
                cache.put(name, NO_ICON);
            }
            return null;
        }
    }

    private static final Image toBufferedImage(Image img) {
        new ImageIcon(img, "");
        if (img.getHeight(null) * img.getWidth(null) > 576) {
            return img;
        }
        BufferedImage rep = ImageUtilities.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, id);
        }
    }

    private static final ToolTipImage doMergeImages(Image image1, Image image2, int x, int y) {
        ImageUtilities.ensureLoaded(image1);
        ImageUtilities.ensureLoaded(image2);
        int w = Math.max(image1.getWidth(null), x + image2.getWidth(null));
        int h = Math.max(image1.getHeight(null), y + image2.getHeight(null));
        boolean bitmask = image1 instanceof Transparency && ((Transparency)((Object)image1)).getTransparency() != 3 && image2 instanceof Transparency && ((Transparency)((Object)image2)).getTransparency() != 3;
        StringBuilder str = new StringBuilder(image1 instanceof ToolTipImage ? ((ToolTipImage)image1).toolTipText : "");
        if (image2 instanceof ToolTipImage) {
            String toolTip = ((ToolTipImage)image2).toolTipText;
            if (str.length() > 0 && toolTip.length() > 0) {
                str.append(TOOLTIP_SEPAR);
            }
            str.append(toolTip);
        }
        Object firstUrl = image1.getProperty("url", null);
        ColorModel model = ImageUtilities.colorModel(bitmask ? 2 : 3);
        MergedIcon delegateIcon = new MergedIcon(ImageUtilities.image2Icon(image1), ImageUtilities.image2Icon(image2), x, y);
        ToolTipImage buffImage = new ToolTipImage(str.toString(), delegateIcon, model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null, firstUrl instanceof URL ? (URL)firstUrl : null);
        Graphics2D g = buffImage.createGraphics();
        g.drawImage(image1, 0, 0, null);
        g.drawImage(image2, x, y, null);
        g.dispose();
        return buffImage;
    }

    static final BufferedImage createBufferedImage(int width, int height) {
        if (Utilities.isMac()) {
            return new BufferedImage(width, height, 3);
        }
        ColorModel model = ImageUtilities.colorModel(3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    private static ColorModel colorModel(int transparency) {
        ColorModel model;
        try {
            model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(transparency);
        }
        catch (ArrayIndexOutOfBoundsException aioobE) {
            model = ColorModel.getRGBdefault();
        }
        catch (HeadlessException he) {
            model = ColorModel.getRGBdefault();
        }
        return model;
    }

    static {
        ERR = Logger.getLogger(ImageUtilities.class.getName());
        if (EventQueue.isDispatchThread()) {
            dummyIconComponent = new JLabel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dummyIconComponent = new JLabel();
                }
            });
        }
        ImageIO.setUseCache(false);
        PNG_READER = ImageIO.getImageReadersByMIMEType("image/png").next();
    }

    private static final class ActiveRef<T>
    extends SoftReference<ToolTipImage>
    implements Runnable {
        private final Map<T, ActiveRef<T>> holder;
        private final T key;

        public ActiveRef(ToolTipImage o, Map<T, ActiveRef<T>> holder, T key) {
            super(o, Utilities.activeReferenceQueue());
            this.holder = holder;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<T, ActiveRef<T>> map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static final class CachedLookupLoader<T> {
        private final Class<T> clazz;
        private final AtomicBoolean noLoaderWarned = new AtomicBoolean(false);
        private volatile Optional<T> currentLoader;
        private Thread threadInProgress;
        private Lookup.Result<T> loaderQuery;

        public CachedLookupLoader(Class<T> clazz) {
            Parameters.notNull((CharSequence)"clazz", clazz);
            this.clazz = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getLoader() {
            Lookup.Result<T> useLoaderQuery;
            Optional<Object> toReturn = this.currentLoader;
            if (toReturn != null) {
                return toReturn.orElse(null);
            }
            CachedLookupLoader cachedLookupLoader = this;
            synchronized (cachedLookupLoader) {
                this.threadInProgress = Thread.currentThread();
                if (this.loaderQuery == null) {
                    this.loaderQuery = Lookup.getDefault().lookupResult(this.clazz);
                    this.loaderQuery.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent ev) {
                            ERR.log(Level.FINE, "Loader for {0} cleared", clazz);
                            CachedLookupLoader cachedLookupLoader = this;
                            synchronized (cachedLookupLoader) {
                                currentLoader = null;
                                threadInProgress = null;
                            }
                        }
                    });
                }
                useLoaderQuery = this.loaderQuery;
            }
            Iterator it = useLoaderQuery.allInstances().iterator();
            toReturn = Optional.ofNullable(it.hasNext() ? (Object)it.next() : null);
            if (!toReturn.isPresent()) {
                if (!this.noLoaderWarned.getAndSet(true)) {
                    ERR.log(Level.WARNING, "No {0} instance found in {1}", new Object[]{this.clazz, Lookup.getDefault()});
                }
            } else if (ERR.isLoggable(Level.FINE)) {
                ERR.log(Level.FINE, "Loader computed for {0}: {1}", new Object[]{this.clazz, toReturn.orElse(null)});
            }
            CachedLookupLoader cachedLookupLoader2 = this;
            synchronized (cachedLookupLoader2) {
                if (this.threadInProgress == Thread.currentThread()) {
                    this.threadInProgress = null;
                    this.currentLoader = toReturn;
                }
            }
            return toReturn.orElse(null);
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image base, Image overlay, int x, int y) {
            this.x = x;
            this.y = y;
            this.baseImage = base;
            this.overlayImage = overlay;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey k = (CompositeImageKey)other;
            return this.x == k.x && this.y == k.y && this.baseImage == k.baseImage && this.overlayImage == k.overlayImage;
        }

        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            hash = hash ^ System.identityHashCode(this.baseImage) ^ System.identityHashCode(this.overlayImage);
            return hash;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }

    private static class DisabledButtonFilter
    extends RGBImageFilter {
        public static final RGBImageFilter INSTANCE = new DisabledButtonFilter();

        DisabledButtonFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return (rgb & 0xFF000000) + 0x888888 + ((rgb >> 16 & 0xFF) >> 2 << 16) + ((rgb >> 8 & 0xFF) >> 2 << 8) + ((rgb & 0xFF) >> 2);
        }

        public void setProperties(Hashtable props) {
            props = (Hashtable)props.clone();
            this.consumer.setProperties(props);
        }
    }

    private static final class IconImageIcon
    extends ImageIcon {
        private volatile Icon delegate;

        private IconImageIcon(Icon delegate) {
            super(ImageUtilities.icon2Image(delegate));
            Parameters.notNull((CharSequence)"delegate", (Object)delegate);
            this.delegate = delegate;
        }

        private static ImageIcon create(Icon delegate) {
            return delegate instanceof ImageIcon ? (ImageIcon)delegate : new IconImageIcon(delegate);
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            this.delegate.paintIcon(c, g, x, y);
        }

        public Icon getDelegateIcon() {
            return this.delegate;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(new ImageIcon(this.getImage()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.delegate = (ImageIcon)in.readObject();
        }

        private void readObjectNoData() throws ObjectStreamException {
            this.delegate = new ImageIcon(new BufferedImage(1, 1, 6));
        }
    }

    private static final class MergedIcon
    extends CachedHiDPIIcon {
        private final Icon icon1;
        private final Icon icon2;
        private final int x;
        private final int y;

        public MergedIcon(Icon icon1, Icon icon2, int x, int y) {
            super(Math.max(icon1.getIconWidth(), x + icon2.getIconWidth()), Math.max(icon1.getIconHeight(), y + icon2.getIconHeight()));
            this.icon1 = icon1;
            this.icon2 = icon2;
            this.x = x;
            this.y = y;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Image createAndPaintImage(Component c, ColorModel colorModel, int deviceWidth, int deviceHeight, double scale) {
            BufferedImage ret = MergedIcon.createBufferedImage(colorModel, deviceWidth, deviceHeight);
            Graphics2D g = ret.createGraphics();
            try {
                g.clip(new Rectangle(0, 0, deviceWidth, deviceHeight));
                g.scale(scale, scale);
                this.icon1.paintIcon(c, g, 0, 0);
                this.icon2.paintIcon(c, g, this.x, this.y);
            }
            finally {
                g.dispose();
            }
            return ret;
        }
    }

    private static class ToolTipImage
    extends BufferedImage
    implements Icon {
        final String toolTipText;
        final Icon delegateIcon;
        final URL url;
        ImageIcon imageIconVersion;

        public static ToolTipImage createNew(String toolTipText, Image image, URL url) {
            ImageUtilities.ensureLoaded(image);
            boolean bitmask = image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() != 3;
            ColorModel model = ImageUtilities.colorModel(bitmask ? 2 : 3);
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (url == null) {
                Object value = image.getProperty("url", null);
                url = value instanceof URL ? (URL)value : null;
            }
            Icon icon = image instanceof ToolTipImage ? ((ToolTipImage)image).getDelegateIcon() : null;
            ToolTipImage newImage = new ToolTipImage(toolTipText, icon, model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null, url);
            Graphics2D g = newImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return newImage;
        }

        public ToolTipImage(String toolTipText, Icon delegateIcon, ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties, URL url) {
            super(cm, raster, isRasterPremultiplied, properties);
            this.toolTipText = toolTipText;
            this.delegateIcon = delegateIcon;
            this.url = url;
        }

        public synchronized ImageIcon asImageIcon() {
            if (this.imageIconVersion == null) {
                this.imageIconVersion = IconImageIcon.create(this);
            }
            return this.imageIconVersion;
        }

        public ToolTipImage(Icon delegateIcon, String toolTipText, URL url, int imageType) {
            super(Math.max(1, delegateIcon.getIconWidth()), Math.max(1, delegateIcon.getIconHeight()), imageType);
            this.delegateIcon = delegateIcon;
            this.toolTipText = toolTipText;
            this.url = url;
        }

        public Icon getDelegateIcon() {
            return this.delegateIcon;
        }

        @Override
        public int getIconHeight() {
            return super.getHeight();
        }

        @Override
        public int getIconWidth() {
            return super.getWidth();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.delegateIcon != null) {
                this.delegateIcon.paintIcon(c, g, x, y);
            } else {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    AffineTransform tx = g2.getTransform();
                    int txType = tx.getType();
                    double scale = txType == 2 || txType == 3 ? tx.getScaleX() : 1.0;
                    if (scale != 1.0) {
                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g2.setTransform(new AffineTransform(scale, 0.0, 0.0, scale, (double)((int)tx.getTranslateX()), (double)((int)tx.getTranslateY())));
                    }
                    g2.drawImage((Image)this, x, y, null);
                }
                finally {
                    g2.dispose();
                }
            }
        }

        @Override
        public Object getProperty(String name, ImageObserver observer) {
            if ("url".equals(name)) {
                if (this.url != null) {
                    return this.url;
                }
                if (!(this.delegateIcon instanceof ImageIcon)) {
                    return null;
                }
                Image image = ((ImageIcon)this.delegateIcon).getImage();
                if (image == this || image == null) {
                    return null;
                }
                return image.getProperty("url", observer);
            }
            return super.getProperty(name, observer);
        }
    }

    private static class ToolTipImageKey {
        Image image;
        String str;

        ToolTipImageKey(Image image, String str) {
            this.image = image;
            this.str = str;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ToolTipImageKey)) {
                return false;
            }
            ToolTipImageKey k = (ToolTipImageKey)other;
            return this.str.equals(k.str) && this.image == k.image;
        }

        public int hashCode() {
            return System.identityHashCode(this.image) ^ this.str.hashCode();
        }

        public String toString() {
            return "ImageStringKey for " + this.image + " + " + this.str;
        }
    }
}

